﻿// Copyright (c) Rodel. All rights reserved.

using System.Collections.Generic;

namespace RodelAgent.Statics;

/// <summary>
/// Emoji 静态类.
/// </summary>
public static class EmojiStatics
{
    /// <summary>
    /// 获取 Emoji 列表.
    /// </summary>
    /// <returns>Emoji 列表.</returns>
    public static List<EmojiItem> GetEmojis()
    {
        return
        [
            new("1st place medal", "1f947", "Activities"),
            new("2nd place medal", "1f948", "Activities"),
            new("3rd place medal", "1f949", "Activities"),
            new("A button blood type", "1f170 fe0f", "Symbols"),
            new("Ab button blood type", "1f18e", "Symbols"),
            new("Abacus", "1f9ee", "Objects"),
            new("Accordion", "1fa97", "Objects"),
            new("Adhesive bandage", "1fa79", "Objects"),
            new("Admission tickets", "1f39f fe0f", "Activities"),
            new("Aerial tramway", "1f6a1", "Travel & Places"),
            new("Airplane", "2708 fe0f", "Travel & Places"),
            new("Airplane arrival", "1f6ec", "Travel & Places"),
            new("Airplane departure", "1f6eb", "Travel & Places"),
            new("Alarm clock", "23f0", "Travel & Places"),
            new("Alembic", "2697 fe0f", "Objects"),
            new("Alien", "1f47d", "Smileys & Emotion"),
            new("Alien monster", "1f47e", "Smileys & Emotion"),
            new("Ambulance", "1f691", "Travel & Places"),
            new("American football", "1f3c8", "Activities"),
            new("Amphora", "1f3fa", "Food & Drink"),
            new("Anatomical heart", "1fac0", "People & Body"),
            new("Anchor", "2693", "Travel & Places"),
            new("Anger symbol", "1f4a2", "Smileys & Emotion"),
            new("Angry face", "1f620", "Smileys & Emotion"),
            new("Angry face with horns", "1f47f", "Smileys & Emotion"),
            new("Anguished face", "1f627", "Smileys & Emotion"),
            new("Ant", "1f41c", "Animals & Nature"),
            new("Antenna bars", "1f4f6", "Symbols"),
            new("Anxious face with sweat", "1f630", "Smileys & Emotion"),
            new("Aquarius", "2652", "Symbols"),
            new("Aries", "2648", "Symbols"),
            new("Articulated lorry", "1f69b", "Travel & Places"),
            new("Artist palette", "1f3a8", "Activities"),
            new("Astonished face", "1f632", "Smileys & Emotion"),
            new("Atm sign", "1f3e7", "Symbols"),
            new("Atom symbol", "269b fe0f", "Symbols"),
            new("Auto rickshaw", "1f6fa", "Travel & Places"),
            new("Automobile", "1f697", "Travel & Places"),
            new("Avocado", "1f951", "Food & Drink"),
            new("Axe", "1fa93", "Objects"),
            new("B button blood type", "1f171 fe0f", "Symbols"),
            new("Baby bottle", "1f37c", "Food & Drink"),
            new("Baby chick", "1f424", "Animals & Nature"),
            new("Baby symbol", "1f6bc", "Symbols"),
            new("Back arrow", "1f519", "Symbols"),
            new("Backpack", "1f392", "Objects"),
            new("Bacon", "1f953", "Food & Drink"),
            new("Badger", "1f9a1", "Animals & Nature"),
            new("Badminton", "1f3f8", "Activities"),
            new("Bagel", "1f96f", "Food & Drink"),
            new("Baggage claim", "1f6c4", "Symbols"),
            new("Baguette bread", "1f956", "Food & Drink"),
            new("Balance scale", "2696 fe0f", "Objects"),
            new("Ballet shoes", "1fa70", "Objects"),
            new("Balloon", "1f388", "Activities"),
            new("Ballot box with ballot", "1f5f3 fe0f", "Objects"),
            new("Banana", "1f34c", "Food & Drink"),
            new("Banjo", "1fa95", "Objects"),
            new("Bank", "1f3e6", "Travel & Places"),
            new("Bar chart", "1f4ca", "Objects"),
            new("Barber pole", "1f488", "Travel & Places"),
            new("Baseball", "26be", "Activities"),
            new("Basket", "1f9fa", "Objects"),
            new("Basketball", "1f3c0", "Activities"),
            new("Bat", "1f987", "Animals & Nature"),
            new("Bathtub", "1f6c1", "Objects"),
            new("Battery", "1f50b", "Objects"),
            new("Beach with umbrella", "1f3d6 fe0f", "Travel & Places"),
            new("Beaming face with smiling eyes", "1f601", "Smileys & Emotion"),
            new("Beans", "1fad8", "Food & Drink"),
            new("Bear", "1f43b", "Animals & Nature"),
            new("Beating heart", "1f493", "Smileys & Emotion"),
            new("Beaver", "1f9ab", "Animals & Nature"),
            new("Bed", "1f6cf fe0f", "Objects"),
            new("Beer mug", "1f37a", "Food & Drink"),
            new("Beetle", "1fab2", "Animals & Nature"),
            new("Bell", "1f514", "Objects"),
            new("Bell pepper", "1fad1", "Food & Drink"),
            new("Bell with slash", "1f515", "Objects"),
            new("Bellhop bell", "1f6ce fe0f", "Travel & Places"),
            new("Bento box", "1f371", "Food & Drink"),
            new("Beverage box", "1f9c3", "Food & Drink"),
            new("Bicycle", "1f6b2", "Travel & Places"),
            new("Bikini", "1f459", "Objects"),
            new("Billed cap", "1f9e2", "Objects"),
            new("Biohazard", "2623 fe0f", "Symbols"),
            new("Bird", "1f426", "Animals & Nature"),
            new("Birthday cake", "1f382", "Food & Drink"),
            new("Bison", "1f9ac", "Animals & Nature"),
            new("Biting lip", "1fae6", "People & Body"),
            new("Black cat", "1f408 200d 2b1b", "Animals & Nature"),
            new("Black circle", "26ab", "Symbols"),
            new("Black flag", "1f3f4", "Flags"),
            new("Black heart", "1f5a4", "Smileys & Emotion"),
            new("Black large square", "2b1b", "Symbols"),
            new("Black medium square", "25fc fe0f", "Symbols"),
            new("Black medium-small square", "25fe", "Symbols"),
            new("Black nib", "2712 fe0f", "Objects"),
            new("Black small square", "25aa fe0f", "Symbols"),
            new("Black square button", "1f532", "Symbols"),
            new("Blossom", "1f33c", "Animals & Nature"),
            new("Blowfish", "1f421", "Animals & Nature"),
            new("Blue book", "1f4d8", "Objects"),
            new("Blue circle", "1f535", "Symbols"),
            new("Blue heart", "1f499", "Smileys & Emotion"),
            new("Blue square", "1f7e6", "Symbols"),
            new("Blueberries", "1fad0", "Food & Drink"),
            new("Boar", "1f417", "Animals & Nature"),
            new("Bomb", "1f4a3", "Smileys & Emotion"),
            new("Bone", "1f9b4", "People & Body"),
            new("Bookmark", "1f516", "Objects"),
            new("Bookmark tabs", "1f4d1", "Objects"),
            new("Books", "1f4da", "Objects"),
            new("Boomerang", "1fa83", "Objects"),
            new("Bottle with popping cork", "1f37e", "Food & Drink"),
            new("Bouquet", "1f490", "Animals & Nature"),
            new("Bow and arrow", "1f3f9", "Objects"),
            new("Bowl with spoon", "1f963", "Food & Drink"),
            new("Bowling", "1f3b3", "Activities"),
            new("Boxing glove", "1f94a", "Activities"),
            new("Brain", "1f9e0", "People & Body"),
            new("Bread", "1f35e", "Food & Drink"),
            new("Brick", "1f9f1", "Travel & Places"),
            new("Bridge at night", "1f309", "Travel & Places"),
            new("Briefcase", "1f4bc", "Objects"),
            new("Briefs", "1fa72", "Objects"),
            new("Bright button", "1f506", "Symbols"),
            new("Broccoli", "1f966", "Food & Drink"),
            new("Broken heart", "1f494", "Smileys & Emotion"),
            new("Broom", "1f9f9", "Objects"),
            new("Brown circle", "1f7e4", "Symbols"),
            new("Brown heart", "1f90e", "Smileys & Emotion"),
            new("Brown square", "1f7eb", "Symbols"),
            new("Bubble tea", "1f9cb", "Food & Drink"),
            new("Bubbles", "1fae7", "Objects"),
            new("Bucket", "1faa3", "Objects"),
            new("Bug", "1f41b", "Animals & Nature"),
            new("Building construction", "1f3d7 fe0f", "Travel & Places"),
            new("Bullet train", "1f685", "Travel & Places"),
            new("Bullseye", "1f3af", "Activities"),
            new("Burrito", "1f32f", "Food & Drink"),
            new("Bus", "1f68c", "Travel & Places"),
            new("Bus stop", "1f68f", "Travel & Places"),
            new("Bust in silhouette", "1f464", "People & Body"),
            new("Busts in silhouette", "1f465", "People & Body"),
            new("Butter", "1f9c8", "Food & Drink"),
            new("Butterfly", "1f98b", "Animals & Nature"),
            new("Cactus", "1f335", "Animals & Nature"),
            new("Calendar", "1f4c5", "Objects"),
            new("Camel", "1f42a", "Animals & Nature"),
            new("Camera", "1f4f7", "Objects"),
            new("Camera with flash", "1f4f8", "Objects"),
            new("Camping", "1f3d5 fe0f", "Travel & Places"),
            new("Cancer", "264b", "Symbols"),
            new("Candle", "1f56f fe0f", "Objects"),
            new("Candy", "1f36c", "Food & Drink"),
            new("Canned food", "1f96b", "Food & Drink"),
            new("Canoe", "1f6f6", "Travel & Places"),
            new("Capricorn", "2651", "Symbols"),
            new("Card file box", "1f5c3 fe0f", "Objects"),
            new("Card index", "1f4c7", "Objects"),
            new("Card index dividers", "1f5c2 fe0f", "Objects"),
            new("Carousel horse", "1f3a0", "Travel & Places"),
            new("Carp streamer", "1f38f", "Activities"),
            new("Carpentry saw", "1fa9a", "Objects"),
            new("Carrot", "1f955", "Food & Drink"),
            new("Castle", "1f3f0", "Travel & Places"),
            new("Cat", "1f408", "Animals & Nature"),
            new("Cat face", "1f431", "Animals & Nature"),
            new("Cat with tears of joy", "1f639", "Smileys & Emotion"),
            new("Cat with wry smile", "1f63c", "Smileys & Emotion"),
            new("Chains", "26d3 fe0f", "Objects"),
            new("Chair", "1fa91", "Objects"),
            new("Chart decreasing", "1f4c9", "Objects"),
            new("Chart increasing", "1f4c8", "Objects"),
            new("Chart increasing with yen", "1f4b9", "Objects"),
            new("Check box with check", "2611 fe0f", "Symbols"),
            new("Check mark", "2714 fe0f", "Symbols"),
            new("Check mark button", "2705", "Symbols"),
            new("Cheese wedge", "1f9c0", "Food & Drink"),
            new("Chequered flag", "1f3c1", "Flags"),
            new("Cherries", "1f352", "Food & Drink"),
            new("Cherry blossom", "1f338", "Animals & Nature"),
            new("Chess pawn", "265f fe0f", "Activities"),
            new("Chestnut", "1f330", "Food & Drink"),
            new("Chicken", "1f414", "Animals & Nature"),
            new("Children crossing", "1f6b8", "Symbols"),
            new("Chipmunk", "1f43f fe0f", "Animals & Nature"),
            new("Chocolate bar", "1f36b", "Food & Drink"),
            new("Chopsticks", "1f962", "Food & Drink"),
            new("Christmas tree", "1f384", "Activities"),
            new("Church", "26ea", "Travel & Places"),
            new("Cigarette", "1f6ac", "Objects"),
            new("Cinema", "1f3a6", "Symbols"),
            new("Circled m", "24c2 fe0f", "Symbols"),
            new("Circus tent", "1f3aa", "Travel & Places"),
            new("Cityscape", "1f3d9 fe0f", "Travel & Places"),
            new("Cityscape at dusk", "1f306", "Travel & Places"),
            new("Cl button", "1f191", "Symbols"),
            new("Clamp", "1f5dc fe0f", "Objects"),
            new("Clapper board", "1f3ac", "Objects"),
            new("Classical building", "1f3db fe0f", "Travel & Places"),
            new("Clinking beer mugs", "1f37b", "Food & Drink"),
            new("Clinking glasses", "1f942", "Food & Drink"),
            new("Clipboard", "1f4cb", "Objects"),
            new("Clockwise vertical arrows", "1f503", "Symbols"),
            new("Closed book", "1f4d5", "Objects"),
            new("Closed mailbox with lowered flag", "1f4ea", "Objects"),
            new("Closed mailbox with raised flag", "1f4eb", "Objects"),
            new("Closed umbrella", "1f302", "Travel & Places"),
            new("Cloud", "2601 fe0f", "Travel & Places"),
            new("Cloud with lightning", "1f329 fe0f", "Travel & Places"),
            new("Cloud with lightning and rain", "26c8 fe0f", "Travel & Places"),
            new("Cloud with rain", "1f327 fe0f", "Travel & Places"),
            new("Cloud with snow", "1f328 fe0f", "Travel & Places"),
            new("Clown face", "1f921", "Smileys & Emotion"),
            new("Club suit", "2663 fe0f", "Activities"),
            new("Clutch bag", "1f45d", "Objects"),
            new("Coat", "1f9e5", "Objects"),
            new("Cockroach", "1fab3", "Animals & Nature"),
            new("Cocktail glass", "1f378", "Food & Drink"),
            new("Coconut", "1f965", "Food & Drink"),
            new("Coffin", "26b0 fe0f", "Objects"),
            new("Coin", "1fa99", "Objects"),
            new("Cold face", "1f976", "Smileys & Emotion"),
            new("Collision", "1f4a5", "Smileys & Emotion"),
            new("Comet", "2604 fe0f", "Travel & Places"),
            new("Compass", "1f9ed", "Travel & Places"),
            new("Computer disk", "1f4bd", "Objects"),
            new("Computer mouse", "1f5b1 fe0f", "Objects"),
            new("Confetti ball", "1f38a", "Activities"),
            new("Confounded face", "1f616", "Smileys & Emotion"),
            new("Confused face", "1f615", "Smileys & Emotion"),
            new("Construction", "1f6a7", "Travel & Places"),
            new("Control knobs", "1f39b fe0f", "Objects"),
            new("Convenience store", "1f3ea", "Travel & Places"),
            new("Cooked rice", "1f35a", "Food & Drink"),
            new("Cookie", "1f36a", "Food & Drink"),
            new("Cooking", "1f373", "Food & Drink"),
            new("Cool button", "1f192", "Symbols"),
            new("Copyright", "00a9 fe0f", "Symbols"),
            new("Coral", "1fab8", "Animals & Nature"),
            new("Couch and lamp", "1f6cb fe0f", "Objects"),
            new("Counterclockwise arrows button", "1f504", "Symbols"),
            new("Cow", "1f404", "Animals & Nature"),
            new("Cow face", "1f42e", "Animals & Nature"),
            new("Cowboy hat face", "1f920", "Smileys & Emotion"),
            new("Crab", "1f980", "Food & Drink"),
            new("Crayon", "1f58d fe0f", "Objects"),
            new("Credit card", "1f4b3", "Objects"),
            new("Crescent moon", "1f319", "Travel & Places"),
            new("Cricket", "1f997", "Animals & Nature"),
            new("Cricket game", "1f3cf", "Activities"),
            new("Crocodile", "1f40a", "Animals & Nature"),
            new("Croissant", "1f950", "Food & Drink"),
            new("Cross mark", "274c", "Symbols"),
            new("Cross mark button", "274e", "Symbols"),
            new("Crossed flags", "1f38c", "Flags"),
            new("Crossed swords", "2694 fe0f", "Objects"),
            new("Crown", "1f451", "Objects"),
            new("Crutch", "1fa7c", "Objects"),
            new("Crying cat", "1f63f", "Smileys & Emotion"),
            new("Crying face", "1f622", "Smileys & Emotion"),
            new("Crystal ball", "1f52e", "Activities"),
            new("Cucumber", "1f952", "Food & Drink"),
            new("Cup with straw", "1f964", "Food & Drink"),
            new("Cupcake", "1f9c1", "Food & Drink"),
            new("Curling stone", "1f94c", "Activities"),
            new("Curly loop", "27b0", "Symbols"),
            new("Currency exchange", "1f4b1", "Symbols"),
            new("Curry rice", "1f35b", "Food & Drink"),
            new("Custard", "1f36e", "Food & Drink"),
            new("Customs", "1f6c3", "Symbols"),
            new("Cut of meat", "1f969", "Food & Drink"),
            new("Cyclone", "1f300", "Travel & Places"),
            new("Dagger", "1f5e1 fe0f", "Objects"),
            new("Dango", "1f361", "Food & Drink"),
            new("Dashing away", "1f4a8", "Smileys & Emotion"),
            new("Deciduous tree", "1f333", "Animals & Nature"),
            new("Deer", "1f98c", "Animals & Nature"),
            new("Delivery truck", "1f69a", "Travel & Places"),
            new("Department store", "1f3ec", "Travel & Places"),
            new("Derelict house", "1f3da fe0f", "Travel & Places"),
            new("Desert", "1f3dc fe0f", "Travel & Places"),
            new("Desert island", "1f3dd fe0f", "Travel & Places"),
            new("Desktop computer", "1f5a5 fe0f", "Objects"),
            new("Diamond suit", "2666 fe0f", "Activities"),
            new("Diamond with a dot", "1f4a0", "Symbols"),
            new("Dim button", "1f505", "Symbols"),
            new("Disappointed face", "1f61e", "Smileys & Emotion"),
            new("Disguised face", "1f978", "Smileys & Emotion"),
            new("Divide", "2797", "Symbols"),
            new("Diving mask", "1f93f", "Activities"),
            new("Diya lamp", "1fa94", "Objects"),
            new("Dizzy", "1f4ab", "Smileys & Emotion"),
            new("Dna", "1f9ec", "Objects"),
            new("Dodo", "1f9a4", "Animals & Nature"),
            new("Dog", "1f415", "Animals & Nature"),
            new("Dog face", "1f436", "Animals & Nature"),
            new("Dollar banknote", "1f4b5", "Objects"),
            new("Dolphin", "1f42c", "Animals & Nature"),
            new("Door", "1f6aa", "Objects"),
            new("Dotted line face", "1fae5", "Smileys & Emotion"),
            new("Dotted six-pointed star", "1f52f", "Symbols"),
            new("Double curly loop", "27bf", "Symbols"),
            new("Double exclamation mark", "203c fe0f", "Symbols"),
            new("Doughnut", "1f369", "Food & Drink"),
            new("Dove", "1f54a fe0f", "Animals & Nature"),
            new("Down arrow", "2b07 fe0f", "Symbols"),
            new("Down-left arrow", "2199 fe0f", "Symbols"),
            new("Down-right arrow", "2198 fe0f", "Symbols"),
            new("Downcast face with sweat", "1f613", "Smileys & Emotion"),
            new("Downwards button", "1f53d", "Symbols"),
            new("Dragon", "1f409", "Animals & Nature"),
            new("Dragon face", "1f432", "Animals & Nature"),
            new("Dress", "1f457", "Objects"),
            new("Drooling face", "1f924", "Smileys & Emotion"),
            new("Drop of blood", "1fa78", "Objects"),
            new("Droplet", "1f4a7", "Travel & Places"),
            new("Drum", "1f941", "Objects"),
            new("Duck", "1f986", "Animals & Nature"),
            new("Dumpling", "1f95f", "Food & Drink"),
            new("Dvd", "1f4c0", "Objects"),
            new("E-mail", "1f4e7", "Objects"),
            new("Eagle", "1f985", "Animals & Nature"),
            new("Ear of corn", "1f33d", "Food & Drink"),
            new("Egg", "1f95a", "Food & Drink"),
            new("Eggplant", "1f346", "Food & Drink"),
            new("Eight oclock", "1f557", "Travel & Places"),
            new("Eight-pointed star", "2734 fe0f", "Symbols"),
            new("Eight-spoked asterisk", "2733 fe0f", "Symbols"),
            new("Eight-thirty", "1f563", "Travel & Places"),
            new("Eject button", "23cf fe0f", "Symbols"),
            new("Electric plug", "1f50c", "Objects"),
            new("Elephant", "1f418", "Animals & Nature"),
            new("Elevator", "1f6d7", "Objects"),
            new("Eleven oclock", "1f55a", "Travel & Places"),
            new("Eleven-thirty", "1f566", "Travel & Places"),
            new("Empty nest", "1fab9", "Animals & Nature"),
            new("End arrow", "1f51a", "Symbols"),
            new("Envelope", "2709 fe0f", "Objects"),
            new("Envelope with arrow", "1f4e9", "Objects"),
            new("Euro banknote", "1f4b6", "Objects"),
            new("Evergreen tree", "1f332", "Animals & Nature"),
            new("Ewe", "1f411", "Animals & Nature"),
            new("Exclamation question mark", "2049 fe0f", "Symbols"),
            new("Exploding head", "1f92f", "Smileys & Emotion"),
            new("Expressionless face", "1f611", "Smileys & Emotion"),
            new("Eye", "1f441 fe0f", "People & Body"),
            new("Eye in speech bubble", "1f441 fe0f 200d 1f5e8 fe0f", "Smileys & Emotion"),
            new("Eyes", "1f440", "People & Body"),
            new("Face blowing a kiss", "1f618", "Smileys & Emotion"),
            new("Face exhaling", "1f62e 200d 1f4a8", "Smileys & Emotion"),
            new("Face holding back tears", "1f979", "Smileys & Emotion"),
            new("Face in clouds", "1f636 200d 1f32b fe0f", "Smileys & Emotion"),
            new("Face savoring food", "1f60b", "Smileys & Emotion"),
            new("Face screaming in fear", "1f631", "Smileys & Emotion"),
            new("Face vomiting", "1f92e", "Smileys & Emotion"),
            new("Face with diagonal mouth", "1fae4", "Smileys & Emotion"),
            new("Face with hand over mouth", "1f92d", "Smileys & Emotion"),
            new("Face with head-bandage", "1f915", "Smileys & Emotion"),
            new("Face with medical mask", "1f637", "Smileys & Emotion"),
            new("Face with monocle", "1f9d0", "Smileys & Emotion"),
            new("Face with open eyes and hand over mouth", "1fae2", "Smileys & Emotion"),
            new("Face with open mouth", "1f62e", "Smileys & Emotion"),
            new("Face with peeking eye", "1fae3", "Smileys & Emotion"),
            new("Face with raised eyebrow", "1f928", "Smileys & Emotion"),
            new("Face with rolling eyes", "1f644", "Smileys & Emotion"),
            new("Face with spiral eyes", "1f635 200d 1f4ab", "Smileys & Emotion"),
            new("Face with steam from nose", "1f624", "Smileys & Emotion"),
            new("Face with symbols on mouth", "1f92c", "Smileys & Emotion"),
            new("Face with tears of joy", "1f602", "Smileys & Emotion"),
            new("Face with thermometer", "1f912", "Smileys & Emotion"),
            new("Face with tongue", "1f61b", "Smileys & Emotion"),
            new("Face without mouth", "1f636", "Smileys & Emotion"),
            new("Factory", "1f3ed", "Travel & Places"),
            new("Falafel", "1f9c6", "Food & Drink"),
            new("Fallen leaf", "1f342", "Animals & Nature"),
            new("Fast down button", "23ec", "Symbols"),
            new("Fast reverse button", "23ea", "Symbols"),
            new("Fast up button", "23eb", "Symbols"),
            new("Fast-forward button", "23e9", "Symbols"),
            new("Fax machine", "1f4e0", "Objects"),
            new("Fearful face", "1f628", "Smileys & Emotion"),
            new("Feather", "1fab6", "Animals & Nature"),
            new("Female sign", "2640 fe0f", "Symbols"),
            new("Ferris wheel", "1f3a1", "Travel & Places"),
            new("Ferry", "26f4 fe0f", "Travel & Places"),
            new("Field hockey", "1f3d1", "Activities"),
            new("File cabinet", "1f5c4 fe0f", "Objects"),
            new("File folder", "1f4c1", "Objects"),
            new("Film frames", "1f39e fe0f", "Objects"),
            new("Film projector", "1f4fd fe0f", "Objects"),
            new("Fire", "1f525", "Travel & Places"),
            new("Fire engine", "1f692", "Travel & Places"),
            new("Fire extinguisher", "1f9ef", "Objects"),
            new("Firecracker", "1f9e8", "Activities"),
            new("Fireworks", "1f386", "Activities"),
            new("First quarter moon", "1f313", "Travel & Places"),
            new("First quarter moon face", "1f31b", "Travel & Places"),
            new("Fish", "1f41f", "Animals & Nature"),
            new("Fish cake with swirl", "1f365", "Food & Drink"),
            new("Fishing pole", "1f3a3", "Activities"),
            new("Five oclock", "1f554", "Travel & Places"),
            new("Five-thirty", "1f560", "Travel & Places"),
            new("Flag in hole", "26f3", "Activities"),
            new("Flamingo", "1f9a9", "Animals & Nature"),
            new("Flashlight", "1f526", "Objects"),
            new("Flat shoe", "1f97f", "Objects"),
            new("Flatbread", "1fad3", "Food & Drink"),
            new("Fleur-de-lis", "269c fe0f", "Symbols"),
            new("Floppy disk", "1f4be", "Objects"),
            new("Flower playing cards", "1f3b4", "Activities"),
            new("Flushed face", "1f633", "Smileys & Emotion"),
            new("Fly", "1fab0", "Animals & Nature"),
            new("Flying disc", "1f94f", "Activities"),
            new("Flying saucer", "1f6f8", "Travel & Places"),
            new("Fog", "1f32b fe0f", "Travel & Places"),
            new("Foggy", "1f301", "Travel & Places"),
            new("Fondue", "1fad5", "Food & Drink"),
            new("Footprints", "1f463", "People & Body"),
            new("Fork and knife", "1f374", "Food & Drink"),
            new("Fork and knife with plate", "1f37d fe0f", "Food & Drink"),
            new("Fortune cookie", "1f960", "Food & Drink"),
            new("Fountain", "26f2", "Travel & Places"),
            new("Fountain pen", "1f58b fe0f", "Objects"),
            new("Four leaf clover", "1f340", "Animals & Nature"),
            new("Four oclock", "1f553", "Travel & Places"),
            new("Four-thirty", "1f55f", "Travel & Places"),
            new("Fox", "1f98a", "Animals & Nature"),
            new("Framed picture", "1f5bc fe0f", "Activities"),
            new("Free button", "1f193", "Symbols"),
            new("French fries", "1f35f", "Food & Drink"),
            new("Fried shrimp", "1f364", "Food & Drink"),
            new("Frog", "1f438", "Animals & Nature"),
            new("Front-facing baby chick", "1f425", "Animals & Nature"),
            new("Frowning face", "2639 fe0f", "Smileys & Emotion"),
            new("Frowning face with open mouth", "1f626", "Smileys & Emotion"),
            new("Fuel pump", "26fd", "Travel & Places"),
            new("Full moon", "1f315", "Travel & Places"),
            new("Full moon face", "1f31d", "Travel & Places"),
            new("Funeral urn", "26b1 fe0f", "Objects"),
            new("Game die", "1f3b2", "Activities"),
            new("Garlic", "1f9c4", "Food & Drink"),
            new("Gear", "2699 fe0f", "Objects"),
            new("Gem stone", "1f48e", "Objects"),
            new("Gemini", "264a", "Symbols"),
            new("Ghost", "1f47b", "Smileys & Emotion"),
            new("Giraffe", "1f992", "Animals & Nature"),
            new("Glass of milk", "1f95b", "Food & Drink"),
            new("Glasses", "1f453", "Objects"),
            new("Globe showing americas", "1f30e", "Travel & Places"),
            new("Globe showing asia-australia", "1f30f", "Travel & Places"),
            new("Globe showing europe-africa", "1f30d", "Travel & Places"),
            new("Globe with meridians", "1f310", "Travel & Places"),
            new("Gloves", "1f9e4", "Objects"),
            new("Glowing star", "1f31f", "Travel & Places"),
            new("Goal net", "1f945", "Activities"),
            new("Goat", "1f410", "Animals & Nature"),
            new("Goblin", "1f47a", "Smileys & Emotion"),
            new("Goggles", "1f97d", "Objects"),
            new("Gorilla", "1f98d", "Animals & Nature"),
            new("Graduation cap", "1f393", "Objects"),
            new("Grapes", "1f347", "Food & Drink"),
            new("Green apple", "1f34f", "Food & Drink"),
            new("Green book", "1f4d7", "Objects"),
            new("Green circle", "1f7e2", "Symbols"),
            new("Green heart", "1f49a", "Smileys & Emotion"),
            new("Green salad", "1f957", "Food & Drink"),
            new("Green square", "1f7e9", "Symbols"),
            new("Grimacing face", "1f62c", "Smileys & Emotion"),
            new("Grinning cat", "1f63a", "Smileys & Emotion"),
            new("Grinning cat with smiling eyes", "1f638", "Smileys & Emotion"),
            new("Grinning face", "1f600", "Smileys & Emotion"),
            new("Grinning face with big eyes", "1f603", "Smileys & Emotion"),
            new("Grinning face with smiling eyes", "1f604", "Smileys & Emotion"),
            new("Grinning face with sweat", "1f605", "Smileys & Emotion"),
            new("Grinning squinting face", "1f606", "Smileys & Emotion"),
            new("Growing heart", "1f497", "Smileys & Emotion"),
            new("Guide dog", "1f9ae", "Animals & Nature"),
            new("Guitar", "1f3b8", "Objects"),
            new("Hamburger", "1f354", "Food & Drink"),
            new("Hammer", "1f528", "Objects"),
            new("Hammer and pick", "2692 fe0f", "Objects"),
            new("Hammer and wrench", "1f6e0 fe0f", "Objects"),
            new("Hamsa", "1faac", "Activities"),
            new("Hamster", "1f439", "Animals & Nature"),
            new("Handbag", "1f45c", "Objects"),
            new("Handshake", "1f91d", "People & Body"),
            new("Hatching chick", "1f423", "Animals & Nature"),
            new("Headphone", "1f3a7", "Objects"),
            new("Headstone", "1faa6", "Objects"),
            new("Hear-no-evil monkey", "1f649", "Smileys & Emotion"),
            new("Heart decoration", "1f49f", "Smileys & Emotion"),
            new("Heart exclamation", "2763 fe0f", "Smileys & Emotion"),
            new("Heart on fire", "2764 fe0f 200d 1f525", "Smileys & Emotion"),
            new("Heart suit", "2665 fe0f", "Activities"),
            new("Heart with arrow", "1f498", "Smileys & Emotion"),
            new("Heart with ribbon", "1f49d", "Smileys & Emotion"),
            new("Heavy dollar sign", "1f4b2", "Symbols"),
            new("Heavy equals sign", "1f7f0", "Symbols"),
            new("Hedgehog", "1f994", "Animals & Nature"),
            new("Helicopter", "1f681", "Travel & Places"),
            new("Herb", "1f33f", "Animals & Nature"),
            new("Hibiscus", "1f33a", "Animals & Nature"),
            new("High voltage", "26a1", "Travel & Places"),
            new("High-heeled shoe", "1f460", "Objects"),
            new("High-speed train", "1f684", "Travel & Places"),
            new("Hiking boot", "1f97e", "Objects"),
            new("Hindu temple", "1f6d5", "Travel & Places"),
            new("Hippopotamus", "1f99b", "Animals & Nature"),
            new("Hole", "1f573 fe0f", "Smileys & Emotion"),
            new("Hollow red circle", "2b55", "Symbols"),
            new("Honey pot", "1f36f", "Food & Drink"),
            new("Honeybee", "1f41d", "Animals & Nature"),
            new("Hook", "1fa9d", "Objects"),
            new("Horizontal traffic light", "1f6a5", "Travel & Places"),
            new("Horse", "1f40e", "Animals & Nature"),
            new("Horse face", "1f434", "Animals & Nature"),
            new("Hospital", "1f3e5", "Travel & Places"),
            new("Hot beverage", "2615", "Food & Drink"),
            new("Hot dog", "1f32d", "Food & Drink"),
            new("Hot face", "1f975", "Smileys & Emotion"),
            new("Hot pepper", "1f336 fe0f", "Food & Drink"),
            new("Hot springs", "2668 fe0f", "Travel & Places"),
            new("Hotel", "1f3e8", "Travel & Places"),
            new("Hourglass done", "231b", "Travel & Places"),
            new("Hourglass not done", "23f3", "Travel & Places"),
            new("House", "1f3e0", "Travel & Places"),
            new("House with garden", "1f3e1", "Travel & Places"),
            new("Houses", "1f3d8 fe0f", "Travel & Places"),
            new("Hugging face", "1f917", "Smileys & Emotion"),
            new("Hundred points", "1f4af", "Smileys & Emotion"),
            new("Hushed face", "1f62f", "Smileys & Emotion"),
            new("Hut", "1f6d6", "Travel & Places"),
            new("Ice", "1f9ca", "Food & Drink"),
            new("Ice cream", "1f368", "Food & Drink"),
            new("Ice hockey", "1f3d2", "Activities"),
            new("Ice skate", "26f8 fe0f", "Activities"),
            new("Id button", "1f194", "Symbols"),
            new("Identification card", "1faaa", "Objects"),
            new("Inbox tray", "1f4e5", "Objects"),
            new("Incoming envelope", "1f4e8", "Objects"),
            new("Infinity", "267e fe0f", "Symbols"),
            new("Information", "2139 fe0f", "Symbols"),
            new("Input latin letters", "1f524", "Symbols"),
            new("Input latin lowercase", "1f521", "Symbols"),
            new("Input latin uppercase", "1f520", "Symbols"),
            new("Input numbers", "1f522", "Symbols"),
            new("Input symbols", "1f523", "Symbols"),
            new("Jack-o-lantern", "1f383", "Activities"),
            new("Japanese acceptable button", "1f251", "Symbols"),
            new("Japanese application button", "1f238", "Symbols"),
            new("Japanese bargain button", "1f250", "Symbols"),
            new("Japanese castle", "1f3ef", "Travel & Places"),
            new("Japanese congratulations button", "3297 fe0f", "Symbols"),
            new("Japanese discount button", "1f239", "Symbols"),
            new("Japanese dolls", "1f38e", "Activities"),
            new("Japanese free of charge button", "1f21a", "Symbols"),
            new("Japanese here button", "1f201", "Symbols"),
            new("Japanese monthly amount button", "1f237 fe0f", "Symbols"),
            new("Japanese no vacancy button", "1f235", "Symbols"),
            new("Japanese not free of charge button", "1f236", "Symbols"),
            new("Japanese open for business button", "1f23a", "Symbols"),
            new("Japanese passing grade button", "1f234", "Symbols"),
            new("Japanese post office", "1f3e3", "Travel & Places"),
            new("Japanese prohibited button", "1f232", "Symbols"),
            new("Japanese reserved button", "1f22f", "Symbols"),
            new("Japanese secret button", "3299 fe0f", "Symbols"),
            new("Japanese service charge button", "1f202 fe0f", "Symbols"),
            new("Japanese symbol for beginner", "1f530", "Symbols"),
            new("Japanese vacancy button", "1f233", "Symbols"),
            new("Jar", "1fad9", "Food & Drink"),
            new("Jeans", "1f456", "Objects"),
            new("Joker", "1f0cf", "Activities"),
            new("Joystick", "1f579 fe0f", "Activities"),
            new("Kaaba", "1f54b", "Travel & Places"),
            new("Kangaroo", "1f998", "Animals & Nature"),
            new("Key", "1f511", "Objects"),
            new("Keyboard", "2328 fe0f", "Objects"),
            new("Keycap 0", "0030 fe0f 20e3", "Symbols"),
            new("Keycap 1", "0031 fe0f 20e3", "Symbols"),
            new("Keycap 10", "1f51f", "Symbols"),
            new("Keycap 2", "0032 fe0f 20e3", "Symbols"),
            new("Keycap 3", "0033 fe0f 20e3", "Symbols"),
            new("Keycap 4", "0034 fe0f 20e3", "Symbols"),
            new("Keycap 5", "0035 fe0f 20e3", "Symbols"),
            new("Keycap 6", "0036 fe0f 20e3", "Symbols"),
            new("Keycap 7", "0037 fe0f 20e3", "Symbols"),
            new("Keycap 8", "0038 fe0f 20e3", "Symbols"),
            new("Keycap 9", "0039 fe0f 20e3", "Symbols"),
            new("Keycap asterisk", "002a fe0f 20e3", "Symbols"),
            new("Keycap hashtag", "0023 fe0f 20e3", "Symbols"),
            new("Kick scooter", "1f6f4", "Travel & Places"),
            new("Kimono", "1f458", "Objects"),
            new("Kiss mark", "1f48b", "Smileys & Emotion"),
            new("Kissing cat", "1f63d", "Smileys & Emotion"),
            new("Kissing face", "1f617", "Smileys & Emotion"),
            new("Kissing face with closed eyes", "1f61a", "Smileys & Emotion"),
            new("Kissing face with smiling eyes", "1f619", "Smileys & Emotion"),
            new("Kitchen knife", "1f52a", "Food & Drink"),
            new("Kite", "1fa81", "Activities"),
            new("Kiwi fruit", "1f95d", "Food & Drink"),
            new("Knocked-out face", "1f635", "Smileys & Emotion"),
            new("Knot", "1faa2", "Activities"),
            new("Koala", "1f428", "Animals & Nature"),
            new("Lab coat", "1f97c", "Objects"),
            new("Label", "1f3f7 fe0f", "Objects"),
            new("Lacrosse", "1f94d", "Activities"),
            new("Ladder", "1fa9c", "Objects"),
            new("Lady beetle", "1f41e", "Animals & Nature"),
            new("Laptop", "1f4bb", "Objects"),
            new("Large blue diamond", "1f537", "Symbols"),
            new("Large orange diamond", "1f536", "Symbols"),
            new("Last quarter moon", "1f317", "Travel & Places"),
            new("Last quarter moon face", "1f31c", "Travel & Places"),
            new("Last track button", "23ee fe0f", "Symbols"),
            new("Latin cross", "271d fe0f", "Symbols"),
            new("Leaf fluttering in wind", "1f343", "Animals & Nature"),
            new("Leafy green", "1f96c", "Food & Drink"),
            new("Ledger", "1f4d2", "Objects"),
            new("Left arrow", "2b05 fe0f", "Symbols"),
            new("Left arrow curving right", "21aa fe0f", "Symbols"),
            new("Left luggage", "1f6c5", "Symbols"),
            new("Left speech bubble", "1f5e8 fe0f", "Smileys & Emotion"),
            new("Left-right arrow", "2194 fe0f", "Symbols"),
            new("Lemon", "1f34b", "Food & Drink"),
            new("Leo", "264c", "Symbols"),
            new("Leopard", "1f406", "Animals & Nature"),
            new("Level slider", "1f39a fe0f", "Objects"),
            new("Libra", "264e", "Symbols"),
            new("Light bulb", "1f4a1", "Objects"),
            new("Light rail", "1f688", "Travel & Places"),
            new("Link", "1f517", "Objects"),
            new("Linked paperclips", "1f587 fe0f", "Objects"),
            new("Lion", "1f981", "Animals & Nature"),
            new("Lipstick", "1f484", "Objects"),
            new("Litter in bin sign", "1f6ae", "Symbols"),
            new("Lizard", "1f98e", "Animals & Nature"),
            new("Llama", "1f999", "Animals & Nature"),
            new("Lobster", "1f99e", "Food & Drink"),
            new("Locked", "1f512", "Objects"),
            new("Locked with key", "1f510", "Objects"),
            new("Locked with pen", "1f50f", "Objects"),
            new("Locomotive", "1f682", "Travel & Places"),
            new("Lollipop", "1f36d", "Food & Drink"),
            new("Long drum", "1fa98", "Objects"),
            new("Lotion bottle", "1f9f4", "Objects"),
            new("Lotus", "1fab7", "Animals & Nature"),
            new("Loudly crying face", "1f62d", "Smileys & Emotion"),
            new("Loudspeaker", "1f4e2", "Objects"),
            new("Love hotel", "1f3e9", "Travel & Places"),
            new("Love letter", "1f48c", "Smileys & Emotion"),
            new("Low battery", "1faab", "Objects"),
            new("Luggage", "1f9f3", "Travel & Places"),
            new("Lungs", "1fac1", "People & Body"),
            new("Lying face", "1f925", "Smileys & Emotion"),
            new("Magic wand", "1fa84", "Activities"),
            new("Magnet", "1f9f2", "Objects"),
            new("Magnifying glass tilted left", "1f50d", "Objects"),
            new("Magnifying glass tilted right", "1f50e", "Objects"),
            new("Mahjong red dragon", "1f004", "Activities"),
            new("Male sign", "2642 fe0f", "Symbols"),
            new("Mammoth", "1f9a3", "Animals & Nature"),
            new("Man genie", "1f9de 200d 2642 fe0f", "People & Body"),
            new("Man with bunny ears", "1f46f 200d 2642 fe0f", "People & Body"),
            new("Man wrestling", "1f93c 200d 2642 fe0f", "People & Body"),
            new("Man zombie", "1f9df 200d 2642 fe0f", "People & Body"),
            new("Mango", "1f96d", "Food & Drink"),
            new("Mans shoe", "1f45e", "Objects"),
            new("Mantelpiece clock", "1f570 fe0f", "Travel & Places"),
            new("Manual wheelchair", "1f9bd", "Travel & Places"),
            new("Map of japan", "1f5fe", "Travel & Places"),
            new("Maple leaf", "1f341", "Animals & Nature"),
            new("Martial arts uniform", "1f94b", "Activities"),
            new("Mate", "1f9c9", "Food & Drink"),
            new("Meat on bone", "1f356", "Food & Drink"),
            new("Mechanical arm", "1f9be", "People & Body"),
            new("Mechanical leg", "1f9bf", "People & Body"),
            new("Medical symbol", "2695 fe0f", "Symbols"),
            new("Megaphone", "1f4e3", "Objects"),
            new("Melon", "1f348", "Food & Drink"),
            new("Melting face", "1fae0", "Smileys & Emotion"),
            new("Memo", "1f4dd", "Objects"),
            new("Mending heart", "2764 fe0f 200d 1fa79", "Smileys & Emotion"),
            new("Menorah", "1f54e", "Symbols"),
            new("Mens room", "1f6b9", "Symbols"),
            new("Metro", "1f687", "Travel & Places"),
            new("Microbe", "1f9a0", "Animals & Nature"),
            new("Microphone", "1f3a4", "Objects"),
            new("Microscope", "1f52c", "Objects"),
            new("Military helmet", "1fa96", "Objects"),
            new("Military medal", "1f396 fe0f", "Activities"),
            new("Milky way", "1f30c", "Travel & Places"),
            new("Minibus", "1f690", "Travel & Places"),
            new("Minus", "2796", "Symbols"),
            new("Mirror", "1fa9e", "Objects"),
            new("Mirror ball", "1faa9", "Activities"),
            new("Moai", "1f5ff", "Objects"),
            new("Mobile phone", "1f4f1", "Objects"),
            new("Mobile phone off", "1f4f4", "Symbols"),
            new("Mobile phone with arrow", "1f4f2", "Objects"),
            new("Money bag", "1f4b0", "Objects"),
            new("Money with wings", "1f4b8", "Objects"),
            new("Money-mouth face", "1f911", "Smileys & Emotion"),
            new("Monkey", "1f412", "Animals & Nature"),
            new("Monkey face", "1f435", "Animals & Nature"),
            new("Monorail", "1f69d", "Travel & Places"),
            new("Moon cake", "1f96e", "Food & Drink"),
            new("Moon viewing ceremony", "1f391", "Activities"),
            new("Mosque", "1f54c", "Travel & Places"),
            new("Mosquito", "1f99f", "Animals & Nature"),
            new("Motor boat", "1f6e5 fe0f", "Travel & Places"),
            new("Motor scooter", "1f6f5", "Travel & Places"),
            new("Motorcycle", "1f3cd fe0f", "Travel & Places"),
            new("Motorized wheelchair", "1f9bc", "Travel & Places"),
            new("Motorway", "1f6e3 fe0f", "Travel & Places"),
            new("Mount fuji", "1f5fb", "Travel & Places"),
            new("Mountain", "26f0 fe0f", "Travel & Places"),
            new("Mountain cableway", "1f6a0", "Travel & Places"),
            new("Mountain railway", "1f69e", "Travel & Places"),
            new("Mouse", "1f401", "Animals & Nature"),
            new("Mouse face", "1f42d", "Animals & Nature"),
            new("Mouse trap", "1faa4", "Objects"),
            new("Mouth", "1f444", "People & Body"),
            new("Movie camera", "1f3a5", "Objects"),
            new("Multiply", "2716 fe0f", "Symbols"),
            new("Mushroom", "1f344", "Food & Drink"),
            new("Musical keyboard", "1f3b9", "Objects"),
            new("Musical note", "1f3b5", "Objects"),
            new("Musical notes", "1f3b6", "Objects"),
            new("Musical score", "1f3bc", "Objects"),
            new("Muted speaker", "1f507", "Objects"),
            new("Name badge", "1f4db", "Symbols"),
            new("National park", "1f3de fe0f", "Travel & Places"),
            new("Nauseated face", "1f922", "Smileys & Emotion"),
            new("Nazar amulet", "1f9ff", "Activities"),
            new("Necktie", "1f454", "Objects"),
            new("Nerd face", "1f913", "Smileys & Emotion"),
            new("Nest with eggs", "1faba", "Animals & Nature"),
            new("Nesting dolls", "1fa86", "Activities"),
            new("Neutral face", "1f610", "Smileys & Emotion"),
            new("New button", "1f195", "Symbols"),
            new("New moon", "1f311", "Travel & Places"),
            new("New moon face", "1f31a", "Travel & Places"),
            new("Newspaper", "1f4f0", "Objects"),
            new("Next track button", "23ed fe0f", "Symbols"),
            new("Ng button", "1f196", "Symbols"),
            new("Night with stars", "1f303", "Travel & Places"),
            new("Nine oclock", "1f558", "Travel & Places"),
            new("Nine-thirty", "1f564", "Travel & Places"),
            new("No bicycles", "1f6b3", "Symbols"),
            new("No entry", "26d4", "Symbols"),
            new("No littering", "1f6af", "Symbols"),
            new("No mobile phones", "1f4f5", "Symbols"),
            new("No one under eighteen", "1f51e", "Symbols"),
            new("No pedestrians", "1f6b7", "Symbols"),
            new("No smoking", "1f6ad", "Symbols"),
            new("Non-potable water", "1f6b1", "Symbols"),
            new("Notebook", "1f4d3", "Objects"),
            new("Notebook with decorative cover", "1f4d4", "Objects"),
            new("Nut and bolt", "1f529", "Objects"),
            new("O button blood type", "1f17e fe0f", "Symbols"),
            new("Octopus", "1f419", "Animals & Nature"),
            new("Oden", "1f362", "Food & Drink"),
            new("Office building", "1f3e2", "Travel & Places"),
            new("Ogre", "1f479", "Smileys & Emotion"),
            new("Oil drum", "1f6e2 fe0f", "Travel & Places"),
            new("Ok button", "1f197", "Symbols"),
            new("Old key", "1f5dd fe0f", "Objects"),
            new("Olive", "1fad2", "Food & Drink"),
            new("Om", "1f549 fe0f", "Symbols"),
            new("On! arrow", "1f51b", "Symbols"),
            new("Oncoming automobile", "1f698", "Travel & Places"),
            new("Oncoming bus", "1f68d", "Travel & Places"),
            new("Oncoming police car", "1f694", "Travel & Places"),
            new("Oncoming taxi", "1f696", "Travel & Places"),
            new("One oclock", "1f550", "Travel & Places"),
            new("One-piece swimsuit", "1fa71", "Objects"),
            new("One-thirty", "1f55c", "Travel & Places"),
            new("Onion", "1f9c5", "Food & Drink"),
            new("Open book", "1f4d6", "Objects"),
            new("Open file folder", "1f4c2", "Objects"),
            new("Open mailbox with lowered flag", "1f4ed", "Objects"),
            new("Open mailbox with raised flag", "1f4ec", "Objects"),
            new("Ophiuchus", "26ce", "Symbols"),
            new("Optical disk", "1f4bf", "Objects"),
            new("Orange book", "1f4d9", "Objects"),
            new("Orange circle", "1f7e0", "Symbols"),
            new("Orange heart", "1f9e1", "Smileys & Emotion"),
            new("Orange square", "1f7e7", "Symbols"),
            new("Orangutan", "1f9a7", "Animals & Nature"),
            new("Orthodox cross", "2626 fe0f", "Symbols"),
            new("Otter", "1f9a6", "Animals & Nature"),
            new("Outbox tray", "1f4e4", "Objects"),
            new("Owl", "1f989", "Animals & Nature"),
            new("Ox", "1f402", "Animals & Nature"),
            new("Oyster", "1f9aa", "Food & Drink"),
            new("P button", "1f17f fe0f", "Symbols"),
            new("Package", "1f4e6", "Objects"),
            new("Page facing up", "1f4c4", "Objects"),
            new("Page with curl", "1f4c3", "Objects"),
            new("Pager", "1f4df", "Objects"),
            new("Paintbrush", "1f58c fe0f", "Objects"),
            new("Palm tree", "1f334", "Animals & Nature"),
            new("Pancakes", "1f95e", "Food & Drink"),
            new("Panda", "1f43c", "Animals & Nature"),
            new("Parachute", "1fa82", "Travel & Places"),
            new("Parrot", "1f99c", "Animals & Nature"),
            new("Part alternation mark", "303d fe0f", "Symbols"),
            new("Party popper", "1f389", "Activities"),
            new("Partying face", "1f973", "Smileys & Emotion"),
            new("Passenger ship", "1f6f3 fe0f", "Travel & Places"),
            new("Passport control", "1f6c2", "Symbols"),
            new("Pause button", "23f8 fe0f", "Symbols"),
            new("Paw prints", "1f43e", "Animals & Nature"),
            new("Peace symbol", "262e fe0f", "Symbols"),
            new("Peach", "1f351", "Food & Drink"),
            new("Peacock", "1f99a", "Animals & Nature"),
            new("Peanuts", "1f95c", "Food & Drink"),
            new("Pear", "1f350", "Food & Drink"),
            new("Pen", "1f58a fe0f", "Objects"),
            new("Pencil", "270f fe0f", "Objects"),
            new("Penguin", "1f427", "Animals & Nature"),
            new("Pensive face", "1f614", "Smileys & Emotion"),
            new("People hugging", "1fac2", "People & Body"),
            new("Performing arts", "1f3ad", "Activities"),
            new("Persevering face", "1f623", "Smileys & Emotion"),
            new("Person fencing", "1f93a", "People & Body"),
            new("Person genie", "1f9de", "People & Body"),
            new("Person with bunny ears", "1f46f", "People & Body"),
            new("Person wrestling", "1f93c", "People & Body"),
            new("Person zombie", "1f9df", "People & Body"),
            new("Petri dish", "1f9eb", "Objects"),
            new("Pick", "26cf fe0f", "Objects"),
            new("Pickup truck", "1f6fb", "Travel & Places"),
            new("Pie", "1f967", "Food & Drink"),
            new("Pig", "1f416", "Animals & Nature"),
            new("Pig face", "1f437", "Animals & Nature"),
            new("Pig nose", "1f43d", "Animals & Nature"),
            new("Pile of poo", "1f4a9", "Smileys & Emotion"),
            new("Pill", "1f48a", "Objects"),
            new("Pine decoration", "1f38d", "Activities"),
            new("Pineapple", "1f34d", "Food & Drink"),
            new("Ping pong", "1f3d3", "Activities"),
            new("Pirate flag", "1f3f4 200d 2620 fe0f", "Flags"),
            new("Pisces", "2653", "Symbols"),
            new("Pizza", "1f355", "Food & Drink"),
            new("Piñata", "1fa85", "Activities"),
            new("Placard", "1faa7", "Objects"),
            new("Place of worship", "1f6d0", "Symbols"),
            new("Play button", "25b6 fe0f", "Symbols"),
            new("Play or pause button", "23ef fe0f", "Symbols"),
            new("Playground slide", "1f6dd", "Travel & Places"),
            new("Pleading face", "1f97a", "Smileys & Emotion"),
            new("Plunger", "1faa0", "Objects"),
            new("Plus", "2795", "Symbols"),
            new("Polar bear", "1f43b 200d 2744 fe0f", "Animals & Nature"),
            new("Police car", "1f693", "Travel & Places"),
            new("Police car light", "1f6a8", "Travel & Places"),
            new("Poodle", "1f429", "Animals & Nature"),
            new("Pool 8 ball", "1f3b1", "Activities"),
            new("Popcorn", "1f37f", "Food & Drink"),
            new("Post office", "1f3e4", "Travel & Places"),
            new("Postal horn", "1f4ef", "Objects"),
            new("Postbox", "1f4ee", "Objects"),
            new("Pot of food", "1f372", "Food & Drink"),
            new("Potable water", "1f6b0", "Symbols"),
            new("Potato", "1f954", "Food & Drink"),
            new("Potted plant", "1fab4", "Animals & Nature"),
            new("Poultry leg", "1f357", "Food & Drink"),
            new("Pound banknote", "1f4b7", "Objects"),
            new("Pouring liquid", "1fad7", "Food & Drink"),
            new("Pouting cat", "1f63e", "Smileys & Emotion"),
            new("Pouting face", "1f621", "Smileys & Emotion"),
            new("Prayer beads", "1f4ff", "Objects"),
            new("Pretzel", "1f968", "Food & Drink"),
            new("Printer", "1f5a8 fe0f", "Objects"),
            new("Prohibited", "1f6ab", "Symbols"),
            new("Purple circle", "1f7e3", "Symbols"),
            new("Purple heart", "1f49c", "Smileys & Emotion"),
            new("Purple square", "1f7ea", "Symbols"),
            new("Purse", "1f45b", "Objects"),
            new("Pushpin", "1f4cc", "Objects"),
            new("Puzzle piece", "1f9e9", "Activities"),
            new("Rabbit", "1f407", "Animals & Nature"),
            new("Rabbit face", "1f430", "Animals & Nature"),
            new("Raccoon", "1f99d", "Animals & Nature"),
            new("Racing car", "1f3ce fe0f", "Travel & Places"),
            new("Radio", "1f4fb", "Objects"),
            new("Radio button", "1f518", "Symbols"),
            new("Radioactive", "2622 fe0f", "Symbols"),
            new("Railway car", "1f683", "Travel & Places"),
            new("Railway track", "1f6e4 fe0f", "Travel & Places"),
            new("Rainbow", "1f308", "Travel & Places"),
            new("Rainbow flag", "1f3f3 fe0f 200d 1f308", "Flags"),
            new("Ram", "1f40f", "Animals & Nature"),
            new("Rat", "1f400", "Animals & Nature"),
            new("Razor", "1fa92", "Objects"),
            new("Receipt", "1f9fe", "Objects"),
            new("Record button", "23fa fe0f", "Symbols"),
            new("Recycling symbol", "267b fe0f", "Symbols"),
            new("Red apple", "1f34e", "Food & Drink"),
            new("Red circle", "1f534", "Symbols"),
            new("Red envelope", "1f9e7", "Activities"),
            new("Red exclamation mark", "2757", "Symbols"),
            new("Red heart", "2764 fe0f", "Smileys & Emotion"),
            new("Red paper lantern", "1f3ee", "Objects"),
            new("Red question mark", "2753", "Symbols"),
            new("Red square", "1f7e5", "Symbols"),
            new("Red triangle", "1f53a", "Symbols"),
            new("Red triangle pointed down", "1f53b", "Symbols"),
            new("Registered", "00ae fe0f", "Symbols"),
            new("Relieved face", "1f60c", "Smileys & Emotion"),
            new("Reminder ribbon", "1f397 fe0f", "Activities"),
            new("Repeat button", "1f501", "Symbols"),
            new("Repeat single button", "1f502", "Symbols"),
            new("Rescue workers helmet", "26d1 fe0f", "Objects"),
            new("Restroom", "1f6bb", "Symbols"),
            new("Reverse button", "25c0 fe0f", "Symbols"),
            new("Revolving hearts", "1f49e", "Smileys & Emotion"),
            new("Rhinoceros", "1f98f", "Animals & Nature"),
            new("Ribbon", "1f380", "Activities"),
            new("Rice ball", "1f359", "Food & Drink"),
            new("Rice cracker", "1f358", "Food & Drink"),
            new("Right anger bubble", "1f5ef fe0f", "Smileys & Emotion"),
            new("Right arrow", "27a1 fe0f", "Symbols"),
            new("Right arrow curving down", "2935 fe0f", "Symbols"),
            new("Right arrow curving left", "21a9 fe0f", "Symbols"),
            new("Right arrow curving up", "2934 fe0f", "Symbols"),
            new("Ring", "1f48d", "Objects"),
            new("Ring buoy", "1f6df", "Travel & Places"),
            new("Ringed planet", "1fa90", "Travel & Places"),
            new("Roasted sweet potato", "1f360", "Food & Drink"),
            new("Robot", "1f916", "Smileys & Emotion"),
            new("Rock", "1faa8", "Travel & Places"),
            new("Rocket", "1f680", "Travel & Places"),
            new("Roll of paper", "1f9fb", "Objects"),
            new("Rolled-up newspaper", "1f5de fe0f", "Objects"),
            new("Roller coaster", "1f3a2", "Travel & Places"),
            new("Roller skate", "1f6fc", "Travel & Places"),
            new("Rolling on the floor laughing", "1f923", "Smileys & Emotion"),
            new("Rooster", "1f413", "Animals & Nature"),
            new("Rose", "1f339", "Animals & Nature"),
            new("Rosette", "1f3f5 fe0f", "Animals & Nature"),
            new("Round pushpin", "1f4cd", "Objects"),
            new("Rugby football", "1f3c9", "Activities"),
            new("Running shirt", "1f3bd", "Activities"),
            new("Running shoe", "1f45f", "Objects"),
            new("Sad but relieved face", "1f625", "Smileys & Emotion"),
            new("Safety pin", "1f9f7", "Objects"),
            new("Safety vest", "1f9ba", "Objects"),
            new("Sagittarius", "2650", "Symbols"),
            new("Sailboat", "26f5", "Travel & Places"),
            new("Sake", "1f376", "Food & Drink"),
            new("Salt", "1f9c2", "Food & Drink"),
            new("Saluting face", "1fae1", "Smileys & Emotion"),
            new("Sandwich", "1f96a", "Food & Drink"),
            new("Sari", "1f97b", "Objects"),
            new("Satellite", "1f6f0 fe0f", "Travel & Places"),
            new("Satellite antenna", "1f4e1", "Objects"),
            new("Sauropod", "1f995", "Animals & Nature"),
            new("Saxophone", "1f3b7", "Objects"),
            new("Scarf", "1f9e3", "Objects"),
            new("School", "1f3eb", "Travel & Places"),
            new("Scissors", "2702 fe0f", "Objects"),
            new("Scorpio", "264f", "Symbols"),
            new("Scorpion", "1f982", "Animals & Nature"),
            new("Screwdriver", "1fa9b", "Objects"),
            new("Scroll", "1f4dc", "Objects"),
            new("Seal", "1f9ad", "Animals & Nature"),
            new("Seat", "1f4ba", "Travel & Places"),
            new("See-no-evil monkey", "1f648", "Smileys & Emotion"),
            new("Seedling", "1f331", "Animals & Nature"),
            new("Service dog", "1f415 200d 1f9ba", "Animals & Nature"),
            new("Seven oclock", "1f556", "Travel & Places"),
            new("Seven-thirty", "1f562", "Travel & Places"),
            new("Sewing needle", "1faa1", "Activities"),
            new("Shallow pan of food", "1f958", "Food & Drink"),
            new("Shamrock", "2618 fe0f", "Animals & Nature"),
            new("Shark", "1f988", "Animals & Nature"),
            new("Shaved ice", "1f367", "Food & Drink"),
            new("Sheaf of rice", "1f33e", "Animals & Nature"),
            new("Shield", "1f6e1 fe0f", "Objects"),
            new("Shinto shrine", "26e9 fe0f", "Travel & Places"),
            new("Ship", "1f6a2", "Travel & Places"),
            new("Shooting star", "1f320", "Travel & Places"),
            new("Shopping bags", "1f6cd fe0f", "Objects"),
            new("Shopping cart", "1f6d2", "Objects"),
            new("Shortcake", "1f370", "Food & Drink"),
            new("Shorts", "1fa73", "Objects"),
            new("Shower", "1f6bf", "Objects"),
            new("Shrimp", "1f990", "Food & Drink"),
            new("Shuffle tracks button", "1f500", "Symbols"),
            new("Shushing face", "1f92b", "Smileys & Emotion"),
            new("Six oclock", "1f555", "Travel & Places"),
            new("Six-thirty", "1f561", "Travel & Places"),
            new("Skateboard", "1f6f9", "Travel & Places"),
            new("Skier", "26f7 fe0f", "People & Body"),
            new("Skis", "1f3bf", "Activities"),
            new("Skull", "1f480", "Smileys & Emotion"),
            new("Skull and crossbones", "2620 fe0f", "Smileys & Emotion"),
            new("Skunk", "1f9a8", "Animals & Nature"),
            new("Sled", "1f6f7", "Activities"),
            new("Sleeping face", "1f634", "Smileys & Emotion"),
            new("Sleepy face", "1f62a", "Smileys & Emotion"),
            new("Slightly frowning face", "1f641", "Smileys & Emotion"),
            new("Slightly smiling face", "1f642", "Smileys & Emotion"),
            new("Slot machine", "1f3b0", "Activities"),
            new("Sloth", "1f9a5", "Animals & Nature"),
            new("Small airplane", "1f6e9 fe0f", "Travel & Places"),
            new("Small blue diamond", "1f539", "Symbols"),
            new("Small orange diamond", "1f538", "Symbols"),
            new("Smiling cat with heart-eyes", "1f63b", "Smileys & Emotion"),
            new("Smiling face", "263a fe0f", "Smileys & Emotion"),
            new("Smiling face with halo", "1f607", "Smileys & Emotion"),
            new("Smiling face with heart-eyes", "1f60d", "Smileys & Emotion"),
            new("Smiling face with hearts", "1f970", "Smileys & Emotion"),
            new("Smiling face with horns", "1f608", "Smileys & Emotion"),
            new("Smiling face with smiling eyes", "1f60a", "Smileys & Emotion"),
            new("Smiling face with sunglasses", "1f60e", "Smileys & Emotion"),
            new("Smiling face with tear", "1f972", "Smileys & Emotion"),
            new("Smirking face", "1f60f", "Smileys & Emotion"),
            new("Snail", "1f40c", "Animals & Nature"),
            new("Snake", "1f40d", "Animals & Nature"),
            new("Sneezing face", "1f927", "Smileys & Emotion"),
            new("Snow-capped mountain", "1f3d4 fe0f", "Travel & Places"),
            new("Snowflake", "2744 fe0f", "Travel & Places"),
            new("Snowman", "2603 fe0f", "Travel & Places"),
            new("Snowman without snow", "26c4", "Travel & Places"),
            new("Soap", "1f9fc", "Objects"),
            new("Soccer ball", "26bd", "Activities"),
            new("Socks", "1f9e6", "Objects"),
            new("Soft ice cream", "1f366", "Food & Drink"),
            new("Softball", "1f94e", "Activities"),
            new("Soon arrow", "1f51c", "Symbols"),
            new("Sos button", "1f198", "Symbols"),
            new("Spade suit", "2660 fe0f", "Activities"),
            new("Spaghetti", "1f35d", "Food & Drink"),
            new("Sparkle", "2747 fe0f", "Symbols"),
            new("Sparkler", "1f387", "Activities"),
            new("Sparkles", "2728", "Activities"),
            new("Sparkling heart", "1f496", "Smileys & Emotion"),
            new("Speak-no-evil monkey", "1f64a", "Smileys & Emotion"),
            new("Speaker high volume", "1f50a", "Objects"),
            new("Speaker low volume", "1f508", "Objects"),
            new("Speaker medium volume", "1f509", "Objects"),
            new("Speaking head", "1f5e3 fe0f", "People & Body"),
            new("Speech balloon", "1f4ac", "Smileys & Emotion"),
            new("Speedboat", "1f6a4", "Travel & Places"),
            new("Spider", "1f577 fe0f", "Animals & Nature"),
            new("Spider web", "1f578 fe0f", "Animals & Nature"),
            new("Spiral calendar", "1f5d3 fe0f", "Objects"),
            new("Spiral notepad", "1f5d2 fe0f", "Objects"),
            new("Spiral shell", "1f41a", "Animals & Nature"),
            new("Sponge", "1f9fd", "Objects"),
            new("Spoon", "1f944", "Food & Drink"),
            new("Sport utility vehicle", "1f699", "Travel & Places"),
            new("Sports medal", "1f3c5", "Activities"),
            new("Spouting whale", "1f433", "Animals & Nature"),
            new("Squid", "1f991", "Food & Drink"),
            new("Squinting face with tongue", "1f61d", "Smileys & Emotion"),
            new("Stadium", "1f3df fe0f", "Travel & Places"),
            new("Star", "2b50", "Travel & Places"),
            new("Star and crescent", "262a fe0f", "Symbols"),
            new("Star of david", "2721 fe0f", "Symbols"),
            new("Star-struck", "1f929", "Smileys & Emotion"),
            new("Station", "1f689", "Travel & Places"),
            new("Statue of liberty", "1f5fd", "Travel & Places"),
            new("Steaming bowl", "1f35c", "Food & Drink"),
            new("Stethoscope", "1fa7a", "Objects"),
            new("Stop button", "23f9 fe0f", "Symbols"),
            new("Stop sign", "1f6d1", "Travel & Places"),
            new("Stopwatch", "23f1 fe0f", "Travel & Places"),
            new("Straight ruler", "1f4cf", "Objects"),
            new("Strawberry", "1f353", "Food & Drink"),
            new("Studio microphone", "1f399 fe0f", "Objects"),
            new("Stuffed flatbread", "1f959", "Food & Drink"),
            new("Sun", "2600 fe0f", "Travel & Places"),
            new("Sun behind cloud", "26c5", "Travel & Places"),
            new("Sun behind large cloud", "1f325 fe0f", "Travel & Places"),
            new("Sun behind rain cloud", "1f326 fe0f", "Travel & Places"),
            new("Sun behind small cloud", "1f324 fe0f", "Travel & Places"),
            new("Sun with face", "1f31e", "Travel & Places"),
            new("Sunflower", "1f33b", "Animals & Nature"),
            new("Sunglasses", "1f576 fe0f", "Objects"),
            new("Sunrise", "1f305", "Travel & Places"),
            new("Sunrise over mountains", "1f304", "Travel & Places"),
            new("Sunset", "1f307", "Travel & Places"),
            new("Sushi", "1f363", "Food & Drink"),
            new("Suspension railway", "1f69f", "Travel & Places"),
            new("Swan", "1f9a2", "Animals & Nature"),
            new("Sweat droplets", "1f4a6", "Smileys & Emotion"),
            new("Synagogue", "1f54d", "Travel & Places"),
            new("Syringe", "1f489", "Objects"),
            new("T-rex", "1f996", "Animals & Nature"),
            new("T-shirt", "1f455", "Objects"),
            new("Taco", "1f32e", "Food & Drink"),
            new("Takeout box", "1f961", "Food & Drink"),
            new("Tamale", "1fad4", "Food & Drink"),
            new("Tanabata tree", "1f38b", "Activities"),
            new("Tangerine", "1f34a", "Food & Drink"),
            new("Taurus", "2649", "Symbols"),
            new("Taxi", "1f695", "Travel & Places"),
            new("Teacup without handle", "1f375", "Food & Drink"),
            new("Teapot", "1fad6", "Food & Drink"),
            new("Tear-off calendar", "1f4c6", "Objects"),
            new("Teddy bear", "1f9f8", "Activities"),
            new("Telephone", "260e fe0f", "Objects"),
            new("Telephone receiver", "1f4de", "Objects"),
            new("Telescope", "1f52d", "Objects"),
            new("Television", "1f4fa", "Objects"),
            new("Ten oclock", "1f559", "Travel & Places"),
            new("Ten-thirty", "1f565", "Travel & Places"),
            new("Tennis", "1f3be", "Activities"),
            new("Tent", "26fa", "Travel & Places"),
            new("Test tube", "1f9ea", "Objects"),
            new("Thermometer", "1f321 fe0f", "Travel & Places"),
            new("Thinking face", "1f914", "Smileys & Emotion"),
            new("Thong sandal", "1fa74", "Objects"),
            new("Thought balloon", "1f4ad", "Smileys & Emotion"),
            new("Thread", "1f9f5", "Activities"),
            new("Three oclock", "1f552", "Travel & Places"),
            new("Three-thirty", "1f55e", "Travel & Places"),
            new("Ticket", "1f3ab", "Activities"),
            new("Tiger", "1f405", "Animals & Nature"),
            new("Tiger face", "1f42f", "Animals & Nature"),
            new("Timer clock", "23f2 fe0f", "Travel & Places"),
            new("Tired face", "1f62b", "Smileys & Emotion"),
            new("Toilet", "1f6bd", "Objects"),
            new("Tokyo tower", "1f5fc", "Travel & Places"),
            new("Tomato", "1f345", "Food & Drink"),
            new("Tongue", "1f445", "People & Body"),
            new("Toolbox", "1f9f0", "Objects"),
            new("Tooth", "1f9b7", "People & Body"),
            new("Toothbrush", "1faa5", "Objects"),
            new("Top arrow", "1f51d", "Symbols"),
            new("Top hat", "1f3a9", "Objects"),
            new("Tornado", "1f32a fe0f", "Travel & Places"),
            new("Trackball", "1f5b2 fe0f", "Objects"),
            new("Tractor", "1f69c", "Travel & Places"),
            new("Trade mark", "2122 fe0f", "Symbols"),
            new("Train", "1f686", "Travel & Places"),
            new("Tram", "1f68a", "Travel & Places"),
            new("Tram car", "1f68b", "Travel & Places"),
            new("Transgender flag", "1f3f3 fe0f 200d 26a7 fe0f", "Flags"),
            new("Transgender symbol", "26a7 fe0f", "Symbols"),
            new("Triangular flag", "1f6a9", "Flags"),
            new("Triangular ruler", "1f4d0", "Objects"),
            new("Trident emblem", "1f531", "Symbols"),
            new("Troll", "1f9cc", "People & Body"),
            new("Trolleybus", "1f68e", "Travel & Places"),
            new("Trophy", "1f3c6", "Activities"),
            new("Tropical drink", "1f379", "Food & Drink"),
            new("Tropical fish", "1f420", "Animals & Nature"),
            new("Trumpet", "1f3ba", "Objects"),
            new("Tulip", "1f337", "Animals & Nature"),
            new("Tumbler glass", "1f943", "Food & Drink"),
            new("Turkey", "1f983", "Animals & Nature"),
            new("Turtle", "1f422", "Animals & Nature"),
            new("Twelve oclock", "1f55b", "Travel & Places"),
            new("Twelve-thirty", "1f567", "Travel & Places"),
            new("Two hearts", "1f495", "Smileys & Emotion"),
            new("Two oclock", "1f551", "Travel & Places"),
            new("Two-hump camel", "1f42b", "Animals & Nature"),
            new("Two-thirty", "1f55d", "Travel & Places"),
            new("Umbrella", "2602 fe0f", "Travel & Places"),
            new("Umbrella on ground", "26f1 fe0f", "Travel & Places"),
            new("Umbrella with rain drops", "2614", "Travel & Places"),
            new("Unamused face", "1f612", "Smileys & Emotion"),
            new("Unicorn", "1f984", "Animals & Nature"),
            new("Unlocked", "1f513", "Objects"),
            new("Up arrow", "2b06 fe0f", "Symbols"),
            new("Up! button", "1f199", "Symbols"),
            new("Up-down arrow", "2195 fe0f", "Symbols"),
            new("Up-left arrow", "2196 fe0f", "Symbols"),
            new("Up-right arrow", "2197 fe0f", "Symbols"),
            new("Upside-down face", "1f643", "Smileys & Emotion"),
            new("Upwards button", "1f53c", "Symbols"),
            new("Vertical traffic light", "1f6a6", "Travel & Places"),
            new("Vibration mode", "1f4f3", "Symbols"),
            new("Video camera", "1f4f9", "Objects"),
            new("Videocassette", "1f4fc", "Objects"),
            new("Violin", "1f3bb", "Objects"),
            new("Virgo", "264d", "Symbols"),
            new("Volcano", "1f30b", "Travel & Places"),
            new("Volleyball", "1f3d0", "Activities"),
            new("Vs button", "1f19a", "Symbols"),
            new("Waffle", "1f9c7", "Food & Drink"),
            new("Waning crescent moon", "1f318", "Travel & Places"),
            new("Waning gibbous moon", "1f316", "Travel & Places"),
            new("Warning", "26a0 fe0f", "Symbols"),
            new("Wastebasket", "1f5d1 fe0f", "Objects"),
            new("Watch", "231a", "Travel & Places"),
            new("Water buffalo", "1f403", "Animals & Nature"),
            new("Water closet", "1f6be", "Symbols"),
            new("Water pistol", "1f52b", "Objects"),
            new("Water wave", "1f30a", "Travel & Places"),
            new("Watermelon", "1f349", "Food & Drink"),
            new("Wavy dash", "3030 fe0f", "Symbols"),
            new("Waxing crescent moon", "1f312", "Travel & Places"),
            new("Waxing gibbous moon", "1f314", "Travel & Places"),
            new("Weary cat", "1f640", "Smileys & Emotion"),
            new("Weary face", "1f629", "Smileys & Emotion"),
            new("Wedding", "1f492", "Travel & Places"),
            new("Whale", "1f40b", "Animals & Nature"),
            new("Wheel", "1f6de", "Travel & Places"),
            new("Wheel of dharma", "2638 fe0f", "Symbols"),
            new("Wheelchair symbol", "267f", "Symbols"),
            new("White cane", "1f9af", "Objects"),
            new("White circle", "26aa", "Symbols"),
            new("White exclamation mark", "2755", "Symbols"),
            new("White flag", "1f3f3 fe0f", "Flags"),
            new("White flower", "1f4ae", "Animals & Nature"),
            new("White heart", "1f90d", "Smileys & Emotion"),
            new("White large square", "2b1c", "Symbols"),
            new("White medium square", "25fb fe0f", "Symbols"),
            new("White medium-small square", "25fd", "Symbols"),
            new("White question mark", "2754", "Symbols"),
            new("White small square", "25ab fe0f", "Symbols"),
            new("White square button", "1f533", "Symbols"),
            new("Wilted flower", "1f940", "Animals & Nature"),
            new("Wind chime", "1f390", "Activities"),
            new("Wind face", "1f32c fe0f", "Travel & Places"),
            new("Window", "1fa9f", "Objects"),
            new("Wine glass", "1f377", "Food & Drink"),
            new("Winking face", "1f609", "Smileys & Emotion"),
            new("Winking face with tongue", "1f61c", "Smileys & Emotion"),
            new("Wolf", "1f43a", "Animals & Nature"),
            new("Woman genie", "1f9de 200d 2640 fe0f", "People & Body"),
            new("Woman with bunny ears", "1f46f 200d 2640 fe0f", "People & Body"),
            new("Woman wrestling", "1f93c 200d 2640 fe0f", "People & Body"),
            new("Woman zombie", "1f9df 200d 2640 fe0f", "People & Body"),
            new("Womans boot", "1f462", "Objects"),
            new("Womans clothes", "1f45a", "Objects"),
            new("Womans hat", "1f452", "Objects"),
            new("Womans sandal", "1f461", "Objects"),
            new("Womens room", "1f6ba", "Symbols"),
            new("Wood", "1fab5", "Travel & Places"),
            new("Woozy face", "1f974", "Smileys & Emotion"),
            new("World map", "1f5fa fe0f", "Travel & Places"),
            new("Worm", "1fab1", "Animals & Nature"),
            new("Worried face", "1f61f", "Smileys & Emotion"),
            new("Wrapped gift", "1f381", "Activities"),
            new("Wrench", "1f527", "Objects"),
            new("X-ray", "1fa7b", "Objects"),
            new("Yarn", "1f9f6", "Activities"),
            new("Yawning face", "1f971", "Smileys & Emotion"),
            new("Yellow circle", "1f7e1", "Symbols"),
            new("Yellow heart", "1f49b", "Smileys & Emotion"),
            new("Yellow square", "1f7e8", "Symbols"),
            new("Yen banknote", "1f4b4", "Objects"),
            new("Yin yang", "262f fe0f", "Symbols"),
            new("Yo-yo", "1fa80", "Activities"),
            new("Zany face", "1f92a", "Smileys & Emotion"),
            new("Zebra", "1f993", "Animals & Nature"),
            new("Zipper-mouth face", "1f910", "Smileys & Emotion"),
            new("Zzz", "1f4a4", "Smileys & Emotion"),
        ];
    }
}

/// <summary>
/// Emoji 项.
/// </summary>
public sealed class EmojiItem(string name, string unicode, string group)
{
    /// <summary>
    /// Emoji 名称.
    /// </summary>
    public string? Name { get; } = name;

    /// <summary>
    /// Unicode.
    /// </summary>
    public string? Unicode { get; } = unicode;

    /// <summary>
    /// 分组.
    /// </summary>
    public string? Group { get; } = group;

    /// <summary>
    /// 转换为 Emoji.
    /// </summary>
    /// <returns>Emoji 表示.</returns>
    public string ToEmoji()
    {
        var unicodePoints = Unicode!.Split(' ');
        var result = string.Empty;

        foreach (var point in unicodePoints)
        {
            var code = int.Parse(point, System.Globalization.NumberStyles.HexNumber);
            if (code <= 0xFFFF)
            {
                result += (char)code;
            }
            else
            {
                result += char.ConvertFromUtf32(code);
            }
        }

        return result;
    }
}
