interface definitions {[id:string]:any};
/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  "/deployables/create": {
    /**
     * Create a private deployable.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "deployables:write",
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateDeployable"];
  };
  "/deployables/{deployable_id}/get": {
    /**
     * Get a deployable.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "deployables:read"
     *     ],
     *     "deployables": [
     *       {
     *         "params": "deployable_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetDeployable"];
  };
  "/deployables/{deployable_id}/update": {
    /**
     * Update a deployable
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "deployables:write"
     *     ],
     *     "deployables": [
     *       {
     *         "params": "deployable_id"
     *       }
     *     ]
     *   },
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateDeployable"];
  };
  "/deployables/delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "deployables:write"
     *     ],
     *     "deployables": [
     *       {
     *         "body": "id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteDeployable"];
  };
  "/deployables/{deployable_id}/share": {
    /**
     * Share a private deployable.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "sharing:write",
     *       "deployables:read"
     *     ],
     *     "deployables": [
     *       {
     *         "params": "deployable_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateDeployableKey"];
  };
  "/deployables/{deployable_id}/invite": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write",
     *       "deployables:read"
     *     ],
     *     "deployables": [
     *       {
     *         "params": "deployable_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateDeployableInvite"];
  };
  "/deployables/{deployable_id}/users/{user_id}/update": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write",
     *       "deployables:read"
     *     ],
     *     "deployables": [
     *       {
     *         "params": "deployable_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateUsersDeployablePermissions"];
  };
  "/deployables/{deployable_id}/private": {
    /**
     * Unshare a shared deployable, making it private.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "sharing:write",
     *       "deployables:read"
     *     ],
     *     "deployables": [
     *       {
     *         "params": "deployable_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteDeployableKey"];
  };
  "/deployables/list": {
    /**
     * List all deployables.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": []
     *   }
     * ]
     */
    get: operations["ListDeployables"];
  };
  "/deployablegroups/{deployablegroup_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteDeployableGroup"];
  };
  "/deployablegroups/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListDeployableGroups"];
  };
  "/deployablegroups/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateDeployableGroup"];
  };
  "/deployablegroups/{deployablegroup_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetDeployableGroup"];
  };
  "/deployablegroups/{deployablegroup_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateDeployableGroup"];
  };
  "/deployablegroups/{deployablegroup_id}/share": {
    /**
     * Share a private deployable group. Required read access to all deployables that are shared, and the datasets deployables are tied to.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "sharing:write"
     *     ]
     *   }
     * ]
     */
    post: operations["CreateDeployableGroupKey"];
  };
  "/deployablegroups/{deployablegroup_id}/private": {
    /**
     * Unshare a shared deployable group, making it private.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "sharing:write"
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteDeployableGroupKey"];
  };
  "/projects/create": {
    /**
     * Create a new Project that your user will have access to
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:write"
     *     ],
     *     "organizations": [
     *       {
     *         "body": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateProject"];
  };
  "/projects/update": {
    /**
     * Update metadata of a Project
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "admin"
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateProject"];
  };
  "/projects/transfer_to_organization": {
    /**
     * Tie a project to an organization. This requires admin privileges over project and organization.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "admin"
     *     ],
     *     "projects": [
     *       {
     *         "user_info": "username"
     *       }
     *     ]
     *   },
     *   {
     *     "actions": [
     *       "organizations:write"
     *     ],
     *     "organizations": [
     *       {
     *         "body": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["TransferProjectToOrganization"];
  };
  "/projects/list": {
    /**
     * List all projects and their metadata
     *
     * ### Required permissions
     * > []
     */
    get: operations["ListProjects"];
  };
  "/projects/organization_info": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ]
     *   }
     * ]
     */
    get: operations["GetProjectsOrgInfo"];
  };
  "/projects/keys/list": {
    /**
     * List which keys exist for a project
     *
     * ### Required permissions
     * > []
     */
    get: operations["ListProjectKeys"];
  };
  "/projects/keys/get": {
    /**
     * Get value for key for a project
     *
     * ### Required permissions
     * > []
     */
    post: operations["GetProjectKey"];
  };
  "/projects/keys/set": {
    /**
     * Set a key for a project
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "admin"
     *     ]
     *   }
     * ]
     */
    post: operations["SetProjectKey"];
  };
  "/projects/keys/delete": {
    /**
     * Delete a key for a project
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "admin"
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteProjectKey"];
  };
  "/auth/users/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["CreateUser"];
  };
  "/auth/users/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": []
     *   }
     * ]
     */
    post: operations["ListUsers"];
  };
  "/auth/is_authorized": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["IsUserAuthorized"];
  };
  "/auth/info": {
    /**
     * Get user_id, key_id and permissions from an auth header.
     *
     * ### Required permissions
     * > []
     */
    get: operations["GetAuthHeaderInfo"];
  };
  "/auth/invite/create": {
    /**
     * Invite a user to a project using either their email or their user_id
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["CreateProjectInvite"];
  };
  "/auth/invite/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListProjectInvites"];
  };
  "/auth/invite/accept": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["AcceptProjectInvite"];
  };
  "/auth/invite/delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteProjectInvite"];
  };
  "/auth/invite/resend": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["ResendProjectInvite"];
  };
  "/auth/users/{user_id}": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "users": [
     *       {
     *         "params": "user_id"
     *       }
     *     ],
     *     "actions": [
     *       "users:read"
     *     ]
     *   }
     * ]
     */
    get: operations["GetUser"];
  };
  "/auth/users/{user_id}/update": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "users": [
     *       {
     *         "params": "user_id"
     *       }
     *     ],
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateUser"];
  };
  "/auth/users/{user_id}/delete": {
    /**
     * Deletes a User from ONLY your project. If they have permissions for other projects, they will still have acces to them.
     *
     * ### Required permissions
     * > [
     *   {
     *     "users": [
     *       {
     *         "params": "user_id"
     *       }
     *     ],
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteUser"];
  };
  "/auth/users/{user_id}/keys/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "users": [
     *       {
     *         "params": "user_id"
     *       }
     *     ],
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["CreateUserKey"];
  };
  "/auth/users/{user_id}/keys/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "users": [
     *       {
     *         "params": "user_id"
     *       }
     *     ],
     *     "actions": [
     *       "users:read"
     *     ]
     *   }
     * ]
     */
    post: operations["ListUserKeys"];
  };
  "/auth/users/{user_id}/keys/delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "users": [
     *       {
     *         "params": "user_id"
     *       }
     *     ],
     *     "actions": [
     *       "users:write"
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteUserKey"];
  };
  "/datasets/{dataset_id}/cluster/centroids/insert": {
    /**
     * Insert your own cluster centroids for it to be used in approximate search settings and cluster aggregations.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["InsertClusterCentroids"];
  };
  "/datasets/{dataset_id}/cluster/centroids/update": {
    /**
     * Update your own cluster centroids for it to be used in approximate search settings and cluster aggregations. Will merge rather than replace centroids.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateClusterCentroids"];
  };
  "/datasets/{dataset_id}/cluster/centroids/compare_centroids": {
    /**
     * For each centroid in a list of centroids, find the closest centroids in another set of centroids.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       },
     *       {
     *         "body": "comparison_centroids.dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CompareClusterCentroids"];
  };
  "/datasets/{dataset_id}/aggregate": {
    /**
     * Aggregation/Groupby of a collection using an aggregation query.
     * The aggregation query is a json body that follows the schema of:
     *
     *     {
     *         "groupby" : [
     *             {"name": <alias>, "field": <field in the collection>, "agg": "category"},
     *             {"name": <alias>, "field": <another groupby field in the collection>, "agg": "numeric"}
     *         ],
     *         "metrics" : [
     *             {"name": <alias>, "field": <numeric field in the collection>, "agg": "avg"}
     *             {"name": <alias>, "field": <another numeric field in the collection>, "agg": "max"}
     *             {"name": <alias>, "fields": [<numeric field in the collection>, <another numeric field in the collection>], "agg": "correlation"}
     *         ]
     *     }
     *     For example, one can use the following aggregations to group score based on region and player name.
     *     {
     *         "groupby" : [
     *             {"name": "region", "field": "player_region", "agg": "category"},
     *             {"name": "player_name", "field": "name", "agg": "category"}
     *         ],
     *         "metrics" : [
     *             {"name": "average_score", "field": "final_score", "agg": "avg"},
     *             {"name": "max_score", "field": "final_score", "agg": "max"},
     *             {'name':'total_score','field':"final_score", 'agg':'sum'},
     *             {'name':'average_deaths','field':"final_deaths", 'agg':'avg'},
     *             {'name':'highest_deaths','field':"final_deaths", 'agg':'max'},
     *             {'name':'score_death_correlation', 'fields':['final_deaths', 'final_score'], 'agg': 'correlation'},
     *         ]
     *     }
     * - "groupby" is the fields you want to split the data into. These are the available groupby types:
     *     - category" : groupby a field that is a category
     *     - numeric: groupby a field that is a numeric
     * - "metrics" is the fields you want to metrics you want to calculate in each of those, every aggregation includes a frequency metric. These are the available metric types:
     *     - For single fields: "avg"/"average"/"mean", "cardinality", "count", "kurtosis", "max", "min", "percentiles", "kurtosis", "std_deviation", "std_deviation_bounds", "sum", "sum_of_squares", "variance"
     *     - For multiple fields (the attribute "fields" must be used instead of "field"): "correlation", "covariance", "kurtosis", "mean", "skewness", "variance"
     *
     * The response returned has the following in descending order.
     *
     * IF you want to return documents, specify a "group_size" parameter and a "select_fields" parameter if you want to limit the specific fields chosen.
     * This looks as such:
     *
     *     {
     *       'groupby':[
     *         {'name':'Manufacturer','field':'manufacturer','agg':'category',
     *         'group_size': 10, 'select_fields': ["name"]},
     *       ],
     *       'metrics':[
     *         {'name':'Price Average','field':'price','agg':'avg'},
     *       ],
     *     }
     *
     *     {"title": {"title": "books", "frequency": 200, "documents": [{...}, {...}]}, {"title": "books", "frequency": 100, "documents": [{...}, {...}]}}
     *
     * For array-aggregations, you can add "agg": "array" into the aggregation query.
     *
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["Aggregate"];
  };
  "/datasets/{dataset_id}/cluster/aggregate": {
    /**
     * Takes an aggregation query and gets the aggregate of each cluster in a collection. This helps you interpret each cluster and what is in them.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["AggregateClusters"];
  };
  "/datasets/{dataset_id}/cluster/facets": {
    /**
     * Takes a high level aggregation of every field and every cluster in a collection. This helps you interpret each cluster and what is in them.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListClusterFacets"];
  };
  "/datasets/{dataset_id}/cluster/centroids/list_closest_to_center": {
    /**
     * List documents with vector fields closest to centroids.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListClosestToCentroids"];
  };
  "/datasets/{dataset_id}/cluster/centroids/list_furthest_from_center": {
    /**
     * List documents with vector fields furthest from centroids.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListFurthestFromCentroids"];
  };
  "/datasets/{dataset_id}/cluster/centroids/documents": {
    /**
     * List centroids, optionally filtering by their ids.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListCentroids"];
  };
  "/datasets/{dataset_id}/cluster/centroids/configs/list": {
    /**
     * List centroids configs for a dataset.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListCentroidConfigs"];
  };
  "/datasets/{dataset_id}/cluster/centroids/{centroid_id}/delete": {
    /**
     * Delete a centroid by ID
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteCentroid"];
  };
  "/datasets/{dataset_id}/cluster/realtime": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["RealtimeClustering"];
  };
  "/datasets/{dataset_id}/cluster/merge": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["MergeClusters"];
  };
  "/datasets/{dataset_id}/cluster/centroids/summaries/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read",
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateClusterSummaries"];
  };
  "/datasets/{dataset_id}/cluster/centroids/labels/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read",
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateClusterLabels"];
  };
  "/datasets/{dataset_id}/cluster/centroids/summaries/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListClusterSummaries"];
  };
  "/datasets/{dataset_id}/cluster/hierarchical/create": {
    /**
     * Endpoint for creating Hierarchical Clusters from a given dataset on top of existing clusters.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read",
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateHierarchicalClusters"];
  };
  "/datasets/{dataset_id}/cluster/centroids/summaries/bulk_delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteClusterSummaries"];
  };
  "/datasets/{dataset_id}/cluster/one_to_many/edit": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["EditOneToManyClusters"];
  };
  "/datasets/{dataset_id}/documents/edit_list": {
    /**
     * If a document looks like this:
     *   ```
     *   {mylistfield:{
     *     innerfield:[
     *       {filter_list_field:'aaa',update_field:{'inner_update_field':'a'}}
     *     ]
     *   }}
     *   ```
     *   the inner field can be filtered like this:
     *   ```
     *   {
     *     list_field: 'mylistfield.innerfield'
     *     match_field:'filter_list_field',
     *     update_field:'update_field.inner_update_field'
     *     updates:{'a':'valuetoreplace'}
     *   }
     *   ```
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["EditListInDocuments"];
  };
  "/organizations/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateOrganization"];
  };
  "/organizations/{organization_id}/update": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:write"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateOrganization"];
  };
  "/admin/organizations/{organization_id}/update": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "support:write"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateOrganizationAdmin"];
  };
  "/organizations/list": {
    /**
     * List all organizations and their metadata
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ]
     *   }
     * ]
     */
    get: operations["ListOrganizations"];
  };
  "/organizations/{organization_id}/delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:write"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteOrganization"];
  };
  "/organizations/{organization_id}/get": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetOrganization"];
  };
  "/organizations/{organization_id}/usage/get": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetOrganizationUsage"];
  };
  "/organizations/{organization_id}/users/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListUsersInOrganization"];
  };
  "/organizations/{organization_id}/projects/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListProjectsInOrganization"];
  };
  "/organizations/{organization_id}/metrics/aggregate": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["AggregateOrganizationMetrics"];
  };
  "/organizations/{organization_id}/billing/events/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:read"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListBillingEvents"];
  };
  "/admin/organizations/{organization_id}/billing/events/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "support:write"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateBillingEventAdmin"];
  };
  "/organizations/{organization_id}/billing/get_billing_frontend_link": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:write"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetBillingFrontendLink"];
  };
  "/organizations/{organization_id}/billing/update": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "organizations:write"
     *     ],
     *     "organizations": [
     *       {
     *         "params": "organization_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateOrganizationBilling"];
  };
  "/connectors/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write",
     *       "connectors:write"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateConnector"];
  };
  "/connectors/check_connection": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CheckConnection"];
  };
  "/connectors/{connector_id}/get": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "connectors:read"
     *     ],
     *     "connectors": [
     *       {
     *         "params": "connector_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetConnector"];
  };
  "/connectors/{connector_id}/update": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "connectors:write",
     *       "datasets:write"
     *     ],
     *     "connectors": [
     *       {
     *         "params": "connector_id"
     *       }
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateConnector"];
  };
  "/connectors/{connector_id}/trigger": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "connectors:write"
     *     ],
     *     "connectors": [
     *       {
     *         "params": "connector_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["TriggerConnector"];
  };
  "/connectors/{connector_id}/delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "connectors:write"
     *     ],
     *     "connectors": [
     *       {
     *         "params": "connector_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteConnector"];
  };
  "/connectors/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": []
     *   }
     * ]
     */
    get: operations["ListConnectors"];
  };
  "/connectors/types/list": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["ListConnectorTypes"];
  };
  "/connectors/types/{connector_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetConnectorType"];
  };
  "/connectors/{connector_id}/jobs/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "connectors:read"
     *     ],
     *     "connectors": [
     *       {
     *         "params": "connector_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListConnectorJobs"];
  };
  "/connectors/{connector_id}/jobs/{job_id}/get": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "connectors:read"
     *     ],
     *     "connectors": [
     *       {
     *         "params": "connector_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetConnectorJob"];
  };
  "/workflows/trigger": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read",
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["TriggerWorkflow"];
  };
  "/workflows/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ]
     *   }
     * ]
     */
    get: operations["ListWorkflows"];
  };
  "/workflows/{workflow_id}/get": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ]
     *   }
     * ]
     */
    post: operations["GetWorkflowStatus"];
  };
  "/workflows/{workflow_id}/config": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["GetWorkflowConfig"];
  };
  "/workflows/{workflow_id}/delete": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteWorkflowStatus"];
  };
  "/workflows/{workflow_id}/terminate": {
    /**
     * Terminate a workflow
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ]
     *   }
     * ]
     */
    post: operations["TerminateWorkflow"];
  };
  "/workflows/{workflow_id}/metadata": {
    /**
     * Update metadata for a workflow run
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ]
     *   }
     * ]
     */
    post: operations["UpsertWorkflowMetadata"];
  };
  "/workflows/{workflow_id}/progress": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ]
     *   }
     * ]
     */
    post: operations["UpsertWorkflowProgress"];
  };
  "/workflows/{workflow_id}/status": {
    /**
     * Update status for a workflow run
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ]
     *   }
     * ]
     */
    post: operations["UpsertWorkflowStatus"];
  };
  "/workflows/types/list": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["ListWorkflowTypes"];
  };
  "/workflows/types/search": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["SearchWorkflowTypes"];
  };
  "/workflows/types/openapi": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetWorkflowTypesAsOpenAPI"];
  };
  "/workflows/types/aggregate": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["AggregateWorkflowTypes"];
  };
  "/workflows/types/bulk_update": {
    /**
     * Admin Endpoint for updating workflow types
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "support:write"
     *     ]
     *   }
     * ]
     */
    post: operations["BulkUpdateWorkflowTypesAdmin"];
  };
  "/workflows/types/version_aliases/update": {
    /**
     * Admin Endpoint for updating workflow version aliases
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "support:write"
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateWorkflowTypesVersionAliasesAdmin"];
  };
  "/workflows/types/version_aliases/get": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["GetWorkflowTypesVersionAliases"];
  };
  "/workflows/types/{workflow_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetWorkflowType"];
  };
  "/workflows/types/{workflow_id}/validate": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ValidateWorkflowParams"];
  };
  "/datasets/{dataset_id}/documents/insert": {
    /**
     * When inserting the document you can specify your own id for a document by using the field name **"\_id"**.
     *
     *     For specifying your own vector use the suffix (ends with)  **"\_vector\_"** for the field name.
     * e.g. "product\_description\_vector\_"
     *
     *
     *     If inserting many items in a short timespan, use bulkInsert, or set update_schema to false.
     *     Every insert api call temporarily locks and updates the schema, so will slow down with many inserts in quick succession.
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["Insert"];
  };
  "/datasets/{dataset_id}/documents/bulk_insert": {
    /**
     * Insert one or more documents.
     *
     * This method is the same as [`/insert`](/reference/insert) but provides support for more than one document to be inserted at a time.
     *
     * For each insertion, if an `_id` is provided and a document with that ID already exists, all existing field values will be deleted and the new ones will be stored. If no `_id` field is provided, one will automatically be added to the document.
     *
     * This method will entirely replace the documents. If you would like to only partially update a document, use [`/update_where`](/reference/updatewhere).
     *
     * If the document with the provided `_id` doesn't exist, one will be automatically created.
     * If the provided dataset doesn't exist, one will be automatically created.
     *
     * Limit the payload of documents to a maximum 100MB for optimal performance.
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["BulkInsert"];
  };
  "/datasets/{dataset_id}/get_file_upload_urls": {
    /**
     * specify a list of file paths. For each file path, a url upload_url is returned. files can be POSTed on upload_url to upload them. They can then be accessed on url. Upon dataset deletion, these files will be deleted.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["GetFileUploadUrlsForDataset"];
  };
  "/services/get_temporary_file_upload_url": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["GetTemporaryFileUploadUrl"];
  };
  "/datasets/{dataset_id}/list_file_uploads": {
    /**
     * Return up to 1000 files uploaded for a dataset.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListFileUploadsForDataset"];
  };
  "/datasets/{dataset_id}/parse_blob": {
    /**
     * Bulk insert a large number of documents by downloading a file using "download url". This bypasses the need to directly send documents to the api, as happens in BulkInsert.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ParseBlob"];
  };
  "/admin/copy_foreign_dataset": {
    /**
     * Copy a dataset from another users projects into your project. This is considered a project job.
     *
     * ### Required permissions
     * > []
     */
    post: operations["CopyForeignDataset"];
  };
  "/admin/request_read_api_key": {
    /**
     * Creates a read only key for your project. Make sure to save the api key somewhere safe. When doing a search the admin username should still be used.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "users:write",
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "raw": "*"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateProjectReadKey"];
  };
  "/onboard/generate": {
    /**
     * Generate onboarding data.
     *
     * ### Required permissions
     * > []
     */
    post: operations["GenerateOnboarding"];
  };
  "/datasets/{dataset_id}/delete": {
    /**
     * Delete a dataset.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteDataset"];
  };
  "/datasets/create": {
    /**
     * A dataset can store documents to be **searched, retrieved, filtered and aggregated** (similar to Collections in MongoDB, Tables in SQL, Indexes in ElasticSearch).
     *
     * A powerful and core feature of VecDB is that you can store both your metadata and vectors in the same document.
     * When specifying the schema of a dataset and inserting your own vector use the suffix (ends with) **"\_vector\_"** for the field name, and specify the length of the vector in dataset_schema.
     *
     * For example:
     *
     *     {
     *         "product_image_vector_": 1024,
     *         "product_text_description_vector_" : 128
     *     }
     *
     * These are the field types supported in our datasets: **["text", "numeric", "date", "dict", "chunks", "vector", "chunkvector"]**.
     *
     * For example:
     *
     *     {
     *         "product_text_description" : "text",
     *         "price" : "numeric",
     *         "created_date" : "date",
     *         "product_texts_chunk_": "chunks",
     *         "product_text_chunkvector_" : 1024
     *     }
     *
     * You don't have to specify the schema of every single field when creating a dataset, as VecDB will automatically detect the appropriate data type for each field (vectors will be automatically identified by its **"\_vector\_"** suffix). Infact you also don't always have to use this endpoint to create a dataset as **\/datasets/bulk_insert** will infer and create the dataset and schema as you insert new documents.
     *
     * Note:
     *  * A dataset name/id can only contain undercase letters, dash, underscore and numbers.
     *  * "\_id" is reserved as the key and id of a document.
     *  * Once a schema is set for a dataset it cannot be altered. If it has to be altered, utlise the copy dataset endpoint.
     *
     * For more information about vectors check out the 'Vectorizing' section, **\/services/search/vector** or out blog at [https://tryrelevance.com/blog](https://tryrelevance.com/blog).
     * For more information about chunks and chunk vectors check out **\/services/search/chunk**.
     *
     *
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateDataset"];
  };
  "/datasets/{dataset_id}/schema": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetSchema"];
  };
  "/datasets/list": {
    /**
     * List all datasets in a project that you are authorized to read/write.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": []
     *   }
     * ]
     */
    get: operations["ListDatasets"];
  };
  "/datasets/combine": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_ids"
     *       }
     *     ]
     *   },
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "new_dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CombineDatasets"];
  };
  "/datasets/combine/{job_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["GetCombineJobStatus"];
  };
  "/datasets/search": {
    /**
     * Search all datasets in a project that you are authorized to read/write.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": []
     *   }
     * ]
     */
    get: operations["SearchDatasets"];
  };
  "/datasets/{dataset_id}/monitor/health": {
    /**
     * Gives you a summary of the health of your vectors, e.g. how many documents with vectors are missing, how many documents with zero vectors
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetFieldHealth"];
  };
  "/datasets/{dataset_id}/monitor/stats": {
    /**
     * View the usage statistics of a dataset.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetDatasetStats"];
  };
  "/datasets/{dataset_id}/vector_mappings": {
    /**
     * DEPRECATED !!!! Retrieve the mapping of vectors generated through fields, dictionary, array, etc
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetVectorMappings"];
  };
  "/datasets/{dataset_id}/details": {
    /**
     * Returns a page of datasets and in detail the dataset's associated information that you are authorized to read/write. The information includes:
     *
     * | Information      | Description |
     * | ----------- | ----------- |
     * | schema      | Data schema of a dataset. (returns same data as **\/dataset/{dataset_id}/schema**) |
     * | metadata   | Metadata of a dataset. (returns same data as **\/dataset/{dataset_id}/metadata**) |
     * | stats   | Statistics of number of documents and size of a dataset. (returns same data as **\/dataset/{dataset_id}/monitor/stats**) |
     * | vector_health   | Number of zero vectors stored. (returns same data as **\/dataset/{dataset_id}/monitor/health**) |
     * | schema_stats   | Fields and number of documents missing/not missing for that field. (returns same data as **\/dataset/{dataset_id}/monitor/stats**) |
     * | active_jobs   | All active jobs/tasks on the dataset. (returns same data as **\/dataset/{dataset_id}/tasks/list**) |
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["GetDatasetDetails"];
  };
  "/datasets/{dataset_id}/documents/get": {
    /**
     * Retrieve a document by its `_id`.
     *
     * This is the most performant method to get a document or check if it exists, faster than filtering a dataset for by an `_id`.
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetDocument"];
  };
  "/datasets/{dataset_id}/documents/delete": {
    /**
     * Delete a document by its `_id` and remove it from the dataset.
     *
     * Support for deleting many documents at once is available through [`/bulk_delete`](/reference/bulk_delete_api_datasets__dataset_id__documents_bulk_delete_post).
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteDocument"];
  };
  "/datasets/{dataset_id}/settings": {
    /**
     * Retreives settings for dataset.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetDatasetSettings"];
    /**
     * Add and overwrite settings about a dataset. Notably description, data source, etc.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpsertDatasetSettings"];
  };
  "/datasets/{dataset_id}/metadata": {
    /**
     * Retreives metadata about a dataset. Notably description, data source, etc
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["GetDatasetMetadata"];
    /**
     * Retreives metadata about a dataset. Notably description, data source, etc
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpsertDatasetMetadata"];
  };
  "/datasets/{dataset_id}/documents/update": {
    /**
     * Update an existing document by providing its `_id` and an object containing the new field values.
     *
     * This method supports a partial update so you may add new fields or update existing ones. It will not overwrite the entire existing document.
     *
     * If the provided `_id` has no matching document in the dataset, a new document will be created. Likewise, if the provided `dataset_id` does not match a dataset in your project a new one will be created.
     *
     * Support for updating many documents at once with a filter condition is available through [`/update_where`](/reference/updatewhere).
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["Update"];
  };
  "/datasets/{dataset_id}/documents/delete_fields": {
    /**
     * Delete fields in a document in a dataset by its id.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteDocumentFields"];
  };
  "/datasets/{dataset_id}/documents/bulk_update": {
    /**
     * Edits documents by providing a key value pair of fields you are adding or changing, make sure to include the "_id" in the documents.
     *
     *     If updating many items in a short timespan, please use BulkUpdate.
     *
     *     Every update api call temporarily locks and updates the schema, so will slow down with many updates in quick succession.
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["BulkUpdate"];
  };
  "/datasets/{dataset_id}/documents/update_where": {
    /**
     * Update fields in all existing documents that match a filter condition.
     *
     * This method supports a partial update so you may add new fields or update only those you need. Other fields will remain unaffected.
     *
     * If the provided `dataset_id` does not match a dataset in your project, a new one will be created.
     *
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["UpdateWhere"];
  };
  "/datasets/{dataset_id}/tags/append": {
    /**
     * Append tags to tag field.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["AppendTags"];
  };
  "/datasets/{dataset_id}/tags/delete": {
    /**
     * Delete tags from tag field by tag value. tag field can be in format ["cat"], or [{"label":"cat"}]
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteTags"];
  };
  "/datasets/{dataset_id}/tags/merge": {
    /**
     * Delete tags from tag field by tag value. tag field can be in format ["cat"], or [{"label":"cat"}]. tags_to_merge should look like {"dog":"pet","cat":"pet"}
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["MergeTags"];
  };
  "/datasets/{dataset_id}/tags/edit": {
    /**
     * Perform all tagging operations on a field in one payload.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["EditTags"];
  };
  "/datasets/{dataset_id}/facets": {
    /**
     * Takes a high level aggregation of every field, return their unique values and frequencies. This is used to help create the filter bar for search.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["ListFacets"];
  };
  "/datasets/{dataset_id}/documents/get_where": {
    /**
     * Retrieve documents with filters.
     * afterId is provided to retrieve even more documents. Loop through it to retrieve all documents in the database.
     * Filter is used to retrieve documents that match the conditions set in a filter query.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["GetWhere"];
  };
  "/datasets/{dataset_id}/documents/paginate": {
    /**
     * Retrieve documents with filters.
     * afterId is provided to retrieve even more documents. Loop through it to retrieve all documents in the database.
     * Filter is used to retrieve documents that match the conditions set in a filter query.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["PaginateDocuments"];
  };
  "/datasets/{dataset_id}/summaries/create": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read",
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CreateDatasetSummary"];
  };
  "/datasets/{dataset_id}/summaries/history/list": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListDatasetSummaryHistory"];
  };
  "/datasets/{dataset_id}/documents/bulk_get": {
    /**
     * Retrieve documents by their IDs ("_id" field). This will retrieve the documents faster than a filter applied on the "_id" field. For single id lookup version of this request use /datasets/{dataset_id}/documents/get.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["BulkGetDocuments"];
  };
  "/datasets/{dataset_id}/documents/bulk_delete": {
    /**
     * Delete a list of documents by their IDs. For deleting a single document refer to /datasets/{dataset_id}/documents/delete or deleting documents by filters refer to /datasets/{dataset_id}/documents/delete_where.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["BulkDeleteDocuments"];
  };
  "/datasets/{dataset_id}/documents/list": {
    /**
     * Retrieve documents with filters.
     * afterId is provided to retrieve even more documents. Loop through it to retrieve all documents in the database.
     * Filter is used to retrieve documents that match the conditions set in a filter query.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListDocuments"];
  };
  "/datasets/{dataset_id}/documents/delete_where": {
    /**
     * Delete documents that match on a filters. At least one filter must be provided.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["DeleteWhere"];
  };
  "/datasets/{dataset_id}/simple_search": {
    /**
     * SimpleSearch is an easy way to use vector search and traditional text matching to search your dataset. It also supports filtering, sorting and aggregating results.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["SimpleSearchPost"];
  };
  "/datasets/{dataset_id}/search": {
    /**
     * SimpleSearch is an easy way to use vector search and traditional text matching to search your dataset. It also supports filtering, sorting and aggregating results.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["Search"];
  };
  "/datasets/{dataset_id}/recommend": {
    /**
     * Recommend documents similar to specific documents. Specify which vector field must be used for recommendation using  the documentsToRecommend property.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["Recommend"];
  };
  "/datasets/{dataset_id}/clone": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   },
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "new_dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["CloneDataset"];
  };
  "/services/prediction/regression/knn": {
    /**
     * Predict using KNN regression.
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "body": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["PredictKNNRegression"];
  };
  "/services/prediction/knn_from_results": {
    /**
     * Predict using KNN regression from search results.
     *
     * ### Required permissions
     * > []
     */
    post: operations["PredictKNNFromResults"];
  };
  "/services/evaluation/bias": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["BiasEvaluation"];
  };
  "/services/vectorize": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["Vectorize"];
  };
  "/services/vectorize/{dataset_id}/vectorize_and_insert": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["VectorizeAndInsert"];
  };
  "/services/vectorize/{dataset_id}": {
    /**
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:write"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    post: operations["VectorizeField"];
  };
  "/datasets/{dataset_id}/workflows_by_fields": {
    /**
     * Get workflow history grouped by fields
     *
     * ### Required permissions
     * > [
     *   {
     *     "actions": [
     *       "datasets:read"
     *     ],
     *     "datasets": [
     *       {
     *         "params": "dataset_id"
     *       }
     *     ]
     *   }
     * ]
     */
    get: operations["ListDatasetWorkflowsByFields"];
  };
  "/health": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetAPIHealth"];
  };
  "/datasets/{dataset_id}/field_children/{fieldchildren_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteFieldChildren"];
  };
  "/datasets/{dataset_id}/field_children/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListFieldChildrens"];
  };
  "/datasets/{dataset_id}/field_children/{fieldchildren_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateFieldChildren"];
  };
  "/workflows/favourites/{favouriteworkflow_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteFavouriteWorkflow"];
  };
  "/workflows/favourites/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListFavouriteWorkflows"];
  };
  "/workflows/favourites/{favouriteworkflow_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateFavouriteWorkflow"];
  };
  "/savedfilters/{savedfilter_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteSavedFilter"];
  };
  "/savedfilters/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListSavedFilters"];
  };
  "/savedfilters/{savedfilter_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateSavedFilter"];
  };
  "/savedfilters/{savedfilter_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetSavedFilter"];
  };
  "/savedfilters/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateSavedFilter"];
  };
  "/components/{component_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteComponent"];
  };
  "/components/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListComponents"];
  };
  "/components/{component_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateComponent"];
  };
  "/components/{component_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetComponent"];
  };
  "/components/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateComponent"];
  };
  "/datasets/{dataset_id}/editor/history/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListDatasetEditorHistorys"];
  };
  "/datasets/{dataset_id}/editor/history/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateDatasetEditorHistory"];
  };
  "/editor/configuration/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListEditorConfigurations"];
  };
  "/editor/configuration/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateEditorConfiguration"];
  };
  "/editor/configuration/{editorconfiguration_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateEditorConfiguration"];
  };
  "/editor/configuration/{editorconfiguration_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteEditorConfiguration"];
  };
  "/editor/configuration/{editorconfiguration_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetEditorConfiguration"];
  };
  "/datasets/{dataset_id}/fields/{field}/keyphrase/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListKeyphrases"];
  };
  "/datasets/{dataset_id}/fields/{field}/keyphrase/{keyphrase_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateKeyphrase"];
  };
  "/datasets/{dataset_id}/fields/{field}/keyphrase/{keyphrase_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteKeyphrase"];
  };
  "/datasets/{dataset_id}/fields/{field}/keyphrase/{keyphrase_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetKeyphrase"];
  };
  "/datasets/{dataset_id}/fields/{field}/keyphrase/bulk_update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["BulkUpdateKeyphrases"];
  };
  "/datasets/{dataset_id}/fields/{field}/keyphrase/bulk_delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["BulkDeleteKeyphrases"];
  };
  "/taxonomys/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListTaxonomys"];
  };
  "/taxonomys/{taxonomy_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateTaxonomy"];
  };
  "/taxonomys/{taxonomy_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteTaxonomy"];
  };
  "/taxonomys/{taxonomy_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetTaxonomy"];
  };
  "/taxonomys/create": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["CreateTaxonomy"];
  };
  "/datasets/favourites/{favouritedataset_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteFavouriteDataset"];
  };
  "/datasets/favourites/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListFavouriteDatasets"];
  };
  "/datasets/favourites/{favouritedataset_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateFavouriteDataset"];
  };
  "/deployable/favourites/{favouritedeployable_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteFavouriteDeployable"];
  };
  "/deployable/favourites/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListFavouriteDeployables"];
  };
  "/deployable/favourites/{favouritedeployable_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateFavouriteDeployable"];
  };
  "/useronboardingflags/{useronboardingflag_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteUserOnboardingFlag"];
  };
  "/useronboardingflags/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListUserOnboardingFlags"];
  };
  "/useronboardingflags/{useronboardingflag_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateUserOnboardingFlag"];
  };
  "/datasets/{dataset_id}/fields/{field}/transcript_tags/{transcripttaglist_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetTranscriptTagList"];
  };
  "/datasets/{dataset_id}/fields/{field}/transcript_tags/{transcripttaglist_id}/update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["UpdateTranscriptTagList"];
  };
  "/datasets/{dataset_id}/fields/{field}/transcript_tags/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListTranscriptTagLists"];
  };
  "/datasets/{dataset_id}/field/{tag_field}/tags/list": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["ListTags"];
  };
  "/datasets/{dataset_id}/field/{tag_field}/tags/{tag_id}/delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["DeleteTag"];
  };
  "/datasets/{dataset_id}/field/{tag_field}/tags/{tag_id}/get": {
    /**
     * ### Required permissions
     * > []
     */
    get: operations["GetTag"];
  };
  "/datasets/{dataset_id}/field/{tag_field}/tags/bulk_delete": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["BulkDeleteTags"];
  };
  "/datasets/{dataset_id}/field/{tag_field}/tags/bulk_update": {
    /**
     * ### Required permissions
     * > []
     */
    post: operations["BulkUpdateTags"];
  };
}

export interface components {
  schemas: {
    CreateDeployableInput: {
      /** @description The deployable configuration. */
      configuration?: { [key: string]: unknown };
      /** @description Dataset to create deployable for. */
      dataset_id?: string;
    };
    CreateDeployableOutput: {
      deployable_id: string;
      dataset_id: string;
      project_id: string;
      configuration: { [key: string]: unknown };
      private?: boolean;
    };
    GetDeployableInput: unknown;
    GetDeployableOutput: {
      deployable_id?: string;
      dataset_id?: string;
      project_id?: string;
      api_key?: string;
      configuration?: { [key: string]: unknown };
      private?: boolean;
      updated_at?: string;
    };
    UpdateDeployableInput: {
      /** @description The deployable configuration. */
      configuration?: { [key: string]: unknown };
      /** @description Dataset to create deployable for. */
      dataset_id?: string;
      /**
       * @description Whether to overwrite document if it exists.
       * @default true
       */
      overwrite?: boolean;
      /**
       * @description This is prioritised over overwrite. If True, adds new fields.
       * @default true
       */
      upsert?: boolean;
    };
    UpdateDeployableOutput: {
      status: string;
      message: string;
    };
    DeleteDeployableInput: {
      /** @description The deployable ID. */
      id: string;
    };
    DeleteDeployableOutput: unknown;
    CreateDeployableKeyInput: unknown;
    CreateDeployableKeyOutput: {
      status: string;
      message: string;
    };
    CreateDeployableInviteInput: {
      email: string;
      type: "read" | "write";
    };
    CreateDeployableInviteOutput: {
      invite_code: string;
    };
    UpdateUsersDeployablePermissionsInput: {
      type: "read" | "write" | "none";
    };
    UpdateUsersDeployablePermissionsOutput: unknown;
    DeleteDeployableKeyInput: unknown;
    DeleteDeployableKeyOutput: {
      status: string;
      message: string;
    };
    ListDeployablesInput: unknown;
    ListDeployablesOutput: {
      deployables: {
        deployable_id?: string;
        dataset_id?: string;
        project_id?: string;
        api_key?: string;
        configuration?: { [key: string]: unknown };
        private?: boolean;
        updated_at?: string;
      }[];
      count: number;
    };
    DeleteDeployableGroupInput: unknown;
    DeleteDeployableGroupOutput: unknown;
    ListDeployableGroupsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListDeployableGroupsOutput: {
      results: ({
        _id?: string;
        name?: string;
        description?: string;
        api_key?: string;
        private?: boolean;
        show_digest?: boolean;
        deployables?: unknown[];
      } & { [key: string]: unknown })[];
    };
    CreateDeployableGroupInput: {
      _id?: string;
      name?: string;
      description?: string;
      api_key?: string;
      private?: boolean;
      show_digest?: boolean;
      deployables?: unknown[];
    };
    CreateDeployableGroupOutput: {
      id: string;
    };
    GetDeployableGroupInput: unknown;
    GetDeployableGroupOutput: {
      _id?: string;
      name?: string;
      description?: string;
      api_key?: string;
      private?: boolean;
      show_digest?: boolean;
      deployables?: unknown[];
    } & { [key: string]: unknown };
    UpdateDeployableGroupInput: {
      _id?: string;
      name?: string;
      description?: string;
      api_key?: string;
      private?: boolean;
      show_digest?: boolean;
      deployables?: unknown[];
    };
    UpdateDeployableGroupOutput: unknown;
    CreateDeployableGroupKeyInput: unknown;
    CreateDeployableGroupKeyOutput: unknown;
    DeleteDeployableGroupKeyInput: unknown;
    DeleteDeployableGroupKeyOutput: unknown;
    CreateProjectInput: {
      /** @description The name of the project */
      name?: string;
      /** @description The description of the project */
      description?: string;
      organization_id: string;
      /** @description If set to redis, it expects a redis connection string set using project keys under the name "redis". */
      datastore?: "redis";
    };
    CreateProjectOutput: {
      project_id: string;
    };
    UpdateProjectInput: {
      /** @description The name of the project */
      name?: string;
      /** @description The description of the project */
      description?: string;
      /** @description If set to redis, it expects a redis connection string set using project keys under the name "redis". */
      datastore?: "redis";
    };
    UpdateProjectOutput: {
      status: string;
      message: string;
    };
    TransferProjectToOrganizationInput: {
      /** @description The ID of the organization. */
      organization_id: string;
    };
    TransferProjectToOrganizationOutput: unknown;
    ListProjectsInput: unknown;
    ListProjectsOutput: {
      projects: {
        project_id?: string;
        name?: string;
        description?: string;
        permissions?: { [key: string]: unknown };
        updated_at?: string;
        keys?: { [key: string]: unknown };
        /** @description If set to redis, it expects a redis connection string set using project keys under the name "redis". */
        datastore?: "redis";
      }[];
      count: number;
    };
    GetProjectsOrgInfoInput: unknown;
    GetProjectsOrgInfoOutput: {
      credits: number;
    };
    ListProjectKeysInput: unknown;
    ListProjectKeysOutput: {
      keys: string[];
    };
    GetProjectKeyInput: {
      key: string;
      token: string;
    };
    GetProjectKeyOutput: {
      value: string;
    };
    SetProjectKeyInput: {
      key: string;
      value: string;
    };
    SetProjectKeyOutput: {
      status: string;
      message: string;
    };
    DeleteProjectKeyInput: {
      key: string;
    };
    DeleteProjectKeyOutput: {
      status: string;
      message: string;
    };
    permissions: {
      items: {
        [key: string]: {
          resources?: {
            datasets?: { [key: string]: boolean };
            deployables?: { [key: string]: boolean };
            users?: { [key: string]: boolean };
          };
          actions?: { [key: string]: boolean };
        };
      };
    };
    CreateUserInput: {
      profile_picture_url?: string;
      onboarded?: boolean;
      first_name?: string;
      last_name?: string;
      role?: string;
      company?: string;
      label?: string;
      notes?: string;
      permissions?: unknown;
      organization_permissions?: { [key: string]: unknown };
      referral_code?: string;
      organization_name?: string;
      project_name?: string;
      /** @description The name of the project. This will contain all your datasets. */
      project?: string;
      /** @description The id token for a signed in account. This attaches the sign in account to the user. */
      id_token?: string;
    };
    CreateUserOutput: {
      user_id: string;
      api_key: string;
      project: string;
      organization_id?: string;
    };
    ListUsersInput: {
      /** @default 1 */
      page?: number;
      /** @default 20 */
      page_size?: number;
      required_permissions?: {
        items: {
          [key: string]: {
            resources?: {
              datasets?: { [key: string]: boolean };
              deployables?: { [key: string]: boolean };
              users?: { [key: string]: boolean };
            };
            actions?: { [key: string]: boolean };
          };
        };
      };
      /** @description Currently limited to exact_match, ids, exists, regexp filter_type */
      filters?: {
        strict?: "must" | "should" | "must_or";
        condition?: string;
        case_insensitive?: boolean;
        field?: string;
        filter_type?:
          | "text_match"
          | "word_match"
          | "term"
          | "terms"
          | "text"
          | "texts"
          | "match"
          | "contains"
          | "substring"
          | "class"
          | "category"
          | "exact_match"
          | "classes"
          | "categories"
          | "exists"
          | "traditional"
          | "fuzzy"
          | "regexp"
          | "ids"
          | "date"
          | "numeric"
          | "search"
          | "or"
          | "word_count"
          | "character_count"
          | "dedupe_by_value"
          | "match_array"
          | "random";
        condition_value?: unknown;
        fuzzy?: number;
        join?: boolean;
      }[];
    };
    ListUsersOutput: {
      results: {
        profile_picture_url?: string;
        onboarded?: boolean;
        first_name?: string;
        last_name?: string;
        role?: string;
        company?: string;
        label?: string;
        notes?: string;
        permissions: {
          projects: {
            [key: string]: {
              items: {
                [key: string]: {
                  resources?: {
                    datasets?: { [key: string]: boolean };
                    deployables?: { [key: string]: boolean };
                    users?: { [key: string]: boolean };
                  };
                  actions?: { [key: string]: boolean };
                };
              };
            };
          };
          organizations?: {
            [key: string]: {
              items: {
                [key: string]: {
                  resources?: {
                    datasets?: { [key: string]: boolean };
                    deployables?: { [key: string]: boolean };
                    users?: { [key: string]: boolean };
                  };
                  actions?: { [key: string]: boolean };
                };
              };
            };
          };
          administrator?: {
            items: {
              [key: string]: {
                resources?: {
                  datasets?: { [key: string]: boolean };
                  deployables?: { [key: string]: boolean };
                  users?: { [key: string]: boolean };
                };
                actions?: { [key: string]: boolean };
              };
            };
          };
        };
        type: "user" | "machine";
        _id: string;
        email?: string;
        creator_user_id?: string;
      }[];
    };
    IsUserAuthorizedInput: {
      permissions?: unknown;
      organization_permissions?: { [key: string]: unknown };
    };
    IsUserAuthorizedOutput: {
      valid: boolean;
      message: string;
    };
    GetAuthHeaderInfoInput: unknown;
    fullUserPermissions: {
      projects: {
        [key: string]: {
          items: {
            [key: string]: {
              resources?: {
                datasets?: { [key: string]: boolean };
                deployables?: { [key: string]: boolean };
                users?: { [key: string]: boolean };
              };
              actions?: { [key: string]: boolean };
            };
          };
        };
      };
      organizations?: {
        [key: string]: {
          items: {
            [key: string]: {
              resources?: {
                datasets?: { [key: string]: boolean };
                deployables?: { [key: string]: boolean };
                users?: { [key: string]: boolean };
              };
              actions?: { [key: string]: boolean };
            };
          };
        };
      };
      administrator?: {
        items: {
          [key: string]: {
            resources?: {
              datasets?: { [key: string]: boolean };
              deployables?: { [key: string]: boolean };
              users?: { [key: string]: boolean };
            };
            actions?: { [key: string]: boolean };
          };
        };
      };
    };
    GetAuthHeaderInfoOutput: {
      profile_picture_url?: string;
      onboarded?: boolean;
      first_name?: string;
      last_name?: string;
      role?: string;
      company?: string;
      label?: string;
      notes?: string;
      user_id: string;
      key_id: string;
      permissions: unknown;
      email?: string;
    };
    CreateProjectInviteInput: {
      permissions?: unknown;
      organization_permissions?: { [key: string]: unknown };
      email?: string;
      user_id?: string;
      type?: "deployable" | "project";
    };
    CreateProjectInviteOutput: {
      invite_code: string;
    };
    ListProjectInvitesInput: unknown;
    ListProjectInvitesOutput: {
      results: {
        _id: string;
        user_id?: string;
        permissions?: {
          items: {
            [key: string]: {
              resources?: {
                datasets?: { [key: string]: boolean };
                deployables?: { [key: string]: boolean };
                users?: { [key: string]: boolean };
              };
              actions?: { [key: string]: boolean };
            };
          };
        };
        email?: string;
        project?: string;
      }[];
    };
    AcceptProjectInviteInput: {
      invite_code: string;
    };
    AcceptProjectInviteOutput: { [key: string]: unknown };
    DeleteProjectInviteInput: {
      invite_code: string;
    };
    DeleteProjectInviteOutput: { [key: string]: unknown };
    ResendProjectInviteInput: {
      permissions?: {
        items: {
          [key: string]: {
            resources?: {
              datasets?: { [key: string]: boolean };
              deployables?: { [key: string]: boolean };
              users?: { [key: string]: boolean };
            };
            actions?: { [key: string]: boolean };
          };
        };
      };
      organization_permissions?: { [key: string]: unknown };
      invite_code: string;
    };
    ResendProjectInviteOutput: {
      invite_code: string;
    };
    GetUserInput: { [key: string]: unknown };
    GetUserOutput: {
      profile_picture_url?: string;
      onboarded?: boolean;
      first_name?: string;
      last_name?: string;
      role?: string;
      company?: string;
      label?: string;
      notes?: string;
      permissions: {
        projects: {
          [key: string]: {
            items: {
              [key: string]: {
                resources?: {
                  datasets?: { [key: string]: boolean };
                  deployables?: { [key: string]: boolean };
                  users?: { [key: string]: boolean };
                };
                actions?: { [key: string]: boolean };
              };
            };
          };
        };
        organizations?: {
          [key: string]: {
            items: {
              [key: string]: {
                resources?: {
                  datasets?: { [key: string]: boolean };
                  deployables?: { [key: string]: boolean };
                  users?: { [key: string]: boolean };
                };
                actions?: { [key: string]: boolean };
              };
            };
          };
        };
        administrator?: {
          items: {
            [key: string]: {
              resources?: {
                datasets?: { [key: string]: boolean };
                deployables?: { [key: string]: boolean };
                users?: { [key: string]: boolean };
              };
              actions?: { [key: string]: boolean };
            };
          };
        };
      };
      type: "user" | "machine";
      _id: string;
      email?: string;
      creator_user_id?: string;
    };
    UpdateUserInput: {
      profile_picture_url?: string;
      onboarded?: boolean;
      first_name?: string;
      last_name?: string;
      role?: string;
      company?: string;
      label?: string;
      notes?: string;
      permissions?: unknown;
      organization_permissions?: { [key: string]: unknown };
      /** @description The id token for a signed in account. This attaches the sign in account to the user. */
      id_token?: string;
      /** @description Set this to true to replace users permissions for project, rather than upserting */
      overwrite?: boolean;
    };
    UpdateUserOutput: { [key: string]: unknown };
    DeleteUserInput: { [key: string]: unknown };
    DeleteUserOutput: { [key: string]: unknown };
    CreateUserKeyInput: {
      label?: string;
      notes?: string;
    };
    CreateUserKeyOutput: {
      api_key: string;
      id: string;
    };
    ListUserKeysInput: unknown;
    ListUserKeysOutput: {
      results: {
        _id: string;
        label?: string;
        notes?: string;
      }[];
    };
    DeleteUserKeyInput: {
      id: string;
    };
    DeleteUserKeyOutput: { [key: string]: unknown };
    InsertClusterCentroidsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      /**
       * @description Insert cluster centers.
       *   Cluster center documents needs to be the following:
       *   [
       *       {
       *           "_id": "cluster_0",
       *           "centroid_vector_": [0.1, 0.2, 0.1]
       *       }
       *   ]
       */
      cluster_centers: {
        _id: string;
      }[];
    };
    InsertClusterCentroidsOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    UpdateClusterCentroidsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      /**
       * @description Insert cluster centers.
       *   Cluster center documents needs to be the following:
       *   [
       *       {
       *           "_id": "cluster_0",
       *           "centroid_vector_": [0.1, 0.2, 0.1]
       *       }
       *   ]
       */
      cluster_centers: {
        _id: string;
      }[];
    };
    UpdateClusterCentroidsOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    CompareClusterCentroidsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      comparison_centroids: {
        /** @description Field to cluster on */
        cluster_field?: string;
        /** @description The vector fields that these centroids are associated with. */
        vector_fields?: string[];
        centroid_vector_fields?: string[];
        /** @description Alias is used to name a cluster. */
        alias?: string;
        dataset_id?: string;
      };
    };
    CompareClusterCentroidsOutput: {
      results: {
        [key: string]: {
          results?: unknown[];
          /** @description Used in future requests to retrieve items after these values in the sort order. */
          after_id?: unknown[];
        };
      };
    };
    simpleSearchAndFlatFilterItem: Partial<{
      /** @description Match where document[field] is in value list. */
      match?: {
        /** @description If matching on text, match even if there are extra words / case insensitivity */
        fuzzy?: boolean;
        /** @description Field to match on. */
        field?: string;
        /** @description Can be either a single item or a list of items to match on. */
        value: unknown;
      };
      matchArray?: {
        field: string;
        value: unknown[];
      };
      random?: {
        size: number;
      };
      /** @description Match where document._id is in value list. */
      matchIds?: {
        /** @description Can be either a single item or a list of items to match on. */
        value: unknown;
      };
      /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
      range?: {
        /** @description Field to match on. */
        field?: string;
        greaterThan?: unknown;
        lessThan?: unknown;
        greaterThanOrEqualTo?: unknown;
        lessThanOrEqualTo?: unknown;
      };
      /**
       * @description
       * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
       *
       * Possible matching patterns:
       *
       * * - documents where the field has any value
       * ? - documents where a single character from the field matches the provided values
       *
       * Example:
       *
       * {
       *   wildcard: {
       *      field: "title",
       *      value: [ "Avenger*" ]
       *   }
       * }
       */
      wildcard?: {
        /** @description Field to match on. */
        field?: string;
        /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
        value: unknown;
      };
      /** @description hybrid search query that must reach a certain value to filter */
      search?: {
        /**
         * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
         *
         *     "tele" matches "Television", "This television is an excellent product…"
         *
         *     Example: "tele"
         */
        query?: string;
        /** @description Configuration for traditional search query. */
        queryConfig?: {
          /**
           * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
           * @default 1
           */
          weight?: number;
          /**
           * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
           *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
           * @default 1
           */
          sentenceWeight?: number;
          /**
           * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
           *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
           * @default 1
           */
          fuzzyWeight?: number;
        };
        /**
         * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
         *
         *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
         *
         *     It can be an object or a list of objects.
         *
         *
         *
         *     Example payloads:
         *
         *     {"field":"animaltype_vector_","query":"kitten"}
         *
         *     [
         *
         *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
         *
         *     ]
         */
        vectorSearchQuery?: unknown;
        realtimeClustering?: {
          /** @default 4 */
          nClusters?: number;
          /** @default kmeans-realtime-4 */
          alias?: string;
          vectorField: string;
          /** @default _cluster_.{vector_field}.{alias} */
          outputField?: string;
        };
        /**
         * @description A list of fields to search using the "query" parameter.
         *
         *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
         *
         *     Default behaviour is to search all fields.
         *
         *     Example: ["name",{"field":"favourite_color","weight":0.2}]
         */
        fieldsToSearch?: unknown[];
        /**
         * @description Only return documents with a _relevance above this threshold.
         *
         *     Example: 0.3
         */
        minimumRelevance: number;
      };
      /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
      fieldExists?: {
        /** @description Field that must exist. */
        field?: string;
      };
      /** @description Match documents where doc[field] % module == value */
      matchModulo?: {
        /** @default _id */
        field?: string;
        modulo: number;
        value: number;
      };
      /** @description Filter down to one document for each value of selected field. */
      dedupeByValue?: {
        /** @description Field to filter on. */
        field: string;
      };
      /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
      selfreference?: {
        /** @description First field in comparison. */
        a: string;
        /** @description Second field in comparison. */
        b: string;
        /** @description Operator used to compare a and b. */
        operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
      };
      /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
      wordCount?: {
        /** @description Field to match on. */
        field: string;
        /** @description Minimum word count. */
        greaterThan?: number;
        /** @description Maximum word count. */
        lessThan?: number;
      };
      /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
      characterCount?: {
        /** @description Field to match on. */
        field: string;
        /** @description Minimum character count. */
        greaterThan?: number;
        /** @description Maximum character count. */
        lessThan?: number;
      };
      /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
      or?: unknown[];
      /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
      not?: unknown;
      /** @description Filter based on data within a _chunk_ field. */
      chunk?: {
        /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
        path: string;
        filters: unknown[];
      };
    }> &
      Partial<{
        strict?: "must" | "should" | "must_or";
        condition?: string;
        case_insensitive?: boolean;
        field?: string;
        filter_type?:
          | "text_match"
          | "word_match"
          | "term"
          | "terms"
          | "text"
          | "texts"
          | "match"
          | "contains"
          | "substring"
          | "class"
          | "category"
          | "exact_match"
          | "classes"
          | "categories"
          | "exists"
          | "traditional"
          | "fuzzy"
          | "regexp"
          | "ids"
          | "date"
          | "numeric"
          | "search"
          | "or"
          | "word_count"
          | "character_count"
          | "dedupe_by_value"
          | "match_array"
          | "random";
        condition_value?: unknown;
        fuzzy?: number;
        join?: boolean;
      }>;
    AggregateInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Aggregation query to aggregate data */
      aggregation_query?: {
        groupby?: {
          agg?:
            | "texts"
            | "categories"
            | "classes"
            | "text"
            | "category"
            | "class"
            | "terms"
            | "number"
            | "numeric"
            | "bool"
            | "wordcloud"
            | "array"
            | "boolean_filter"
            | "histogram";
          size?: number;
          field?: string;
          name?: string;
          boolean_filter?: Partial<{
            /** @description Match where document[field] is in value list. */
            match?: {
              /** @description If matching on text, match even if there are extra words / case insensitivity */
              fuzzy?: boolean;
              /** @description Field to match on. */
              field?: string;
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            matchArray?: {
              field: string;
              value: unknown[];
            };
            random?: {
              size: number;
            };
            /** @description Match where document._id is in value list. */
            matchIds?: {
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
            range?: {
              /** @description Field to match on. */
              field?: string;
              greaterThan?: unknown;
              lessThan?: unknown;
              greaterThanOrEqualTo?: unknown;
              lessThanOrEqualTo?: unknown;
            };
            /**
             * @description
             * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
             *
             * Possible matching patterns:
             *
             * * - documents where the field has any value
             * ? - documents where a single character from the field matches the provided values
             *
             * Example:
             *
             * {
             *   wildcard: {
             *      field: "title",
             *      value: [ "Avenger*" ]
             *   }
             * }
             */
            wildcard?: {
              /** @description Field to match on. */
              field?: string;
              /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
              value: unknown;
            };
            /** @description hybrid search query that must reach a certain value to filter */
            search?: {
              /**
               * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
               *
               *     "tele" matches "Television", "This television is an excellent product…"
               *
               *     Example: "tele"
               */
              query?: string;
              /** @description Configuration for traditional search query. */
              queryConfig?: {
                /**
                 * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
                 * @default 1
                 */
                weight?: number;
                /**
                 * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
                 *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
                 * @default 1
                 */
                sentenceWeight?: number;
                /**
                 * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
                 *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
                 * @default 1
                 */
                fuzzyWeight?: number;
              };
              /**
               * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
               *
               *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
               *
               *     It can be an object or a list of objects.
               *
               *
               *
               *     Example payloads:
               *
               *     {"field":"animaltype_vector_","query":"kitten"}
               *
               *     [
               *
               *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
               *
               *     ]
               */
              vectorSearchQuery?: unknown;
              realtimeClustering?: {
                /** @default 4 */
                nClusters?: number;
                /** @default kmeans-realtime-4 */
                alias?: string;
                vectorField: string;
                /** @default _cluster_.{vector_field}.{alias} */
                outputField?: string;
              };
              /**
               * @description A list of fields to search using the "query" parameter.
               *
               *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
               *
               *     Default behaviour is to search all fields.
               *
               *     Example: ["name",{"field":"favourite_color","weight":0.2}]
               */
              fieldsToSearch?: unknown[];
              /**
               * @description Only return documents with a _relevance above this threshold.
               *
               *     Example: 0.3
               */
              minimumRelevance: number;
            };
            /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
            fieldExists?: {
              /** @description Field that must exist. */
              field?: string;
            };
            /** @description Match documents where doc[field] % module == value */
            matchModulo?: {
              /** @default _id */
              field?: string;
              modulo: number;
              value: number;
            };
            /** @description Filter down to one document for each value of selected field. */
            dedupeByValue?: {
              /** @description Field to filter on. */
              field: string;
            };
            /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
            selfreference?: {
              /** @description First field in comparison. */
              a: string;
              /** @description Second field in comparison. */
              b: string;
              /** @description Operator used to compare a and b. */
              operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
            };
            /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
            wordCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum word count. */
              greaterThan?: number;
              /** @description Maximum word count. */
              lessThan?: number;
            };
            /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
            characterCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum character count. */
              greaterThan?: number;
              /** @description Maximum character count. */
              lessThan?: number;
            };
            /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
            or?: unknown[];
            /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
            not?: unknown;
            /** @description Filter based on data within a _chunk_ field. */
            chunk?: {
              /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
              path: string;
              filters: unknown[];
            };
          }> &
            Partial<{
              strict?: "must" | "should" | "must_or";
              condition?: string;
              case_insensitive?: boolean;
              field?: string;
              filter_type?:
                | "text_match"
                | "word_match"
                | "term"
                | "terms"
                | "text"
                | "texts"
                | "match"
                | "contains"
                | "substring"
                | "class"
                | "category"
                | "exact_match"
                | "classes"
                | "categories"
                | "exists"
                | "traditional"
                | "fuzzy"
                | "regexp"
                | "ids"
                | "date"
                | "numeric"
                | "search"
                | "or"
                | "word_count"
                | "character_count"
                | "dedupe_by_value"
                | "match_array"
                | "random";
              condition_value?: unknown;
              fuzzy?: number;
              join?: boolean;
            }>;
          /** @description Control the number of results for this aggregation level. This will default to the page_size provided in the root body if not provided. */
          page_size?: number;
          group_size?: number;
          select_fields?: string[];
          remove_words?: string[];
          include_words?: string[];
          /** @default monthly */
          date_interval?:
            | "monthly"
            | "daily"
            | "yearly"
            | "hourly"
            | "minutely"
            | "weekly";
          /** @description If provided, group by field into n buckets in date range. */
          n_date_buckets?: number;
          buckets?: Partial<{
            histogram?: {
              interval?: number;
              min_doc_count?: number;
            };
          }> &
            Partial<
              {
                from?: number;
                to?: number;
              }[]
            >;
        }[];
        metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        sort?: unknown[];
      };
      /**
       * @description Size of each page of results
       * @default 20
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      /** @description Whether to sort results by ascending or descending order. */
      asc?: boolean;
      dataset_ids?: string[];
      dataset_id?: string;
    };
    AggregateOutput: {
      results?: unknown[];
    };
    AggregateClustersInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Aggregation query to aggregate data */
      aggregation_query?: {
        groupby?: {
          agg?:
            | "texts"
            | "categories"
            | "classes"
            | "text"
            | "category"
            | "class"
            | "terms"
            | "number"
            | "numeric"
            | "bool"
            | "wordcloud"
            | "array"
            | "boolean_filter"
            | "histogram";
          size?: number;
          field?: string;
          name?: string;
          boolean_filter?: Partial<{
            /** @description Match where document[field] is in value list. */
            match?: {
              /** @description If matching on text, match even if there are extra words / case insensitivity */
              fuzzy?: boolean;
              /** @description Field to match on. */
              field?: string;
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            matchArray?: {
              field: string;
              value: unknown[];
            };
            random?: {
              size: number;
            };
            /** @description Match where document._id is in value list. */
            matchIds?: {
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
            range?: {
              /** @description Field to match on. */
              field?: string;
              greaterThan?: unknown;
              lessThan?: unknown;
              greaterThanOrEqualTo?: unknown;
              lessThanOrEqualTo?: unknown;
            };
            /**
             * @description
             * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
             *
             * Possible matching patterns:
             *
             * * - documents where the field has any value
             * ? - documents where a single character from the field matches the provided values
             *
             * Example:
             *
             * {
             *   wildcard: {
             *      field: "title",
             *      value: [ "Avenger*" ]
             *   }
             * }
             */
            wildcard?: {
              /** @description Field to match on. */
              field?: string;
              /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
              value: unknown;
            };
            /** @description hybrid search query that must reach a certain value to filter */
            search?: {
              /**
               * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
               *
               *     "tele" matches "Television", "This television is an excellent product…"
               *
               *     Example: "tele"
               */
              query?: string;
              /** @description Configuration for traditional search query. */
              queryConfig?: {
                /**
                 * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
                 * @default 1
                 */
                weight?: number;
                /**
                 * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
                 *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
                 * @default 1
                 */
                sentenceWeight?: number;
                /**
                 * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
                 *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
                 * @default 1
                 */
                fuzzyWeight?: number;
              };
              /**
               * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
               *
               *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
               *
               *     It can be an object or a list of objects.
               *
               *
               *
               *     Example payloads:
               *
               *     {"field":"animaltype_vector_","query":"kitten"}
               *
               *     [
               *
               *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
               *
               *     ]
               */
              vectorSearchQuery?: unknown;
              realtimeClustering?: {
                /** @default 4 */
                nClusters?: number;
                /** @default kmeans-realtime-4 */
                alias?: string;
                vectorField: string;
                /** @default _cluster_.{vector_field}.{alias} */
                outputField?: string;
              };
              /**
               * @description A list of fields to search using the "query" parameter.
               *
               *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
               *
               *     Default behaviour is to search all fields.
               *
               *     Example: ["name",{"field":"favourite_color","weight":0.2}]
               */
              fieldsToSearch?: unknown[];
              /**
               * @description Only return documents with a _relevance above this threshold.
               *
               *     Example: 0.3
               */
              minimumRelevance: number;
            };
            /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
            fieldExists?: {
              /** @description Field that must exist. */
              field?: string;
            };
            /** @description Match documents where doc[field] % module == value */
            matchModulo?: {
              /** @default _id */
              field?: string;
              modulo: number;
              value: number;
            };
            /** @description Filter down to one document for each value of selected field. */
            dedupeByValue?: {
              /** @description Field to filter on. */
              field: string;
            };
            /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
            selfreference?: {
              /** @description First field in comparison. */
              a: string;
              /** @description Second field in comparison. */
              b: string;
              /** @description Operator used to compare a and b. */
              operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
            };
            /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
            wordCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum word count. */
              greaterThan?: number;
              /** @description Maximum word count. */
              lessThan?: number;
            };
            /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
            characterCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum character count. */
              greaterThan?: number;
              /** @description Maximum character count. */
              lessThan?: number;
            };
            /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
            or?: unknown[];
            /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
            not?: unknown;
            /** @description Filter based on data within a _chunk_ field. */
            chunk?: {
              /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
              path: string;
              filters: unknown[];
            };
          }> &
            Partial<{
              strict?: "must" | "should" | "must_or";
              condition?: string;
              case_insensitive?: boolean;
              field?: string;
              filter_type?:
                | "text_match"
                | "word_match"
                | "term"
                | "terms"
                | "text"
                | "texts"
                | "match"
                | "contains"
                | "substring"
                | "class"
                | "category"
                | "exact_match"
                | "classes"
                | "categories"
                | "exists"
                | "traditional"
                | "fuzzy"
                | "regexp"
                | "ids"
                | "date"
                | "numeric"
                | "search"
                | "or"
                | "word_count"
                | "character_count"
                | "dedupe_by_value"
                | "match_array"
                | "random";
              condition_value?: unknown;
              fuzzy?: number;
              join?: boolean;
            }>;
          /** @description Control the number of results for this aggregation level. This will default to the page_size provided in the root body if not provided. */
          page_size?: number;
          group_size?: number;
          select_fields?: string[];
          remove_words?: string[];
          include_words?: string[];
          /** @default monthly */
          date_interval?:
            | "monthly"
            | "daily"
            | "yearly"
            | "hourly"
            | "minutely"
            | "weekly";
          /** @description If provided, group by field into n buckets in date range. */
          n_date_buckets?: number;
          buckets?: Partial<{
            histogram?: {
              interval?: number;
              min_doc_count?: number;
            };
          }> &
            Partial<
              {
                from?: number;
                to?: number;
              }[]
            >;
        }[];
        metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        sort?: unknown[];
      };
      /**
       * @description Size of each page of results
       * @default 20
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      /** @description Whether to sort results by ascending or descending order. */
      asc?: boolean;
      dataset_ids?: string[];
      dataset_id?: string;
      alias?: string;
      vector_fields?: string[];
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description List of cluster IDs to aggregate on */
      cluster_ids?: unknown[];
      /** @description Filter if clusters with certain characteristics should be hidden in results. */
      cluster_properties_filter?: {
        /** @description Clusters with less than this many items will be hidden from results. */
        minimum_cluster_size?: number;
        /**
         * @description Whether to add to list of cluster to show (or), or filter clusters to show based on minimum_cluster_size (and)
         * @default and
         */
        minimum_cluster_size_filter_type?: "or" | "and";
        cluster_page?: number;
        cluster_page_size?: number;
        sort_metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        /** @description Whether to sort results by ascending or descending order. */
        asc?: boolean;
      };
      /** @description For each frequency in results, also return expected_frequency as cluster_size*(count(groupbyattribute)/count(dataset)). Useful for knowing if an attribute is occurring more or less than expected. */
      include_expected_frequency?: boolean;
      /** @description Return the number of clusters in the dataset in the field "count", and the number of documents belonging to at least one cluster in "document_count". */
      include_counts?: boolean;
    };
    AggregateClustersOutput: {
      results: { [key: string]: unknown[] };
      cluster_order: string[];
      cluster_stats?: {
        [key: string]: {
          percentage: number;
          count: number;
        };
      };
      /** @description Total number of clusters in the dataset. */
      count?: number;
      /** @description Total number of documents that are part of at least one cluster. */
      document_count?: number;
    };
    ListClusterFacetsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Aggregation query to aggregate data */
      aggregation_query?: {
        groupby?: {
          agg?:
            | "texts"
            | "categories"
            | "classes"
            | "text"
            | "category"
            | "class"
            | "terms"
            | "number"
            | "numeric"
            | "bool"
            | "wordcloud"
            | "array"
            | "boolean_filter"
            | "histogram";
          size?: number;
          field?: string;
          name?: string;
          boolean_filter?: Partial<{
            /** @description Match where document[field] is in value list. */
            match?: {
              /** @description If matching on text, match even if there are extra words / case insensitivity */
              fuzzy?: boolean;
              /** @description Field to match on. */
              field?: string;
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            matchArray?: {
              field: string;
              value: unknown[];
            };
            random?: {
              size: number;
            };
            /** @description Match where document._id is in value list. */
            matchIds?: {
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
            range?: {
              /** @description Field to match on. */
              field?: string;
              greaterThan?: unknown;
              lessThan?: unknown;
              greaterThanOrEqualTo?: unknown;
              lessThanOrEqualTo?: unknown;
            };
            /**
             * @description
             * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
             *
             * Possible matching patterns:
             *
             * * - documents where the field has any value
             * ? - documents where a single character from the field matches the provided values
             *
             * Example:
             *
             * {
             *   wildcard: {
             *      field: "title",
             *      value: [ "Avenger*" ]
             *   }
             * }
             */
            wildcard?: {
              /** @description Field to match on. */
              field?: string;
              /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
              value: unknown;
            };
            /** @description hybrid search query that must reach a certain value to filter */
            search?: {
              /**
               * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
               *
               *     "tele" matches "Television", "This television is an excellent product…"
               *
               *     Example: "tele"
               */
              query?: string;
              /** @description Configuration for traditional search query. */
              queryConfig?: {
                /**
                 * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
                 * @default 1
                 */
                weight?: number;
                /**
                 * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
                 *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
                 * @default 1
                 */
                sentenceWeight?: number;
                /**
                 * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
                 *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
                 * @default 1
                 */
                fuzzyWeight?: number;
              };
              /**
               * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
               *
               *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
               *
               *     It can be an object or a list of objects.
               *
               *
               *
               *     Example payloads:
               *
               *     {"field":"animaltype_vector_","query":"kitten"}
               *
               *     [
               *
               *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
               *
               *     ]
               */
              vectorSearchQuery?: unknown;
              realtimeClustering?: {
                /** @default 4 */
                nClusters?: number;
                /** @default kmeans-realtime-4 */
                alias?: string;
                vectorField: string;
                /** @default _cluster_.{vector_field}.{alias} */
                outputField?: string;
              };
              /**
               * @description A list of fields to search using the "query" parameter.
               *
               *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
               *
               *     Default behaviour is to search all fields.
               *
               *     Example: ["name",{"field":"favourite_color","weight":0.2}]
               */
              fieldsToSearch?: unknown[];
              /**
               * @description Only return documents with a _relevance above this threshold.
               *
               *     Example: 0.3
               */
              minimumRelevance: number;
            };
            /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
            fieldExists?: {
              /** @description Field that must exist. */
              field?: string;
            };
            /** @description Match documents where doc[field] % module == value */
            matchModulo?: {
              /** @default _id */
              field?: string;
              modulo: number;
              value: number;
            };
            /** @description Filter down to one document for each value of selected field. */
            dedupeByValue?: {
              /** @description Field to filter on. */
              field: string;
            };
            /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
            selfreference?: {
              /** @description First field in comparison. */
              a: string;
              /** @description Second field in comparison. */
              b: string;
              /** @description Operator used to compare a and b. */
              operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
            };
            /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
            wordCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum word count. */
              greaterThan?: number;
              /** @description Maximum word count. */
              lessThan?: number;
            };
            /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
            characterCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum character count. */
              greaterThan?: number;
              /** @description Maximum character count. */
              lessThan?: number;
            };
            /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
            or?: unknown[];
            /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
            not?: unknown;
            /** @description Filter based on data within a _chunk_ field. */
            chunk?: {
              /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
              path: string;
              filters: unknown[];
            };
          }> &
            Partial<{
              strict?: "must" | "should" | "must_or";
              condition?: string;
              case_insensitive?: boolean;
              field?: string;
              filter_type?:
                | "text_match"
                | "word_match"
                | "term"
                | "terms"
                | "text"
                | "texts"
                | "match"
                | "contains"
                | "substring"
                | "class"
                | "category"
                | "exact_match"
                | "classes"
                | "categories"
                | "exists"
                | "traditional"
                | "fuzzy"
                | "regexp"
                | "ids"
                | "date"
                | "numeric"
                | "search"
                | "or"
                | "word_count"
                | "character_count"
                | "dedupe_by_value"
                | "match_array"
                | "random";
              condition_value?: unknown;
              fuzzy?: number;
              join?: boolean;
            }>;
          /** @description Control the number of results for this aggregation level. This will default to the page_size provided in the root body if not provided. */
          page_size?: number;
          group_size?: number;
          select_fields?: string[];
          remove_words?: string[];
          include_words?: string[];
          /** @default monthly */
          date_interval?:
            | "monthly"
            | "daily"
            | "yearly"
            | "hourly"
            | "minutely"
            | "weekly";
          /** @description If provided, group by field into n buckets in date range. */
          n_date_buckets?: number;
          buckets?: Partial<{
            histogram?: {
              interval?: number;
              min_doc_count?: number;
            };
          }> &
            Partial<
              {
                from?: number;
                to?: number;
              }[]
            >;
        }[];
        metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        sort?: unknown[];
      };
      /**
       * @description Size of facet page
       * @default 1000
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      /** @description Whether to sort results by ascending or descending frequency */
      asc?: boolean;
      dataset_ids?: string[];
      dataset_id?: string;
      alias?: string;
      vector_fields?: string[];
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description List of cluster IDs to aggregate on */
      cluster_ids?: unknown[];
      /** @description Filter if clusters with certain characteristics should be hidden in results. */
      cluster_properties_filter?: {
        /** @description Clusters with less than this many items will be hidden from results. */
        minimum_cluster_size?: number;
        /**
         * @description Whether to add to list of cluster to show (or), or filter clusters to show based on minimum_cluster_size (and)
         * @default and
         */
        minimum_cluster_size_filter_type?: "or" | "and";
        cluster_page?: number;
        cluster_page_size?: number;
        sort_metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        /** @description Whether to sort results by ascending or descending order. */
        asc?: boolean;
      };
      /** @description Fields to include in the facets, if [] then all */
      facet_fields?: string[];
      /** @default monthly */
      date_interval?:
        | "monthly"
        | "daily"
        | "yearly"
        | "hourly"
        | "minutely"
        | "weekly";
    };
    ListClusterFacetsOutput: {
      results?: {
        [key: string]: {
          results: { [key: string]: unknown };
        };
      };
    };
    ListClosestToCentroidsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description List of cluster IDs to retrieve */
      cluster_ids?: unknown[];
      select_fields?: string[];
      approx?: number;
      sum_fields?: boolean;
      /**
       * @description Size of each page of results
       * @default 20
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      similarity_metric?: "cosine" | "l2" | "l1" | "dp";
      min_score?: number;
      /** @description Include vectors in the search results */
      include_vector?: boolean;
      include_count?: boolean;
      /** @description Filter if clusters with certain characteristics should be hidden in results. */
      cluster_properties_filter?: {
        /** @description Clusters with less than this many items will be hidden from results. */
        minimum_cluster_size?: number;
        /**
         * @description Whether to add to list of cluster to show (or), or filter clusters to show based on minimum_cluster_size (and)
         * @default and
         */
        minimum_cluster_size_filter_type?: "or" | "and";
        cluster_page?: number;
        cluster_page_size?: number;
        sort_metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        /** @description Whether to sort results by ascending or descending order. */
        asc?: boolean;
      };
      /** @description Whether to include relevance scores for each item in each cluster. */
      include_relevance?: boolean;
      cluster_overrides?: {
        [key: string]: {
          /** @description Used in future requests to retrieve items after these values in the sort order. */
          after_id?: unknown[];
        };
      };
    };
    ListClosestToCentroidsOutput: {
      results: {
        [key: string]: {
          results?: unknown[];
          /** @description Used in future requests to retrieve items after these values in the sort order. */
          after_id?: unknown[];
        };
      };
    };
    ListFurthestFromCentroidsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description List of cluster IDs to retrieve */
      cluster_ids?: unknown[];
      select_fields?: string[];
      approx?: number;
      sum_fields?: boolean;
      /**
       * @description Size of each page of results
       * @default 20
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      similarity_metric?: "cosine" | "l2" | "l1" | "dp";
      min_score?: number;
      /** @description Include vectors in the search results */
      include_vector?: boolean;
      include_count?: boolean;
      /** @description Filter if clusters with certain characteristics should be hidden in results. */
      cluster_properties_filter?: {
        /** @description Clusters with less than this many items will be hidden from results. */
        minimum_cluster_size?: number;
        /**
         * @description Whether to add to list of cluster to show (or), or filter clusters to show based on minimum_cluster_size (and)
         * @default and
         */
        minimum_cluster_size_filter_type?: "or" | "and";
        cluster_page?: number;
        cluster_page_size?: number;
        sort_metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        /** @description Whether to sort results by ascending or descending order. */
        asc?: boolean;
      };
      /** @description Whether to include relevance scores for each item in each cluster. */
      include_relevance?: boolean;
      cluster_overrides?: {
        [key: string]: {
          /** @description Used in future requests to retrieve items after these values in the sort order. */
          after_id?: unknown[];
        };
      };
    };
    ListFurthestFromCentroidsOutput: {
      results: {
        [key: string]: {
          results?: unknown[];
          /** @description Used in future requests to retrieve items after these values in the sort order. */
          after_id?: unknown[];
        };
      };
    };
    ListCentroidsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      /** @description List of cluster IDs to retrieve */
      cluster_ids?: unknown[];
      /** @description Size of each page of results */
      page_size?: number;
      /** @description Page of the results */
      page?: number;
      /** @description Include vectors in the search results */
      include_vector?: boolean;
    };
    ListCentroidsOutput: {
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      results: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
    };
    ListCentroidConfigsInput: unknown;
    ListCentroidConfigsOutput: {
      results: {
        count: number;
        /** @description The vector fields that these centroids are associated with. */
        vector_fields: string[];
        /** @description Alias is used to name a cluster. */
        alias: string;
      }[];
    };
    DeleteCentroidInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
    };
    DeleteCentroidOutput: unknown;
    RealtimeClusteringInput: {
      /** @description The vector field to cluster in real-time. */
      vector_field: string;
      /** @description The keyword query to apply during vector retrieval */
      keyword_query: string;
      /** @description The number of documents to get. */
      number_of_documents?: number;
      /** @description The number of clusters to cluster the documents over. */
      number_of_clusters?: number;
    };
    RealtimeClusteringOutput: {
      results?: unknown[];
    };
    MergeClustersInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      cluster_ids: unknown[];
    };
    MergeClustersOutput: {
      results?: string;
    };
    CreateClusterSummariesInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      cluster_ids?: unknown[];
      /** @description Set to true to only return summaries, not save them. */
      dont_save_summaries?: boolean;
      questions: {
        cluster_ids?: unknown[];
        /**
         * @description Summarise the top results in a sentence. Fields will form a string like:
         *   ```
         *   {question_prefix}
         *   {item_prefix} 1:{field_value}
         *   {item_prefix} 2: {field_value_2}
         *   {question_suffix}}
         *   ```
         *   To create a summary on a field name 'feedback' for each cluster, An example payload could be:
         *
         *   ```
         *   "cluster_text_summary":[
         *     {"item_prefix":"Feedback","question_suffix":"Summarise the feedback in one short sentence.","field":"feedback"}
         *   ]
         *   ```
         */
        config: {
          examples?: {
            /** @description Embedded in prompt as example text that should predict label. */
            items: string[];
            /** @description Will embedded in the prompt as the expected target label of the items. */
            label: string;
          }[];
          /** @description Text field of clusters to summarize */
          field: string;
          question_prefix?: string;
          question_suffix?: string;
          item_prefix?: string;
          /**
           * @description Add 1:,2:,3:... to each item. This makes it more likely output will be numbered.
           * @default true
           */
          items_numbered?: boolean;
          /**
           * @description Cluster items provide context to the question. Limiting cluster item char length reduces cost, but may miss end of sentences with context.
           * @default 200
           */
          max_item_length?: number;
          /**
           * @description Cluster items provide context to the question. Limiting cluster item count reduces cost, but may miss items with context.
           * @default 10
           */
          max_item_count?: number;
          /**
           * @description Controls answer quality. Higher quality answers have exponentially higher cost.
           * @default 1
           */
          accuracy?: 1 | 2 | 3 | 4;
          /** @default 0.7 */
          temperature?: number;
          /**
           * @description Maximum number of words that will be generated.
           * @default 60
           */
          max_answer_length?: number;
          /**
           * @description To avoid overloading our summary API, you can increase / decrease the ms delay between questions.
           * @default 1000
           */
          delay_between_summary_generation?: number;
        };
      }[];
    };
    CreateClusterSummariesOutput: {
      results: {
        [key: string]: {
          answers: {
            answer: string;
            question: string;
            /**
             * @description Summarise the top results in a sentence. Fields will form a string like:
             *   ```
             *   {question_prefix}
             *   {item_prefix} 1:{field_value}
             *   {item_prefix} 2: {field_value_2}
             *   {question_suffix}}
             *   ```
             *   To create a summary on a field name 'feedback' for each cluster, An example payload could be:
             *
             *   ```
             *   "cluster_text_summary":[
             *     {"item_prefix":"Feedback","question_suffix":"Summarise the feedback in one short sentence.","field":"feedback"}
             *   ]
             *   ```
             */
            config: {
              examples?: {
                /** @description Embedded in prompt as example text that should predict label. */
                items: string[];
                /** @description Will embedded in the prompt as the expected target label of the items. */
                label: string;
              }[];
              /** @description Text field of clusters to summarize */
              field: string;
              question_prefix?: string;
              question_suffix?: string;
              item_prefix?: string;
              /**
               * @description Add 1:,2:,3:... to each item. This makes it more likely output will be numbered.
               * @default true
               */
              items_numbered?: boolean;
              /**
               * @description Cluster items provide context to the question. Limiting cluster item char length reduces cost, but may miss end of sentences with context.
               * @default 200
               */
              max_item_length?: number;
              /**
               * @description Cluster items provide context to the question. Limiting cluster item count reduces cost, but may miss items with context.
               * @default 10
               */
              max_item_count?: number;
              /**
               * @description Controls answer quality. Higher quality answers have exponentially higher cost.
               * @default 1
               */
              accuracy?: 1 | 2 | 3 | 4;
              /** @default 0.7 */
              temperature?: number;
              /**
               * @description Maximum number of words that will be generated.
               * @default 60
               */
              max_answer_length?: number;
              /**
               * @description To avoid overloading our summary API, you can increase / decrease the ms delay between questions.
               * @default 1000
               */
              delay_between_summary_generation?: number;
            };
            confidence?: number;
            retry_count?: number;
          }[];
        };
      };
    };
    CreateClusterLabelsInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      cluster_ids?: unknown[];
      /** @description Set to true to only return summaries, not save them. */
      dont_save_summaries?: boolean;
      questions: {
        cluster_ids?: unknown[];
        /**
         * @description Summarise the top results in a sentence. Fields will form a string like:
         *   ```
         *   {question_prefix}
         *   {item_prefix} 1:{field_value}
         *   {item_prefix} 2: {field_value_2}
         *   {question_suffix}}
         *   ```
         *   To create a summary on a field name 'feedback' for each cluster, An example payload could be:
         *
         *   ```
         *   "cluster_text_summary":[
         *     {"item_prefix":"Feedback","question_suffix":"Summarise the feedback in one short sentence.","field":"feedback"}
         *   ]
         *   ```
         */
        config: {
          examples?: {
            /** @description Embedded in prompt as example text that should predict label. */
            items: string[];
            /** @description Will embedded in the prompt as the expected target label of the items. */
            label: string;
          }[];
          /** @description Text field of clusters to summarize */
          field: string;
          question_prefix?: string;
          question_suffix?: string;
          item_prefix?: string;
          /**
           * @description Add 1:,2:,3:... to each item. This makes it more likely output will be numbered.
           * @default true
           */
          items_numbered?: boolean;
          /**
           * @description Cluster items provide context to the question. Limiting cluster item char length reduces cost, but may miss end of sentences with context.
           * @default 200
           */
          max_item_length?: number;
          /**
           * @description Cluster items provide context to the question. Limiting cluster item count reduces cost, but may miss items with context.
           * @default 10
           */
          max_item_count?: number;
          /**
           * @description Controls answer quality. Higher quality answers have exponentially higher cost.
           * @default 1
           */
          accuracy?: 1 | 2 | 3 | 4;
          /** @default 0.7 */
          temperature?: number;
          /**
           * @description Maximum number of words that will be generated.
           * @default 60
           */
          max_answer_length?: number;
          /**
           * @description To avoid overloading our summary API, you can increase / decrease the ms delay between questions.
           * @default 1000
           */
          delay_between_summary_generation?: number;
        };
      }[];
    };
    CreateClusterLabelsOutput: {
      results: {
        [key: string]: {
          answers: {
            answer: string;
            question: string;
            /**
             * @description Summarise the top results in a sentence. Fields will form a string like:
             *   ```
             *   {question_prefix}
             *   {item_prefix} 1:{field_value}
             *   {item_prefix} 2: {field_value_2}
             *   {question_suffix}}
             *   ```
             *   To create a summary on a field name 'feedback' for each cluster, An example payload could be:
             *
             *   ```
             *   "cluster_text_summary":[
             *     {"item_prefix":"Feedback","question_suffix":"Summarise the feedback in one short sentence.","field":"feedback"}
             *   ]
             *   ```
             */
            config: {
              examples?: {
                /** @description Embedded in prompt as example text that should predict label. */
                items: string[];
                /** @description Will embedded in the prompt as the expected target label of the items. */
                label: string;
              }[];
              /** @description Text field of clusters to summarize */
              field: string;
              question_prefix?: string;
              question_suffix?: string;
              item_prefix?: string;
              /**
               * @description Add 1:,2:,3:... to each item. This makes it more likely output will be numbered.
               * @default true
               */
              items_numbered?: boolean;
              /**
               * @description Cluster items provide context to the question. Limiting cluster item char length reduces cost, but may miss end of sentences with context.
               * @default 200
               */
              max_item_length?: number;
              /**
               * @description Cluster items provide context to the question. Limiting cluster item count reduces cost, but may miss items with context.
               * @default 10
               */
              max_item_count?: number;
              /**
               * @description Controls answer quality. Higher quality answers have exponentially higher cost.
               * @default 1
               */
              accuracy?: 1 | 2 | 3 | 4;
              /** @default 0.7 */
              temperature?: number;
              /**
               * @description Maximum number of words that will be generated.
               * @default 60
               */
              max_answer_length?: number;
              /**
               * @description To avoid overloading our summary API, you can increase / decrease the ms delay between questions.
               * @default 1000
               */
              delay_between_summary_generation?: number;
            };
            confidence?: number;
            retry_count?: number;
          }[];
        };
      };
    };
    ListClusterSummariesInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
    };
    ListClusterSummariesOutput: {
      results: {
        [key: string]: {
          answers: {
            answer: string;
            question: string;
            /**
             * @description Summarise the top results in a sentence. Fields will form a string like:
             *   ```
             *   {question_prefix}
             *   {item_prefix} 1:{field_value}
             *   {item_prefix} 2: {field_value_2}
             *   {question_suffix}}
             *   ```
             *   To create a summary on a field name 'feedback' for each cluster, An example payload could be:
             *
             *   ```
             *   "cluster_text_summary":[
             *     {"item_prefix":"Feedback","question_suffix":"Summarise the feedback in one short sentence.","field":"feedback"}
             *   ]
             *   ```
             */
            config: {
              examples?: {
                /** @description Embedded in prompt as example text that should predict label. */
                items: string[];
                /** @description Will embedded in the prompt as the expected target label of the items. */
                label: string;
              }[];
              /** @description Text field of clusters to summarize */
              field: string;
              question_prefix?: string;
              question_suffix?: string;
              item_prefix?: string;
              /**
               * @description Add 1:,2:,3:... to each item. This makes it more likely output will be numbered.
               * @default true
               */
              items_numbered?: boolean;
              /**
               * @description Cluster items provide context to the question. Limiting cluster item char length reduces cost, but may miss end of sentences with context.
               * @default 200
               */
              max_item_length?: number;
              /**
               * @description Cluster items provide context to the question. Limiting cluster item count reduces cost, but may miss items with context.
               * @default 10
               */
              max_item_count?: number;
              /**
               * @description Controls answer quality. Higher quality answers have exponentially higher cost.
               * @default 1
               */
              accuracy?: 1 | 2 | 3 | 4;
              /** @default 0.7 */
              temperature?: number;
              /**
               * @description Maximum number of words that will be generated.
               * @default 60
               */
              max_answer_length?: number;
              /**
               * @description To avoid overloading our summary API, you can increase / decrease the ms delay between questions.
               * @default 1000
               */
              delay_between_summary_generation?: number;
            };
            confidence?: number;
            retry_count?: number;
          }[];
        };
      };
    };
    CreateHierarchicalClustersInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      /** @default 10 */
      n_clusters?: number;
    };
    CreateHierarchicalClustersOutput: {
      alias: string;
    };
    DeleteClusterSummariesInput: {
      /** @description Field to cluster on */
      cluster_field?: string;
      /** @description The vector fields that these centroids are associated with. */
      vector_fields?: string[];
      centroid_vector_fields?: string[];
      /** @description Alias is used to name a cluster. */
      alias?: string;
      dataset_id?: string;
      cluster_ids: unknown[];
      /** @description Whether to optionally only delete summaries matching the question suffix. */
      question_suffix?: string;
      /** @description Whether to optionally only delete summaries matching the question prefix. */
      question_prefix?: string;
      /** @description Whether to optionally only delete summaries matching the field. */
      field?: string;
    };
    DeleteClusterSummariesOutput: unknown;
    EditOneToManyClustersInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      field: string;
      vector_field: string;
      chunk_alias: string;
      cluster_alias: string;
      clusters_to_merge?: { [key: string]: string };
      clusters_to_delete?: string[];
    };
    EditOneToManyClustersOutput: unknown;
    EditListInDocumentsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description List field to perform edits on. */
      list_field: string;
      /** @description the field within list items used to filter which list items to edit */
      match_field?: string;
      /** @description the field within list items to edit */
      update_field: string;
      updates: { [key: string]: string };
    };
    EditListInDocumentsOutput: unknown;
    CreateOrganizationInput: {
      name?: string;
    };
    CreateOrganizationOutput: {
      organization_id: string;
    };
    UpdateOrganizationInput: {
      name?: string;
    };
    UpdateOrganizationOutput: unknown;
    UpdateOrganizationAdminInput: {
      name?: string;
      entitlements?: {
        users?: {
          limit?: number;
        };
        workflows_gpu?: {
          enabled?: boolean;
        };
        negative_credits?: {
          limit?: number;
        };
        workflows_seconds_per_year?: {
          limit?: number;
        };
        documents?: {
          limit?: number;
        };
        documents_per_dataset?: {
          limit?: number;
        };
      };
      entitlement_plan?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      credits?: number;
      external_billing_id?: string;
      billing_period_start_date?: string;
    };
    UpdateOrganizationAdminOutput: unknown;
    ListOrganizationsInput: unknown;
    ListOrganizationsOutput: {
      results: {
        organization_id?: string;
        name?: string;
        entitlements?: {
          users?: {
            limit?: number;
          };
          workflows_gpu?: {
            enabled?: boolean;
          };
          negative_credits?: {
            limit?: number;
          };
          workflows_seconds_per_year?: {
            limit?: number;
          };
          documents?: {
            limit?: number;
          };
          documents_per_dataset?: {
            limit?: number;
          };
        };
        entitlement_plan?:
          | "free"
          | "basic"
          | "starter"
          | "business"
          | "enterprise"
          | "custom";
        credits?: number;
        external_billing_id?: string;
        billing_period_start_date?: string;
      }[];
    };
    DeleteOrganizationInput: unknown;
    DeleteOrganizationOutput: unknown;
    GetOrganizationInput: unknown;
    GetOrganizationOutput: {
      organization_id?: string;
      name?: string;
      entitlements?: {
        users?: {
          limit?: number;
        };
        workflows_gpu?: {
          enabled?: boolean;
        };
        negative_credits?: {
          limit?: number;
        };
        workflows_seconds_per_year?: {
          limit?: number;
        };
        documents?: {
          limit?: number;
        };
        documents_per_dataset?: {
          limit?: number;
        };
      };
      entitlement_plan?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      credits?: number;
      external_billing_id?: string;
      billing_period_start_date?: string;
    };
    GetOrganizationUsageInput: unknown;
    GetOrganizationUsageOutput: {
      usage: {
        users?: {
          limit?: number;
        };
        workflows_gpu?: {
          enabled?: boolean;
        };
        negative_credits?: {
          limit?: number;
        };
        workflows_seconds_per_year?: {
          limit?: number;
        };
        documents?: {
          limit?: number;
        };
        documents_per_dataset?: {
          limit?: number;
        };
      };
      limit: {
        users?: {
          limit?: number;
        };
        workflows_gpu?: {
          enabled?: boolean;
        };
        negative_credits?: {
          limit?: number;
        };
        workflows_seconds_per_year?: {
          limit?: number;
        };
        documents?: {
          limit?: number;
        };
        documents_per_dataset?: {
          limit?: number;
        };
      };
    };
    ListUsersInOrganizationInput: {
      /** @description Currently limited to exact_match, ids, exists, regexp filter_type */
      filters?: {
        strict?: "must" | "should" | "must_or";
        condition?: string;
        case_insensitive?: boolean;
        field?: string;
        filter_type?:
          | "text_match"
          | "word_match"
          | "term"
          | "terms"
          | "text"
          | "texts"
          | "match"
          | "contains"
          | "substring"
          | "class"
          | "category"
          | "exact_match"
          | "classes"
          | "categories"
          | "exists"
          | "traditional"
          | "fuzzy"
          | "regexp"
          | "ids"
          | "date"
          | "numeric"
          | "search"
          | "or"
          | "word_count"
          | "character_count"
          | "dedupe_by_value"
          | "match_array"
          | "random";
        condition_value?: unknown;
        fuzzy?: number;
        join?: boolean;
      }[];
    };
    ListUsersInOrganizationOutput: {
      results: {
        _id?: string;
        profile_picture_url?: string;
        onboarded?: boolean;
        first_name?: string;
        last_name?: string;
        role?: string;
        company?: string;
        label?: string;
        notes?: string;
      }[];
    };
    ListProjectsInOrganizationInput: unknown;
    ListProjectsInOrganizationOutput: {
      results: {
        _id?: string;
        project_id?: string;
        name?: string;
        description?: string;
        permissions?: { [key: string]: unknown };
        updated_at?: string;
        keys?: { [key: string]: unknown };
        /** @description If set to redis, it expects a redis connection string set using project keys under the name "redis". */
        datastore?: "redis";
      }[];
    };
    AggregateOrganizationMetricsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Aggregation query to aggregate data */
      aggregation_query?: {
        groupby?: {
          agg?:
            | "texts"
            | "categories"
            | "classes"
            | "text"
            | "category"
            | "class"
            | "terms"
            | "number"
            | "numeric"
            | "bool"
            | "wordcloud"
            | "array"
            | "boolean_filter"
            | "histogram";
          size?: number;
          field?: string;
          name?: string;
          boolean_filter?: Partial<{
            /** @description Match where document[field] is in value list. */
            match?: {
              /** @description If matching on text, match even if there are extra words / case insensitivity */
              fuzzy?: boolean;
              /** @description Field to match on. */
              field?: string;
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            matchArray?: {
              field: string;
              value: unknown[];
            };
            random?: {
              size: number;
            };
            /** @description Match where document._id is in value list. */
            matchIds?: {
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
            range?: {
              /** @description Field to match on. */
              field?: string;
              greaterThan?: unknown;
              lessThan?: unknown;
              greaterThanOrEqualTo?: unknown;
              lessThanOrEqualTo?: unknown;
            };
            /**
             * @description
             * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
             *
             * Possible matching patterns:
             *
             * * - documents where the field has any value
             * ? - documents where a single character from the field matches the provided values
             *
             * Example:
             *
             * {
             *   wildcard: {
             *      field: "title",
             *      value: [ "Avenger*" ]
             *   }
             * }
             */
            wildcard?: {
              /** @description Field to match on. */
              field?: string;
              /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
              value: unknown;
            };
            /** @description hybrid search query that must reach a certain value to filter */
            search?: {
              /**
               * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
               *
               *     "tele" matches "Television", "This television is an excellent product…"
               *
               *     Example: "tele"
               */
              query?: string;
              /** @description Configuration for traditional search query. */
              queryConfig?: {
                /**
                 * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
                 * @default 1
                 */
                weight?: number;
                /**
                 * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
                 *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
                 * @default 1
                 */
                sentenceWeight?: number;
                /**
                 * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
                 *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
                 * @default 1
                 */
                fuzzyWeight?: number;
              };
              /**
               * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
               *
               *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
               *
               *     It can be an object or a list of objects.
               *
               *
               *
               *     Example payloads:
               *
               *     {"field":"animaltype_vector_","query":"kitten"}
               *
               *     [
               *
               *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
               *
               *     ]
               */
              vectorSearchQuery?: unknown;
              realtimeClustering?: {
                /** @default 4 */
                nClusters?: number;
                /** @default kmeans-realtime-4 */
                alias?: string;
                vectorField: string;
                /** @default _cluster_.{vector_field}.{alias} */
                outputField?: string;
              };
              /**
               * @description A list of fields to search using the "query" parameter.
               *
               *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
               *
               *     Default behaviour is to search all fields.
               *
               *     Example: ["name",{"field":"favourite_color","weight":0.2}]
               */
              fieldsToSearch?: unknown[];
              /**
               * @description Only return documents with a _relevance above this threshold.
               *
               *     Example: 0.3
               */
              minimumRelevance: number;
            };
            /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
            fieldExists?: {
              /** @description Field that must exist. */
              field?: string;
            };
            /** @description Match documents where doc[field] % module == value */
            matchModulo?: {
              /** @default _id */
              field?: string;
              modulo: number;
              value: number;
            };
            /** @description Filter down to one document for each value of selected field. */
            dedupeByValue?: {
              /** @description Field to filter on. */
              field: string;
            };
            /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
            selfreference?: {
              /** @description First field in comparison. */
              a: string;
              /** @description Second field in comparison. */
              b: string;
              /** @description Operator used to compare a and b. */
              operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
            };
            /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
            wordCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum word count. */
              greaterThan?: number;
              /** @description Maximum word count. */
              lessThan?: number;
            };
            /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
            characterCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum character count. */
              greaterThan?: number;
              /** @description Maximum character count. */
              lessThan?: number;
            };
            /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
            or?: unknown[];
            /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
            not?: unknown;
            /** @description Filter based on data within a _chunk_ field. */
            chunk?: {
              /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
              path: string;
              filters: unknown[];
            };
          }> &
            Partial<{
              strict?: "must" | "should" | "must_or";
              condition?: string;
              case_insensitive?: boolean;
              field?: string;
              filter_type?:
                | "text_match"
                | "word_match"
                | "term"
                | "terms"
                | "text"
                | "texts"
                | "match"
                | "contains"
                | "substring"
                | "class"
                | "category"
                | "exact_match"
                | "classes"
                | "categories"
                | "exists"
                | "traditional"
                | "fuzzy"
                | "regexp"
                | "ids"
                | "date"
                | "numeric"
                | "search"
                | "or"
                | "word_count"
                | "character_count"
                | "dedupe_by_value"
                | "match_array"
                | "random";
              condition_value?: unknown;
              fuzzy?: number;
              join?: boolean;
            }>;
          /** @description Control the number of results for this aggregation level. This will default to the page_size provided in the root body if not provided. */
          page_size?: number;
          group_size?: number;
          select_fields?: string[];
          remove_words?: string[];
          include_words?: string[];
          /** @default monthly */
          date_interval?:
            | "monthly"
            | "daily"
            | "yearly"
            | "hourly"
            | "minutely"
            | "weekly";
          /** @description If provided, group by field into n buckets in date range. */
          n_date_buckets?: number;
          buckets?: Partial<{
            histogram?: {
              interval?: number;
              min_doc_count?: number;
            };
          }> &
            Partial<
              {
                from?: number;
                to?: number;
              }[]
            >;
        }[];
        metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        sort?: unknown[];
      };
      /**
       * @description Size of each page of results
       * @default 20
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      /** @description Whether to sort results by ascending or descending order. */
      asc?: boolean;
      dataset_ids?: string[];
      dataset_id?: string;
      /** @default monthly */
      date_interval?:
        | "monthly"
        | "daily"
        | "yearly"
        | "hourly"
        | "minutely"
        | "weekly";
    };
    AggregateOrganizationMetricsOutput: {
      results?: unknown[];
    };
    ListBillingEventsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Fields to include in the search results, empty array/list means all fields. */
      select_fields?: string[];
      /** @description Size of each page of results. */
      page_size?: number;
      /** @description Size of each page of results. */
      page?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
      /** @description Include vectors in the search results. */
      include_vector?: boolean;
      /** @description Retrieve items after these sort values in the sort order. */
      after_id?: unknown[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vector_search_query?: unknown;
    };
    ListBillingEventsOutput: {
      results?: unknown[];
    };
    CreateBillingEventAdminInput: {
      tags?: { [key: string]: unknown };
      user_tier?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      /** @default 1 */
      credits_per_unit?: number;
      cost?: number;
      pricing_unit?: string;
      /** @default 1 */
      units_processed?: number;
    };
    CreateBillingEventAdminOutput: unknown;
    GetBillingFrontendLinkInput: unknown;
    GetBillingFrontendLinkOutput: {
      link: string;
    };
    UpdateOrganizationBillingInput: {
      plan: "free" | "basic" | "starter" | "business" | "enterprise" | "custom";
    };
    UpdateOrganizationBillingOutput: unknown;
    CreateConnectorInput: {
      source_type: "Snowflake";
      source_database?: string;
      source_collection: string;
      /** @description If provided, use this field as the _id value in documents. */
      id_field?: string;
      source_settings: {
        custom?: { [key: string]: unknown };
        Snowflake?: {
          /** Authorization Method */
          credentials?: { [key: string]: unknown };
          /**
           * Account Name
           * @description The host domain of the snowflake instance (must include the account, region, cloud environment, and end with snowflakecomputing.com).
           */
          host?: string;
          /**
           * Role
           * @description The role you created for Airbyte to access Snowflake.
           */
          role?: string;
          /**
           * Warehouse
           * @description The warehouse you created for Airbyte to access data.
           */
          warehouse?: string;
          /**
           * Database
           * @description The database you created for Airbyte to access data.
           */
          database?: string;
          /** Schema */
          schema?: string;
        };
      };
      schedule?: {
        date_interval: "minutes" | "hours" | "days" | "weeks" | "months";
        units: number;
      };
      dataset_id: string;
      name?: string;
    };
    ConnectorSchema: {
      source_type: "Snowflake";
      source_database?: string;
      source_collection: string;
      /** @description If provided, use this field as the _id value in documents. */
      id_field?: string;
      source_settings: {
        custom?: { [key: string]: unknown };
        Snowflake?: {
          /** Authorization Method */
          credentials?: { [key: string]: unknown };
          /**
           * Account Name
           * @description The host domain of the snowflake instance (must include the account, region, cloud environment, and end with snowflakecomputing.com).
           */
          host?: string;
          /**
           * Role
           * @description The role you created for Airbyte to access Snowflake.
           */
          role?: string;
          /**
           * Warehouse
           * @description The warehouse you created for Airbyte to access data.
           */
          warehouse?: string;
          /**
           * Database
           * @description The database you created for Airbyte to access data.
           */
          database?: string;
          /** Schema */
          schema?: string;
        };
      };
      schedule?: {
        date_interval: "minutes" | "hours" | "days" | "weeks" | "months";
        units: number;
      };
      dataset_id: string;
      name?: string;
    };
    CreateConnectorOutput: {
      _id: string;
    };
    CheckConnectionInput: {
      source_type: "Snowflake";
      source_settings: {
        custom?: { [key: string]: unknown };
        Snowflake?: {
          /** Authorization Method */
          credentials?: { [key: string]: unknown };
          /**
           * Account Name
           * @description The host domain of the snowflake instance (must include the account, region, cloud environment, and end with snowflakecomputing.com).
           */
          host?: string;
          /**
           * Role
           * @description The role you created for Airbyte to access Snowflake.
           */
          role?: string;
          /**
           * Warehouse
           * @description The warehouse you created for Airbyte to access data.
           */
          warehouse?: string;
          /**
           * Database
           * @description The database you created for Airbyte to access data.
           */
          database?: string;
          /** Schema */
          schema?: string;
        };
      };
    };
    CheckConnectionOutput: {
      status: "succeeded" | "failed";
      message: string;
    };
    GetConnectorInput: unknown;
    GetConnectorOutput: {
      source_type: "Snowflake";
      source_database?: string;
      source_collection: string;
      /** @description If provided, use this field as the _id value in documents. */
      id_field?: string;
      source_settings: {
        custom?: { [key: string]: unknown };
        Snowflake?: {
          /** Authorization Method */
          credentials?: { [key: string]: unknown };
          /**
           * Account Name
           * @description The host domain of the snowflake instance (must include the account, region, cloud environment, and end with snowflakecomputing.com).
           */
          host?: string;
          /**
           * Role
           * @description The role you created for Airbyte to access Snowflake.
           */
          role?: string;
          /**
           * Warehouse
           * @description The warehouse you created for Airbyte to access data.
           */
          warehouse?: string;
          /**
           * Database
           * @description The database you created for Airbyte to access data.
           */
          database?: string;
          /** Schema */
          schema?: string;
        };
      };
      schedule?: {
        date_interval: "minutes" | "hours" | "days" | "weeks" | "months";
        units: number;
      };
      dataset_id: string;
      name?: string;
      _id?: string;
    };
    UpdateConnectorInput: {
      source_type: "Snowflake";
      source_database?: string;
      source_collection: string;
      /** @description If provided, use this field as the _id value in documents. */
      id_field?: string;
      source_settings: {
        custom?: { [key: string]: unknown };
        Snowflake?: {
          /** Authorization Method */
          credentials?: { [key: string]: unknown };
          /**
           * Account Name
           * @description The host domain of the snowflake instance (must include the account, region, cloud environment, and end with snowflakecomputing.com).
           */
          host?: string;
          /**
           * Role
           * @description The role you created for Airbyte to access Snowflake.
           */
          role?: string;
          /**
           * Warehouse
           * @description The warehouse you created for Airbyte to access data.
           */
          warehouse?: string;
          /**
           * Database
           * @description The database you created for Airbyte to access data.
           */
          database?: string;
          /** Schema */
          schema?: string;
        };
      };
      schedule?: {
        date_interval: "minutes" | "hours" | "days" | "weeks" | "months";
        units: number;
      };
      dataset_id: string;
      name?: string;
    };
    UpdateConnectorOutput: unknown;
    TriggerConnectorInput: unknown;
    TriggerConnectorOutput: unknown;
    DeleteConnectorInput: unknown;
    DeleteConnectorOutput: unknown;
    ListConnectorsInput: unknown;
    ListConnectorsOutput: {
      results: {
        source_type: "Snowflake";
        source_database?: string;
        source_collection: string;
        /** @description If provided, use this field as the _id value in documents. */
        id_field?: string;
        source_settings: {
          custom?: { [key: string]: unknown };
          Snowflake?: {
            /** Authorization Method */
            credentials?: { [key: string]: unknown };
            /**
             * Account Name
             * @description The host domain of the snowflake instance (must include the account, region, cloud environment, and end with snowflakecomputing.com).
             */
            host?: string;
            /**
             * Role
             * @description The role you created for Airbyte to access Snowflake.
             */
            role?: string;
            /**
             * Warehouse
             * @description The warehouse you created for Airbyte to access data.
             */
            warehouse?: string;
            /**
             * Database
             * @description The database you created for Airbyte to access data.
             */
            database?: string;
            /** Schema */
            schema?: string;
          };
        };
        schedule?: {
          date_interval: "minutes" | "hours" | "days" | "weeks" | "months";
          units: number;
        };
        dataset_id: string;
        name?: string;
        _id?: string;
      }[];
    };
    ListConnectorTypesInput: unknown;
    ListConnectorTypesOutput: {
      results: {
        image: string;
        _id: "Snowflake";
        name: string;
        tags: "Data Warehouse"[];
        description: string;
      }[];
    };
    GetConnectorTypeInput: unknown;
    GetConnectorTypeOutput: {
      image: string;
      _id: "Snowflake";
      name: string;
      tags: "Data Warehouse"[];
      description: string;
      schema: { [key: string]: unknown };
    };
    ListConnectorJobsInput: unknown;
    ListConnectorJobsOutput: {
      results: {
        status:
          | "pending"
          | "running"
          | "incomplete"
          | "failed"
          | "succeeded"
          | "cancelled";
        created_at: number;
        error_message?: string;
        _id: number;
      }[];
    };
    GetConnectorJobInput: unknown;
    GetConnectorJobOutput: {
      status:
        | "pending"
        | "running"
        | "incomplete"
        | "failed"
        | "succeeded"
        | "cancelled";
      created_at: number;
      error_message?: string;
      _id: number;
    };
    TriggerWorkflowInput: {
      /**
       * @description the workflows version to execute. It could be a tag like production or a version like v1.1.5.
       * @default production
       */
      version?: string;
      /** @description The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
      collection?: unknown;
      params: { [key: string]: unknown };
      notebook_path?: string;
      instance_type?: string;
      dataset_id: string;
      workflow_id?: string;
      /** @description Run workflow on N random documents from the dataset. */
      run_on_random_subset?: number;
      /**
       * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
       *
       * ${{params.my_param + params.my_param2 <= 5 }}
       *
       * Operators supported: ["!=","==","+","-","&&","||","false","true"]
       * Ensure that there is a space between each expression item or it will not evaluate correctly.
       */
      template?: {
        transformations: {
          [key: string]: {
            properties: {
              params: { [key: string]: unknown };
              workflow_id: string;
              dataset_id?: string;
            };
            depends_on?: string[];
            /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
            repeat?: string;
            if?: string;
          };
        };
      };
      metadata?: { [key: string]: unknown };
    };
    TriggerWorkflowOutput: {
      job_id: string;
    };
    ListWorkflowsInput: unknown;
    ListWorkflowsOutput: {
      results: ({
        creation_time?: string;
        completion_time?: string;
        notebook_path?: string;
        instance_type?: string;
        dataset_id?: string;
        params?: { [key: string]: unknown };
        _id?: string;
        workflow_id?: string;
        user_tier?:
          | "free"
          | "basic"
          | "starter"
          | "business"
          | "enterprise"
          | "custom";
        workflow_version?: string;
        workflow_efs_version?: string;
        parent_job_id?: string;
        metadata?: { [key: string]: unknown };
        output?: { [key: string]: unknown };
        /** @description Status of the workflow. Used for knowing when to send an email notification. */
        status?: "complete" | "inprogress" | "failed" | "cancelled";
        worker_status?: {
          [key: string]: {
            status?: "complete" | "inprogress" | "failed" | "cancelled";
            completion_time?: string;
            creation_time?: string;
          };
        };
        n_workers?: number;
        credits_used?: number;
        /**
         * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
         *
         * ${{params.my_param + params.my_param2 <= 5 }}
         *
         * Operators supported: ["!=","==","+","-","&&","||","false","true"]
         * Ensure that there is a space between each expression item or it will not evaluate correctly.
         */
        template?: {
          transformations: {
            [key: string]: {
              properties: {
                params: { [key: string]: unknown };
                workflow_id: string;
                dataset_id?: string;
              };
              depends_on?: string[];
              /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
              repeat?: string;
              if?: string;
            };
          };
        };
        template_history?: {
          events?: {
            name: string;
            action: "failed_to_start" | "skipped" | "started";
            version?: string;
            params?: { [key: string]: unknown };
            message?: string;
            dataset_id?: string;
          }[];
        }[];
        steps?: {
          [key: string]: {
            worker_progress?: {
              [key: string]: {
                n_processed?: number;
                n_processed_pricing?: number;
                n_total?: number;
              };
            };
            n_processed?: number;
            n_processed_pricing?: number;
            n_total?: number;
            job_id?: string;
            error_message?: string;
            skipped?: boolean;
          };
        };
        email?: {
          /** @description If specified, a secondary CTA will be added to the email. Both URL and Text are required. */
          secondary_cta?: {
            /** @description URL of the secondary CTA button. */
            url?: string;
            /** @description Text of the secondary CTA button. */
            text?: string;
          };
        };
        marker_seen?: boolean;
      } & { [key: string]: unknown })[];
    };
    GetWorkflowStatusInput: unknown;
    GetWorkflowStatusOutput: {
      creation_time?: string;
      completion_time?: string;
      notebook_path?: string;
      instance_type?: string;
      dataset_id?: string;
      params?: { [key: string]: unknown };
      _id?: string;
      workflow_id?: string;
      user_tier?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      workflow_version?: string;
      workflow_efs_version?: string;
      parent_job_id?: string;
      metadata?: { [key: string]: unknown };
      output?: { [key: string]: unknown };
      /** @description Status of the workflow. Used for knowing when to send an email notification. */
      status?: "complete" | "inprogress" | "failed" | "cancelled";
      worker_status?: {
        [key: string]: {
          status?: "complete" | "inprogress" | "failed" | "cancelled";
          completion_time?: string;
          creation_time?: string;
        };
      };
      n_workers?: number;
      credits_used?: number;
      /**
       * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
       *
       * ${{params.my_param + params.my_param2 <= 5 }}
       *
       * Operators supported: ["!=","==","+","-","&&","||","false","true"]
       * Ensure that there is a space between each expression item or it will not evaluate correctly.
       */
      template?: {
        transformations: {
          [key: string]: {
            properties: {
              params: { [key: string]: unknown };
              workflow_id: string;
              dataset_id?: string;
            };
            depends_on?: string[];
            /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
            repeat?: string;
            if?: string;
          };
        };
      };
      template_history?: {
        events?: {
          name: string;
          action: "failed_to_start" | "skipped" | "started";
          version?: string;
          params?: { [key: string]: unknown };
          message?: string;
          dataset_id?: string;
        }[];
      }[];
      steps?: {
        [key: string]: {
          worker_progress?: {
            [key: string]: {
              n_processed?: number;
              n_processed_pricing?: number;
              n_total?: number;
            };
          };
          n_processed?: number;
          n_processed_pricing?: number;
          n_total?: number;
          job_id?: string;
          error_message?: string;
          skipped?: boolean;
        };
      };
      email?: {
        /** @description If specified, a secondary CTA will be added to the email. Both URL and Text are required. */
        secondary_cta?: {
          /** @description URL of the secondary CTA button. */
          url?: string;
          /** @description Text of the secondary CTA button. */
          text?: string;
        };
      };
      marker_seen?: boolean;
    } & { [key: string]: unknown };
    GetWorkflowConfigInput: unknown;
    GetWorkflowConfigOutput: {
      creation_time?: string;
      completion_time?: string;
      notebook_path?: string;
      instance_type?: string;
      dataset_id?: string;
      params?: { [key: string]: unknown };
      _id?: string;
      workflow_id?: string;
      user_tier?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      workflow_version?: string;
      workflow_efs_version?: string;
      parent_job_id?: string;
      metadata?: { [key: string]: unknown };
      output?: { [key: string]: unknown };
      /** @description Status of the workflow. Used for knowing when to send an email notification. */
      status?: "complete" | "inprogress" | "failed" | "cancelled";
      worker_status?: {
        [key: string]: {
          status?: "complete" | "inprogress" | "failed" | "cancelled";
          completion_time?: string;
          creation_time?: string;
        };
      };
      n_workers?: number;
      credits_used?: number;
      /**
       * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
       *
       * ${{params.my_param + params.my_param2 <= 5 }}
       *
       * Operators supported: ["!=","==","+","-","&&","||","false","true"]
       * Ensure that there is a space between each expression item or it will not evaluate correctly.
       */
      template?: {
        transformations: {
          [key: string]: {
            properties: {
              params: { [key: string]: unknown };
              workflow_id: string;
              dataset_id?: string;
            };
            depends_on?: string[];
            /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
            repeat?: string;
            if?: string;
          };
        };
      };
      template_history?: {
        events?: {
          name: string;
          action: "failed_to_start" | "skipped" | "started";
          version?: string;
          params?: { [key: string]: unknown };
          message?: string;
          dataset_id?: string;
        }[];
      }[];
      steps?: {
        [key: string]: {
          worker_progress?: {
            [key: string]: {
              n_processed?: number;
              n_processed_pricing?: number;
              n_total?: number;
            };
          };
          n_processed?: number;
          n_processed_pricing?: number;
          n_total?: number;
          job_id?: string;
          error_message?: string;
          skipped?: boolean;
        };
      };
      email?: {
        /** @description If specified, a secondary CTA will be added to the email. Both URL and Text are required. */
        secondary_cta?: {
          /** @description URL of the secondary CTA button. */
          url?: string;
          /** @description Text of the secondary CTA button. */
          text?: string;
        };
      };
      marker_seen?: boolean;
    } & { [key: string]: unknown };
    DeleteWorkflowStatusInput: unknown;
    DeleteWorkflowStatusOutput: unknown;
    TerminateWorkflowInput: unknown;
    TerminateWorkflowOutput: unknown;
    UpsertWorkflowMetadataInput: {
      /** @description Edit and add metadata for the workflow. */
      metadata: { [key: string]: unknown };
    };
    UpsertWorkflowMetadataOutput: unknown;
    UpsertWorkflowProgressInput: {
      worker_number: number;
      step: string;
      n_processed?: number;
      n_processed_pricing?: number;
      n_total?: number;
    };
    UpsertWorkflowProgressOutput: unknown;
    UpsertWorkflowStatusInput: {
      /** @description Metadata of the workflow. Can be an object including any information you want to store. */
      metadata?: { [key: string]: unknown };
      /** @description Status of the workflow. Used for knowing when to send an email notification. */
      status: "complete" | "inprogress" | "failed" | "cancelled";
      /** @description Workflow name that is passed into the email. */
      workflow_name?: string;
      /** @description Additional information of the workflow that is passed into the email. */
      additional_information?: string;
      email?: {
        /** @description If specified, a secondary CTA will be added to the email. Both URL and Text are required. */
        secondary_cta?: {
          /** @description URL of the secondary CTA button. */
          url?: string;
          /** @description Text of the secondary CTA button. */
          text?: string;
        };
      };
      /**
       * @description Whether to send an email on workflow completion.
       * @default true
       */
      send_email?: boolean;
      worker_number?: number;
      output?: { [key: string]: unknown };
      marker_seen?: boolean;
    };
    UpsertWorkflowStatusOutput: {
      creation_time?: string;
      completion_time?: string;
      notebook_path?: string;
      instance_type?: string;
      dataset_id?: string;
      params?: { [key: string]: unknown };
      _id?: string;
      workflow_id?: string;
      user_tier?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      workflow_version?: string;
      workflow_efs_version?: string;
      parent_job_id?: string;
      metadata?: { [key: string]: unknown };
      output?: { [key: string]: unknown };
      /** @description Status of the workflow. Used for knowing when to send an email notification. */
      status?: "complete" | "inprogress" | "failed" | "cancelled";
      worker_status?: {
        [key: string]: {
          status?: "complete" | "inprogress" | "failed" | "cancelled";
          completion_time?: string;
          creation_time?: string;
        };
      };
      n_workers?: number;
      credits_used?: number;
      /**
       * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
       *
       * ${{params.my_param + params.my_param2 <= 5 }}
       *
       * Operators supported: ["!=","==","+","-","&&","||","false","true"]
       * Ensure that there is a space between each expression item or it will not evaluate correctly.
       */
      template?: {
        transformations: {
          [key: string]: {
            properties: {
              params: { [key: string]: unknown };
              workflow_id: string;
              dataset_id?: string;
            };
            depends_on?: string[];
            /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
            repeat?: string;
            if?: string;
          };
        };
      };
      template_history?: {
        events?: {
          name: string;
          action: "failed_to_start" | "skipped" | "started";
          version?: string;
          params?: { [key: string]: unknown };
          message?: string;
          dataset_id?: string;
        }[];
      }[];
      steps?: {
        [key: string]: {
          worker_progress?: {
            [key: string]: {
              n_processed?: number;
              n_processed_pricing?: number;
              n_total?: number;
            };
          };
          n_processed?: number;
          n_processed_pricing?: number;
          n_total?: number;
          job_id?: string;
          error_message?: string;
          skipped?: boolean;
        };
      };
      email?: {
        /** @description If specified, a secondary CTA will be added to the email. Both URL and Text are required. */
        secondary_cta?: {
          /** @description URL of the secondary CTA button. */
          url?: string;
          /** @description Text of the secondary CTA button. */
          text?: string;
        };
      };
      marker_seen?: boolean;
    } & { [key: string]: unknown };
    ListWorkflowTypesInput: unknown;
    ListWorkflowTypesOutput: {
      results: {
        /**
         * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
         *
         * ${{params.my_param + params.my_param2 <= 5 }}
         *
         * Operators supported: ["!=","==","+","-","&&","||","false","true"]
         * Ensure that there is a space between each expression item or it will not evaluate correctly.
         */
        template_raw_?: {
          transformations: {
            [key: string]: {
              properties: {
                params: { [key: string]: unknown };
                workflow_id: string;
                dataset_id?: string;
              };
              depends_on?: string[];
              /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
              repeat?: string;
              if?: string;
            };
          };
        };
        components_raw_?: {
          description?: string;
          optional?: boolean;
          default_value?: unknown;
          title?: string;
          valueKey?: string;
          type?: string;
          props?: {
            excludeTypes?: string[];
            multiple?: boolean;
            onlyTypes?: string[];
          };
        }[];
        workflow_id: string;
        hidden?: boolean;
        sdk_link?: unknown;
        docker_hash?: unknown;
        why_run?: string;
        efs_version?: string;
        documentation_links?: {
          link?: string;
          title?: string;
        }[];
        powered_by?: string;
        icon?: unknown;
        description?: string;
        documentation_link?: string;
        submit_on_colab?: boolean;
        pricing_tier?:
          | "free"
          | "basic"
          | "starter"
          | "business"
          | "enterprise"
          | "custom";
        submit_on_cloud?: boolean;
        categories?: {
          use_case?: string[];
          data_type?: string[];
          industry?: string[];
        };
        data_format?: string;
        runtime_per_document_seconds?: unknown;
        in_development?: unknown;
        popular?: unknown;
        requirements?: string[];
        new_workflow_path?: string;
        requirements_hash?: string;
        suggested_workflows?: string[];
        insert_date_?: string;
        workflow_path?: string;
        abstract?: string;
        gpu?: boolean;
        version?: string;
        base_image?: unknown;
        memory_gb?: number;
        examples?: string[];
        status_badges?: string[];
        vcpu_num?: number;
        name?: string;
        parameters_raw_?: { [key: string]: unknown };
        colab_path?: unknown;
        instance_type?: string;
        hardcoded?: boolean;
        internal_use_only?: boolean;
        _id?: string;
      }[];
    };
    /**
     * @description Control which fields aggregate data will be generated for. Aggregate data will appear in the "aggregates" property of the response body.
     *
     *     Each list element can be a string like "name" or a dictionary like {"field":"name","resultsSize":11}
     *
     *     Default: []
     *
     *     Example: ["name","price","likes_cats",{"field":"color","resultsSize":20}]
     */
    fieldsToAggregate: unknown[];
    /**
     * @description Control which fields aggregate stats data will be generated for. This includes, min value, max value, average value, and document counts per interval within the dataset.
     *
     *     Aggregate data will appear in the "aggregateStats" property of the response body.
     *
     *     Each list item can be:
     *
     *      a string stating which field to aggregate stats on
     *
     *     An object containing "field" to pick a field, and "interval" to control the range of each bucket when counting documents:
     *
     *     For example, if we had products {"price":50},{"price:"150"},{price:"180"},{"field":"price","interval":100}  would split results into 2 buckets.
     *
     *     Default: []
     *     Example: ["postcode",{"field":"price","interval":10}]
     */
    fieldsToAggregateStats: unknown[];
    simpleSearchFilterItem: {
      /** @description Match where document[field] is in value list. */
      match?: {
        /** @description If matching on text, match even if there are extra words / case insensitivity */
        fuzzy?: boolean;
        /** @description Field to match on. */
        field?: string;
        /** @description Can be either a single item or a list of items to match on. */
        value: unknown;
      };
      matchArray?: {
        field: string;
        value: unknown[];
      };
      random?: {
        size: number;
      };
      /** @description Match where document._id is in value list. */
      matchIds?: {
        /** @description Can be either a single item or a list of items to match on. */
        value: unknown;
      };
      /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
      range?: {
        /** @description Field to match on. */
        field?: string;
        greaterThan?: unknown;
        lessThan?: unknown;
        greaterThanOrEqualTo?: unknown;
        lessThanOrEqualTo?: unknown;
      };
      /**
       * @description
       * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
       *
       * Possible matching patterns:
       *
       * * - documents where the field has any value
       * ? - documents where a single character from the field matches the provided values
       *
       * Example:
       *
       * {
       *   wildcard: {
       *      field: "title",
       *      value: [ "Avenger*" ]
       *   }
       * }
       */
      wildcard?: {
        /** @description Field to match on. */
        field?: string;
        /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
        value: unknown;
      };
      /** @description hybrid search query that must reach a certain value to filter */
      search?: {
        /**
         * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
         *
         *     "tele" matches "Television", "This television is an excellent product…"
         *
         *     Example: "tele"
         */
        query?: string;
        /** @description Configuration for traditional search query. */
        queryConfig?: {
          /**
           * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
           * @default 1
           */
          weight?: number;
          /**
           * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
           *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
           * @default 1
           */
          sentenceWeight?: number;
          /**
           * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
           *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
           * @default 1
           */
          fuzzyWeight?: number;
        };
        /**
         * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
         *
         *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
         *
         *     It can be an object or a list of objects.
         *
         *
         *
         *     Example payloads:
         *
         *     {"field":"animaltype_vector_","query":"kitten"}
         *
         *     [
         *
         *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
         *
         *     ]
         */
        vectorSearchQuery?: unknown;
        realtimeClustering?: {
          /** @default 4 */
          nClusters?: number;
          /** @default kmeans-realtime-4 */
          alias?: string;
          vectorField: string;
          /** @default _cluster_.{vector_field}.{alias} */
          outputField?: string;
        };
        /**
         * @description A list of fields to search using the "query" parameter.
         *
         *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
         *
         *     Default behaviour is to search all fields.
         *
         *     Example: ["name",{"field":"favourite_color","weight":0.2}]
         */
        fieldsToSearch?: unknown[];
        /**
         * @description Only return documents with a _relevance above this threshold.
         *
         *     Example: 0.3
         */
        minimumRelevance: number;
      };
      /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
      fieldExists?: {
        /** @description Field that must exist. */
        field?: string;
      };
      /** @description Match documents where doc[field] % module == value */
      matchModulo?: {
        /** @default _id */
        field?: string;
        modulo: number;
        value: number;
      };
      /** @description Filter down to one document for each value of selected field. */
      dedupeByValue?: {
        /** @description Field to filter on. */
        field: string;
      };
      /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
      selfreference?: {
        /** @description First field in comparison. */
        a: string;
        /** @description Second field in comparison. */
        b: string;
        /** @description Operator used to compare a and b. */
        operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
      };
      /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
      wordCount?: {
        /** @description Field to match on. */
        field: string;
        /** @description Minimum word count. */
        greaterThan?: number;
        /** @description Maximum word count. */
        lessThan?: number;
      };
      /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
      characterCount?: {
        /** @description Field to match on. */
        field: string;
        /** @description Minimum character count. */
        greaterThan?: number;
        /** @description Maximum character count. */
        lessThan?: number;
      };
      /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
      or?: unknown[];
      /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
      not?: unknown;
      /** @description Filter based on data within a _chunk_ field. */
      chunk?: {
        /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
        path: string;
        filters: unknown[];
      };
    };
    flatFilterItem: {
      strict?: "must" | "should" | "must_or";
      condition?: string;
      case_insensitive?: boolean;
      field?: string;
      filter_type?:
        | "text_match"
        | "word_match"
        | "term"
        | "terms"
        | "text"
        | "texts"
        | "match"
        | "contains"
        | "substring"
        | "class"
        | "category"
        | "exact_match"
        | "classes"
        | "categories"
        | "exists"
        | "traditional"
        | "fuzzy"
        | "regexp"
        | "ids"
        | "date"
        | "numeric"
        | "search"
        | "or"
        | "word_count"
        | "character_count"
        | "dedupe_by_value"
        | "match_array"
        | "random";
      condition_value?: unknown;
      fuzzy?: number;
      join?: boolean;
    };
    relevanceBoosterItem: {
      strict?: "must" | "should" | "must_or";
      condition?: string;
      case_insensitive?: boolean;
      field?: string;
      filter_type?:
        | "text_match"
        | "word_match"
        | "term"
        | "terms"
        | "text"
        | "texts"
        | "match"
        | "contains"
        | "substring"
        | "class"
        | "category"
        | "exact_match"
        | "classes"
        | "categories"
        | "exists"
        | "traditional"
        | "fuzzy"
        | "regexp"
        | "ids"
        | "date"
        | "numeric"
        | "search"
        | "or"
        | "word_count"
        | "character_count"
        | "dedupe_by_value"
        | "match_array"
        | "random";
      condition_value?: unknown;
      fuzzy?: number;
      join?: boolean;
      /**
       * @description Multiplies the relevance contribution of this condition.
       * @default 1
       */
      weight?: number;
    };
    SearchWorkflowTypesInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /** @description Configuration for traditional search query. */
      queryConfig?: {
        /**
         * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
         * @default 1
         */
        weight?: number;
        /**
         * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
         *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
         * @default 1
         */
        sentenceWeight?: number;
        /**
         * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
         *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
         * @default 1
         */
        fuzzyWeight?: number;
      };
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vectorSearchQuery?: unknown;
      realtimeClustering?: {
        /** @default 4 */
        nClusters?: number;
        /** @default kmeans-realtime-4 */
        alias?: string;
        vectorField: string;
        /** @default _cluster_.{vector_field}.{alias} */
        outputField?: string;
      };
      /**
       * @description A list of fields to search using the "query" parameter.
       *
       *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
       *
       *     Default behaviour is to search all fields.
       *
       *     Example: ["name",{"field":"favourite_color","weight":0.2}]
       */
      fieldsToSearch?: unknown[];
      /**
       * @description Only return documents with a _relevance above this threshold.
       *
       *     Example: 0.3
       */
      minimumRelevance?: number;
      instantAnswerQuery?: {
        preset?: "support" | "support2" | "support3";
        query: string;
        field: string;
        urlField?: string;
        titleField?: string;
        temperature?: number;
        /**
         * @description Maximum number of words that will be generated.
         * @default 100
         */
        maxAnswerLength?: number;
      };
      /**
       * @description Page of results to return.
       *     Returns results from position page*pageSize to (page+1)*pageSize
       *
       *     Default: 0
       *
       *     Example: 3
       */
      page?: number;
      /**
       * @description Page size of results to return.
       *     Returns results from position page*pageSize to (page+1)*pageSize
       *
       *     Default: 10
       *
       *     Example: 25
       */
      pageSize?: number;
      /**
       * @description Add _relevance field to each document containing the documents relevance based on the search criteria.
       *
       *     Example: true
       * @default true
       */
      includeRelevance?: boolean;
      /**
       * @description Add _dataset field to each document containing the documents parent dataset. Useful when searching multiple datasets at once.
       *
       *     Example: false
       */
      includeDataset?: boolean;
      /**
       * @description Use the datasets schema to remove parameters that are unsafe before making a request.
       *
       *     For example, fieldsToAggregateStats only supports numeric fields. if this flag is set, all non numeric fields will be removed from fieldsToAggregateStats.
       *
       *     Example: true
       */
      cleanPayloadUsingSchema?: boolean;
      /**
       * @description Prioritise results based on integer, float and boolean fields values. Can sort ascending or descending.
       *
       *     Example 1: {"on_sale":"desc"}
       *
       *     Example 2: {"price":"asc"}
       */
      sort?: { [key: string]: "asc" | "desc" };
      /**
       * @description Only return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector_"]
       */
      includeFields?: string[];
      /**
       * @description Don't return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector"]
       */
      excludeFields?: string[];
      /**
       * @description Set to true to return all vector fields. includeFields / excludeFields has priority over this rule.
       *
       *     Example: true / false
       */
      includeVectors?: boolean;
      /**
       * @description Prioritise results based on integer, float and boolean fields values. Can sort ascending or descending.
       *
       *     Example 1: {"on_sale":"desc"}
       *
       *     Example 2: {"price":"asc"}
       */
      textSort?: { [key: string]: "asc" | "desc" };
      fieldsToAggregate?: unknown;
      fieldsToAggregateStats?: unknown;
      /** @description Add relevance to documents if they match conditions in this list. configure 'weight' on each condition to modify the relevance contribution. */
      relevanceBoosters?: unknown[];
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      afterId?: unknown[];
      /**
       * @description the workflows version to execute. It could be a tag like production or a version like v1.1.5.
       * @default production
       */
      version?: string;
      /** @description The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
      collection?: unknown;
      show_hidden?: boolean;
    };
    /** @description Aggregate output. Recursive aggregate output is returned here. */
    outputAggregations: {
      [key: string]: {
        /** @description Most common field values and their counts. */
        results: { [key: string]: number };
        aggregates: { [key: string]: unknown };
        aggregateStats?: {
          /** @description Maximum value of field. */
          max: number;
          /** @description Minimum value of field. */
          min: number;
          /** @description Average value of field. */
          avg: number;
          /** @description Sum of all field values. */
          sum: number;
        };
        dateAggregate?: {
          value: number;
          frequency: number;
        }[];
        /** @description Documents retrieved by the 'getDocuments' parameter. */
        documents?: unknown[];
      };
    };
    /**
     * @description Dictionary of field stats.
     *
     *     Fields to summarise is specified in "fieldsToAggregateStats" of request body.
     *
     *     Example: {"price":{"min":0.5,"max":2000,"avg":100,sum:"40230032","results":{"0":202,"100":43,"200":16}}}
     */
    aggregateStats: {
      [key: string]: {
        /** @description Maximum value of field. */
        max: number;
        /** @description Minimum value of field. */
        min: number;
        /** @description Average value of field. */
        avg: number;
        /** @description Sum of all field values. */
        sum: number;
      };
    };
    SearchWorkflowTypesOutput: {
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      results: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
      instantAnswerResults?: {
        answer?: string;
        status?: string;
        message?: string;
        question?: string;
        resultsIndex?: number;
      };
      /**
       * @description Total number of documents matched in the dataset.
       *
       *     Example: 100
       */
      resultsSize: number;
      aggregates: unknown;
      aggregateStats: unknown;
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      afterId: unknown[];
    } & {
      aggregations: unknown;
    };
    GetWorkflowTypesAsOpenAPIInput: unknown;
    GetWorkflowTypesAsOpenAPIOutput: unknown;
    AggregateWorkflowTypesInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Aggregation query to aggregate data */
      aggregation_query?: {
        groupby?: {
          agg?:
            | "texts"
            | "categories"
            | "classes"
            | "text"
            | "category"
            | "class"
            | "terms"
            | "number"
            | "numeric"
            | "bool"
            | "wordcloud"
            | "array"
            | "boolean_filter"
            | "histogram";
          size?: number;
          field?: string;
          name?: string;
          boolean_filter?: Partial<{
            /** @description Match where document[field] is in value list. */
            match?: {
              /** @description If matching on text, match even if there are extra words / case insensitivity */
              fuzzy?: boolean;
              /** @description Field to match on. */
              field?: string;
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            matchArray?: {
              field: string;
              value: unknown[];
            };
            random?: {
              size: number;
            };
            /** @description Match where document._id is in value list. */
            matchIds?: {
              /** @description Can be either a single item or a list of items to match on. */
              value: unknown;
            };
            /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
            range?: {
              /** @description Field to match on. */
              field?: string;
              greaterThan?: unknown;
              lessThan?: unknown;
              greaterThanOrEqualTo?: unknown;
              lessThanOrEqualTo?: unknown;
            };
            /**
             * @description
             * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
             *
             * Possible matching patterns:
             *
             * * - documents where the field has any value
             * ? - documents where a single character from the field matches the provided values
             *
             * Example:
             *
             * {
             *   wildcard: {
             *      field: "title",
             *      value: [ "Avenger*" ]
             *   }
             * }
             */
            wildcard?: {
              /** @description Field to match on. */
              field?: string;
              /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
              value: unknown;
            };
            /** @description hybrid search query that must reach a certain value to filter */
            search?: {
              /**
               * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
               *
               *     "tele" matches "Television", "This television is an excellent product…"
               *
               *     Example: "tele"
               */
              query?: string;
              /** @description Configuration for traditional search query. */
              queryConfig?: {
                /**
                 * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
                 * @default 1
                 */
                weight?: number;
                /**
                 * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
                 *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
                 * @default 1
                 */
                sentenceWeight?: number;
                /**
                 * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
                 *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
                 * @default 1
                 */
                fuzzyWeight?: number;
              };
              /**
               * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
               *
               *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
               *
               *     It can be an object or a list of objects.
               *
               *
               *
               *     Example payloads:
               *
               *     {"field":"animaltype_vector_","query":"kitten"}
               *
               *     [
               *
               *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
               *
               *     ]
               */
              vectorSearchQuery?: unknown;
              realtimeClustering?: {
                /** @default 4 */
                nClusters?: number;
                /** @default kmeans-realtime-4 */
                alias?: string;
                vectorField: string;
                /** @default _cluster_.{vector_field}.{alias} */
                outputField?: string;
              };
              /**
               * @description A list of fields to search using the "query" parameter.
               *
               *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
               *
               *     Default behaviour is to search all fields.
               *
               *     Example: ["name",{"field":"favourite_color","weight":0.2}]
               */
              fieldsToSearch?: unknown[];
              /**
               * @description Only return documents with a _relevance above this threshold.
               *
               *     Example: 0.3
               */
              minimumRelevance: number;
            };
            /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
            fieldExists?: {
              /** @description Field that must exist. */
              field?: string;
            };
            /** @description Match documents where doc[field] % module == value */
            matchModulo?: {
              /** @default _id */
              field?: string;
              modulo: number;
              value: number;
            };
            /** @description Filter down to one document for each value of selected field. */
            dedupeByValue?: {
              /** @description Field to filter on. */
              field: string;
            };
            /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
            selfreference?: {
              /** @description First field in comparison. */
              a: string;
              /** @description Second field in comparison. */
              b: string;
              /** @description Operator used to compare a and b. */
              operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
            };
            /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
            wordCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum word count. */
              greaterThan?: number;
              /** @description Maximum word count. */
              lessThan?: number;
            };
            /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
            characterCount?: {
              /** @description Field to match on. */
              field: string;
              /** @description Minimum character count. */
              greaterThan?: number;
              /** @description Maximum character count. */
              lessThan?: number;
            };
            /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
            or?: unknown[];
            /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
            not?: unknown;
            /** @description Filter based on data within a _chunk_ field. */
            chunk?: {
              /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
              path: string;
              filters: unknown[];
            };
          }> &
            Partial<{
              strict?: "must" | "should" | "must_or";
              condition?: string;
              case_insensitive?: boolean;
              field?: string;
              filter_type?:
                | "text_match"
                | "word_match"
                | "term"
                | "terms"
                | "text"
                | "texts"
                | "match"
                | "contains"
                | "substring"
                | "class"
                | "category"
                | "exact_match"
                | "classes"
                | "categories"
                | "exists"
                | "traditional"
                | "fuzzy"
                | "regexp"
                | "ids"
                | "date"
                | "numeric"
                | "search"
                | "or"
                | "word_count"
                | "character_count"
                | "dedupe_by_value"
                | "match_array"
                | "random";
              condition_value?: unknown;
              fuzzy?: number;
              join?: boolean;
            }>;
          /** @description Control the number of results for this aggregation level. This will default to the page_size provided in the root body if not provided. */
          page_size?: number;
          group_size?: number;
          select_fields?: string[];
          remove_words?: string[];
          include_words?: string[];
          /** @default monthly */
          date_interval?:
            | "monthly"
            | "daily"
            | "yearly"
            | "hourly"
            | "minutely"
            | "weekly";
          /** @description If provided, group by field into n buckets in date range. */
          n_date_buckets?: number;
          buckets?: Partial<{
            histogram?: {
              interval?: number;
              min_doc_count?: number;
            };
          }> &
            Partial<
              {
                from?: number;
                to?: number;
              }[]
            >;
        }[];
        metrics?: {
          field?: string;
          fields?: string[];
          agg?:
            | "avg"
            | "average"
            | "cardinality"
            | "max"
            | "mean"
            | "min"
            | "sum"
            | "percentiles"
            | "sum_of_squares"
            | "variance"
            | "std_deviation"
            | "std_deviation_bounds"
            | "kurtosis"
            | "covariance"
            | "skewness"
            | "character_count"
            | "count"
            | "correlation"
            | "missing";
          name?: string;
        }[];
        sort?: unknown[];
      };
      /**
       * @description Size of each page of results
       * @default 20
       */
      page_size?: number;
      /**
       * @description Page of the results
       * @default 1
       */
      page?: number;
      /** @description Whether to sort results by ascending or descending order. */
      asc?: boolean;
      dataset_ids?: string[];
      dataset_id?: string;
      /**
       * @description the workflows version to execute. It could be a tag like production or a version like v1.1.5.
       * @default production
       */
      version?: string;
      /** @description The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
      collection?: unknown;
    };
    AggregateWorkflowTypesOutput: {
      results?: unknown[];
    };
    BulkUpdateWorkflowTypesAdminInput: {
      updates: {
        /**
         * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
         *
         * ${{params.my_param + params.my_param2 <= 5 }}
         *
         * Operators supported: ["!=","==","+","-","&&","||","false","true"]
         * Ensure that there is a space between each expression item or it will not evaluate correctly.
         */
        template_raw_?: {
          transformations: {
            [key: string]: {
              properties: {
                params: { [key: string]: unknown };
                workflow_id: string;
                dataset_id?: string;
              };
              depends_on?: string[];
              /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
              repeat?: string;
              if?: string;
            };
          };
        };
        components_raw_?: {
          description?: string;
          optional?: boolean;
          default_value?: unknown;
          title?: string;
          valueKey?: string;
          type?: string;
          props?: {
            excludeTypes?: string[];
            multiple?: boolean;
            onlyTypes?: string[];
          };
        }[];
        workflow_id: string;
        hidden?: boolean;
        sdk_link?: unknown;
        docker_hash?: unknown;
        why_run?: string;
        efs_version?: string;
        documentation_links?: {
          link?: string;
          title?: string;
        }[];
        powered_by?: string;
        icon?: unknown;
        description?: string;
        documentation_link?: string;
        submit_on_colab?: boolean;
        pricing_tier?:
          | "free"
          | "basic"
          | "starter"
          | "business"
          | "enterprise"
          | "custom";
        submit_on_cloud?: boolean;
        categories?: {
          use_case?: string[];
          data_type?: string[];
          industry?: string[];
        };
        data_format?: string;
        runtime_per_document_seconds?: unknown;
        in_development?: unknown;
        popular?: unknown;
        requirements?: string[];
        new_workflow_path?: string;
        requirements_hash?: string;
        suggested_workflows?: string[];
        insert_date_?: string;
        workflow_path?: string;
        abstract?: string;
        gpu?: boolean;
        version?: string;
        base_image?: unknown;
        memory_gb?: number;
        examples?: string[];
        status_badges?: string[];
        vcpu_num?: number;
        name?: string;
        parameters_raw_?: { [key: string]: unknown };
        colab_path?: unknown;
        instance_type?: string;
        hardcoded?: boolean;
        internal_use_only?: boolean;
        _id?: string;
      }[];
      /**
       * @description the workflows version to execute. It could be a tag like production or a version like v1.1.5.
       * @default production
       */
      version: string;
      /** @description The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
      collection?: unknown;
    };
    BulkUpdateWorkflowTypesAdminOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    UpdateWorkflowTypesVersionAliasesAdminInput: {
      aliases: { [key: string]: unknown };
    };
    UpdateWorkflowTypesVersionAliasesAdminOutput: unknown;
    GetWorkflowTypesVersionAliasesInput: unknown;
    GetWorkflowTypesVersionAliasesOutput: {
      aliases: { [key: string]: unknown };
    };
    GetWorkflowTypeInput: unknown;
    GetWorkflowTypeOutput: {
      /**
       * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
       *
       * ${{params.my_param + params.my_param2 <= 5 }}
       *
       * Operators supported: ["!=","==","+","-","&&","||","false","true"]
       * Ensure that there is a space between each expression item or it will not evaluate correctly.
       */
      template_raw_?: {
        transformations: {
          [key: string]: {
            properties: {
              params: { [key: string]: unknown };
              workflow_id: string;
              dataset_id?: string;
            };
            depends_on?: string[];
            /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
            repeat?: string;
            if?: string;
          };
        };
      };
      components_raw_?: {
        description?: string;
        optional?: boolean;
        default_value?: unknown;
        title?: string;
        valueKey?: string;
        type?: string;
        props?: {
          excludeTypes?: string[];
          multiple?: boolean;
          onlyTypes?: string[];
        };
      }[];
      workflow_id: string;
      hidden?: boolean;
      sdk_link?: unknown;
      docker_hash?: unknown;
      why_run?: string;
      efs_version?: string;
      documentation_links?: {
        link?: string;
        title?: string;
      }[];
      powered_by?: string;
      icon?: unknown;
      description?: string;
      documentation_link?: string;
      submit_on_colab?: boolean;
      pricing_tier?:
        | "free"
        | "basic"
        | "starter"
        | "business"
        | "enterprise"
        | "custom";
      submit_on_cloud?: boolean;
      categories?: {
        use_case?: string[];
        data_type?: string[];
        industry?: string[];
      };
      data_format?: string;
      runtime_per_document_seconds?: unknown;
      in_development?: unknown;
      popular?: unknown;
      requirements?: string[];
      new_workflow_path?: string;
      requirements_hash?: string;
      suggested_workflows?: string[];
      insert_date_?: string;
      workflow_path?: string;
      abstract?: string;
      gpu?: boolean;
      version?: string;
      base_image?: unknown;
      memory_gb?: number;
      examples?: string[];
      status_badges?: string[];
      vcpu_num?: number;
      name?: string;
      parameters_raw_?: { [key: string]: unknown };
      colab_path?: unknown;
      instance_type?: string;
      hardcoded?: boolean;
      internal_use_only?: boolean;
      _id?: string;
    };
    ValidateWorkflowParamsInput: {
      /**
       * @description the workflows version to execute. It could be a tag like production or a version like v1.1.5.
       * @default production
       */
      version?: string;
      /** @description The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
      collection?: unknown;
      parameters: { [key: string]: unknown };
    };
    ValidateWorkflowParamsOutput: {
      status: string;
      message: string;
    };
    InsertInput: {
      /** @description Each document to upsert must have an _id field matching an existing document. */
      document?: {
        _id?: unknown;
      } & { [key: string]: unknown };
      /** @description Return immediately after storing data in a spot where it can be ingested in the background. Best for large datasets. */
      ingest_in_background?: boolean;
      /**
       * @description Whether to include insert date as a field 'insert_date_'.
       * @default true
       */
      insert_date?: boolean;
      /** @description Whether to include update date as a field 'update_date_'. Updates field if present already. */
      update_date_?: boolean;
      /**
       * @description Whether to transform fields containing dates to a valid Relevance date format.
       * @default true
       */
      transform_date_format?: boolean;
      /**
       * @description Whether to remove fields with the value 'N/A' from documents. Required to process pandas style CSVs.
       * @default true
       */
      remove_na?: boolean;
      /**
       * @description Whether to overwrite document if it exists.
       * @default true
       */
      overwrite?: boolean;
      /**
       * @description Whether the api should check the documents for vector datatype to update the schema.
       * @default true
       */
      update_schema?: boolean;
      /**
       * @description Whether to return before all documents have finished updating.
       * @default true
       */
      wait_for_update?: boolean;
      encoders?: {
        /** @description The model url to use */
        model_url?: string;
        /** @description The model name to use. */
        model_name?:
          | "image_text"
          | "text_image"
          | "all-mpnet-base-v2"
          | "clip-vit-b-32-image"
          | "clip-vit-b-32-text"
          | "clip-vit-l-14-image"
          | "clip-vit-l-14-text"
          | "sentence-transformers"
          | "text-embedding-ada-002"
          | "cohere-small"
          | "cohere-large"
          | "cohere-multilingual-22-12";
        /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
        body?: string;
        /** @description The document field to encode. */
        field: string;
        /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
        alias?: string;
      }[];
      /** @description Before insertion, fields of documents will be transformed according to this array of rules. If transformation fails, the output field will not be generated. */
      field_transformers?: {
        /** @description Field to transform. to transform a nested field, use a.b */
        field: string;
        /** @description If specified, place result in this field. To place in a nested field, use format a.b */
        output_field?: string;
        /** @description Whether to strip html tags from field. */
        remove_html?: boolean;
        /** @description Whether transform a text field into an array of text by splitting sentences. */
        split_sentences?: boolean;
        /** @description If specified, documents with the vector fields will be clustered according to the clustering alias */
        assign_to_cluster?: {
          /** @description The alias of the clustering. */
          alias?: string;
        };
      }[];
      /** @description A list of jobs to run once all documents are processed. */
      jobs_to_trigger?: {
        /** @description Specify this to run an encoding job after documents are processed. Supports chunk field encoding, encoding many fields, and storing results in a new field specified by alias. */
        encode?: {
          /** @description Chunk field to encode. Will produce a field with _chunkvector_ suffix. */
          chunk_field?: string;
          /** @description Regular fields to encode. Will produce a field with _vector suffix. */
          fields?: string[];
          /** @description If provided, this string will be added to the output field name. */
          alias?: string;
          /** @description Model name to use for encoding. */
          model_name?: string;
        };
      }[];
    };
    InsertOutput: unknown;
    BulkInsertInput: {
      documents?: ({
        _id?: unknown;
      } & { [key: string]: unknown })[];
      /** @description Return immediately after storing data in a spot where it can be ingested in the background. Best for large datasets. */
      ingest_in_background?: boolean;
      /**
       * @description Whether to include insert date as a field 'insert_date_'.
       * @default true
       */
      insert_date?: boolean;
      /** @description Whether to include update date as a field 'update_date_'. Updates field if present already. */
      update_date_?: boolean;
      /**
       * @description Whether to transform fields containing dates to a valid Relevance date format.
       * @default true
       */
      transform_date_format?: boolean;
      /**
       * @description Whether to remove fields with the value 'N/A' from documents. Required to process pandas style CSVs.
       * @default true
       */
      remove_na?: boolean;
      /**
       * @description Whether to overwrite document if it exists.
       * @default true
       */
      overwrite?: boolean;
      /**
       * @description Whether the api should check the documents for vector datatype to update the schema.
       * @default true
       */
      update_schema?: boolean;
      /**
       * @description Whether to return before all documents have finished updating.
       * @default true
       */
      wait_for_update?: boolean;
      encoders?: {
        /** @description The model url to use */
        model_url?: string;
        /** @description The model name to use. */
        model_name?:
          | "image_text"
          | "text_image"
          | "all-mpnet-base-v2"
          | "clip-vit-b-32-image"
          | "clip-vit-b-32-text"
          | "clip-vit-l-14-image"
          | "clip-vit-l-14-text"
          | "sentence-transformers"
          | "text-embedding-ada-002"
          | "cohere-small"
          | "cohere-large"
          | "cohere-multilingual-22-12";
        /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
        body?: string;
        /** @description The document field to encode. */
        field: string;
        /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
        alias?: string;
      }[];
      /** @description Before insertion, fields of documents will be transformed according to this array of rules. If transformation fails, the output field will not be generated. */
      field_transformers?: {
        /** @description Field to transform. to transform a nested field, use a.b */
        field: string;
        /** @description If specified, place result in this field. To place in a nested field, use format a.b */
        output_field?: string;
        /** @description Whether to strip html tags from field. */
        remove_html?: boolean;
        /** @description Whether transform a text field into an array of text by splitting sentences. */
        split_sentences?: boolean;
        /** @description If specified, documents with the vector fields will be clustered according to the clustering alias */
        assign_to_cluster?: {
          /** @description The alias of the clustering. */
          alias?: string;
        };
      }[];
      /** @description A list of jobs to run once all documents are processed. */
      jobs_to_trigger?: {
        /** @description Specify this to run an encoding job after documents are processed. Supports chunk field encoding, encoding many fields, and storing results in a new field specified by alias. */
        encode?: {
          /** @description Chunk field to encode. Will produce a field with _chunkvector_ suffix. */
          chunk_field?: string;
          /** @description Regular fields to encode. Will produce a field with _vector suffix. */
          fields?: string[];
          /** @description If provided, this string will be added to the output field name. */
          alias?: string;
          /** @description Model name to use for encoding. */
          model_name?: string;
        };
      }[];
    };
    BulkInsertOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    GetFileUploadUrlsForDatasetInput: {
      /** @description files we be accessible under a url that will be returned in the output. */
      files: string[];
      include_file_path_in_url?: boolean;
    };
    GetFileUploadUrlsForDatasetOutput: {
      files: {
        upload_url: string;
        url: string;
      }[];
    };
    GetTemporaryFileUploadUrlInput: {
      /**
       * @description Used so when file is downloaded by customers, extension is correct.
       * @default csv
       */
      extension?: string;
    };
    GetTemporaryFileUploadUrlOutput: {
      upload_url: string;
      download_url: string;
    };
    ListFileUploadsForDatasetInput: unknown;
    ListFileUploadsForDatasetOutput: {
      files: {
        url: string;
      }[];
    };
    ParseBlobInput: {
      /** @description Used to download the blob of documents. */
      blob_url: string;
      /** @description Whether the blob is in csv or json format. */
      format: "csv" | "json";
      /** @description replace _id with (_id||id)['$oid'], or JSON.stringify(_id||id) */
      process_id?: boolean;
      /** @description Only process rows of length skip_rows. */
      skip_rows?: number;
      /**
       * @description Whether to return quickly and then wait for ingestion to complete in the background. This will speed up document ingestion significantly.
       * @default true
       */
      ingest_in_background?: boolean;
      /** @description Whether to parse this blob in a workflow for csv files only. Required for csv files larger than 30mb. */
      run_csv_workflow?: boolean;
      /** @description Whether to send an email when the csv workflow is complete. */
      send_csv_workflow_email?: boolean;
      /** @description Columns to rename */
      columns_to_rename?: { [key: string]: string };
      columns_to_remove?: string[];
      /**
       * @description Whether to transform the dataset name to what is allowed
       * @default true
       */
      process_dataset_name?: boolean;
    };
    ParseBlobOutput: {
      status: string;
      /** @description Response message or error message. */
      message: string;
      /** @description Number of successfully inserted documents. */
      inserted?: number;
      /** @description Failed documents. */
      failed_documents?: unknown[];
    };
    CopyForeignDatasetInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Dataset name to copy into */
      dataset_id: string;
      /** @description project name you want to copy the dataset into */
      project: string;
      /** @description api key of the project you want to copy the dataset into */
      api_key: string;
      /** @description Dataset to copy from */
      source_dataset_id: string;
      /** @description Source project name of whom the dataset belongs to */
      source_project: string;
      /** @description Api key to access the source project name */
      source_api_key: string;
    };
    CopyForeignDatasetOutput: unknown;
    CreateProjectReadKeyInput: {
      /** @description Username for read only key */
      read_username: unknown;
    };
    CreateProjectReadKeyOutput: unknown;
    GenerateOnboardingInput: {
      /** @description What is the product idea? */
      product_idea: string;
    };
    GenerateOnboardingOutput: {
      /** @description What is the feedback? */
      feedback: string;
      /** @description What is the transcript? */
      transcript: string;
      /** @description What is the pdf? */
      pdf: string;
      /** @description What is the knowledgebase? */
      knowledgebase: string;
    };
    DeleteDatasetInput: { [key: string]: unknown };
    DeleteDatasetOutput: {
      /** @description Completion status. */
      status: string;
      /** @description Response message for completion state. */
      message: string;
    };
    CreateDatasetInput: {
      id?: string;
      schema?: { [key: string]: unknown };
      /**
       * @description If true, creating a dataset that already exists will not error. If false, it will error.
       * @default true
       */
      upsert?: boolean;
    };
    CreateDatasetOutput: unknown;
    GetSchemaInput: unknown;
    GetSchemaOutput: { [key: string]: unknown };
    ListDatasetsInput: unknown;
    ListDatasetsOutput: {
      datasets: string[];
      count: number;
    };
    CombineDatasetsInput: {
      dataset_ids: string[];
      dataset_to_copy_metadata_from?: string;
      new_dataset_id: string;
      rename_fields?: { [key: string]: string };
      include_fields?: string[];
      remove_fields?: string[];
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
    };
    CombineDatasetsOutput: {
      job_id: string;
    };
    GetCombineJobStatusInput: unknown;
    GetCombineJobStatusOutput: {
      job_message: string;
      job_status: "Completed" | "InProgress";
    };
    SearchDatasetsInput: unknown;
    SearchDatasetsOutput: {
      datasets: string[];
      count: number;
    };
    GetFieldHealthInput: unknown;
    GetFieldHealthOutput: {
      [key: string]: {
        exists: number;
        missing: number;
      };
    };
    GetDatasetStatsInput: unknown;
    GetDatasetStatsOutput: { [key: string]: unknown };
    GetVectorMappingsInput: unknown;
    GetVectorMappingsOutput: { [key: string]: unknown };
    GetDatasetDetailsInput: {
      /**
       * @description Whether to return schema
       * @default true
       */
      include_schema?: boolean;
      /**
       * @description Whether to return stats
       * @default true
       */
      include_stats?: boolean;
      /**
       * @description Whether to return metadata
       * @default true
       */
      include_metadata?: boolean;
      /** @description Whether to return schema stats */
      include_schema_stats?: boolean;
      /** @description Whether to return vector health */
      include_vector_health?: boolean;
      /** @description Whether to return active jobs */
      include_active_jobs?: boolean;
      /** @description Whether to retrieve the datasets dashboard settings. */
      include_settings?: boolean;
      /** @description Whether to include when dataset was last used. */
      include_last_used?: boolean;
      /** @description Whether error if a stat type fails */
      throw_errors?: boolean;
    };
    GetDatasetDetailsOutput: {
      schema?: unknown;
      stats?: unknown;
      metadata?: unknown;
      schema_stats?: unknown;
      vector_health?: unknown;
      active_jobs?: unknown;
      settings?: unknown;
      last_used?: unknown;
    };
    GetDocumentInput: unknown;
    GetDocumentOutput: {
      document: { [key: string]: unknown };
    };
    DeleteDocumentInput: {
      /** @description Delete document with matching _id. */
      id: string;
    };
    DeleteDocumentOutput: unknown;
    UpsertDatasetSettingsInput: {
      settings: { [key: string]: unknown };
    };
    UpsertDatasetSettingsOutput: unknown;
    UpsertDatasetMetadataInput: {
      /** @description Edit and add metadata about a dataset. Notably description, data source, etc */
      metadata: { [key: string]: unknown };
    };
    UpsertDatasetMetadataOutput: unknown;
    GetDatasetMetadataInput: unknown;
    GetDatasetMetadataOutput: {
      results: { [key: string]: unknown };
    };
    GetDatasetSettingsInput: unknown;
    GetDatasetSettingsOutput: {
      results: { [key: string]: unknown };
    };
    UpdateInput: {
      /** @description _id of document to update. */
      id: unknown;
      /** @description Each document to upsert must have an _id field matching an existing document. */
      updates: {
        _id?: unknown;
      } & { [key: string]: unknown };
      /** @description Return immediately after storing data in a spot where it can be ingested in the background. Best for large datasets. */
      ingest_in_background?: boolean;
      /**
       * @description Whether to include insert date as a field 'insert_date_'.
       * @default true
       */
      insert_date?: boolean;
      /** @description Whether to include update date as a field 'update_date_'. Updates field if present already. */
      update_date_?: boolean;
      /**
       * @description Whether to transform fields containing dates to a valid Relevance date format.
       * @default true
       */
      transform_date_format?: boolean;
      /**
       * @description Whether to remove fields with the value 'N/A' from documents. Required to process pandas style CSVs.
       * @default true
       */
      remove_na?: boolean;
      /**
       * @description Whether to overwrite document if it exists.
       * @default true
       */
      overwrite?: boolean;
      /**
       * @description Whether the api should check the documents for vector datatype to update the schema.
       * @default true
       */
      update_schema?: boolean;
      /**
       * @description Whether to return before all documents have finished updating.
       * @default true
       */
      wait_for_update?: boolean;
      encoders?: {
        /** @description The model url to use */
        model_url?: string;
        /** @description The model name to use. */
        model_name?:
          | "image_text"
          | "text_image"
          | "all-mpnet-base-v2"
          | "clip-vit-b-32-image"
          | "clip-vit-b-32-text"
          | "clip-vit-l-14-image"
          | "clip-vit-l-14-text"
          | "sentence-transformers"
          | "text-embedding-ada-002"
          | "cohere-small"
          | "cohere-large"
          | "cohere-multilingual-22-12";
        /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
        body?: string;
        /** @description The document field to encode. */
        field: string;
        /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
        alias?: string;
      }[];
      /** @description Before insertion, fields of documents will be transformed according to this array of rules. If transformation fails, the output field will not be generated. */
      field_transformers?: {
        /** @description Field to transform. to transform a nested field, use a.b */
        field: string;
        /** @description If specified, place result in this field. To place in a nested field, use format a.b */
        output_field?: string;
        /** @description Whether to strip html tags from field. */
        remove_html?: boolean;
        /** @description Whether transform a text field into an array of text by splitting sentences. */
        split_sentences?: boolean;
        /** @description If specified, documents with the vector fields will be clustered according to the clustering alias */
        assign_to_cluster?: {
          /** @description The alias of the clustering. */
          alias?: string;
        };
      }[];
      /** @description A list of jobs to run once all documents are processed. */
      jobs_to_trigger?: {
        /** @description Specify this to run an encoding job after documents are processed. Supports chunk field encoding, encoding many fields, and storing results in a new field specified by alias. */
        encode?: {
          /** @description Chunk field to encode. Will produce a field with _chunkvector_ suffix. */
          chunk_field?: string;
          /** @description Regular fields to encode. Will produce a field with _vector suffix. */
          fields?: string[];
          /** @description If provided, this string will be added to the output field name. */
          alias?: string;
          /** @description Model name to use for encoding. */
          model_name?: string;
        };
      }[];
    };
    UpdateOutput: {
      /** @description Completion status. */
      status: string;
      /** @description Response message for completion state. */
      message: string;
    };
    DeleteDocumentFieldsInput: {
      /** @description _id of document to delete fields of. */
      id: string;
      /** @description List of fields to delete in a document */
      fields: string[];
    };
    DeleteDocumentFieldsOutput: unknown;
    BulkUpdateInput: {
      /** @description List of updates to apply to documents. Each update item must contain an _id. */
      updates: ({
        _id?: unknown;
      } & { [key: string]: unknown })[];
      /** @description Return immediately after storing data in a spot where it can be ingested in the background. Best for large datasets. */
      ingest_in_background?: boolean;
      /**
       * @description Whether to include insert date as a field 'insert_date_'.
       * @default true
       */
      insert_date?: boolean;
      /** @description Whether to include update date as a field 'update_date_'. Updates field if present already. */
      update_date_?: boolean;
      /**
       * @description Whether to transform fields containing dates to a valid Relevance date format.
       * @default true
       */
      transform_date_format?: boolean;
      /**
       * @description Whether to remove fields with the value 'N/A' from documents. Required to process pandas style CSVs.
       * @default true
       */
      remove_na?: boolean;
      /**
       * @description Whether to overwrite document if it exists.
       * @default true
       */
      overwrite?: boolean;
      /**
       * @description Whether the api should check the documents for vector datatype to update the schema.
       * @default true
       */
      update_schema?: boolean;
      /**
       * @description Whether to return before all documents have finished updating.
       * @default true
       */
      wait_for_update?: boolean;
      encoders?: {
        /** @description The model url to use */
        model_url?: string;
        /** @description The model name to use. */
        model_name?:
          | "image_text"
          | "text_image"
          | "all-mpnet-base-v2"
          | "clip-vit-b-32-image"
          | "clip-vit-b-32-text"
          | "clip-vit-l-14-image"
          | "clip-vit-l-14-text"
          | "sentence-transformers"
          | "text-embedding-ada-002"
          | "cohere-small"
          | "cohere-large"
          | "cohere-multilingual-22-12";
        /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
        body?: string;
        /** @description The document field to encode. */
        field: string;
        /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
        alias?: string;
      }[];
      /** @description Before insertion, fields of documents will be transformed according to this array of rules. If transformation fails, the output field will not be generated. */
      field_transformers?: {
        /** @description Field to transform. to transform a nested field, use a.b */
        field: string;
        /** @description If specified, place result in this field. To place in a nested field, use format a.b */
        output_field?: string;
        /** @description Whether to strip html tags from field. */
        remove_html?: boolean;
        /** @description Whether transform a text field into an array of text by splitting sentences. */
        split_sentences?: boolean;
        /** @description If specified, documents with the vector fields will be clustered according to the clustering alias */
        assign_to_cluster?: {
          /** @description The alias of the clustering. */
          alias?: string;
        };
      }[];
      /** @description A list of jobs to run once all documents are processed. */
      jobs_to_trigger?: {
        /** @description Specify this to run an encoding job after documents are processed. Supports chunk field encoding, encoding many fields, and storing results in a new field specified by alias. */
        encode?: {
          /** @description Chunk field to encode. Will produce a field with _chunkvector_ suffix. */
          chunk_field?: string;
          /** @description Regular fields to encode. Will produce a field with _vector suffix. */
          fields?: string[];
          /** @description If provided, this string will be added to the output field name. */
          alias?: string;
          /** @description Model name to use for encoding. */
          model_name?: string;
        };
      }[];
    };
    BulkUpdateOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    UpdateWhereInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Updates to make to the documents. It should be specified in a format of {"field_name": "value"}. e.g. {"item.status" : "Sold Out"} */
      updates: { [key: string]: unknown };
      /** @description Updates to apply conditionally based on a fields value. For example, if a field category exists, to add categoryUppercase use conditional_updates:[{field:"category",output_field:"categoryUppercase",condition_map:{"nonfiction":"NONFICTION"}}] */
      conditional_updates?: {
        field: string;
        output_field: string;
        condition_map: { [key: string]: unknown };
      }[];
      /** @default true */
      wait_for_update?: boolean;
      update_date_?: boolean;
    };
    UpdateWhereOutput: {
      /** @description Completion status. */
      status: string;
      /** @description Response message for completion state. */
      message: string;
    };
    AppendTagsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      field: string;
      tags_to_add: string[];
      update_date_?: boolean;
    };
    AppendTagsOutput: unknown;
    DeleteTagsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      field: string;
      tags_to_delete: string[];
      update_date_?: boolean;
    };
    DeleteTagsOutput: unknown;
    MergeTagsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      field: string;
      tags_to_merge: { [key: string]: string };
      update_date_?: boolean;
    };
    MergeTagsOutput: unknown;
    EditTagsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      field: string;
      tags_to_merge?: { [key: string]: string };
      tags_to_delete?: string[];
      tags_to_add?: string[];
      update_date_?: boolean;
    };
    EditTagsOutput: unknown;
    ListFacetsInput: {
      /** @description Fields to include in the facets, if [] then all */
      fields?: string[];
      /** @default monthly */
      date_interval?:
        | "monthly"
        | "daily"
        | "yearly"
        | "hourly"
        | "minutely"
        | "weekly";
      /**
       * @description Size of facet page
       * @default 1000
       */
      page_size?: number;
      /** @description Whether to sort results by ascending or descending frequency */
      asc?: boolean;
    };
    ListFacetsOutput: {
      results: { [key: string]: unknown };
    };
    GetWhereInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Fields to include in the search results, empty array/list means all fields. */
      select_fields?: string[];
      /** @description Size of each page of results. */
      page_size?: number;
      /** @description Size of each page of results. */
      page?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
      /** @description Include vectors in the search results. */
      include_vector?: boolean;
      /** @description Retrieve items after these sort values in the sort order. */
      after_id?: unknown[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vector_search_query?: unknown;
    };
    GetWhereOutput: {
      count: number;
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      documents: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      after_id: unknown[];
    };
    PaginateDocumentsInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Fields to include in the search results, empty array/list means all fields. */
      select_fields?: string[];
      /** @description Size of each page of results. */
      page_size?: number;
      /** @description Size of each page of results. */
      page?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
      /** @description Include vectors in the search results. */
      include_vector?: boolean;
      /** @description Retrieve items after these sort values in the sort order. */
      after_id?: unknown[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vector_search_query?: unknown;
    };
    PaginateDocumentsOutput: {
      count: number;
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      documents: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      after_id: unknown[];
    };
    CreateDatasetSummaryInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /** @description Fields to include in the search results, empty array/list means all fields. */
      select_fields?: string[];
      /** @description Size of each page of results. */
      page_size?: number;
      /** @description Size of each page of results. */
      page?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
      /** @description Include vectors in the search results. */
      include_vector?: boolean;
      /** @description Retrieve items after these sort values in the sort order. */
      after_id?: unknown[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vector_search_query?: unknown;
      question: string;
      field: string;
    };
    CreateDatasetSummaryOutput: {
      question: string;
      answer: string;
    };
    ListDatasetSummaryHistoryInput: unknown;
    ListDatasetSummaryHistoryOutput: {
      results: {
        question?: string;
        prompt?: string;
        field?: string;
        answer?: string;
        dataset?: string;
      }[];
    };
    BulkGetDocumentsInput: {
      /** @description IDs of documents to retrieve */
      ids: string[];
      /** @description Fields to include in the search results, empty array/list means all fields. */
      select_fields?: string[];
      /** @description Include vectors in the search results */
      include_vector?: boolean;
    };
    BulkGetDocumentsOutput: {
      /** @description A list of documents. Document is a JSON-like data that we store our metadata and vectors with. For specifying id of the document use the field '_id', for specifying vector field use the suffix of '_vector_' */
      documents: unknown[];
    };
    BulkDeleteDocumentsInput: {
      /** @description IDs of documents to delete */
      ids: string[];
    };
    BulkDeleteDocumentsOutput: unknown;
    ListDocumentsInput: unknown;
    ListDocumentsOutput: {
      count: number;
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      documents: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      after_id: unknown[];
    };
    DeleteWhereInput: { [key: string]: unknown } & {
      filters: unknown;
    };
    DeleteWhereOutput: {
      /** @description Completion status. */
      status: string;
      /** @description Response message for completion state. */
      message: string;
    };
    SimpleSearchPostInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /** @description Configuration for traditional search query. */
      queryConfig?: {
        /**
         * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
         * @default 1
         */
        weight?: number;
        /**
         * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
         *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
         * @default 1
         */
        sentenceWeight?: number;
        /**
         * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
         *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
         * @default 1
         */
        fuzzyWeight?: number;
      };
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vectorSearchQuery?: unknown;
      realtimeClustering?: {
        /** @default 4 */
        nClusters?: number;
        /** @default kmeans-realtime-4 */
        alias?: string;
        vectorField: string;
        /** @default _cluster_.{vector_field}.{alias} */
        outputField?: string;
      };
      /**
       * @description A list of fields to search using the "query" parameter.
       *
       *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
       *
       *     Default behaviour is to search all fields.
       *
       *     Example: ["name",{"field":"favourite_color","weight":0.2}]
       */
      fieldsToSearch?: unknown[];
      /**
       * @description Only return documents with a _relevance above this threshold.
       *
       *     Example: 0.3
       */
      minimumRelevance?: number;
      instantAnswerQuery?: {
        preset?: "support" | "support2" | "support3";
        query: string;
        field: string;
        urlField?: string;
        titleField?: string;
        temperature?: number;
        /**
         * @description Maximum number of words that will be generated.
         * @default 100
         */
        maxAnswerLength?: number;
      };
      /**
       * @description Page of results to return.
       *     Returns results from position page*pageSize to (page+1)*pageSize
       *
       *     Default: 0
       *
       *     Example: 3
       */
      page?: number;
      /**
       * @description Page size of results to return.
       *     Returns results from position page*pageSize to (page+1)*pageSize
       *
       *     Default: 10
       *
       *     Example: 25
       */
      pageSize?: number;
      /**
       * @description Add _relevance field to each document containing the documents relevance based on the search criteria.
       *
       *     Example: true
       * @default true
       */
      includeRelevance?: boolean;
      /**
       * @description Add _dataset field to each document containing the documents parent dataset. Useful when searching multiple datasets at once.
       *
       *     Example: false
       */
      includeDataset?: boolean;
      /**
       * @description Use the datasets schema to remove parameters that are unsafe before making a request.
       *
       *     For example, fieldsToAggregateStats only supports numeric fields. if this flag is set, all non numeric fields will be removed from fieldsToAggregateStats.
       *
       *     Example: true
       */
      cleanPayloadUsingSchema?: boolean;
      /**
       * @description Prioritise results based on integer, float and boolean fields values. Can sort ascending or descending.
       *
       *     Example 1: {"on_sale":"desc"}
       *
       *     Example 2: {"price":"asc"}
       */
      sort?: { [key: string]: "asc" | "desc" };
      /**
       * @description Only return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector_"]
       */
      includeFields?: string[];
      /**
       * @description Don't return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector"]
       */
      excludeFields?: string[];
      /**
       * @description Set to true to return all vector fields. includeFields / excludeFields has priority over this rule.
       *
       *     Example: true / false
       */
      includeVectors?: boolean;
      /**
       * @description Prioritise results based on integer, float and boolean fields values. Can sort ascending or descending.
       *
       *     Example 1: {"on_sale":"desc"}
       *
       *     Example 2: {"price":"asc"}
       */
      textSort?: { [key: string]: "asc" | "desc" };
      fieldsToAggregate?: unknown;
      fieldsToAggregateStats?: unknown;
      /** @description Add relevance to documents if they match conditions in this list. configure 'weight' on each condition to modify the relevance contribution. */
      relevanceBoosters?: unknown[];
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      afterId?: unknown[];
    };
    SimpleSearchPostOutput: {
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      results: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
      instantAnswerResults?: {
        answer?: string;
        status?: string;
        message?: string;
        question?: string;
        resultsIndex?: number;
      };
      /**
       * @description Total number of documents matched in the dataset.
       *
       *     Example: 100
       */
      resultsSize: number;
      aggregates: unknown;
      aggregateStats: unknown;
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      afterId: unknown[];
    } & {
      aggregations: unknown;
    };
    SearchInput: {
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
      /**
       * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
       *
       *     "tele" matches "Television", "This television is an excellent product…"
       *
       *     Example: "tele"
       */
      query?: string;
      /** @description Configuration for traditional search query. */
      queryConfig?: {
        /**
         * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
         * @default 1
         */
        weight?: number;
        /**
         * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
         *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
         * @default 1
         */
        sentenceWeight?: number;
        /**
         * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
         *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
         * @default 1
         */
        fuzzyWeight?: number;
      };
      /**
       * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
       *
       *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
       *
       *     It can be an object or a list of objects.
       *
       *
       *
       *     Example payloads:
       *
       *     {"field":"animaltype_vector_","query":"kitten"}
       *
       *     [
       *
       *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
       *
       *     ]
       */
      vectorSearchQuery?: unknown;
      realtimeClustering?: {
        /** @default 4 */
        nClusters?: number;
        /** @default kmeans-realtime-4 */
        alias?: string;
        vectorField: string;
        /** @default _cluster_.{vector_field}.{alias} */
        outputField?: string;
      };
      /**
       * @description A list of fields to search using the "query" parameter.
       *
       *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
       *
       *     Default behaviour is to search all fields.
       *
       *     Example: ["name",{"field":"favourite_color","weight":0.2}]
       */
      fieldsToSearch?: unknown[];
      /**
       * @description Only return documents with a _relevance above this threshold.
       *
       *     Example: 0.3
       */
      minimumRelevance?: number;
      instantAnswerQuery?: {
        preset?: "support" | "support2" | "support3";
        query: string;
        field: string;
        urlField?: string;
        titleField?: string;
        temperature?: number;
        /**
         * @description Maximum number of words that will be generated.
         * @default 100
         */
        maxAnswerLength?: number;
      };
      /**
       * @description Page of results to return.
       *     Returns results from position page*pageSize to (page+1)*pageSize
       *
       *     Default: 0
       *
       *     Example: 3
       */
      page?: number;
      /**
       * @description Page size of results to return.
       *     Returns results from position page*pageSize to (page+1)*pageSize
       *
       *     Default: 10
       *
       *     Example: 25
       */
      pageSize?: number;
      /**
       * @description Add _relevance field to each document containing the documents relevance based on the search criteria.
       *
       *     Example: true
       * @default true
       */
      includeRelevance?: boolean;
      /**
       * @description Add _dataset field to each document containing the documents parent dataset. Useful when searching multiple datasets at once.
       *
       *     Example: false
       */
      includeDataset?: boolean;
      /**
       * @description Use the datasets schema to remove parameters that are unsafe before making a request.
       *
       *     For example, fieldsToAggregateStats only supports numeric fields. if this flag is set, all non numeric fields will be removed from fieldsToAggregateStats.
       *
       *     Example: true
       */
      cleanPayloadUsingSchema?: boolean;
      /**
       * @description Prioritise results based on integer, float and boolean fields values. Can sort ascending or descending.
       *
       *     Example 1: {"on_sale":"desc"}
       *
       *     Example 2: {"price":"asc"}
       */
      sort?: { [key: string]: "asc" | "desc" };
      /**
       * @description Only return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector_"]
       */
      includeFields?: string[];
      /**
       * @description Don't return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector"]
       */
      excludeFields?: string[];
      /**
       * @description Set to true to return all vector fields. includeFields / excludeFields has priority over this rule.
       *
       *     Example: true / false
       */
      includeVectors?: boolean;
      /**
       * @description Prioritise results based on integer, float and boolean fields values. Can sort ascending or descending.
       *
       *     Example 1: {"on_sale":"desc"}
       *
       *     Example 2: {"price":"asc"}
       */
      textSort?: { [key: string]: "asc" | "desc" };
      fieldsToAggregate?: unknown;
      fieldsToAggregateStats?: unknown;
      /** @description Add relevance to documents if they match conditions in this list. configure 'weight' on each condition to modify the relevance contribution. */
      relevanceBoosters?: unknown[];
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      afterId?: unknown[];
    };
    SearchOutput: {
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      results: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
      instantAnswerResults?: {
        answer?: string;
        status?: string;
        message?: string;
        question?: string;
        resultsIndex?: number;
      };
      /**
       * @description Total number of documents matched in the dataset.
       *
       *     Example: 100
       */
      resultsSize: number;
      aggregates: unknown;
      aggregateStats: unknown;
      /** @description Used in future requests to retrieve items after these values in the sort order. */
      afterId: unknown[];
    } & {
      aggregations: unknown;
    };
    RecommendInput: {
      /**
       * @description This takes a list of objects. Each object must specify the id of the document to generate recommendations for, and the vector field that will be compared.
       *     Weight can be changed to increase or decrease how much a document contributes to the recommendation. A negative weight will make a document less likely to be recommended.
       */
      documentsToRecommend: {
        /** @description The vector field used for recommendation. */
        field: string;
        /** @description The id of the document used for recommendation. */
        id: string;
        /** @description Influences how much a document affects recommendation results. A negative weight causes documents like this to show up less. */
        weight?: number;
      }[];
      /**
       * @description Set to true to return all vector fields. includeFields / excludeFields has priority over this rule.
       *
       *     Example: true / false
       */
      includeVectors?: boolean;
      /**
       * @description Add _relevance field to each document containing the documents relevance based on the search criteria.
       *
       *     Example: true
       * @default true
       */
      includeRelevance?: boolean;
      /**
       * @description Only return fields of documents listed in this array.
       *
       *     Example: ["name","description_vector_"]
       */
      includeFields?: string[];
    };
    RecommendOutput: {
      /**
       * @description List of documents. List items are affected by page, pageSize, query, filters. Items order is affected by vectorSeachQuery, sort, textSort.
       *
       *     Example: [{"_id":"abcd","animal":"cat","price":10}, {"_id":"abcd","price":13}]
       */
      results: {
        /** @description Measures how closely a document matches on query and vectorSearchQuery. */
        _relevance?: number;
        _chunk_results?: {
          [key: string]: {
            results: {
              _relevance?: number;
            }[];
            _relevance: number;
          };
        };
      }[];
    };
    CloneDatasetInput: {
      new_dataset_id: string;
      /** @default [object Object] */
      rename_fields?: { [key: string]: string };
      /** @default */
      remove_fields?: string[];
      filters?: (Partial<{
        /** @description Match where document[field] is in value list. */
        match?: {
          /** @description If matching on text, match even if there are extra words / case insensitivity */
          fuzzy?: boolean;
          /** @description Field to match on. */
          field?: string;
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        matchArray?: {
          field: string;
          value: unknown[];
        };
        random?: {
          size: number;
        };
        /** @description Match where document._id is in value list. */
        matchIds?: {
          /** @description Can be either a single item or a list of items to match on. */
          value: unknown;
        };
        /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
        range?: {
          /** @description Field to match on. */
          field?: string;
          greaterThan?: unknown;
          lessThan?: unknown;
          greaterThanOrEqualTo?: unknown;
          lessThanOrEqualTo?: unknown;
        };
        /**
         * @description
         * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
         *
         * Possible matching patterns:
         *
         * * - documents where the field has any value
         * ? - documents where a single character from the field matches the provided values
         *
         * Example:
         *
         * {
         *   wildcard: {
         *      field: "title",
         *      value: [ "Avenger*" ]
         *   }
         * }
         */
        wildcard?: {
          /** @description Field to match on. */
          field?: string;
          /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
          value: unknown;
        };
        /** @description hybrid search query that must reach a certain value to filter */
        search?: {
          /**
           * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
           *
           *     "tele" matches "Television", "This television is an excellent product…"
           *
           *     Example: "tele"
           */
          query?: string;
          /** @description Configuration for traditional search query. */
          queryConfig?: {
            /**
             * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
             * @default 1
             */
            weight?: number;
            /**
             * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
             *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
             * @default 1
             */
            sentenceWeight?: number;
            /**
             * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
             *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
             * @default 1
             */
            fuzzyWeight?: number;
          };
          /**
           * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
           *
           *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
           *
           *     It can be an object or a list of objects.
           *
           *
           *
           *     Example payloads:
           *
           *     {"field":"animaltype_vector_","query":"kitten"}
           *
           *     [
           *
           *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
           *
           *     ]
           */
          vectorSearchQuery?: unknown;
          realtimeClustering?: {
            /** @default 4 */
            nClusters?: number;
            /** @default kmeans-realtime-4 */
            alias?: string;
            vectorField: string;
            /** @default _cluster_.{vector_field}.{alias} */
            outputField?: string;
          };
          /**
           * @description A list of fields to search using the "query" parameter.
           *
           *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
           *
           *     Default behaviour is to search all fields.
           *
           *     Example: ["name",{"field":"favourite_color","weight":0.2}]
           */
          fieldsToSearch?: unknown[];
          /**
           * @description Only return documents with a _relevance above this threshold.
           *
           *     Example: 0.3
           */
          minimumRelevance: number;
        };
        /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
        fieldExists?: {
          /** @description Field that must exist. */
          field?: string;
        };
        /** @description Match documents where doc[field] % module == value */
        matchModulo?: {
          /** @default _id */
          field?: string;
          modulo: number;
          value: number;
        };
        /** @description Filter down to one document for each value of selected field. */
        dedupeByValue?: {
          /** @description Field to filter on. */
          field: string;
        };
        /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
        selfreference?: {
          /** @description First field in comparison. */
          a: string;
          /** @description Second field in comparison. */
          b: string;
          /** @description Operator used to compare a and b. */
          operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
        };
        /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
        wordCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum word count. */
          greaterThan?: number;
          /** @description Maximum word count. */
          lessThan?: number;
        };
        /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
        characterCount?: {
          /** @description Field to match on. */
          field: string;
          /** @description Minimum character count. */
          greaterThan?: number;
          /** @description Maximum character count. */
          lessThan?: number;
        };
        /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
        or?: unknown[];
        /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
        not?: unknown;
        /** @description Filter based on data within a _chunk_ field. */
        chunk?: {
          /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
          path: string;
          filters: unknown[];
        };
      }> &
        Partial<{
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }>)[];
    };
    CloneDatasetOutput: {
      job_id: string;
    };
    PredictKNNRegressionInput: {
      /** @description The unique name of dataset. */
      dataset_id: string;
      /** @description An array of floats that represents data. */
      vector: number[];
      /** @description The vector field to search in. */
      vector_field: string;
      /** @description The field to perform regression on. */
      target_field: string;
      /** @description The number of results for KNN. */
      k?: number;
      /** @description The weighting for each prediction. Can either be a boolean or an array of weights. */
      weighting?: unknown;
      /** @description The value used to fill in the document when the data is missing. */
      impute_value?: number;
      /** @description How to predict using the vectors. Can be either "most_frequent" or "sum_scores". */
      predict_operation?: "mean" | "sum" | "weighted_mean";
      /** @description Whether to include search results. */
      include_search_results?: boolean;
    };
    PredictKNNRegressionOutput: {
      results: number;
      search_results?: unknown[];
    };
    PredictKNNFromResultsInput: {
      /** @description The field in "results" to use for prediction. */
      field: string;
      /** @description A list of documents */
      results: unknown[];
      /** @description The weighting for each prediction. Can either be a boolean or an array of weights. */
      weighting?: unknown;
      /** @description The value used to fill in the document when the data is missing. */
      impute_value?: unknown;
      /** @description How to predict using the vectors. Can be either "most_frequent" or "sum_scores". */
      predict_operation?: "most_frequent" | "score_sum";
    };
    PredictKNNFromResultsOutput: {
      results?: unknown;
    };
    BiasEvaluationInput: {
      /** @description Two keywords to compare. */
      query_list: unknown[];
      /** @description A list of words to compare the keywords against. */
      word_list: unknown[];
      /**
       * @description
       *   To encode a field 'description' with a sentence-transformers model, use:
       *   ```
       *   {field:'description',model_name:'sentence-transformers',model_url:'sentence-t5-base'}
       *   ```
       */
      encoder?: {
        /** @description The model url to use */
        model_url?: string;
        /** @description The model name to use. */
        model_name?:
          | "image_text"
          | "text_image"
          | "all-mpnet-base-v2"
          | "clip-vit-b-32-image"
          | "clip-vit-b-32-text"
          | "clip-vit-l-14-image"
          | "clip-vit-l-14-text"
          | "sentence-transformers"
          | "text-embedding-ada-002"
          | "cohere-small"
          | "cohere-large"
          | "cohere-multilingual-22-12";
        /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
        body?: string;
        /** @description The document field to encode. */
        field: string;
        /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
        alias?: string;
      };
    };
    BiasEvaluationOutput: {
      results?: { [key: string]: unknown };
    };
    VectorizeInput: {
      /** @description The model url to use */
      model_url?: string;
      /** @description The model name to use. */
      model_name?:
        | "image_text"
        | "text_image"
        | "all-mpnet-base-v2"
        | "clip-vit-b-32-image"
        | "clip-vit-b-32-text"
        | "clip-vit-l-14-image"
        | "clip-vit-l-14-text"
        | "sentence-transformers"
        | "text-embedding-ada-002"
        | "cohere-small"
        | "cohere-large"
        | "cohere-multilingual-22-12";
      /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
      body?: string;
      /** @description The document field to encode. */
      field: string;
      /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
      alias?: string;
      /** @description The documents that will be inserted */
      documents: ({
        _id?: unknown;
      } & { [key: string]: unknown })[];
    };
    VectorizeOutput: {
      /** @description The documents that will be vectorized */
      results: ({
        _id?: unknown;
      } & { [key: string]: unknown })[];
      errors: unknown[];
    };
    VectorizeAndInsertInput: {
      /** @description The model url to use */
      model_url?: string;
      /** @description The model name to use. */
      model_name?:
        | "image_text"
        | "text_image"
        | "all-mpnet-base-v2"
        | "clip-vit-b-32-image"
        | "clip-vit-b-32-text"
        | "clip-vit-l-14-image"
        | "clip-vit-l-14-text"
        | "sentence-transformers"
        | "text-embedding-ada-002"
        | "cohere-small"
        | "cohere-large"
        | "cohere-multilingual-22-12";
      /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
      body?: string;
      /** @description The document field to encode. */
      field: string;
      /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
      alias?: string;
      /** @description The documents that will be inserted */
      documents: ({
        _id?: unknown;
      } & { [key: string]: unknown })[];
    };
    VectorizeAndInsertOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    /**
     * @description
     *   To encode a field 'description' with a sentence-transformers model, use:
     *   ```
     *   {field:'description',model_name:'sentence-transformers',model_url:'sentence-t5-base'}
     *   ```
     */
    VectorizeFieldInput: {
      /** @description The model url to use */
      model_url?: string;
      /** @description The model name to use. */
      model_name?:
        | "image_text"
        | "text_image"
        | "all-mpnet-base-v2"
        | "clip-vit-b-32-image"
        | "clip-vit-b-32-text"
        | "clip-vit-l-14-image"
        | "clip-vit-l-14-text"
        | "sentence-transformers"
        | "text-embedding-ada-002"
        | "cohere-small"
        | "cohere-large"
        | "cohere-multilingual-22-12";
      /** @description Can be 'url' or 'text'. Use 'url' for image models and 'text' for text models. */
      body?: string;
      /** @description The document field to encode. */
      field: string;
      /** @description Add 'alias' to a created vector field name. Output format is {field}_{alias}_vector_. */
      alias?: string;
    };
    VectorizeFieldOutput: {
      /** @description Number of successfully processed documents. */
      inserted: number;
      /** @description Information about documents that were not processed successfully. */
      failed_documents: {
        /** @description _id field of unprocessed document. */
        _id?: unknown;
        error?: {
          /** @description http status code of individual document insertion operation. */
          status?: number;
          /** @description body response of individual document insertion operation. */
          body?: string;
        };
      }[];
    };
    ListDatasetWorkflowsByFieldsInput: unknown;
    ListDatasetWorkflowsByFieldsOutput: {
      results: {
        [key: string]: {
          items?: {
            status?: {
              creation_time?: string;
              completion_time?: string;
              notebook_path?: string;
              instance_type?: string;
              dataset_id?: string;
              params?: { [key: string]: unknown };
              _id?: string;
              workflow_id?: string;
              user_tier?:
                | "free"
                | "basic"
                | "starter"
                | "business"
                | "enterprise"
                | "custom";
              workflow_version?: string;
              workflow_efs_version?: string;
              parent_job_id?: string;
              metadata?: { [key: string]: unknown };
              output?: { [key: string]: unknown };
              /** @description Status of the workflow. Used for knowing when to send an email notification. */
              status?: "complete" | "inprogress" | "failed" | "cancelled";
              worker_status?: {
                [key: string]: {
                  status?: "complete" | "inprogress" | "failed" | "cancelled";
                  completion_time?: string;
                  creation_time?: string;
                };
              };
              n_workers?: number;
              credits_used?: number;
              /**
               * @description Templates support simple expressions on 'if' and 'params' fields. Supply an expression in the format:
               *
               * ${{params.my_param + params.my_param2 <= 5 }}
               *
               * Operators supported: ["!=","==","+","-","&&","||","false","true"]
               * Ensure that there is a space between each expression item or it will not evaluate correctly.
               */
              template?: {
                transformations: {
                  [key: string]: {
                    properties: {
                      params: { [key: string]: unknown };
                      workflow_id: string;
                      dataset_id?: string;
                    };
                    depends_on?: string[];
                    /** @description This should evaluate to a number. For example, it would be ${{ params.cluster_job_count }} or ${{ params.cluster_sizes.length }}. it will run a duplicate version of the workflow with a variable ${{ repeat_index }} that marks what index it belongs to. */
                    repeat?: string;
                    if?: string;
                  };
                };
              };
              template_history?: {
                events?: {
                  name: string;
                  action: "failed_to_start" | "skipped" | "started";
                  version?: string;
                  params?: { [key: string]: unknown };
                  message?: string;
                  dataset_id?: string;
                }[];
              }[];
              steps?: {
                [key: string]: {
                  worker_progress?: {
                    [key: string]: {
                      n_processed?: number;
                      n_processed_pricing?: number;
                      n_total?: number;
                    };
                  };
                  n_processed?: number;
                  n_processed_pricing?: number;
                  n_total?: number;
                  job_id?: string;
                  error_message?: string;
                  skipped?: boolean;
                };
              };
              email?: {
                /** @description If specified, a secondary CTA will be added to the email. Both URL and Text are required. */
                secondary_cta?: {
                  /** @description URL of the secondary CTA button. */
                  url?: string;
                  /** @description Text of the secondary CTA button. */
                  text?: string;
                };
              };
              marker_seen?: boolean;
            } & { [key: string]: unknown };
            outputFields?: string[];
          }[];
        };
      };
    };
    GetAPIHealthInput: unknown;
    GetAPIHealthOutput: unknown;
    DeleteFieldChildrenInput: unknown;
    DeleteFieldChildrenOutput: unknown;
    ListFieldChildrensInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListFieldChildrensOutput: {
      results: ({
        _id?: string;
        field?: string;
        field_children?: string[];
        metadata?: { [key: string]: unknown };
        category?: string;
      } & { [key: string]: unknown })[];
    };
    UpdateFieldChildrenInput: {
      _id?: string;
      field?: string;
      field_children?: string[];
      metadata?: { [key: string]: unknown };
      category?: string;
    };
    UpdateFieldChildrenOutput: unknown;
    DeleteFavouriteWorkflowInput: unknown;
    DeleteFavouriteWorkflowOutput: unknown;
    ListFavouriteWorkflowsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListFavouriteWorkflowsOutput: {
      results: ({
        _id?: string;
      } & { [key: string]: unknown })[];
    };
    UpdateFavouriteWorkflowInput: {
      _id?: string;
    };
    UpdateFavouriteWorkflowOutput: unknown;
    DeleteSavedFilterInput: unknown;
    DeleteSavedFilterOutput: unknown;
    ListSavedFiltersInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListSavedFiltersOutput: {
      results: ({
        _id?: string;
        filters?: { [key: string]: unknown };
        label?: string;
        name?: string;
      } & { [key: string]: unknown })[];
    };
    UpdateSavedFilterInput: {
      _id?: string;
      filters?: { [key: string]: unknown };
      label?: string;
      name?: string;
    };
    UpdateSavedFilterOutput: unknown;
    GetSavedFilterInput: unknown;
    GetSavedFilterOutput: {
      _id?: string;
      filters?: { [key: string]: unknown };
      label?: string;
      name?: string;
    } & { [key: string]: unknown };
    CreateSavedFilterInput: {
      _id?: string;
      filters?: { [key: string]: unknown };
      label?: string;
      name?: string;
    };
    CreateSavedFilterOutput: {
      id: string;
    };
    DeleteComponentInput: unknown;
    DeleteComponentOutput: unknown;
    ListComponentsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListComponentsOutput: {
      results: ({
        _id?: string;
        configuration?: { [key: string]: unknown };
      } & { [key: string]: unknown })[];
    };
    UpdateComponentInput: {
      _id?: string;
      configuration?: { [key: string]: unknown };
    };
    UpdateComponentOutput: unknown;
    GetComponentInput: unknown;
    GetComponentOutput: {
      _id?: string;
      configuration?: { [key: string]: unknown };
    } & { [key: string]: unknown };
    CreateComponentInput: {
      _id?: string;
      configuration?: { [key: string]: unknown };
    };
    CreateComponentOutput: {
      id: string;
    };
    ListDatasetEditorHistorysInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListDatasetEditorHistorysOutput: {
      results: ({
        _id?: string;
        metadata?: { [key: string]: unknown };
        items?: {
          [key: string]: {
            updates?: unknown[];
            filters?: unknown[];
          };
        };
      } & { [key: string]: unknown })[];
    };
    CreateDatasetEditorHistoryInput: {
      _id?: string;
      metadata?: { [key: string]: unknown };
      items?: {
        [key: string]: {
          updates?: unknown[];
          filters?: unknown[];
        };
      };
    };
    CreateDatasetEditorHistoryOutput: {
      id: string;
    };
    ListEditorConfigurationsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListEditorConfigurationsOutput: {
      results: ({
        _id?: string;
        metadata?: { [key: string]: unknown };
        items?: {
          [key: string]: {
            updates?: unknown[];
            filters?: unknown[];
          };
        };
      } & { [key: string]: unknown })[];
    };
    CreateEditorConfigurationInput: {
      _id?: string;
      metadata?: { [key: string]: unknown };
      items?: {
        [key: string]: {
          updates?: unknown[];
          filters?: unknown[];
        };
      };
    };
    CreateEditorConfigurationOutput: {
      id: string;
    };
    UpdateEditorConfigurationInput: {
      _id?: string;
      metadata?: { [key: string]: unknown };
      items?: {
        [key: string]: {
          updates?: unknown[];
          filters?: unknown[];
        };
      };
    };
    UpdateEditorConfigurationOutput: unknown;
    DeleteEditorConfigurationInput: unknown;
    DeleteEditorConfigurationOutput: unknown;
    GetEditorConfigurationInput: unknown;
    GetEditorConfigurationOutput: {
      _id?: string;
      metadata?: { [key: string]: unknown };
      items?: {
        [key: string]: {
          updates?: unknown[];
          filters?: unknown[];
        };
      };
    } & { [key: string]: unknown };
    ListKeyphrasesInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListKeyphrasesOutput: {
      results: ({
        _id?: string;
        text: string;
        frequency?: number;
        ancestors?: string[];
        parents?: string[];
        metadata?: { [key: string]: unknown };
        keyphrase_score?: number;
        insert_date_?: string;
        level?: number;
      } & { [key: string]: unknown })[];
    };
    UpdateKeyphraseInput: {
      _id?: string;
      text: string;
      frequency?: number;
      ancestors?: string[];
      parents?: string[];
      metadata?: { [key: string]: unknown };
      keyphrase_score?: number;
      insert_date_?: string;
      level?: number;
    };
    UpdateKeyphraseOutput: unknown;
    DeleteKeyphraseInput: unknown;
    DeleteKeyphraseOutput: unknown;
    GetKeyphraseInput: unknown;
    GetKeyphraseOutput: {
      _id?: string;
      text: string;
      frequency?: number;
      ancestors?: string[];
      parents?: string[];
      metadata?: { [key: string]: unknown };
      keyphrase_score?: number;
      insert_date_?: string;
      level?: number;
    } & { [key: string]: unknown };
    BulkUpdateKeyphrasesInput: {
      updates?: {
        _id?: string;
        text: string;
        frequency?: number;
        ancestors?: string[];
        parents?: string[];
        metadata?: { [key: string]: unknown };
        keyphrase_score?: number;
        insert_date_?: string;
        level?: number;
      }[];
    };
    BulkUpdateKeyphrasesOutput: unknown;
    BulkDeleteKeyphrasesInput: {
      ids: unknown[];
    };
    BulkDeleteKeyphrasesOutput: unknown;
    ListTaxonomysInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListTaxonomysOutput: {
      results: ({
        _id?: string;
        name?: string;
        taxonomy?: string[];
        description?: string;
        metadata?: { [key: string]: unknown };
      } & { [key: string]: unknown })[];
    };
    UpdateTaxonomyInput: {
      _id?: string;
      name?: string;
      taxonomy?: string[];
      description?: string;
      metadata?: { [key: string]: unknown };
    };
    UpdateTaxonomyOutput: unknown;
    DeleteTaxonomyInput: unknown;
    DeleteTaxonomyOutput: unknown;
    GetTaxonomyInput: unknown;
    GetTaxonomyOutput: {
      _id?: string;
      name?: string;
      taxonomy?: string[];
      description?: string;
      metadata?: { [key: string]: unknown };
    } & { [key: string]: unknown };
    CreateTaxonomyInput: {
      _id?: string;
      name?: string;
      taxonomy?: string[];
      description?: string;
      metadata?: { [key: string]: unknown };
    };
    CreateTaxonomyOutput: {
      id: string;
    };
    DeleteFavouriteDatasetInput: unknown;
    DeleteFavouriteDatasetOutput: unknown;
    ListFavouriteDatasetsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListFavouriteDatasetsOutput: {
      results: ({
        _id?: string;
      } & { [key: string]: unknown })[];
    };
    UpdateFavouriteDatasetInput: {
      _id?: string;
    };
    UpdateFavouriteDatasetOutput: unknown;
    DeleteFavouriteDeployableInput: unknown;
    DeleteFavouriteDeployableOutput: unknown;
    ListFavouriteDeployablesInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListFavouriteDeployablesOutput: {
      results: ({
        _id?: string;
      } & { [key: string]: unknown })[];
    };
    UpdateFavouriteDeployableInput: {
      _id?: string;
    };
    UpdateFavouriteDeployableOutput: unknown;
    DeleteUserOnboardingFlagInput: unknown;
    DeleteUserOnboardingFlagOutput: unknown;
    ListUserOnboardingFlagsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListUserOnboardingFlagsOutput: {
      results: ({
        _id?: string;
      } & { [key: string]: unknown })[];
    };
    UpdateUserOnboardingFlagInput: {
      _id?: string;
    };
    UpdateUserOnboardingFlagOutput: unknown;
    GetTranscriptTagListInput: unknown;
    GetTranscriptTagListOutput: {
      /** @description This should be the id of the document that has the corresponding transcript */
      _id?: string;
      tag_ranges: {
        id: string;
        from: number;
        to: number;
        tags: {
          text: string;
          taxonomy_id?: string;
        }[];
      }[];
    } & { [key: string]: unknown };
    UpdateTranscriptTagListInput: {
      /** @description This should be the id of the document that has the corresponding transcript */
      _id?: string;
      tag_ranges: {
        id: string;
        from: number;
        to: number;
        tags: {
          text: string;
          taxonomy_id?: string;
        }[];
      }[];
    };
    UpdateTranscriptTagListOutput: unknown;
    ListTranscriptTagListsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListTranscriptTagListsOutput: {
      results: ({
        /** @description This should be the id of the document that has the corresponding transcript */
        _id?: string;
        tag_ranges: {
          id: string;
          from: number;
          to: number;
          tags: {
            text: string;
            taxonomy_id?: string;
          }[];
        }[];
      } & { [key: string]: unknown })[];
    };
    ListTagsInput: {
      page?: number;
      page_size?: number;
      /** @description Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
      sort?: unknown[];
    };
    ListTagsOutput: {
      results: ({
        _id?: string;
        text: string;
        parents?: string[];
        metadata?: { [key: string]: unknown };
      } & { [key: string]: unknown })[];
    };
    DeleteTagInput: unknown;
    DeleteTagOutput: unknown;
    GetTagInput: unknown;
    GetTagOutput: {
      _id?: string;
      text: string;
      parents?: string[];
      metadata?: { [key: string]: unknown };
    } & { [key: string]: unknown };
    BulkDeleteTagsInput: {
      ids: unknown[];
    };
    BulkDeleteTagsOutput: unknown;
    BulkUpdateTagsInput: {
      updates?: {
        _id?: string;
        text: string;
        parents?: string[];
        metadata?: { [key: string]: unknown };
      }[];
    };
    BulkUpdateTagsOutput: unknown;
  };
}

export interface operations {
  /**
   * Create a private deployable.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "deployables:write",
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateDeployable: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDeployableOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDeployableInput"];
      };
    };
  };
  /**
   * Get a deployable.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "deployables:read"
   *     ],
   *     "deployables": [
   *       {
   *         "params": "deployable_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetDeployable: {
    parameters: {
      path: {
        /** ID of deployable */
        deployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDeployableOutput"];
        };
      };
    };
  };
  /**
   * Update a deployable
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "deployables:write"
   *     ],
   *     "deployables": [
   *       {
   *         "params": "deployable_id"
   *       }
   *     ]
   *   },
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateDeployable: {
    parameters: {
      path: {
        /** ID of deployable */
        deployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateDeployableOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateDeployableInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "deployables:write"
   *     ],
   *     "deployables": [
   *       {
   *         "body": "id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteDeployable: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDeployableOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDeployableInput"];
      };
    };
  };
  /**
   * Share a private deployable.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "sharing:write",
   *       "deployables:read"
   *     ],
   *     "deployables": [
   *       {
   *         "params": "deployable_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateDeployableKey: {
    parameters: {
      path: {
        /** ID of deployable */
        deployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDeployableKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDeployableKeyInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write",
   *       "deployables:read"
   *     ],
   *     "deployables": [
   *       {
   *         "params": "deployable_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateDeployableInvite: {
    parameters: {
      path: {
        /** ID of deployable */
        deployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDeployableInviteOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDeployableInviteInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write",
   *       "deployables:read"
   *     ],
   *     "deployables": [
   *       {
   *         "params": "deployable_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateUsersDeployablePermissions: {
    parameters: {
      path: {
        /** ID of deployable */
        deployable_id: string;
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateUsersDeployablePermissionsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateUsersDeployablePermissionsInput"];
      };
    };
  };
  /**
   * Unshare a shared deployable, making it private.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "sharing:write",
   *       "deployables:read"
   *     ],
   *     "deployables": [
   *       {
   *         "params": "deployable_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteDeployableKey: {
    parameters: {
      path: {
        /** ID of deployable */
        deployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDeployableKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDeployableKeyInput"];
      };
    };
  };
  /**
   * List all deployables.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": []
   *   }
   * ]
   */
  ListDeployables: {
    parameters: {
      query: {
        filters?: (Partial<{
          /** @description Match where document[field] is in value list. */
          match?: {
            /** @description If matching on text, match even if there are extra words / case insensitivity */
            fuzzy?: boolean;
            /** @description Field to match on. */
            field?: string;
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          matchArray?: {
            field: string;
            value: unknown[];
          };
          random?: {
            size: number;
          };
          /** @description Match where document._id is in value list. */
          matchIds?: {
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
          range?: {
            /** @description Field to match on. */
            field?: string;
            greaterThan?: unknown;
            lessThan?: unknown;
            greaterThanOrEqualTo?: unknown;
            lessThanOrEqualTo?: unknown;
          };
          /**
           * @description
           * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
           *
           * Possible matching patterns:
           *
           * * - documents where the field has any value
           * ? - documents where a single character from the field matches the provided values
           *
           * Example:
           *
           * {
           *   wildcard: {
           *      field: "title",
           *      value: [ "Avenger*" ]
           *   }
           * }
           */
          wildcard?: {
            /** @description Field to match on. */
            field?: string;
            /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
            value: unknown;
          };
          /** @description hybrid search query that must reach a certain value to filter */
          search?: {
            /**
             * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
             *
             *     "tele" matches "Television", "This television is an excellent product…"
             *
             *     Example: "tele"
             */
            query?: string;
            /** @description Configuration for traditional search query. */
            queryConfig?: {
              /**
               * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
               * @default 1
               */
              weight?: number;
              /**
               * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
               *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
               * @default 1
               */
              sentenceWeight?: number;
              /**
               * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
               *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
               * @default 1
               */
              fuzzyWeight?: number;
            };
            /**
             * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
             *
             *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
             *
             *     It can be an object or a list of objects.
             *
             *
             *
             *     Example payloads:
             *
             *     {"field":"animaltype_vector_","query":"kitten"}
             *
             *     [
             *
             *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
             *
             *     ]
             */
            vectorSearchQuery?: unknown;
            realtimeClustering?: {
              /** @default 4 */
              nClusters?: number;
              /** @default kmeans-realtime-4 */
              alias?: string;
              vectorField: string;
              /** @default _cluster_.{vector_field}.{alias} */
              outputField?: string;
            };
            /**
             * @description A list of fields to search using the "query" parameter.
             *
             *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
             *
             *     Default behaviour is to search all fields.
             *
             *     Example: ["name",{"field":"favourite_color","weight":0.2}]
             */
            fieldsToSearch?: unknown[];
            /**
             * @description Only return documents with a _relevance above this threshold.
             *
             *     Example: 0.3
             */
            minimumRelevance: number;
          };
          /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
          fieldExists?: {
            /** @description Field that must exist. */
            field?: string;
          };
          /** @description Match documents where doc[field] % module == value */
          matchModulo?: {
            /** @default _id */
            field?: string;
            modulo: number;
            value: number;
          };
          /** @description Filter down to one document for each value of selected field. */
          dedupeByValue?: {
            /** @description Field to filter on. */
            field: string;
          };
          /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
          selfreference?: {
            /** @description First field in comparison. */
            a: string;
            /** @description Second field in comparison. */
            b: string;
            /** @description Operator used to compare a and b. */
            operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
          };
          /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
          wordCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum word count. */
            greaterThan?: number;
            /** @description Maximum word count. */
            lessThan?: number;
          };
          /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
          characterCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum character count. */
            greaterThan?: number;
            /** @description Maximum character count. */
            lessThan?: number;
          };
          /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
          or?: unknown[];
          /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
          not?: unknown;
          /** @description Filter based on data within a _chunk_ field. */
          chunk?: {
            /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
            path: string;
            filters: unknown[];
          };
        }> &
          Partial<{
            strict?: "must" | "should" | "must_or";
            condition?: string;
            case_insensitive?: boolean;
            field?: string;
            filter_type?:
              | "text_match"
              | "word_match"
              | "term"
              | "terms"
              | "text"
              | "texts"
              | "match"
              | "contains"
              | "substring"
              | "class"
              | "category"
              | "exact_match"
              | "classes"
              | "categories"
              | "exists"
              | "traditional"
              | "fuzzy"
              | "regexp"
              | "ids"
              | "date"
              | "numeric"
              | "search"
              | "or"
              | "word_count"
              | "character_count"
              | "dedupe_by_value"
              | "match_array"
              | "random";
            condition_value?: unknown;
            fuzzy?: number;
            join?: boolean;
          }>)[];
        /** Fields to include in the search results, empty array/list means all fields. */
        select_fields?: string[];
        /** Size of each page of results. */
        page_size?: number;
        /** Size of each page of results. */
        page?: number;
        /** Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
        sort?: unknown[];
        /** Include vectors in the search results. */
        include_vector?: boolean;
        /** Retrieve items after these sort values in the sort order. */
        after_id?: unknown[];
        /**
         * Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
         *
         *     "tele" matches "Television", "This television is an excellent product…"
         *
         *     Example: "tele"
         */
        query?: string;
        /**
         * Prioritise the result list of documents based on semantic similarity to "query" provided here.
         *
         *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
         *
         *     It can be an object or a list of objects.
         *
         *
         *
         *     Example payloads:
         *
         *     {"field":"animaltype_vector_","query":"kitten"}
         *
         *     [
         *
         *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
         *
         *     ]
         */
        vector_search_query?: unknown;
        /** Unique name of the dataset */
        dataset_id?: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDeployablesOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteDeployableGroup: {
    parameters: {
      path: {
        /** ID of deployablegroup */
        deployablegroup_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDeployableGroupOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDeployableGroupInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListDeployableGroups: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDeployableGroupsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListDeployableGroupsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateDeployableGroup: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDeployableGroupOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDeployableGroupInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetDeployableGroup: {
    parameters: {
      path: {
        /** ID of deployablegroup */
        deployablegroup_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDeployableGroupOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateDeployableGroup: {
    parameters: {
      path: {
        /** ID of deployablegroup */
        deployablegroup_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateDeployableGroupOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateDeployableGroupInput"];
      };
    };
  };
  /**
   * Share a private deployable group. Required read access to all deployables that are shared, and the datasets deployables are tied to.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "sharing:write"
   *     ]
   *   }
   * ]
   */
  CreateDeployableGroupKey: {
    parameters: {
      path: {
        /** ID of deployablegroup */
        deployablegroup_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDeployableGroupKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDeployableGroupKeyInput"];
      };
    };
  };
  /**
   * Unshare a shared deployable group, making it private.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "sharing:write"
   *     ]
   *   }
   * ]
   */
  DeleteDeployableGroupKey: {
    parameters: {
      path: {
        /** ID of deployablegroup */
        deployablegroup_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDeployableGroupKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDeployableGroupKeyInput"];
      };
    };
  };
  /**
   * Create a new Project that your user will have access to
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:write"
   *     ],
   *     "organizations": [
   *       {
   *         "body": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateProject: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateProjectOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateProjectInput"];
      };
    };
  };
  /**
   * Update metadata of a Project
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "admin"
   *     ]
   *   }
   * ]
   */
  UpdateProject: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateProjectOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateProjectInput"];
      };
    };
  };
  /**
   * Tie a project to an organization. This requires admin privileges over project and organization.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "admin"
   *     ],
   *     "projects": [
   *       {
   *         "user_info": "username"
   *       }
   *     ]
   *   },
   *   {
   *     "actions": [
   *       "organizations:write"
   *     ],
   *     "organizations": [
   *       {
   *         "body": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  TransferProjectToOrganization: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["TransferProjectToOrganizationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TransferProjectToOrganizationInput"];
      };
    };
  };
  /**
   * List all projects and their metadata
   *
   * ### Required permissions
   * > []
   */
  ListProjects: {
    parameters: {
      query: {
        page?: number;
        page_size?: number;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListProjectsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ]
   *   }
   * ]
   */
  GetProjectsOrgInfo: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetProjectsOrgInfoOutput"];
        };
      };
    };
  };
  /**
   * List which keys exist for a project
   *
   * ### Required permissions
   * > []
   */
  ListProjectKeys: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListProjectKeysOutput"];
        };
      };
    };
  };
  /**
   * Get value for key for a project
   *
   * ### Required permissions
   * > []
   */
  GetProjectKey: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetProjectKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetProjectKeyInput"];
      };
    };
  };
  /**
   * Set a key for a project
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "admin"
   *     ]
   *   }
   * ]
   */
  SetProjectKey: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["SetProjectKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["SetProjectKeyInput"];
      };
    };
  };
  /**
   * Delete a key for a project
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "admin"
   *     ]
   *   }
   * ]
   */
  DeleteProjectKey: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteProjectKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteProjectKeyInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  CreateUser: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateUserOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateUserInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": []
   *   }
   * ]
   */
  ListUsers: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListUsersOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListUsersInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  IsUserAuthorized: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["IsUserAuthorizedOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["IsUserAuthorizedInput"];
      };
    };
  };
  /**
   * Get user_id, key_id and permissions from an auth header.
   *
   * ### Required permissions
   * > []
   */
  GetAuthHeaderInfo: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetAuthHeaderInfoOutput"];
        };
      };
    };
  };
  /**
   * Invite a user to a project using either their email or their user_id
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  CreateProjectInvite: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateProjectInviteOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateProjectInviteInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListProjectInvites: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListProjectInvitesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListProjectInvitesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  AcceptProjectInvite: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["AcceptProjectInviteOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AcceptProjectInviteInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  DeleteProjectInvite: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteProjectInviteOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteProjectInviteInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  ResendProjectInvite: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ResendProjectInviteOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ResendProjectInviteInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "users": [
   *       {
   *         "params": "user_id"
   *       }
   *     ],
   *     "actions": [
   *       "users:read"
   *     ]
   *   }
   * ]
   */
  GetUser: {
    parameters: {
      path: {
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetUserOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "users": [
   *       {
   *         "params": "user_id"
   *       }
   *     ],
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  UpdateUser: {
    parameters: {
      path: {
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateUserOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateUserInput"];
      };
    };
  };
  /**
   * Deletes a User from ONLY your project. If they have permissions for other projects, they will still have acces to them.
   *
   * ### Required permissions
   * > [
   *   {
   *     "users": [
   *       {
   *         "params": "user_id"
   *       }
   *     ],
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  DeleteUser: {
    parameters: {
      path: {
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteUserOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteUserInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "users": [
   *       {
   *         "params": "user_id"
   *       }
   *     ],
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  CreateUserKey: {
    parameters: {
      path: {
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateUserKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateUserKeyInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "users": [
   *       {
   *         "params": "user_id"
   *       }
   *     ],
   *     "actions": [
   *       "users:read"
   *     ]
   *   }
   * ]
   */
  ListUserKeys: {
    parameters: {
      path: {
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListUserKeysOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListUserKeysInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "users": [
   *       {
   *         "params": "user_id"
   *       }
   *     ],
   *     "actions": [
   *       "users:write"
   *     ]
   *   }
   * ]
   */
  DeleteUserKey: {
    parameters: {
      path: {
        /** ID of user */
        user_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteUserKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteUserKeyInput"];
      };
    };
  };
  /**
   * Insert your own cluster centroids for it to be used in approximate search settings and cluster aggregations.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  InsertClusterCentroids: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["InsertClusterCentroidsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["InsertClusterCentroidsInput"];
      };
    };
  };
  /**
   * Update your own cluster centroids for it to be used in approximate search settings and cluster aggregations. Will merge rather than replace centroids.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateClusterCentroids: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateClusterCentroidsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateClusterCentroidsInput"];
      };
    };
  };
  /**
   * For each centroid in a list of centroids, find the closest centroids in another set of centroids.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       },
   *       {
   *         "body": "comparison_centroids.dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CompareClusterCentroids: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CompareClusterCentroidsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CompareClusterCentroidsInput"];
      };
    };
  };
  /**
   * Aggregation/Groupby of a collection using an aggregation query.
   * The aggregation query is a json body that follows the schema of:
   *
   *     {
   *         "groupby" : [
   *             {"name": <alias>, "field": <field in the collection>, "agg": "category"},
   *             {"name": <alias>, "field": <another groupby field in the collection>, "agg": "numeric"}
   *         ],
   *         "metrics" : [
   *             {"name": <alias>, "field": <numeric field in the collection>, "agg": "avg"}
   *             {"name": <alias>, "field": <another numeric field in the collection>, "agg": "max"}
   *             {"name": <alias>, "fields": [<numeric field in the collection>, <another numeric field in the collection>], "agg": "correlation"}
   *         ]
   *     }
   *     For example, one can use the following aggregations to group score based on region and player name.
   *     {
   *         "groupby" : [
   *             {"name": "region", "field": "player_region", "agg": "category"},
   *             {"name": "player_name", "field": "name", "agg": "category"}
   *         ],
   *         "metrics" : [
   *             {"name": "average_score", "field": "final_score", "agg": "avg"},
   *             {"name": "max_score", "field": "final_score", "agg": "max"},
   *             {'name':'total_score','field':"final_score", 'agg':'sum'},
   *             {'name':'average_deaths','field':"final_deaths", 'agg':'avg'},
   *             {'name':'highest_deaths','field':"final_deaths", 'agg':'max'},
   *             {'name':'score_death_correlation', 'fields':['final_deaths', 'final_score'], 'agg': 'correlation'},
   *         ]
   *     }
   * - "groupby" is the fields you want to split the data into. These are the available groupby types:
   *     - category" : groupby a field that is a category
   *     - numeric: groupby a field that is a numeric
   * - "metrics" is the fields you want to metrics you want to calculate in each of those, every aggregation includes a frequency metric. These are the available metric types:
   *     - For single fields: "avg"/"average"/"mean", "cardinality", "count", "kurtosis", "max", "min", "percentiles", "kurtosis", "std_deviation", "std_deviation_bounds", "sum", "sum_of_squares", "variance"
   *     - For multiple fields (the attribute "fields" must be used instead of "field"): "correlation", "covariance", "kurtosis", "mean", "skewness", "variance"
   *
   * The response returned has the following in descending order.
   *
   * IF you want to return documents, specify a "group_size" parameter and a "select_fields" parameter if you want to limit the specific fields chosen.
   * This looks as such:
   *
   *     {
   *       'groupby':[
   *         {'name':'Manufacturer','field':'manufacturer','agg':'category',
   *         'group_size': 10, 'select_fields': ["name"]},
   *       ],
   *       'metrics':[
   *         {'name':'Price Average','field':'price','agg':'avg'},
   *       ],
   *     }
   *
   *     {"title": {"title": "books", "frequency": 200, "documents": [{...}, {...}]}, {"title": "books", "frequency": 100, "documents": [{...}, {...}]}}
   *
   * For array-aggregations, you can add "agg": "array" into the aggregation query.
   *
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  Aggregate: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["AggregateOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AggregateInput"];
      };
    };
  };
  /**
   * Takes an aggregation query and gets the aggregate of each cluster in a collection. This helps you interpret each cluster and what is in them.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  AggregateClusters: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["AggregateClustersOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AggregateClustersInput"];
      };
    };
  };
  /**
   * Takes a high level aggregation of every field and every cluster in a collection. This helps you interpret each cluster and what is in them.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListClusterFacets: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListClusterFacetsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListClusterFacetsInput"];
      };
    };
  };
  /**
   * List documents with vector fields closest to centroids.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListClosestToCentroids: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListClosestToCentroidsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListClosestToCentroidsInput"];
      };
    };
  };
  /**
   * List documents with vector fields furthest from centroids.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListFurthestFromCentroids: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFurthestFromCentroidsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListFurthestFromCentroidsInput"];
      };
    };
  };
  /**
   * List centroids, optionally filtering by their ids.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListCentroids: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListCentroidsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListCentroidsInput"];
      };
    };
  };
  /**
   * List centroids configs for a dataset.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListCentroidConfigs: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListCentroidConfigsOutput"];
        };
      };
    };
  };
  /**
   * Delete a centroid by ID
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteCentroid: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of centroid */
        centroid_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteCentroidOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteCentroidInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  RealtimeClustering: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["RealtimeClusteringOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["RealtimeClusteringInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  MergeClusters: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["MergeClustersOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["MergeClustersInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read",
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateClusterSummaries: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateClusterSummariesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateClusterSummariesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read",
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateClusterLabels: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateClusterLabelsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateClusterLabelsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListClusterSummaries: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListClusterSummariesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListClusterSummariesInput"];
      };
    };
  };
  /**
   * Endpoint for creating Hierarchical Clusters from a given dataset on top of existing clusters.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read",
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateHierarchicalClusters: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateHierarchicalClustersOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateHierarchicalClustersInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteClusterSummaries: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteClusterSummariesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteClusterSummariesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  EditOneToManyClusters: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["EditOneToManyClustersOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["EditOneToManyClustersInput"];
      };
    };
  };
  /**
   * If a document looks like this:
   *   ```
   *   {mylistfield:{
   *     innerfield:[
   *       {filter_list_field:'aaa',update_field:{'inner_update_field':'a'}}
   *     ]
   *   }}
   *   ```
   *   the inner field can be filtered like this:
   *   ```
   *   {
   *     list_field: 'mylistfield.innerfield'
   *     match_field:'filter_list_field',
   *     update_field:'update_field.inner_update_field'
   *     updates:{'a':'valuetoreplace'}
   *   }
   *   ```
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  EditListInDocuments: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["EditListInDocumentsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["EditListInDocumentsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateOrganization: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateOrganizationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateOrganizationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:write"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateOrganization: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateOrganizationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateOrganizationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "support:write"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateOrganizationAdmin: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateOrganizationAdminOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateOrganizationAdminInput"];
      };
    };
  };
  /**
   * List all organizations and their metadata
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ]
   *   }
   * ]
   */
  ListOrganizations: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListOrganizationsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:write"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteOrganization: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteOrganizationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteOrganizationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetOrganization: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetOrganizationOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetOrganizationUsage: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetOrganizationUsageOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListUsersInOrganization: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListUsersInOrganizationOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListProjectsInOrganization: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListProjectsInOrganizationOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  AggregateOrganizationMetrics: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["AggregateOrganizationMetricsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AggregateOrganizationMetricsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:read"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListBillingEvents: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListBillingEventsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListBillingEventsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "support:write"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateBillingEventAdmin: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateBillingEventAdminOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateBillingEventAdminInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:write"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetBillingFrontendLink: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetBillingFrontendLinkOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "organizations:write"
   *     ],
   *     "organizations": [
   *       {
   *         "params": "organization_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateOrganizationBilling: {
    parameters: {
      path: {
        /** ID of organization */
        organization_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateOrganizationBillingOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateOrganizationBillingInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write",
   *       "connectors:write"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateConnector: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateConnectorOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateConnectorInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CheckConnection: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CheckConnectionOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CheckConnectionInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "connectors:read"
   *     ],
   *     "connectors": [
   *       {
   *         "params": "connector_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetConnector: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetConnectorOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "connectors:write",
   *       "datasets:write"
   *     ],
   *     "connectors": [
   *       {
   *         "params": "connector_id"
   *       }
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateConnector: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateConnectorOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateConnectorInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "connectors:write"
   *     ],
   *     "connectors": [
   *       {
   *         "params": "connector_id"
   *       }
   *     ]
   *   }
   * ]
   */
  TriggerConnector: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["TriggerConnectorOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TriggerConnectorInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "connectors:write"
   *     ],
   *     "connectors": [
   *       {
   *         "params": "connector_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteConnector: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteConnectorOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteConnectorInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": []
   *   }
   * ]
   */
  ListConnectors: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListConnectorsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListConnectorTypes: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListConnectorTypesOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetConnectorType: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetConnectorTypeOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "connectors:read"
   *     ],
   *     "connectors": [
   *       {
   *         "params": "connector_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListConnectorJobs: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListConnectorJobsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "connectors:read"
   *     ],
   *     "connectors": [
   *       {
   *         "params": "connector_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetConnectorJob: {
    parameters: {
      path: {
        /** ID of connector */
        connector_id: string;
        /** ID of job */
        job_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetConnectorJobOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read",
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  TriggerWorkflow: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["TriggerWorkflowOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TriggerWorkflowInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ]
   *   }
   * ]
   */
  ListWorkflows: {
    parameters: {
      query: {
        /** Only retrieve workflows of this status */
        job_status?: "complete" | "inprogress" | "failed" | "cancelled";
        /** Currently limited to exact_match, ids, exists, regexp filter_type */
        filters?: {
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }[];
        /** Size of each page of results. */
        page?: number;
        /** Size of each page of results. */
        page_size?: number;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListWorkflowsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ]
   *   }
   * ]
   */
  GetWorkflowStatus: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetWorkflowStatusOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetWorkflowStatusInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetWorkflowConfig: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetWorkflowConfigOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetWorkflowConfigInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ]
   *   }
   * ]
   */
  DeleteWorkflowStatus: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteWorkflowStatusOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteWorkflowStatusInput"];
      };
    };
  };
  /**
   * Terminate a workflow
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ]
   *   }
   * ]
   */
  TerminateWorkflow: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["TerminateWorkflowOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["TerminateWorkflowInput"];
      };
    };
  };
  /**
   * Update metadata for a workflow run
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ]
   *   }
   * ]
   */
  UpsertWorkflowMetadata: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpsertWorkflowMetadataOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpsertWorkflowMetadataInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ]
   *   }
   * ]
   */
  UpsertWorkflowProgress: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpsertWorkflowProgressOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpsertWorkflowProgressInput"];
      };
    };
  };
  /**
   * Update status for a workflow run
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ]
   *   }
   * ]
   */
  UpsertWorkflowStatus: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpsertWorkflowStatusOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpsertWorkflowStatusInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListWorkflowTypes: {
    parameters: {
      query: {
        filters?: (Partial<{
          /** @description Match where document[field] is in value list. */
          match?: {
            /** @description If matching on text, match even if there are extra words / case insensitivity */
            fuzzy?: boolean;
            /** @description Field to match on. */
            field?: string;
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          matchArray?: {
            field: string;
            value: unknown[];
          };
          random?: {
            size: number;
          };
          /** @description Match where document._id is in value list. */
          matchIds?: {
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
          range?: {
            /** @description Field to match on. */
            field?: string;
            greaterThan?: unknown;
            lessThan?: unknown;
            greaterThanOrEqualTo?: unknown;
            lessThanOrEqualTo?: unknown;
          };
          /**
           * @description
           * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
           *
           * Possible matching patterns:
           *
           * * - documents where the field has any value
           * ? - documents where a single character from the field matches the provided values
           *
           * Example:
           *
           * {
           *   wildcard: {
           *      field: "title",
           *      value: [ "Avenger*" ]
           *   }
           * }
           */
          wildcard?: {
            /** @description Field to match on. */
            field?: string;
            /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
            value: unknown;
          };
          /** @description hybrid search query that must reach a certain value to filter */
          search?: {
            /**
             * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
             *
             *     "tele" matches "Television", "This television is an excellent product…"
             *
             *     Example: "tele"
             */
            query?: string;
            /** @description Configuration for traditional search query. */
            queryConfig?: {
              /**
               * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
               * @default 1
               */
              weight?: number;
              /**
               * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
               *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
               * @default 1
               */
              sentenceWeight?: number;
              /**
               * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
               *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
               * @default 1
               */
              fuzzyWeight?: number;
            };
            /**
             * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
             *
             *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
             *
             *     It can be an object or a list of objects.
             *
             *
             *
             *     Example payloads:
             *
             *     {"field":"animaltype_vector_","query":"kitten"}
             *
             *     [
             *
             *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
             *
             *     ]
             */
            vectorSearchQuery?: unknown;
            realtimeClustering?: {
              /** @default 4 */
              nClusters?: number;
              /** @default kmeans-realtime-4 */
              alias?: string;
              vectorField: string;
              /** @default _cluster_.{vector_field}.{alias} */
              outputField?: string;
            };
            /**
             * @description A list of fields to search using the "query" parameter.
             *
             *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
             *
             *     Default behaviour is to search all fields.
             *
             *     Example: ["name",{"field":"favourite_color","weight":0.2}]
             */
            fieldsToSearch?: unknown[];
            /**
             * @description Only return documents with a _relevance above this threshold.
             *
             *     Example: 0.3
             */
            minimumRelevance: number;
          };
          /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
          fieldExists?: {
            /** @description Field that must exist. */
            field?: string;
          };
          /** @description Match documents where doc[field] % module == value */
          matchModulo?: {
            /** @default _id */
            field?: string;
            modulo: number;
            value: number;
          };
          /** @description Filter down to one document for each value of selected field. */
          dedupeByValue?: {
            /** @description Field to filter on. */
            field: string;
          };
          /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
          selfreference?: {
            /** @description First field in comparison. */
            a: string;
            /** @description Second field in comparison. */
            b: string;
            /** @description Operator used to compare a and b. */
            operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
          };
          /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
          wordCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum word count. */
            greaterThan?: number;
            /** @description Maximum word count. */
            lessThan?: number;
          };
          /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
          characterCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum character count. */
            greaterThan?: number;
            /** @description Maximum character count. */
            lessThan?: number;
          };
          /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
          or?: unknown[];
          /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
          not?: unknown;
          /** @description Filter based on data within a _chunk_ field. */
          chunk?: {
            /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
            path: string;
            filters: unknown[];
          };
        }> &
          Partial<{
            strict?: "must" | "should" | "must_or";
            condition?: string;
            case_insensitive?: boolean;
            field?: string;
            filter_type?:
              | "text_match"
              | "word_match"
              | "term"
              | "terms"
              | "text"
              | "texts"
              | "match"
              | "contains"
              | "substring"
              | "class"
              | "category"
              | "exact_match"
              | "classes"
              | "categories"
              | "exists"
              | "traditional"
              | "fuzzy"
              | "regexp"
              | "ids"
              | "date"
              | "numeric"
              | "search"
              | "or"
              | "word_count"
              | "character_count"
              | "dedupe_by_value"
              | "match_array"
              | "random";
            condition_value?: unknown;
            fuzzy?: number;
            join?: boolean;
          }>)[];
        /** Fields to include in the search results, empty array/list means all fields. */
        select_fields?: string[];
        /** Size of each page of results. */
        page_size?: number;
        /** Size of each page of results. */
        page?: number;
        /** Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
        sort?: unknown[];
        /** Include vectors in the search results. */
        include_vector?: boolean;
        /** Retrieve items after these sort values in the sort order. */
        after_id?: unknown[];
        /**
         * Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
         *
         *     "tele" matches "Television", "This television is an excellent product…"
         *
         *     Example: "tele"
         */
        query?: string;
        /**
         * Prioritise the result list of documents based on semantic similarity to "query" provided here.
         *
         *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
         *
         *     It can be an object or a list of objects.
         *
         *
         *
         *     Example payloads:
         *
         *     {"field":"animaltype_vector_","query":"kitten"}
         *
         *     [
         *
         *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
         *
         *     ]
         */
        vector_search_query?: unknown;
        /** the workflows version to execute. It could be a tag like production or a version like v1.1.5. */
        version?: string;
        /** The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
        collection?: unknown;
        show_hidden?: boolean;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListWorkflowTypesOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  SearchWorkflowTypes: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["SearchWorkflowTypesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["SearchWorkflowTypesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetWorkflowTypesAsOpenAPI: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetWorkflowTypesAsOpenAPIOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  AggregateWorkflowTypes: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["AggregateWorkflowTypesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AggregateWorkflowTypesInput"];
      };
    };
  };
  /**
   * Admin Endpoint for updating workflow types
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "support:write"
   *     ]
   *   }
   * ]
   */
  BulkUpdateWorkflowTypesAdmin: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkUpdateWorkflowTypesAdminOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkUpdateWorkflowTypesAdminInput"];
      };
    };
  };
  /**
   * Admin Endpoint for updating workflow version aliases
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "support:write"
   *     ]
   *   }
   * ]
   */
  UpdateWorkflowTypesVersionAliasesAdmin: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateWorkflowTypesVersionAliasesAdminOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateWorkflowTypesVersionAliasesAdminInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetWorkflowTypesVersionAliases: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetWorkflowTypesVersionAliasesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetWorkflowTypesVersionAliasesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetWorkflowType: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
      query: {
        /** the workflows version to execute. It could be a tag like production or a version like v1.1.5. */
        version?: string;
        /** The collection(s) to use for the workflow. If not specified, the default collection is used. Cannot use `workflow-registry` with other collections. */
        collection?: unknown;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetWorkflowTypeOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ValidateWorkflowParams: {
    parameters: {
      path: {
        /** ID of workflow */
        workflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ValidateWorkflowParamsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ValidateWorkflowParamsInput"];
      };
    };
  };
  /**
   * When inserting the document you can specify your own id for a document by using the field name **"\_id"**.
   *
   *     For specifying your own vector use the suffix (ends with)  **"\_vector\_"** for the field name.
   * e.g. "product\_description\_vector\_"
   *
   *
   *     If inserting many items in a short timespan, use bulkInsert, or set update_schema to false.
   *     Every insert api call temporarily locks and updates the schema, so will slow down with many inserts in quick succession.
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  Insert: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["InsertOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["InsertInput"];
      };
    };
  };
  /**
   * Insert one or more documents.
   *
   * This method is the same as [`/insert`](/reference/insert) but provides support for more than one document to be inserted at a time.
   *
   * For each insertion, if an `_id` is provided and a document with that ID already exists, all existing field values will be deleted and the new ones will be stored. If no `_id` field is provided, one will automatically be added to the document.
   *
   * This method will entirely replace the documents. If you would like to only partially update a document, use [`/update_where`](/reference/updatewhere).
   *
   * If the document with the provided `_id` doesn't exist, one will be automatically created.
   * If the provided dataset doesn't exist, one will be automatically created.
   *
   * Limit the payload of documents to a maximum 100MB for optimal performance.
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  BulkInsert: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkInsertOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkInsertInput"];
      };
    };
  };
  /**
   * specify a list of file paths. For each file path, a url upload_url is returned. files can be POSTed on upload_url to upload them. They can then be accessed on url. Upon dataset deletion, these files will be deleted.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetFileUploadUrlsForDataset: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetFileUploadUrlsForDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetFileUploadUrlsForDatasetInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetTemporaryFileUploadUrl: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetTemporaryFileUploadUrlOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetTemporaryFileUploadUrlInput"];
      };
    };
  };
  /**
   * Return up to 1000 files uploaded for a dataset.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListFileUploadsForDataset: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFileUploadsForDatasetOutput"];
        };
      };
    };
  };
  /**
   * Bulk insert a large number of documents by downloading a file using "download url". This bypasses the need to directly send documents to the api, as happens in BulkInsert.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ParseBlob: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ParseBlobOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ParseBlobInput"];
      };
    };
  };
  /**
   * Copy a dataset from another users projects into your project. This is considered a project job.
   *
   * ### Required permissions
   * > []
   */
  CopyForeignDataset: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CopyForeignDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CopyForeignDatasetInput"];
      };
    };
  };
  /**
   * Creates a read only key for your project. Make sure to save the api key somewhere safe. When doing a search the admin username should still be used.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "users:write",
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "raw": "*"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateProjectReadKey: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateProjectReadKeyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateProjectReadKeyInput"];
      };
    };
  };
  /**
   * Generate onboarding data.
   *
   * ### Required permissions
   * > []
   */
  GenerateOnboarding: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GenerateOnboardingOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GenerateOnboardingInput"];
      };
    };
  };
  /**
   * Delete a dataset.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteDataset: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDatasetInput"];
      };
    };
  };
  /**
   * A dataset can store documents to be **searched, retrieved, filtered and aggregated** (similar to Collections in MongoDB, Tables in SQL, Indexes in ElasticSearch).
   *
   * A powerful and core feature of VecDB is that you can store both your metadata and vectors in the same document.
   * When specifying the schema of a dataset and inserting your own vector use the suffix (ends with) **"\_vector\_"** for the field name, and specify the length of the vector in dataset_schema.
   *
   * For example:
   *
   *     {
   *         "product_image_vector_": 1024,
   *         "product_text_description_vector_" : 128
   *     }
   *
   * These are the field types supported in our datasets: **["text", "numeric", "date", "dict", "chunks", "vector", "chunkvector"]**.
   *
   * For example:
   *
   *     {
   *         "product_text_description" : "text",
   *         "price" : "numeric",
   *         "created_date" : "date",
   *         "product_texts_chunk_": "chunks",
   *         "product_text_chunkvector_" : 1024
   *     }
   *
   * You don't have to specify the schema of every single field when creating a dataset, as VecDB will automatically detect the appropriate data type for each field (vectors will be automatically identified by its **"\_vector\_"** suffix). Infact you also don't always have to use this endpoint to create a dataset as **\/datasets/bulk_insert** will infer and create the dataset and schema as you insert new documents.
   *
   * Note:
   *  * A dataset name/id can only contain undercase letters, dash, underscore and numbers.
   *  * "\_id" is reserved as the key and id of a document.
   *  * Once a schema is set for a dataset it cannot be altered. If it has to be altered, utlise the copy dataset endpoint.
   *
   * For more information about vectors check out the 'Vectorizing' section, **\/services/search/vector** or out blog at [https://tryrelevance.com/blog](https://tryrelevance.com/blog).
   * For more information about chunks and chunk vectors check out **\/services/search/chunk**.
   *
   *
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateDataset: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDatasetInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetSchema: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetSchemaOutput"];
        };
      };
    };
  };
  /**
   * List all datasets in a project that you are authorized to read/write.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": []
   *   }
   * ]
   */
  ListDatasets: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDatasetsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_ids"
   *       }
   *     ]
   *   },
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "new_dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CombineDatasets: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CombineDatasetsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CombineDatasetsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetCombineJobStatus: {
    parameters: {
      path: {
        /** ID of job */
        job_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetCombineJobStatusOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetCombineJobStatusInput"];
      };
    };
  };
  /**
   * Search all datasets in a project that you are authorized to read/write.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": []
   *   }
   * ]
   */
  SearchDatasets: {
    parameters: {
      query: {
        /** Any string that belongs to part of a dataset name. */
        query?: string;
        /** DEPRECATED  - this wont work Sort by created at date. By default shows the newest datasets. Set asc=False to get oldest dataset. */
        sort_by_created_date?: boolean;
        /** DEPRECATED - this wont work Whether to sort results by ascending or descending order */
        asc?: boolean;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["SearchDatasetsOutput"];
        };
      };
    };
  };
  /**
   * Gives you a summary of the health of your vectors, e.g. how many documents with vectors are missing, how many documents with zero vectors
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetFieldHealth: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetFieldHealthOutput"];
        };
      };
    };
  };
  /**
   * View the usage statistics of a dataset.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetDatasetStats: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDatasetStatsOutput"];
        };
      };
    };
  };
  /**
   * DEPRECATED !!!! Retrieve the mapping of vectors generated through fields, dictionary, array, etc
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetVectorMappings: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetVectorMappingsOutput"];
        };
      };
    };
  };
  /**
   * Returns a page of datasets and in detail the dataset's associated information that you are authorized to read/write. The information includes:
   *
   * | Information      | Description |
   * | ----------- | ----------- |
   * | schema      | Data schema of a dataset. (returns same data as **\/dataset/{dataset_id}/schema**) |
   * | metadata   | Metadata of a dataset. (returns same data as **\/dataset/{dataset_id}/metadata**) |
   * | stats   | Statistics of number of documents and size of a dataset. (returns same data as **\/dataset/{dataset_id}/monitor/stats**) |
   * | vector_health   | Number of zero vectors stored. (returns same data as **\/dataset/{dataset_id}/monitor/health**) |
   * | schema_stats   | Fields and number of documents missing/not missing for that field. (returns same data as **\/dataset/{dataset_id}/monitor/stats**) |
   * | active_jobs   | All active jobs/tasks on the dataset. (returns same data as **\/dataset/{dataset_id}/tasks/list**) |
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetDatasetDetails: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDatasetDetailsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetDatasetDetailsInput"];
      };
    };
  };
  /**
   * Retrieve a document by its `_id`.
   *
   * This is the most performant method to get a document or check if it exists, faster than filtering a dataset for by an `_id`.
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetDocument: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
      query: {
        /** Retrieve document with matching _id. */
        id?: string;
        /** Include vectors in the search results */
        include_vector?: boolean;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDocumentOutput"];
        };
      };
    };
  };
  /**
   * Delete a document by its `_id` and remove it from the dataset.
   *
   * Support for deleting many documents at once is available through [`/bulk_delete`](/reference/bulk_delete_api_datasets__dataset_id__documents_bulk_delete_post).
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteDocument: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDocumentOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDocumentInput"];
      };
    };
  };
  /**
   * Retreives settings for dataset.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetDatasetSettings: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDatasetSettingsOutput"];
        };
      };
    };
  };
  /**
   * Add and overwrite settings about a dataset. Notably description, data source, etc.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpsertDatasetSettings: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpsertDatasetSettingsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpsertDatasetSettingsInput"];
      };
    };
  };
  /**
   * Retreives metadata about a dataset. Notably description, data source, etc
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetDatasetMetadata: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetDatasetMetadataOutput"];
        };
      };
    };
  };
  /**
   * Retreives metadata about a dataset. Notably description, data source, etc
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpsertDatasetMetadata: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpsertDatasetMetadataOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpsertDatasetMetadataInput"];
      };
    };
  };
  /**
   * Update an existing document by providing its `_id` and an object containing the new field values.
   *
   * This method supports a partial update so you may add new fields or update existing ones. It will not overwrite the entire existing document.
   *
   * If the provided `_id` has no matching document in the dataset, a new document will be created. Likewise, if the provided `dataset_id` does not match a dataset in your project a new one will be created.
   *
   * Support for updating many documents at once with a filter condition is available through [`/update_where`](/reference/updatewhere).
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  Update: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateInput"];
      };
    };
  };
  /**
   * Delete fields in a document in a dataset by its id.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteDocumentFields: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteDocumentFieldsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteDocumentFieldsInput"];
      };
    };
  };
  /**
   * Edits documents by providing a key value pair of fields you are adding or changing, make sure to include the "_id" in the documents.
   *
   *     If updating many items in a short timespan, please use BulkUpdate.
   *
   *     Every update api call temporarily locks and updates the schema, so will slow down with many updates in quick succession.
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  BulkUpdate: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkUpdateOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkUpdateInput"];
      };
    };
  };
  /**
   * Update fields in all existing documents that match a filter condition.
   *
   * This method supports a partial update so you may add new fields or update only those you need. Other fields will remain unaffected.
   *
   * If the provided `dataset_id` does not match a dataset in your project, a new one will be created.
   *
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  UpdateWhere: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateWhereOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateWhereInput"];
      };
    };
  };
  /**
   * Append tags to tag field.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  AppendTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["AppendTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["AppendTagsInput"];
      };
    };
  };
  /**
   * Delete tags from tag field by tag value. tag field can be in format ["cat"], or [{"label":"cat"}]
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteTagsInput"];
      };
    };
  };
  /**
   * Delete tags from tag field by tag value. tag field can be in format ["cat"], or [{"label":"cat"}]. tags_to_merge should look like {"dog":"pet","cat":"pet"}
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  MergeTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["MergeTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["MergeTagsInput"];
      };
    };
  };
  /**
   * Perform all tagging operations on a field in one payload.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  EditTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["EditTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["EditTagsInput"];
      };
    };
  };
  /**
   * Takes a high level aggregation of every field, return their unique values and frequencies. This is used to help create the filter bar for search.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListFacets: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFacetsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListFacetsInput"];
      };
    };
  };
  /**
   * Retrieve documents with filters.
   * afterId is provided to retrieve even more documents. Loop through it to retrieve all documents in the database.
   * Filter is used to retrieve documents that match the conditions set in a filter query.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  GetWhere: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetWhereOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["GetWhereInput"];
      };
    };
  };
  /**
   * Retrieve documents with filters.
   * afterId is provided to retrieve even more documents. Loop through it to retrieve all documents in the database.
   * Filter is used to retrieve documents that match the conditions set in a filter query.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  PaginateDocuments: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["PaginateDocumentsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PaginateDocumentsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read",
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CreateDatasetSummary: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDatasetSummaryOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDatasetSummaryInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListDatasetSummaryHistory: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
      query: {
        filters?: (Partial<{
          /** @description Match where document[field] is in value list. */
          match?: {
            /** @description If matching on text, match even if there are extra words / case insensitivity */
            fuzzy?: boolean;
            /** @description Field to match on. */
            field?: string;
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          matchArray?: {
            field: string;
            value: unknown[];
          };
          random?: {
            size: number;
          };
          /** @description Match where document._id is in value list. */
          matchIds?: {
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
          range?: {
            /** @description Field to match on. */
            field?: string;
            greaterThan?: unknown;
            lessThan?: unknown;
            greaterThanOrEqualTo?: unknown;
            lessThanOrEqualTo?: unknown;
          };
          /**
           * @description
           * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
           *
           * Possible matching patterns:
           *
           * * - documents where the field has any value
           * ? - documents where a single character from the field matches the provided values
           *
           * Example:
           *
           * {
           *   wildcard: {
           *      field: "title",
           *      value: [ "Avenger*" ]
           *   }
           * }
           */
          wildcard?: {
            /** @description Field to match on. */
            field?: string;
            /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
            value: unknown;
          };
          /** @description hybrid search query that must reach a certain value to filter */
          search?: {
            /**
             * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
             *
             *     "tele" matches "Television", "This television is an excellent product…"
             *
             *     Example: "tele"
             */
            query?: string;
            /** @description Configuration for traditional search query. */
            queryConfig?: {
              /**
               * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
               * @default 1
               */
              weight?: number;
              /**
               * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
               *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
               * @default 1
               */
              sentenceWeight?: number;
              /**
               * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
               *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
               * @default 1
               */
              fuzzyWeight?: number;
            };
            /**
             * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
             *
             *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
             *
             *     It can be an object or a list of objects.
             *
             *
             *
             *     Example payloads:
             *
             *     {"field":"animaltype_vector_","query":"kitten"}
             *
             *     [
             *
             *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
             *
             *     ]
             */
            vectorSearchQuery?: unknown;
            realtimeClustering?: {
              /** @default 4 */
              nClusters?: number;
              /** @default kmeans-realtime-4 */
              alias?: string;
              vectorField: string;
              /** @default _cluster_.{vector_field}.{alias} */
              outputField?: string;
            };
            /**
             * @description A list of fields to search using the "query" parameter.
             *
             *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
             *
             *     Default behaviour is to search all fields.
             *
             *     Example: ["name",{"field":"favourite_color","weight":0.2}]
             */
            fieldsToSearch?: unknown[];
            /**
             * @description Only return documents with a _relevance above this threshold.
             *
             *     Example: 0.3
             */
            minimumRelevance: number;
          };
          /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
          fieldExists?: {
            /** @description Field that must exist. */
            field?: string;
          };
          /** @description Match documents where doc[field] % module == value */
          matchModulo?: {
            /** @default _id */
            field?: string;
            modulo: number;
            value: number;
          };
          /** @description Filter down to one document for each value of selected field. */
          dedupeByValue?: {
            /** @description Field to filter on. */
            field: string;
          };
          /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
          selfreference?: {
            /** @description First field in comparison. */
            a: string;
            /** @description Second field in comparison. */
            b: string;
            /** @description Operator used to compare a and b. */
            operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
          };
          /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
          wordCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum word count. */
            greaterThan?: number;
            /** @description Maximum word count. */
            lessThan?: number;
          };
          /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
          characterCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum character count. */
            greaterThan?: number;
            /** @description Maximum character count. */
            lessThan?: number;
          };
          /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
          or?: unknown[];
          /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
          not?: unknown;
          /** @description Filter based on data within a _chunk_ field. */
          chunk?: {
            /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
            path: string;
            filters: unknown[];
          };
        }> &
          Partial<{
            strict?: "must" | "should" | "must_or";
            condition?: string;
            case_insensitive?: boolean;
            field?: string;
            filter_type?:
              | "text_match"
              | "word_match"
              | "term"
              | "terms"
              | "text"
              | "texts"
              | "match"
              | "contains"
              | "substring"
              | "class"
              | "category"
              | "exact_match"
              | "classes"
              | "categories"
              | "exists"
              | "traditional"
              | "fuzzy"
              | "regexp"
              | "ids"
              | "date"
              | "numeric"
              | "search"
              | "or"
              | "word_count"
              | "character_count"
              | "dedupe_by_value"
              | "match_array"
              | "random";
            condition_value?: unknown;
            fuzzy?: number;
            join?: boolean;
          }>)[];
        /** Fields to include in the search results, empty array/list means all fields. */
        select_fields?: string[];
        /** Size of each page of results. */
        page_size?: number;
        /** Size of each page of results. */
        page?: number;
        /** Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
        sort?: unknown[];
        /** Include vectors in the search results. */
        include_vector?: boolean;
        /** Retrieve items after these sort values in the sort order. */
        after_id?: unknown[];
        /**
         * Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
         *
         *     "tele" matches "Television", "This television is an excellent product…"
         *
         *     Example: "tele"
         */
        query?: string;
        /**
         * Prioritise the result list of documents based on semantic similarity to "query" provided here.
         *
         *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
         *
         *     It can be an object or a list of objects.
         *
         *
         *
         *     Example payloads:
         *
         *     {"field":"animaltype_vector_","query":"kitten"}
         *
         *     [
         *
         *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
         *
         *     ]
         */
        vector_search_query?: unknown;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDatasetSummaryHistoryOutput"];
        };
      };
    };
  };
  /**
   * Retrieve documents by their IDs ("_id" field). This will retrieve the documents faster than a filter applied on the "_id" field. For single id lookup version of this request use /datasets/{dataset_id}/documents/get.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  BulkGetDocuments: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkGetDocumentsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkGetDocumentsInput"];
      };
    };
  };
  /**
   * Delete a list of documents by their IDs. For deleting a single document refer to /datasets/{dataset_id}/documents/delete or deleting documents by filters refer to /datasets/{dataset_id}/documents/delete_where.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  BulkDeleteDocuments: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkDeleteDocumentsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkDeleteDocumentsInput"];
      };
    };
  };
  /**
   * Retrieve documents with filters.
   * afterId is provided to retrieve even more documents. Loop through it to retrieve all documents in the database.
   * Filter is used to retrieve documents that match the conditions set in a filter query.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListDocuments: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
      query: {
        filters?: (Partial<{
          /** @description Match where document[field] is in value list. */
          match?: {
            /** @description If matching on text, match even if there are extra words / case insensitivity */
            fuzzy?: boolean;
            /** @description Field to match on. */
            field?: string;
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          matchArray?: {
            field: string;
            value: unknown[];
          };
          random?: {
            size: number;
          };
          /** @description Match where document._id is in value list. */
          matchIds?: {
            /** @description Can be either a single item or a list of items to match on. */
            value: unknown;
          };
          /** @description Match documents where greaterThan < document[field] < lessThan. Supports numbers and date strings. */
          range?: {
            /** @description Field to match on. */
            field?: string;
            greaterThan?: unknown;
            lessThan?: unknown;
            greaterThanOrEqualTo?: unknown;
            lessThanOrEqualTo?: unknown;
          };
          /**
           * @description
           * Match documents where the field either contains the value as a substring, or matches a provided matching pattern.
           *
           * Possible matching patterns:
           *
           * * - documents where the field has any value
           * ? - documents where a single character from the field matches the provided values
           *
           * Example:
           *
           * {
           *   wildcard: {
           *      field: "title",
           *      value: [ "Avenger*" ]
           *   }
           * }
           */
          wildcard?: {
            /** @description Field to match on. */
            field?: string;
            /** @description single string or array of valid wildcard strings to match on, for example ['tele*'] */
            value: unknown;
          };
          /** @description hybrid search query that must reach a certain value to filter */
          search?: {
            /**
             * @description Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
             *
             *     "tele" matches "Television", "This television is an excellent product…"
             *
             *     Example: "tele"
             */
            query?: string;
            /** @description Configuration for traditional search query. */
            queryConfig?: {
              /**
               * @description Increases or decreases the impact of all traditional search matching when calculating a documents _relevance.
               * @default 1
               */
              weight?: number;
              /**
               * @description Increases or decreases the impact of sentence matching when calculating a documents _relevance.
               *         For example, with query "A fox jumped", with high sentence weight, 'A fox jumped over the' would match before 'jumped a fox over fox'
               * @default 1
               */
              sentenceWeight?: number;
              /**
               * @description Increases or decreases the impact of fuzzy matching when calculating a documents _relevance.
               *         For example, with query "rain", with 0 fuzzy weight, 'brain' would not match.
               * @default 1
               */
              fuzzyWeight?: number;
            };
            /**
             * @description Prioritise the result list of documents based on semantic similarity to "query" provided here.
             *
             *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
             *
             *     It can be an object or a list of objects.
             *
             *
             *
             *     Example payloads:
             *
             *     {"field":"animaltype_vector_","query":"kitten"}
             *
             *     [
             *
             *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
             *
             *     ]
             */
            vectorSearchQuery?: unknown;
            realtimeClustering?: {
              /** @default 4 */
              nClusters?: number;
              /** @default kmeans-realtime-4 */
              alias?: string;
              vectorField: string;
              /** @default _cluster_.{vector_field}.{alias} */
              outputField?: string;
            };
            /**
             * @description A list of fields to search using the "query" parameter.
             *
             *     Each item can be field name as a string, or an object with 'field' as field name and optional parameters such as field weight.
             *
             *     Default behaviour is to search all fields.
             *
             *     Example: ["name",{"field":"favourite_color","weight":0.2}]
             */
            fieldsToSearch?: unknown[];
            /**
             * @description Only return documents with a _relevance above this threshold.
             *
             *     Example: 0.3
             */
            minimumRelevance: number;
          };
          /** @description Match documents where field specified by 'field' exists in the document. for nested fields, use syntax: a.b.c */
          fieldExists?: {
            /** @description Field that must exist. */
            field?: string;
          };
          /** @description Match documents where doc[field] % module == value */
          matchModulo?: {
            /** @default _id */
            field?: string;
            modulo: number;
            value: number;
          };
          /** @description Filter down to one document for each value of selected field. */
          dedupeByValue?: {
            /** @description Field to filter on. */
            field: string;
          };
          /** @description Match documents where document[a] <=/>=/</>/==/!=/stringEquals document[b]. Use stringEquals to compare strings. */
          selfreference?: {
            /** @description First field in comparison. */
            a: string;
            /** @description Second field in comparison. */
            b: string;
            /** @description Operator used to compare a and b. */
            operation: "<=" | ">=" | "<" | ">" | "==" | "!=" | "stringEquals";
          };
          /** @description Match documents where greaterThan < wordCount(document[field]) < lessThan. */
          wordCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum word count. */
            greaterThan?: number;
            /** @description Maximum word count. */
            lessThan?: number;
          };
          /** @description Match documents where greaterThan < characterCount(document[field]) < lessThan. */
          characterCount?: {
            /** @description Field to match on. */
            field: string;
            /** @description Minimum character count. */
            greaterThan?: number;
            /** @description Maximum character count. */
            lessThan?: number;
          };
          /** @description Used to perform a logical OR of filters. each element of the OR list can itself be a list  to perform a nested AND. {or:[[A,B],C]} is equivalent to (A AND B) OR C */
          or?: unknown[];
          /** @description Used to perform NOT filter. Can be a single filter or a list of filters to perform a !(AND). {not:[A,B]} is equivalent to !(A AND B) */
          not?: unknown;
          /** @description Filter based on data within a _chunk_ field. */
          chunk?: {
            /** @description The path of the chunk field to filter on. For example: description_sentences_chunk_ */
            path: string;
            filters: unknown[];
          };
        }> &
          Partial<{
            strict?: "must" | "should" | "must_or";
            condition?: string;
            case_insensitive?: boolean;
            field?: string;
            filter_type?:
              | "text_match"
              | "word_match"
              | "term"
              | "terms"
              | "text"
              | "texts"
              | "match"
              | "contains"
              | "substring"
              | "class"
              | "category"
              | "exact_match"
              | "classes"
              | "categories"
              | "exists"
              | "traditional"
              | "fuzzy"
              | "regexp"
              | "ids"
              | "date"
              | "numeric"
              | "search"
              | "or"
              | "word_count"
              | "character_count"
              | "dedupe_by_value"
              | "match_array"
              | "random";
            condition_value?: unknown;
            fuzzy?: number;
            join?: boolean;
          }>)[];
        /** Fields to include in the search results, empty array/list means all fields. */
        select_fields?: string[];
        /** Size of each page of results. */
        page_size?: number;
        /** Size of each page of results. */
        page?: number;
        /** Fields to sort by. For each field, sort by descending or ascending. If you are using descending by datetime, it will get the most recent ones. */
        sort?: unknown[];
        /** Include vectors in the search results. */
        include_vector?: boolean;
        /** Retrieve items after these sort values in the sort order. */
        after_id?: unknown[];
        /**
         * Search for documents that contain this query string in your dataset. Use fieldsToSearch parameter to restrict which fields are searched.
         *
         *     "tele" matches "Television", "This television is an excellent product…"
         *
         *     Example: "tele"
         */
        query?: string;
        /**
         * Prioritise the result list of documents based on semantic similarity to "query" provided here.
         *
         *     For example if field "animaltype_vector_" contains encoded vector values for "cat", lion, "dog","bird", and "query" is set to "kitten", documents with "cat", "lion" will be returned first in the results list.
         *
         *     It can be an object or a list of objects.
         *
         *
         *
         *     Example payloads:
         *
         *     {"field":"animaltype_vector_","query":"kitten"}
         *
         *     [
         *
         *     {"field":"animaltype_vector_","query":"kitten","weight":1","model":"text"}, {"field":"animaltype_vector_","query":"https://www.dogimage.com/dogimage.png","model":"image","weight":2}
         *
         *     ]
         */
        vector_search_query?: unknown;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDocumentsOutput"];
        };
      };
    };
  };
  /**
   * Delete documents that match on a filters. At least one filter must be provided.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  DeleteWhere: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteWhereOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteWhereInput"];
      };
    };
  };
  /**
   * SimpleSearch is an easy way to use vector search and traditional text matching to search your dataset. It also supports filtering, sorting and aggregating results.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  SimpleSearchPost: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["SimpleSearchPostOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["SimpleSearchPostInput"];
      };
    };
  };
  /**
   * SimpleSearch is an easy way to use vector search and traditional text matching to search your dataset. It also supports filtering, sorting and aggregating results.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  Search: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["SearchOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["SearchInput"];
      };
    };
  };
  /**
   * Recommend documents similar to specific documents. Specify which vector field must be used for recommendation using  the documentsToRecommend property.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  Recommend: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["RecommendOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["RecommendInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   },
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "new_dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  CloneDataset: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CloneDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CloneDatasetInput"];
      };
    };
  };
  /**
   * Predict using KNN regression.
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "body": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  PredictKNNRegression: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["PredictKNNRegressionOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PredictKNNRegressionInput"];
      };
    };
  };
  /**
   * Predict using KNN regression from search results.
   *
   * ### Required permissions
   * > []
   */
  PredictKNNFromResults: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["PredictKNNFromResultsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["PredictKNNFromResultsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  BiasEvaluation: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BiasEvaluationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BiasEvaluationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  Vectorize: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["VectorizeOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["VectorizeInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  VectorizeAndInsert: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["VectorizeAndInsertOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["VectorizeAndInsertInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:write"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  VectorizeField: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["VectorizeFieldOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["VectorizeFieldInput"];
      };
    };
  };
  /**
   * Get workflow history grouped by fields
   *
   * ### Required permissions
   * > [
   *   {
   *     "actions": [
   *       "datasets:read"
   *     ],
   *     "datasets": [
   *       {
   *         "params": "dataset_id"
   *       }
   *     ]
   *   }
   * ]
   */
  ListDatasetWorkflowsByFields: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
      query: {
        /** Currently limited to exact_match, ids, exists, regexp filter_type */
        filters?: {
          strict?: "must" | "should" | "must_or";
          condition?: string;
          case_insensitive?: boolean;
          field?: string;
          filter_type?:
            | "text_match"
            | "word_match"
            | "term"
            | "terms"
            | "text"
            | "texts"
            | "match"
            | "contains"
            | "substring"
            | "class"
            | "category"
            | "exact_match"
            | "classes"
            | "categories"
            | "exists"
            | "traditional"
            | "fuzzy"
            | "regexp"
            | "ids"
            | "date"
            | "numeric"
            | "search"
            | "or"
            | "word_count"
            | "character_count"
            | "dedupe_by_value"
            | "match_array"
            | "random";
          condition_value?: unknown;
          fuzzy?: number;
          join?: boolean;
        }[];
        fields?: string[];
        /** Size of each page of results. */
        page?: number;
        /** Size of each page of results. */
        page_size?: number;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDatasetWorkflowsByFieldsOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetAPIHealth: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetAPIHealthOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteFieldChildren: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of fieldchildren */
        fieldchildren_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteFieldChildrenOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteFieldChildrenInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListFieldChildrens: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFieldChildrensOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListFieldChildrensInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateFieldChildren: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of fieldchildren */
        fieldchildren_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateFieldChildrenOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateFieldChildrenInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteFavouriteWorkflow: {
    parameters: {
      path: {
        /** ID of favouriteworkflow */
        favouriteworkflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteFavouriteWorkflowOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteFavouriteWorkflowInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListFavouriteWorkflows: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFavouriteWorkflowsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListFavouriteWorkflowsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateFavouriteWorkflow: {
    parameters: {
      path: {
        /** ID of favouriteworkflow */
        favouriteworkflow_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateFavouriteWorkflowOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateFavouriteWorkflowInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteSavedFilter: {
    parameters: {
      path: {
        /** ID of savedfilter */
        savedfilter_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteSavedFilterOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteSavedFilterInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListSavedFilters: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListSavedFiltersOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListSavedFiltersInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateSavedFilter: {
    parameters: {
      path: {
        /** ID of savedfilter */
        savedfilter_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateSavedFilterOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateSavedFilterInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetSavedFilter: {
    parameters: {
      path: {
        /** ID of savedfilter */
        savedfilter_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetSavedFilterOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateSavedFilter: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateSavedFilterOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateSavedFilterInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteComponent: {
    parameters: {
      path: {
        /** ID of component */
        component_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteComponentOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteComponentInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListComponents: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListComponentsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListComponentsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateComponent: {
    parameters: {
      path: {
        /** ID of component */
        component_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateComponentOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateComponentInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetComponent: {
    parameters: {
      path: {
        /** ID of component */
        component_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetComponentOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateComponent: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateComponentOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateComponentInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListDatasetEditorHistorys: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListDatasetEditorHistorysOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListDatasetEditorHistorysInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateDatasetEditorHistory: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateDatasetEditorHistoryOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateDatasetEditorHistoryInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListEditorConfigurations: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListEditorConfigurationsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListEditorConfigurationsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateEditorConfiguration: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateEditorConfigurationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateEditorConfigurationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateEditorConfiguration: {
    parameters: {
      path: {
        /** ID of editorconfiguration */
        editorconfiguration_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateEditorConfigurationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateEditorConfigurationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteEditorConfiguration: {
    parameters: {
      path: {
        /** ID of editorconfiguration */
        editorconfiguration_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteEditorConfigurationOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteEditorConfigurationInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetEditorConfiguration: {
    parameters: {
      path: {
        /** ID of editorconfiguration */
        editorconfiguration_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetEditorConfigurationOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListKeyphrases: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListKeyphrasesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListKeyphrasesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateKeyphrase: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
        /** ID of keyphrase */
        keyphrase_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateKeyphraseOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateKeyphraseInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteKeyphrase: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
        /** ID of keyphrase */
        keyphrase_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteKeyphraseOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteKeyphraseInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetKeyphrase: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
        /** ID of keyphrase */
        keyphrase_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetKeyphraseOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  BulkUpdateKeyphrases: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkUpdateKeyphrasesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkUpdateKeyphrasesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  BulkDeleteKeyphrases: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkDeleteKeyphrasesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkDeleteKeyphrasesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListTaxonomys: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListTaxonomysOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListTaxonomysInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateTaxonomy: {
    parameters: {
      path: {
        /** ID of taxonomy */
        taxonomy_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateTaxonomyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateTaxonomyInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteTaxonomy: {
    parameters: {
      path: {
        /** ID of taxonomy */
        taxonomy_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteTaxonomyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteTaxonomyInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetTaxonomy: {
    parameters: {
      path: {
        /** ID of taxonomy */
        taxonomy_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetTaxonomyOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  CreateTaxonomy: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["CreateTaxonomyOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["CreateTaxonomyInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteFavouriteDataset: {
    parameters: {
      path: {
        /** ID of favouritedataset */
        favouritedataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteFavouriteDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteFavouriteDatasetInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListFavouriteDatasets: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFavouriteDatasetsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListFavouriteDatasetsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateFavouriteDataset: {
    parameters: {
      path: {
        /** ID of favouritedataset */
        favouritedataset_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateFavouriteDatasetOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateFavouriteDatasetInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteFavouriteDeployable: {
    parameters: {
      path: {
        /** ID of favouritedeployable */
        favouritedeployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteFavouriteDeployableOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteFavouriteDeployableInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListFavouriteDeployables: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListFavouriteDeployablesOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListFavouriteDeployablesInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateFavouriteDeployable: {
    parameters: {
      path: {
        /** ID of favouritedeployable */
        favouritedeployable_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateFavouriteDeployableOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateFavouriteDeployableInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteUserOnboardingFlag: {
    parameters: {
      path: {
        /** ID of useronboardingflag */
        useronboardingflag_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteUserOnboardingFlagOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteUserOnboardingFlagInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListUserOnboardingFlags: {
    parameters: {};
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListUserOnboardingFlagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListUserOnboardingFlagsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateUserOnboardingFlag: {
    parameters: {
      path: {
        /** ID of useronboardingflag */
        useronboardingflag_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateUserOnboardingFlagOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateUserOnboardingFlagInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetTranscriptTagList: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
        /** ID of transcripttaglist */
        transcripttaglist_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetTranscriptTagListOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  UpdateTranscriptTagList: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
        /** ID of transcripttaglist */
        transcripttaglist_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["UpdateTranscriptTagListOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UpdateTranscriptTagListInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListTranscriptTagLists: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of field */
        field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListTranscriptTagListsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListTranscriptTagListsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  ListTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of tag_field */
        tag_field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["ListTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["ListTagsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  DeleteTag: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of tag_field */
        tag_field: string;
        /** ID of tag */
        tag_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["DeleteTagOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["DeleteTagInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  GetTag: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of tag_field */
        tag_field: string;
        /** ID of tag */
        tag_id: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["GetTagOutput"];
        };
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  BulkDeleteTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of tag_field */
        tag_field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkDeleteTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkDeleteTagsInput"];
      };
    };
  };
  /**
   * ### Required permissions
   * > []
   */
  BulkUpdateTags: {
    parameters: {
      path: {
        /** ID of dataset */
        dataset_id: string;
        /** ID of tag_field */
        tag_field: string;
      };
    };
    responses: {
      /** successful operation */
      200: {
        content: {
          "application/json": components["schemas"]["BulkUpdateTagsOutput"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["BulkUpdateTagsInput"];
      };
    };
  };
}

export interface external {}
