<p align= "center">
    <img src="https://raofin.github.io/r/img/BearBurger/nav-logo.png" title="Logo" alt="Logo" width="500px">
    <br/>
    <b>BearBurger</b> is a web based food management system, built using Spring MVC, Spring Boot, Spring Security, Hibernate with MySQL, Spring Data JPA, JSP, and Maven to manage the dependencies.
</p>

## Features
Customers can browse foods, view details, and explore many other things. However, in order to make a purchase or interact with anything, he must first log in to the system. There are also various features available for administrators. The application is essentially separated into two roles-
* Customer:
    * Login
    * Registration
    * Profile view and modify
    * Browse and search foods
    * Purchase foods
    * Payment with credit card
    * Post comments and replies on each food
* Administrator:
    * Manage user roles
    * Add, remove, and disable users
    * View user and food list
    * Manage foods

## Tools & Technologies
* Java, JSP, HTML, CSS, JavaScript & jQuery
* **Frameworks:** Spring MVC, Spring Boot, Spring Security & Hibernate
* **Database:** MySQL
* **Server:** Apache Tomcat
* **IDE:** IntelliJ IDEA

## How to Run
1. Clone the repository and open it with any Java IDE, like **IntelliJ IDEA**
2. Maven should automatically download the required dependencies
3. Make sure all the dependencies are properly downloaded **(Important!)**
4. Execute the [SQL queries](src/main/resources/database/app.sql) in your MySQL server
5. Run `src\main\java\net\raofin\bearburger\BearBurgerApplication.java`
6. Go to http://localhost:8080

*If you have a different MySQL **username**, **password** or running it on a **different port**, you can modify the project datasource configurations from `src\main\resources\application.properties`.

## Screenshots
<img src="https://raofin.github.io/r/img/BearBurger/(1).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(2).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(3).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(4).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(5).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(6).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(7).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(8).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(9).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(10).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(11).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(12).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(13).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(14).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(15).jpg">
<img src="https://raofin.github.io/r/img/BearBurger/(16).jpg">

## License
This project is licensed under the [MIT License](LICENSE.md).
