### 进程管理

PCB结构

```c
typedef struct task_struct
{
    cpu_context context; 
    volatile long task_state;       //type of state
    unsigned long task_flags;       //type of process
    struct list_head task_list;
    unsigned long kernel_sp;        //save S mode sp
	unsigned long user_sp;          //save U mode sp
    int count;                      //time slice 
    int need_schedule;              //if need to scheduled
    int pid;
    int scramble;                   //if is scramble           
    int priority;
    struct task_struct *next_task;
    struct task_struct *prev_task;
}PCB;
```

创建子进程使用do_fork函数(位于/process/fork.c)

### 进程调度

调度分为自愿调度和抢占调度，抢占调度基于时间片轮转算法

##### 自愿调度：

进程主动调用schedule()(/process/schedule.c)来放弃CPU

过程：

进程调用schedule()->__schedule()寻找一个进程->switch_to切换进程

##### 抢占调度:

定时器中断来临时检查当前进程时间片是否已用完，如果用完则发生进程切换

过程：

定时器中断来临->do_exception_vector中断入口->保存现场->do_exception中断处理->重设定时器->检查是否已经耗尽时间片，如果是则置位标志位need_schedule->ret_from_exception中断准备返回->确定返回到用户层还是内核层->can_preempt检查标志位判断是否可用抢占->preempt_schedule抢占调度->__schedule()寻找进程->switch_to()切换进程->处理进程切换后的工作->恢复中断现场(已经保存的进程上下文)->切换后的进程运行

### 锁相关

sleeplock.c:

睡眠锁，如果要获取已被获取的锁，则当前进程需进入休眠状态，自愿调度

init_sleeplock:初始化睡眠锁

acquire_sleeplock:获取睡眠锁

release_sleeplock：释放睡眠锁

holding_sleeplock:检查是否已经持有锁

spinlock.c:

自旋锁，如果要获取已被获取的锁，则进入忙等待，空耗CPU

spin_init:自旋锁初始化

spin_lock:获取锁

spin_unlock释放锁