import { type IconTheme } from './IconsCommonTypes'

function Loader(theme: IconTheme | undefined = undefined) {
  return (
    <svg
      width={theme && theme.width ? theme.width : '44'}
      height={theme && theme.height ? theme.height : '44'}
      viewBox="0 0 44 44"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M20.1666 7.46163V3.7583C16.4816 4.12497 13.1266 5.59163 10.4133 7.80997L13.0166 10.4316C15.0516 8.85497 17.49 7.79163 20.1666 7.46163ZM33.5866 7.80997C30.8733 5.59163 27.5183 4.12497 23.8333 3.7583V7.46163C26.51 7.79163 28.9483 8.85497 30.9833 10.4316L33.5866 7.80997ZM36.5383 20.1666H40.2416C39.875 16.4816 38.4083 13.1266 36.19 10.4133L33.5683 13.0166C35.145 15.0516 36.2083 17.49 36.5383 20.1666ZM10.4316 13.0166L7.80997 10.4133C5.59163 13.1266 4.12497 16.4816 3.7583 20.1666H7.46163C7.79163 17.49 8.85497 15.0516 10.4316 13.0166ZM7.46163 23.8333H3.7583C4.12497 27.5183 5.59163 30.8733 7.80997 33.5866L10.4316 30.965C8.85497 28.9483 7.79163 26.51 7.46163 23.8333ZM33.5683 30.9833L36.19 33.605C38.4083 30.8916 39.875 27.5183 40.2416 23.8516H36.5383C36.2083 26.51 35.145 28.9483 33.5683 30.9833ZM23.8333 36.5383V40.2416C27.5183 39.875 30.8733 38.4083 33.5866 36.19L30.965 33.5683C28.9483 35.145 26.51 36.2083 23.8333 36.5383ZM10.4133 36.19C13.1266 38.4083 16.5 39.875 20.1666 40.2416V36.5383C17.49 36.2083 15.0516 35.145 13.0166 33.5683L10.4133 36.19Z"
        id="Loader"
        fill={theme && theme.color ? theme.color : 'var(--color-icon)'}
      />
    </svg>
  )
}

export default Loader
