# 🙌Aweseome Civil Engineering 🙌

[List of Contributors](contributing.md) ||
[Edit/Update the list](https://github.com/QuantumNovice/awesome-civil-engineering)





This is a list of softwares and resource used in civil engineering practice.  



## Content

* [Reporting & Documentation](#reporting-and-documentation)
* [Water Resources](#water-resources-drainage)
* [Structure Analysis and Design Software](#structure-analysis-and-design-software)
* [Structural Simulation Software](#structural-simulation-software)
* [GeoTechnical Engineering](#geotechnical-engineering)
* [Transportation Engineering](#transportation-engineering)
* [Environmental Engineering](#environmental-engineering)
* [Calculations](#calculations)
* [Web Calculators](#web-calculators)
* [Drafting](#drafting)
* [3D Modelling](#3d-modelling)
* [GIS](#gis)
* [Project Management](#project-management)
* [Spreadsheet](#Spreadsheet)
* [Programming Libraries](#programming-libraries)
  * [Python](#python)
  * [JavaScript](#javaScript)
  * [Rust](#rust)
  * [C#](#C#)
* [Machine Learning](#machine-learning)



## Reporting and Documentation

- Microsoft Word
- Latex
- Phantom PDF
- Autodesk Revit (Autodesk)
- Bluebeam Revu (Bluebeam, Inc.)
- Procore (Procore Technologies)
- PlanGrid (Autodesk)
- Newforma Project Center (Newforma, Inc.)
- Microsoft Project (Microsoft Corporation)
- Asana (Asana, Inc.)
- Trello (Atlassian)
- BIM 360 (Autodesk)
- CoConstruct (CoConstruct, LLC)

## Water Resources-Drainage

- EPA SWMM - Urban drainage modeling software developed by the Environmental Protection Agency (EPA)
- HEC-RAS - River hydraulic modeling software developed by the US Army Corps of Engineers (USACE)
- [WaterGEMS](https://www.bentley.com/en/products/product-line/water-and-wastewater) - A hydraulic and water quality modeling software for water distribution systems.
- [EPANET](https://www.epa.gov/water-research/epanet) - An open-source software tool for the analysis of water distribution systems.
- [TUFLOW](https://www.tuflow.com/) - Hydrodynamic and hydraulic modeling software for floodplain management
- HydroCAD - Stormwater management and hydraulic modeling software
- XP-SWMM - Urban drainage modeling software
- HEC-HMS - Hydrologic modeling software developed by the US Army Corps of Engineers (USACE)
- MIKE FLOOD - Flood modeling software developed by DHI
- Infoworks ICM - Integrated water management software
- PCSWMM - Stormwater management software
- i-Water Flow - Integrated water management software.
- ICPR - A Hydraulic/Ground Water Modelling Software by Streamline Technologies
- [InfoWater](https://www.autodesk.com/products/infowater-pro/overview) - A software to model water distribution systems in an easy-to-use GIS interface.
- [CE-QUAL-W2](http://www.ce.pdx.edu/w2/) - A 2D water quality and hydrodynamic modelling  for rivers, estuaries, lakes, reservoirs and river basin systems.
## Structure Analysis and Design Software 

- SAP2000 (Computer and Structures, Inc.)
- ETABS (Computers and Structures, Inc.)
- Tekla Structural Designer 2020
- Autodesk Robot Structure Analysis
- Prokon (PROKON Structural Analysis and Design)
- TEKLA Structures (Trimble Solutions)
- Midas Civil (Midas Information Technology)
- SCIA Engineer (SCIA)
- RAM Structural System (Bentley Systems)
- [STAAD.Pro V8i](https://www.bentley.com/en/products/product-line/structural-analysis-design/staadpro) - A comprehensive structural analysis and design software that offers a free trial period.
- [RISA-3D](https://risa3d.com/) - A free 3D structural analysis software for building and bridge design.
- [Dlubal RFEM](https://www.dlubal.com/en/products/rfem-fea-software/what-is-rfem) - A 3D finite element analysis software for structural analysis and design of membrane and tensile structures as well as for plant and mechanical engineering or dynamic analysis.
- [SpaceGASS](https://spacegass.com/) - Amulti-purpose 3D analysis and design program for structural engineers for analysis of beams, trusses and frames to buildings, towers, tanks, cable structures and bridges. 

## Structural Simulation Software

- ANSYS - Multi-physics simulation software
- ABAQUS - Finite Element Analysis (FEA) software
- Autodesk Robot Structural Analysis Professional
- LS-DYNA - Dynamic and non-linear simulation software
- ETABS - Building analysis and design software
- SAP2000 - Structural analysis and design software
- MIDAS - Structural analysis and design software
- [SCIA Engineer](https://www.scia.net/en/products/scia-engineer) - A versatile structural analysis software for design and engineering of all types of structures. It offers a free demo version.- Prokon - Structural analysis and design software
- RAM Structural System - Building analysis and design software.
- [ArchCalc](http://www.archcalc.com/) - A free, easy-to-use, online structural analysis calculator for architects, engineers, and construction professionals.

## GeoTechnical Engineering

- LPile - A special-purposeprogram based on rational procedures for analyzing a pile under lateral loading using the p-y method
- PLAXIS - Finite Element Analysis Software
- FLAC - Fast Lagrangian Analysis of Continua
- SLOPE/W - Slope Stability Analysis Software
- FLOW-3D - 3D Hydro-Geological Modeling Software
- SEEP/W - Seepage and Steady-State Flow Analysis  Software
- SIGMA/W - Stress-Deformation Analysis Software
- GeoStudio - Geotechnical Modeling Software
- GINT - Geotechnical Information System
- TALREN - Terrain Analysis and Engineering Software
- SoilVision Systems - Soil Mechanics and Geotechnical Modeling Software.
- [UDEC](https://www.itascacg.com/software/new-in-udec-7-0) - A Discrete Element Method program that is often used by to model rock and for detailed analysis of Unreinforced Masonry.
- [Carlson Geotech](https://www.carlsones.com/product/carlson-geotech/)  



## Transportation Engineering
- Synchro - Traffic Signal Timing and Analysis Software
- VISSIM - Microscopic Traffic Simulation Software
- AIMSUN - Microscopic and Mesoscopic Traffic Simulation Software
- TransModeler - Traffic Simulation Software
- Paramics - Microscopic Traffic Simulation Software
- HCS - Highway Capacity Software
- CORSIM - Traffic Simulation Software
- SIDRA INTERSECTION - Intersection Capacity and Level of Service Analysis Software
- PTV Vistro - Traffic Engineering and Analysis Software
- TransCAD - GIS-based Transportation Planning and Modeling Software
- [GuideSign](https://www.transoftsolutions.com/signage/guidesign/) - Powerful CAD Software for Designing Roadway and Highway Signs in Minutes
- [AutoTurn](https://www.transoftsolutions.com/emea/vehicle-swept-path/software/autoturn/) - Analyze and Design Highway Infrastructure such as intersections, roundabouts, bus terminals, loading bays, parking lots or any on/off-street assignments involving vehicle access checks, clearances, vehicle tracking and swept path maneuvers.
- [OpenRoads](https://www.bentley.com/software/openroads-conceptstation/) - OpenRoads enables engineer to create conceptual road and bridge designs.
- [MX Roads](https://communities.bentley.com/products/road___site_design/w/road_and_site_design__wiki/7147/steps-to-download-the-software-bentley-mx-v8i-from-select-server-tn) - An advanced, string-based modeling tool that enables rapid and accurate design of all road types
- [Carlson Civil](https://www.carlsones.com/product/carlson-civil/) - A complete CAD-based, design software for highways and a wide variety of land development projects.
- [RoadEng Civil Engineer](www.softree.com) -  A geometric road and site design software for design of rural roads and highways, access roads, pipelines, streams, bridge site design, culvert replacements and earthwork calculations. 

## Calculations
- [SMath Studio](https://en.smath.com/view/SMathStudio/summary) - A freeware, closed-source, mathematical notebook program for calculations.
- [MathCAD](https://www.mathcad.com/en) - A program for the verification, validation, documentation and re-use of mathematical calculations in engineering.
- [Blockpad](https://blockpad.net/) - A program where engineers can create dynamic calculation documents that work like a spreadsheet.
- [EngineeringPaper.xyz](https://engineeringpaper.xyz) - A free and open-source program for engineering calculations that runs in the browser.
- MATLAB - Numerical computing software developed by - - MathWorks
- Octave - Free and open-source alternative to MATLAB
- R - Programming language for statistical computing and data analysis
- Mathematica - Technical computing software developed by Wolfram Research
- SageMath - Free and open-source mathematical software system
- Maxima - Free and open-source computer algebra system
- Scilab - Free and open-source numerical computing software
- Julia - High-level programming language for numerical and scientific computing.
- [TEDDS](https://www.thestructuralengineer.info/software/tedds) - TEDDS is a productivity tool for day-to-day repetitive calculations which replaces hand written calculations.  

## Drafting

- AutoCAD - Computer-Aided Design (CAD) software
- MicroStation - CAD software for architecture, engineering, and construction (AEC)
- Revit - Building Information Modeling (BIM) software
- BricsCAD - CAD software for AEC
- SketchUp - 3D modeling software
- Civil 3D - Civil engineering design and documentation software
- InfraWorks - Infrastructure design and engineering software
- AutoCAD Architecture - CAD software for architectural design
- ArchiCAD - BIM software for architects
- AutoCAD Map 3D - GIS and mapping software.
- [NanoCAD](https://nanocad.com/)
- Openroads
- Openrails
- Openbuildings Designer

## 3D Modelling


- AutoCAD - Computer-Aided Design (CAD) software
- Revit - Building Information Modeling (BIM) software
- 3ds Max - 3D modeling, animation, and rendering software
- SketchUp - 3D modeling software
- Blender - Open source 3D creation software
- Rhino - 3D modeling software for architectural and product design
- Civil 3D - Civil engineering design and documentation software
- InfraWorks - Infrastructure design and engineering software
- ArchiCAD - BIM software for architects
- AutoCAD Map 3D - GIS and mapping software
- FreeCAD - An OpenSource Multipurpose 3D modelling, drafting and engineering calculation software
- [BricsCAD](https://www.bricsys.com/en-eu)

## GIS

- ArcGIS - GIS software by Esri
- QGIS - Open source GIS software
- [SAGA](https://saga-gis.sourceforge.io/) - A GIS, used to edit and analyze spatial data
- [GRASS](https://grass.osgeo.org/) - A GIS suite used for geospatial data management and analysis, image processing, producing graphics and maps, spatial and temporal modeling, and visualizing. 
- AutoCAD Map 3D - GIS and mapping software
- CityEngine - 3D urban design and modeling software
- Global Mapper - GIS and remote sensing software
- GeoServer - Open source server for sharing geospatial data
- ENVI - Remote sensing and image analysis software
- GRASS GIS - Open source GIS software
- Geospatial Modelling Environment (GME) - GIS software for environmental and ecological modeling
- Cesium - Open source platform for 3D geospatial mapping
- [OpenCities Map](https://www.bentley.com/software/opencities-map/) 

## Environmental Engineering

- [Wastewater Collection System Modeling Software (CSSM)](https://www.innovyze.com/products/collection-system-modeling) - A software used for the analysis and design of wastewater collection systems.
- [StormCAD](https://www.bentley.com/en/products/product-line/water-and-wastewater) - A software for the design and analysis of stormwater conveyance systems.
- [PCSWMM](https://www.innovyze.com/products/pc-swmm) - A software for the analysis of urban runoff, combined sewer overflows, and sanitary sewer systems.
- [Air dispersion modeling software](https://www.enviro.space/products/air-dispersion-modeling-software) - A software used to simulate the dispersion of air pollutants from point, area, and line sources.
- [AQUATOX](https://www.epa.gov/water-research/aquatox) - a software for modeling the ecological effects of stressors, such as pollutants, on aquatic ecosystems.
- [SWMM5](https://www.epa.gov/water-research/storm-water-management-model-swmm) - a software for the design and analysis of stormwater management systems.
- [SRH 2-D](https://www.usbr.gov/tsc/techreferences/computer%20software/models/srh2d/index.html) - A two dimensional Sedimentation and River Hydraulics solver

## Project Management
- [AASHTO SiteManager](https://www.aashtowareproject.org/smr) - A comprehensive client/server based construction management tool for data entry, tracking, reporting, and analysis of contract data from contract award through finalization. 
- [P6 Primavera](https://www.oracle.com/pk/industries/construction-engineering/primavera-p6/) - An enterprise project portfolio management software that can perform project management, scheduling, risk analysis, opportunity management, resource management, collaboration and control capabilities.

- Procore - A cloud-based construction project management platform that offers a range of tools for project management, document management, and communication.
- Microsoft Project - A project management software that provides tools for project scheduling, resource allocation, and budget management.
- Asana - A cloud-based collaboration and project management tool that allows teams to track tasks, communicate, and share files in one central place.
- Trello - A visual project management tool that uses boards, lists, and cards to help teams organize and prioritize tasks.
- Wrike - A cloud-based project management tool that offers real-time collaboration, task tracking, and customizable workflows.
- Monday.com - A visual project management tool that helps teams track projects, allocate resources, and collaborate in real-time.
- Basecamp - A project management and collaboration tool that provides a centralized place for teams to manage projects, store files, and communicate.
Achievion - A construction project management software that offers tools for project planning, scheduling, budgeting, and collaboration.
- Smartsheet - A cloud-based project management and collaboration tool that allows teams to manage projects, track tasks, and automate workflows.
- Podio - A cloud-based project management tool that offers a range of tools for project management, communication, and file sharing.
Here is a list of popular web-based civil engineering software:
- [Autodesk BIM 360](https://www.autodesk.com/products/bim-360/overview) - A cloud-based project management platform for construction professionals.
- [Procore](https://www.procore.com/) - A construction project management software with tools for scheduling, budgeting, and communication.
- [Plangrid](https://www.plangrid.com/) - A construction project management platform that allows for collaboration and organization on a single platform.
- [Buildertrend](https://www.buildertrend.com/) - A cloud-based construction management software that includes scheduling, budgeting, and communication tools.
- [Bluebeam Revu](https://www.bluebeam.com/revu) - A software for document management and collaboration in the construction industry.
- [PlanGrid](https://www.plangrid.com/) - A cloud-based construction project management platform that provides collaboration and organization on a single platform.
- [Fieldwire](https://www.fieldwire.com/) - A construction project management software that allows for collaboration on tasks, plans, and punch lists.
- [CoConstruct](https://www.coconstruct.com/) - A cloud-based construction project management software with tools for scheduling, budgeting, and communication.


## Spreadsheet

- Microsoft Excel - Spreadsheet software developed by Microsoft
- Google Sheets - Online spreadsheet software developed by Google
- LibreOffice Calc - Free and open-source spreadsheet software
- Apple Numbers - Spreadsheet software developed by Apple
- WPS Spreadsheets - Free and open-source spreadsheet software
- Airtable - Online spreadsheet software with a database-like interface
- Smartsheet - Online spreadsheet software for project management
- Zoho Sheet - Online spreadsheet software
- Asana Tables - Online spreadsheet software for team collaboration
- Quip Spreadsheets - Online spreadsheet software for team collaboration.


## Web Calculators

### Structure Analysis
- [SkyCiv Engineering](https://www.skyciv.com/structural-analysis-software/) - A cloud-based structural analysis software that provides a user-friendly interface for analyzing structures.


## Programming Libraries


### Python 
* PyFEM - Finite Element Modellingg
* Pandas - Spreadsheet
* NumPy - Vector Operations and Matrix Manipulation
* SciPy - Scientific Python
* SfePy - Finite Element Software
* OpenSees - Structural Analysis Software
* NumPy - Numerical computing library
* SciPy - Scientific computing library
* Pandas - Data analysis and manipulation library
* Matplotlib - Plotting library
* Seaborn - Data visualization library
* Shapely - Library for manipulating and analyzing planar geometric objects
* Fiona - Library for reading and writing geospatial data
* PySAL - Library for spatial analysis
* GeoPandas - Library for geospatial data analysis
* Rasterio - Library for reading and writing raster datasets

### JavaScript
- Leaflet - Library for creating interactive maps
- OpenLayers - Library for displaying maps and adding layers to them
- D3.js - Library for creating dynamic and interactive data visualizations
- Three.js - Library for creating 3D graphics in a web browser
- Cesium - Open source platform for 3D geospatial mapping
- Mapbox GL JS - Library for creating vector maps and custom map styles
- Turf.js - Library for performing spatial analysis in a browser
- Plotly.js - Library for creating interactive and animated charts and graphs
- Deck.gl - Library for large-scale data visualization
- Mapv - Library for fast and efficient data visualization on maps.
### Rust
- nalgebra - Library for linear algebra
- num - Library for numerical computing
- image - Library for image processing
- rust-geo - Library for geographic and geospatial data
- rust-htslib - Library for reading and writing high-throughput sequencing (HTS) data
- rust-postgis - Library for working with PostGIS, a spatial database
- rust-scikit-learn - Library for machine learning in Rust
- rust-stats - Library for statistical computing
- rust-vis - Library for data visualization in Rust
- geojson - Library for working with GeoJSON data.
### C#
- NetTopologySuite - Library for working with geospatial data
- SharpMap - Library for creating and working with maps
- GeoAPI - Library for geospatial data processing
- MapWindow - Open source GIS software
- Artisan - Library for creating 3D models in C#
- DotSpatial - Library for working with geospatial data in .NET
- ProjNet - Library for coordinate system and map projection transformations
- GeoJSON.Net - Library for working with GeoJSON data in .NET
- Microsoft.Maps - Library for working with maps and geospatial data in .NET
- SharpKml - Library for working with KML, a common file format for geospatial data.
### 

## Machine Learning

- TensorFlow - Machine learning library developed by Google
- PyTorch - Machine learning library developed by Facebook
- Scikit-learn - Machine learning library for Python
- R - Programming language for statistical computing and data analysis
- Weka - Machine learning software for data mining and analysis
- KNIME - Machine learning platform for data analysis and visualization
- Orange - Machine learning software for data mining and predictive modeling
- RapidMiner - Machine learning platform for data preparation, analysis, and prediction
- XGBoost - Machine learning library for gradient boosting trees
- LightGBM - Machine learning library for gradient boosting trees.

<style>
mark{
    color:red;
}

hr{
    color:red;
    background-color:yellow;
    height: 2px; 
    border: 0;
}

hr:hover{
    background-color:gold;
}

body{
    background-color: #24292e;
}

ul {
    list-style-type: square;
    list-style: none;
    list-style-type: "🌟  ";
}



li:hover {
    content: "•";
    color: gold;
    transform: scale(1.02);
    
}

h2:hover {
    transform: scale(1.02);
    animation: color-change 1s infinite;
}

h3:hover {
    transform: scale(1.02);
    animation: color-change 1s infinite;
}

h1:hover{
    animation: wiggle 1s infinite;
}

h1{
    animation: float 6s ease-in-out infinite;
}
@keyframes color-change {
  0% { color: red; }
  50% { color: yellow; }
  100% { color: red; }
}

@keyframes wiggle {
  0% { transform: scale(1.02); }
  50% { transform: scale(1);}
  100% { transform: scale(1.02); }
}
@keyframes float {
  0% {
    transform: translatey(0px);
  }
  50% {
    transform: translatey(-10px);
  }
  100% {
    transform: translatey(0px);
  }
}
*{
    color:white;
}
a{
    color:cyan; 
}
</style>
