/*
 * This file is part of QBDI.
 *
 * Copyright 2017 - 2024 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * IDENTIFICATION:
 * stub generated Tue Sep 26 10:48:47 2017
 * with a MiG generated by bootstrap_cmds-96.20.2
 * OPTIONS:
 */
#define __MIG_check__Reply__frida_jit_subsystem__ 1

#include "server-iOS-jit-user.h"

#ifndef mig_internal
#define mig_internal static __inline__
#endif /* mig_internal */

#ifndef mig_external
#define mig_external
#endif /* mig_external */

#if !defined(__MigTypeCheck) && defined(TypeCheck)
#define __MigTypeCheck TypeCheck /* Legacy setting */
#endif                           /* !defined(__MigTypeCheck) */

#if !defined(__MigKernelSpecificCode) && defined(_MIG_KERNEL_SPECIFIC_CODE_)
#define __MigKernelSpecificCode                \
  _MIG_KERNEL_SPECIFIC_CODE_ /* Legacy setting \
                              */
#endif                       /* !defined(__MigKernelSpecificCode) */

#ifndef LimitCheck
#define LimitCheck 0
#endif /* LimitCheck */

#ifndef min
#define min(a, b) (((a) < (b)) ? (a) : (b))
#endif /* min */

#if !defined(_WALIGN_)
#define _WALIGN_(x) (((x) + 3) & ~3)
#endif /* !defined(_WALIGN_) */

#if !defined(_WALIGNSZ_)
#define _WALIGNSZ_(x) _WALIGN_(sizeof(x))
#endif /* !defined(_WALIGNSZ_) */

#ifndef UseStaticTemplates
#define UseStaticTemplates 0
#endif /* UseStaticTemplates */

#ifndef __MachMsgErrorWithTimeout
#define __MachMsgErrorWithTimeout(_R_)                     \
  {                                                        \
    switch (_R_) {                                         \
      case MACH_SEND_INVALID_DATA:                         \
      case MACH_SEND_INVALID_DEST:                         \
      case MACH_SEND_INVALID_HEADER:                       \
        mig_put_reply_port(InP->Head.msgh_reply_port);     \
        break;                                             \
      case MACH_SEND_TIMED_OUT:                            \
      case MACH_RCV_TIMED_OUT:                             \
      default:                                             \
        mig_dealloc_reply_port(InP->Head.msgh_reply_port); \
    }                                                      \
  }
#endif /* __MachMsgErrorWithTimeout */

#ifndef __MachMsgErrorWithoutTimeout
#define __MachMsgErrorWithoutTimeout(_R_)                  \
  {                                                        \
    switch (_R_) {                                         \
      case MACH_SEND_INVALID_DATA:                         \
      case MACH_SEND_INVALID_DEST:                         \
      case MACH_SEND_INVALID_HEADER:                       \
        mig_put_reply_port(InP->Head.msgh_reply_port);     \
        break;                                             \
      default:                                             \
        mig_dealloc_reply_port(InP->Head.msgh_reply_port); \
    }                                                      \
  }
#endif /* __MachMsgErrorWithoutTimeout */

#ifndef __DeclareSendRpc
#define __DeclareSendRpc(_NUM_, _NAME_)
#endif /* __DeclareSendRpc */

#ifndef __BeforeSendRpc
#define __BeforeSendRpc(_NUM_, _NAME_)
#endif /* __BeforeSendRpc */

#ifndef __AfterSendRpc
#define __AfterSendRpc(_NUM_, _NAME_)
#endif /* __AfterSendRpc */

#ifndef __DeclareSendSimple
#define __DeclareSendSimple(_NUM_, _NAME_)
#endif /* __DeclareSendSimple */

#ifndef __BeforeSendSimple
#define __BeforeSendSimple(_NUM_, _NAME_)
#endif /* __BeforeSendSimple */

#ifndef __AfterSendSimple
#define __AfterSendSimple(_NUM_, _NAME_)
#endif /* __AfterSendSimple */

#define msgh_request_port msgh_remote_port
#define msgh_reply_port msgh_local_port

#if (__MigTypeCheck)
#if __MIG_check__Reply__frida_jit_subsystem__
#if !defined(__MIG_check__Reply__frida_jit_alloc_t__defined)
#define __MIG_check__Reply__frida_jit_alloc_t__defined

mig_internal kern_return_t
__MIG_check__Reply__frida_jit_alloc_t(__Reply__frida_jit_alloc_t *Out0P) {

  typedef __Reply__frida_jit_alloc_t __Reply __attribute__((unused));
#if __MigTypeCheck
  unsigned int msgh_size;
#endif /* __MigTypeCheck */
  if (Out0P->Head.msgh_id != 421437) {
    if (Out0P->Head.msgh_id == MACH_NOTIFY_SEND_ONCE) {
      return MIG_SERVER_DIED;
    } else {
      return MIG_REPLY_MISMATCH;
    }
  }

#if __MigTypeCheck
  msgh_size = Out0P->Head.msgh_size;

  if ((Out0P->Head.msgh_bits & MACH_MSGH_BITS_COMPLEX) ||
      ((msgh_size != (mach_msg_size_t)sizeof(__Reply)) &&
       (msgh_size != (mach_msg_size_t)sizeof(mig_reply_error_t) ||
        Out0P->RetCode == KERN_SUCCESS))) {
    return MIG_TYPE_ERROR;
  }
#endif /* __MigTypeCheck */

  if (Out0P->RetCode != KERN_SUCCESS) {
    return ((mig_reply_error_t *)Out0P)->RetCode;
  }

  return MACH_MSG_SUCCESS;
}
#endif /* !defined(__MIG_check__Reply__frida_jit_alloc_t__defined) */
#endif /* __MIG_check__Reply__frida_jit_subsystem__ */
#endif /* ( __MigTypeCheck ) */

/* Routine frida_jit_alloc */
mig_external kern_return_t frida_jit_alloc(mach_port_t server, vm_map_t task,
                                           mach_vm_address_t *address,
                                           mach_vm_size_t size, int flags) {

#ifdef __MigPackStructs
#pragma pack(4)
#endif
  typedef struct {
    mach_msg_header_t Head;
    /* start of the kernel processed data */
    mach_msg_body_t msgh_body;
    mach_msg_port_descriptor_t task;
    /* end of the kernel processed data */
    NDR_record_t NDR;
    mach_vm_address_t address;
    mach_vm_size_t size;
    int flags;
  } Request __attribute__((unused));
#ifdef __MigPackStructs
#pragma pack()
#endif

#ifdef __MigPackStructs
#pragma pack(4)
#endif
  typedef struct {
    mach_msg_header_t Head;
    NDR_record_t NDR;
    kern_return_t RetCode;
    mach_vm_address_t address;
    mach_msg_trailer_t trailer;
  } Reply __attribute__((unused));
#ifdef __MigPackStructs
#pragma pack()
#endif

#ifdef __MigPackStructs
#pragma pack(4)
#endif
  typedef struct {
    mach_msg_header_t Head;
    NDR_record_t NDR;
    kern_return_t RetCode;
    mach_vm_address_t address;
  } __Reply __attribute__((unused));
#ifdef __MigPackStructs
#pragma pack()
#endif
  /*
   * typedef struct {
   * 	mach_msg_header_t Head;
   * 	NDR_record_t NDR;
   * 	kern_return_t RetCode;
   * } mig_reply_error_t;
   */

  union {
    Request In;
    Reply Out;
  } Mess;

  Request *InP = &Mess.In;
  Reply *Out0P = &Mess.Out;

  mach_msg_return_t msg_result;

#ifdef __MIG_check__Reply__frida_jit_alloc_t__defined
  kern_return_t check_result;
#endif /* __MIG_check__Reply__frida_jit_alloc_t__defined */

  __DeclareSendRpc(421337, "frida_jit_alloc")

#if UseStaticTemplates
      const static mach_msg_port_descriptor_t taskTemplate = {
          /* name = */ MACH_PORT_NULL,
          /* pad1 = */ 0,
          /* pad2 = */ 0,
          /* disp = */ 19,
          /* type = */ MACH_MSG_PORT_DESCRIPTOR,
      };
#endif /* UseStaticTemplates */

  InP->msgh_body.msgh_descriptor_count = 1;
#if UseStaticTemplates
  InP->task = taskTemplate;
  InP->task.name = task;
#else  /* UseStaticTemplates */
  InP->task.name = task;
  InP->task.disposition = 19;
  InP->task.type = MACH_MSG_PORT_DESCRIPTOR;
#endif /* UseStaticTemplates */

  InP->NDR = NDR_record;

  InP->address = *address;

  InP->size = size;

  InP->flags = flags;

  InP->Head.msgh_bits =
      MACH_MSGH_BITS_COMPLEX | MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE);
  /* msgh_size passed as argument */
  InP->Head.msgh_request_port = server;
  InP->Head.msgh_reply_port = mig_get_reply_port();
  InP->Head.msgh_id = 421337;
  InP->Head.msgh_reserved = 0;

  /* BEGIN VOUCHER CODE */

#ifdef USING_VOUCHERS
  if (voucher_mach_msg_set != NULL) {
    voucher_mach_msg_set(&InP->Head);
  }
#endif // USING_VOUCHERS

  /* END VOUCHER CODE */

  __BeforeSendRpc(421337, "frida_jit_alloc") msg_result = mach_msg(
      &InP->Head, MACH_SEND_MSG | MACH_RCV_MSG | MACH_MSG_OPTION_NONE,
      (mach_msg_size_t)sizeof(Request), (mach_msg_size_t)sizeof(Reply),
      InP->Head.msgh_reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
  __AfterSendRpc(421337,
                 "frida_jit_alloc") if (msg_result != MACH_MSG_SUCCESS) {
    __MachMsgErrorWithoutTimeout(msg_result);
    { return msg_result; }
  }

#if defined(__MIG_check__Reply__frida_jit_alloc_t__defined)
  check_result = __MIG_check__Reply__frida_jit_alloc_t(
      (__Reply__frida_jit_alloc_t *)Out0P);
  if (check_result != MACH_MSG_SUCCESS) {
    return check_result;
  }
#endif /* defined(__MIG_check__Reply__frida_jit_alloc_t__defined) */

  *address = Out0P->address;

  return KERN_SUCCESS;
}
