if(__add_qbdi_llvm_tblgen)
  return()
endif()
set(__add_qbdi_llvm_tblgen ON)
include(ExternalProject)

set(NATIVE_BUILD_DIR "${CMAKE_CURRENT_BINARY_DIR}/QBDI_llvm_tblgen_native")

if(CMAKE_CONFIGURATION_TYPES)
  set(QBDI_LLVM_NATIVE_TBLGEN "${NATIVE_BUILD_DIR}/Release/bin/llvm-tblgen")
else()
  set(QBDI_LLVM_NATIVE_TBLGEN "${NATIVE_BUILD_DIR}/bin/llvm-tblgen")
endif()

ExternalProject_Add(
  llvm_tblgen
  URL "${QBDI_LLVM_URL}"
  URL_HASH "${QBDI_LLVM_URL_HASH}"
  DOWNLOAD_DIR "${QBDI_THIRD_PARTY_DIRECTORY}/llvm-download"
  SOURCE_DIR "${llvm_cmake_SOURCE_DIR}/../llvm_tblgen_source_dir"
  BINARY_DIR "${NATIVE_BUILD_DIR}"
  CONFIGURE_COMMAND
    "${CMAKE_COMMAND}" -G "${CMAKE_GENERATOR}" -S <SOURCE_DIR> -B <BINARY_DIR>
    "-DCMAKE_MAKE_PROGRAM='${CMAKE_MAKE_PROGRAM}'"
    "-DCMAKE_TOOLCHAIN_FILE='${QBDI_LLVM_TABLEN_TOOLSCHAIN}'"
    -DLLVM_TARGET_IS_CROSSCOMPILE_HOST=TRUE
    "-DLLVM_TARGETS_TO_BUILD='${LLVM_TARGETS_TO_BUILD}'"
    "-DLLVM_TARGET_ARCH='${LLVM_TARGET_ARCH}'" -DCMAKE_BUILD_TYPE=Release
    "-DLLVM_CCACHE_BUILD='${LLVM_CCACHE_BUILD}'" -DLLVM_INCLUDE_TESTS=OFF
    -DLLVM_INCLUDE_BENCHMARKS=OFF -DLLVM_INCLUDE_EXAMPLES=OFF
  BUILD_COMMAND "${CMAKE_COMMAND}" --build <BINARY_DIR> --target llvm-tblgen
  BUILD_BYPRODUCTS "${QBDI_LLVM_NATIVE_TBLGEN}"
  INSTALL_COMMAND "")
