if(__add_qbdi_llvm)
  return()
endif()
set(__add_qbdi_llvm ON)

include(FetchContent_local)

# configure FetchContent
set(QBDI_LLVM_MAJOR_VERSION 17)
set(QBDI_LLVM_VERSION 17.0.6)

# download and include llvm cmake module
option(QBDI_INCLUDE_LLVM_CMAKE_MODUKE "Include llvm cmake module" ON)
if(QBDI_INCLUDE_LLVM_CMAKE_MODUKE)
  FetchContent_Declare(
    llvm_cmake
    URL "https://github.com/llvm/llvm-project/releases/download/llvmorg-${QBDI_LLVM_VERSION}/cmake-${QBDI_LLVM_VERSION}.src.tar.xz"
    URL_HASH
      "SHA256=807f069c54dc20cb47b21c1f6acafdd9c649f3ae015609040d6182cab01140f4"
      SOURCE_DIR "${FETCHCONTENT_BASE_DIR}/cmake"
    DOWNLOAD_DIR "${QBDI_THIRD_PARTY_DIRECTORY}/llvm-cmake-download")

  FetchContent_MakeAvailable(llvm_cmake)
endif()

set(QBDI_LLVM_URL
    "https://github.com/llvm/llvm-project/releases/download/llvmorg-${QBDI_LLVM_VERSION}/llvm-${QBDI_LLVM_VERSION}.src.tar.xz"
)
set(QBDI_LLVM_URL_HASH
    "SHA256=b638167da139126ca11917b6880207cc6e8f9d1cbb1a48d87d017f697ef78188")

FetchContent_Declare(
  llvm
  URL "${QBDI_LLVM_URL}"
  URL_HASH "${QBDI_LLVM_URL_HASH}"
  DOWNLOAD_DIR "${QBDI_THIRD_PARTY_DIRECTORY}/llvm-download"
               ${FETCHCONTENT_EXCLUDE_FROM_ALL})

set(CMAKE_CXX_STANDARD
    17
    CACHE INTERNAL "USE CPP 17")
set(LLVM_BUILD_TOOLS
    OFF
    CACHE INTERNAL "Disable LLVM_BUILD_TOOLS")
set(LLVM_BUILD_UTILS
    OFF
    CACHE INTERNAL "Disable LLVM_BUILD_UTILS")
set(LLVM_BUILD_TESTS
    OFF
    CACHE INTERNAL "Disable LLVM_BUILD_TESTS")
set(LLVM_BUILD_BENCHMARKS
    OFF
    CACHE INTERNAL "Disable LLVM_BUILD_BENCHMARKS")
set(LLVM_BUILD_EXAMPLES
    OFF
    CACHE INTERNAL "Disable LLVM_BUILD_EXAMPLES")
set(LLVM_INCLUDE_TOOLS
    OFF
    CACHE INTERNAL "Disable LLVM_INCLUDE_TOOLS")
set(LLVM_INCLUDE_UTILS
    OFF
    CACHE INTERNAL "Disable LLVM_INCLUDE_UTILS")
set(LLVM_INCLUDE_TESTS
    OFF
    CACHE INTERNAL "Disable LLVM_INCLUDE_TESTS")
set(LLVM_INCLUDE_BENCHMARKS
    OFF
    CACHE INTERNAL "Disable LLVM_INCLUDE_BENCHMARKS")
set(LLVM_INCLUDE_EXAMPLES
    OFF
    CACHE INTERNAL "Disable LLVM_INCLUDE_EXAMPLES")
set(LLVM_ENABLE_TERMINFO
    OFF
    CACHE INTERNAL "Disable LLVM_ENABLE_TERMINFO")
set(LLVM_ENABLE_BINDINGS
    OFF
    CACHE INTERNAL "Disable LLVM_ENABLE_BINDINGS")
set(LLVM_ENABLE_RTTI
    OFF
    CACHE INTERNAL "Disable LLVM_ENABLE_RTTI")
set(LLVM_APPEND_VC_REV
    OFF
    CACHE INTERNAL "Disable LLVM_APPEND_VC_REV")
set(LLVM_ENABLE_Z3_SOLVER
    OFF
    CACHE INTERNAL "Disable LLVM_ENABLE_Z3_SOLVER")
set(LLVM_ENABLE_ZLIB
    OFF
    CACHE INTERNAL "Disable LLVM_ENABLE_ZLIB")
set(LLVM_ENABLE_ZSTD
    OFF
    CACHE INTERNAL "Disable LLVM_ENABLE_ZSTD")
set(LLVM_TARGET_ARCH
    ${QBDI_LLVM_ARCH}
    CACHE INTERNAL "set LLVM_ARCH")
set(LLVM_TARGETS_TO_BUILD
    ${QBDI_LLVM_ARCH}
    CACHE INTERNAL "set LLVM_TARGETS_TO_BUILD")

set(QBDI_LLVM_TRIPLE "")
if(QBDI_ARCH_ARM)
  if(QBDI_PLATFORM_ANDROID)
    set(QBDI_LLVM_TRIPLE armv7-linux-androideabi)
  else()
    set(QBDI_LLVM_TRIPLE armv7-linux-gnu)
  endif()
elseif(QBDI_ARCH_AARCH64)
  if(QBDI_PLATFORM_ANDROID)
    set(QBDI_LLVM_TRIPLE aarch64-linux-android)
  else()
    set(QBDI_LLVM_TRIPLE aarch64-linux-gnu)
  endif()
elseif(QBDI_ARCH_X86)
  set(LLVM_BUILD_32_BITS
      ON
      CACHE INTERNAL "set LLVM_BUILD_32_BITS")
  if(QBDI_PLATFORM_OSX)
    set(LLVM_ENABLE_LIBCXX
        ON
        CACHE INTERNAL "set LLVM_ENABLE_LIBCXX")
    set(QBDI_LLVM_TRIPLE i386-apple-darwin17.7.0)
  elseif(QBDI_PLATFORM_LINUX OR QBDI_PLATFORM_ANDROID)
    set(QBDI_LLVM_TRIPLE i386-pc-linux)
  endif()
elseif(QBDI_ARCH_X86_64)
  if(QBDI_PLATFORM_LINUX)
    set(QBDI_LLVM_TRIPLE x86_64-pc-linux-gnu)
  endif()
else()
  message(FATAL_ERROR "Unsupported LLVM Architecture.")
endif()

if(NOT ("${QBDI_LLVM_TRIPLE}" STREQUAL ""))
  set(LLVM_DEFAULT_TARGET_TRIPLE
      "${QBDI_LLVM_TRIPLE}"
      CACHE INTERNAL "set LLVM_DEFAULT_TARGET_TRIPLE")
endif()

if(QBDI_CCACHE AND CCACHE_FOUND)
  set(LLVM_CCACHE_BUILD
      ON
      CACHE INTERNAL "Enable CCACHE in llvm")
else()
  set(LLVM_CCACHE_BUILD
      OFF
      CACHE INTERNAL "Enable CCACHE in llvm")
endif()

if(QBDI_ASAN AND HAVE_FLAG_SANITIZE_ADDRESS)
  set(LLVM_USE_SANITIZER
      Address
      CACHE INTERNAL "Enable ASAN")
endif()

if(NOT ("${NATIVE_TABLEN_PATH}" STREQUAL ""))
  set(LLVM_TABLEGEN
      "${NATIVE_TABLEN_PATH}"
      CACHE INTERNAL "force tablegen")
elseif(NOT ("${QBDI_LLVM_TABLEN_TOOLSCHAIN}" STREQUAL ""))
  # create a second directory to build the native llvm-tblgen
  # mostly use when crosscompile and need another compiler to create a native
  # target
  include(QBDI_llvm_tblgen)
  set(LLVM_TABLEGEN
      "${QBDI_LLVM_NATIVE_TBLGEN}"
      CACHE INTERNAL "force tablegen")
else()
  # check if llvm-tblgen-X is available
  find_program(LLVM_TABLEN_BIN NAMES llvm-tblgen-${QBDI_LLVM_MAJOR_VERSION})
  message(STATUS "LLVM Table Gen found: ${LLVM_TABLEN_BIN}")
  if(${LLVM_TABLEN_BIN_FOUND})
    set(LLVM_TABLEGEN
        "${LLVM_TABLEN_BIN}"
        CACHE INTERNAL "force tablegen")
  endif()
endif()

# build llvm with visibility hidden
if(DEFINED CMAKE_C_VISIBILITY_PRESET)
  set(QBDI_CACHE_CMAKE_C_VISIBILITY_PRESET ${CMAKE_C_VISIBILITY_PRESET})
endif()
if(DEFINED CMAKE_CXX_VISIBILITY_PRESET)
  set(QBDI_CACHE_CMAKE_CXX_VISIBILITY_PRESET ${CMAKE_CXX_VISIBILITY_PRESET})
endif()
set(CMAKE_C_VISIBILITY_PRESET
    "hidden"
    CACHE INTERNAL "set CMAKE_C_VISIBILITY_PRESET" FORCE)
set(CMAKE_CXX_VISIBILITY_PRESET
    "hidden"
    CACHE INTERNAL "set CMAKE_CXX_VISIBILITY_PRESET" FORCE)

fetchcontent_makeavailable_exclude_from_all(llvm)

# restore visibility
if(DEFINED QBDI_CACHE_CMAKE_C_VISIBILITY_PRESET)
  set(CMAKE_C_VISIBILITY_PRESET
      ${QBDI_CACHE_CMAKE_C_VISIBILITY_PRESET}
      CACHE INTERNAL "set CMAKE_C_VISIBILITY_PRESET" FORCE)
else()
  unset(CMAKE_C_VISIBILITY_PRESET CACHE)
endif()
if(DEFINED QBDI_CACHE_CMAKE_CXX_VISIBILITY_PRESET)
  set(CMAKE_CXX_VISIBILITY_PRESET
      ${QBDI_CACHE_CMAKE_CXX_VISIBILITY_PRESET}
      CACHE INTERNAL "set CMAKE_CXX_VISIBILITY_PRESET" FORCE)
else()
  unset(CMAKE_CXX_VISIBILITY_PRESET CACHE)
endif()

# list of LLVM library to build
set(QBDI_LLVM_TARGET_LIBRARY)
set(QBDI_LLVM_LINK_LIBRARY)
macro(add_llvm_lib)
  foreach(LIB ${ARGV})
    if("${LIB}" MATCHES "^::@")
      continue()
    endif()
    string(FIND "${LIB}" "::@" pos)
    if("${pos}" EQUAL -1)
      set(TARGETLIB "${LIB}")
    else()
      string(SUBSTRING "${LIB}" 0 "${pos}" TARGETLIB)
    endif()
    if((TARGET ${TARGETLIB}) AND NOT (${TARGETLIB} IN_LIST
                                      QBDI_LLVM_TARGET_LIBRARY))
      list(APPEND QBDI_LLVM_TARGET_LIBRARY ${TARGETLIB})
      get_target_property(_LIB_LINK ${TARGETLIB} INTERFACE_LINK_LIBRARIES)
      if(_LIB_LINK)
        add_llvm_lib(${_LIB_LINK})
      endif()
    elseif(NOT (TARGET ${TARGETLIB}) AND NOT (${TARGETLIB} IN_LIST
                                              QBDI_LLVM_LINK_LIBRARY))
      list(APPEND QBDI_LLVM_LINK_LIBRARY ${TARGETLIB})
    endif()
  endforeach()
endmacro()

add_llvm_lib(
  LLVMBinaryFormat
  LLVMMCDisassembler
  LLVMMCParser
  LLVMMC
  LLVMSupport
  LLVMObject
  LLVMTextAPI
  LLVMCore
  LLVMBitReader
  LLVMBitstreamReader
  LLVMRemarks)

if(QBDI_PLATFORM_OSX OR QBDI_PLATFORM_IOS)
  add_llvm_lib(LLVMDemangle)
endif()

if(QBDI_ARCH_ARM)
  add_llvm_lib(LLVMARMAsmParser LLVMARMDisassembler LLVMARMDesc LLVMARMInfo
               LLVMARMUtils)
elseif(QBDI_ARCH_AARCH64)
  add_llvm_lib(LLVMAArch64AsmParser LLVMAArch64Desc LLVMAArch64Disassembler
               LLVMAArch64Info LLVMAArch64Utils)
elseif(QBDI_ARCH_X86_64 OR QBDI_ARCH_X86)
  add_llvm_lib(LLVMX86AsmParser LLVMX86Disassembler LLVMX86Desc LLVMX86Info)
else()
  message(FATAL_ERROR "Unsupported LLVM Architecture.")
endif()

if(QBDI_PLATFORM_OSX)
  find_package(Python3 REQUIRED COMPONENTS Interpreter)

  set(LLVMSupportFixName "${llvm_BINARY_DIR}/libLLVMSupportFix.a")
  add_custom_command(
    OUTPUT "${LLVMSupportFixName}"
    COMMAND
      "${Python3_EXECUTABLE}"
      "${CMAKE_CURRENT_SOURCE_DIR}/cmake/llvm/rename_object.py" -i
      $<TARGET_FILE:LLVMSupport> -o "${LLVMSupportFixName}" -r Memory.cpp.o 1 -r
      Error.cpp.o 1
    COMMENT "Fix LLVMSupport library"
    DEPENDS LLVMSupport
    VERBATIM)
  list(REMOVE_ITEM QBDI_LLVM_TARGET_LIBRARY LLVMSupport)
  list(APPEND QBDI_LLVM_TARGET_LIBRARY "${LLVMSupportFixName}")

  set(LLVMObjectFixName "${llvm_BINARY_DIR}/libLLVMObjectFix.a")
  add_custom_command(
    OUTPUT "${LLVMObjectFixName}"
    COMMAND
      "${Python3_EXECUTABLE}"
      "${CMAKE_CURRENT_SOURCE_DIR}/cmake/llvm/rename_object.py" -i
      $<TARGET_FILE:LLVMObject> -o "${LLVMObjectFixName}" -r Minidump.cpp.o 1
    COMMENT "Fix LLVMObject library"
    DEPENDS LLVMObject
    VERBATIM)
  list(REMOVE_ITEM QBDI_LLVM_TARGET_LIBRARY LLVMObject)
  list(APPEND QBDI_LLVM_TARGET_LIBRARY "${LLVMObjectFixName}")

  list(APPEND QBDI_LLVM_LINK_LIBRARY -lc++)
elseif(QBDI_PLATFORM_LINUX)
  list(APPEND QBDI_LLVM_LINK_LIBRARY -lstdc++)
endif()

merge_static_libs(qbdi-llvm qbdi-llvm \${QBDI_LLVM_TARGET_LIBRARY})
target_link_libraries(qbdi-llvm INTERFACE ${QBDI_LLVM_LINK_LIBRARY})

target_include_directories(
  qbdi-llvm
  INTERFACE ${llvm_SOURCE_DIR}/include
  INTERFACE ${llvm_BINARY_DIR}/include
  INTERFACE ${llvm_SOURCE_DIR}/lib/Target/${QBDI_LLVM_ARCH}
  INTERFACE ${llvm_BINARY_DIR}/lib/Target/${QBDI_LLVM_ARCH}
  INTERFACE ${llvm_SOURCE_DIR}/lib
  INTERFACE ${llvm_BINARY_DIR}/lib)

add_custom_target(llvm DEPENDS qbdi-llvm)
