<p align="center">
  <a href="http://codeperfectplus.com/"><img src="https://capsule-render.vercel.app/api?type=rect&color=666666&height=100&section=header&text=Algorithms%20And%20Data%20Structures&fontSize=55%&fontColor=ffffff&fontAlignY=65" alt="website title image"></a>
  <h2 align="center">👉 A Collection of Algorithms And Data Structures in C++ and Python 👈</h2>
</p>

<p align="center">
 <a href="http://codeperfectplus.com/"><img src="https://capsule-render.vercel.app/api?type=rect&color=666444&height=40&section=header&text=Hacktoberfest%20Excluded&fontSize=35%&fontColor=ffffff&fontAlignY=65" alt="website title image"></a>
</p>

<p align="center">
<img src="https://img.shields.io/badge/language-python-blue?style=for-the-badge">
<img src="https://img.shields.io/badge/language-C++-green?style=for-the-badge">
<img src="https://img.shields.io/badge/language-java-yellow?style=for-the-badge">
<img src="https://img.shields.io/badge/language-Javascript-ff69b4?style=for-the-badge">
</p>

<p align="center">
<a href="https://github.com/codeperfectplus/awesomeScripts/stargazers"><img src="https://img.shields.io/github/stars/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="github stars"></a>
<a href="https://github.com/codeperfectplus/awesomeScripts/network/members"><img src="https://img.shields.io/github/forks/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="github forks"></a>
<img src="https://img.shields.io/github/languages/code-size/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="code size">
  </p>
  <p align="center">
<a href="https://github.com/codeperfectplus/awesomeScripts/issues"><img src="https://img.shields.io/github/issues-raw/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="open issues"></a>
<a href="https://github.com/codeperfectplus/awesomeScripts/issues"><img src="https://img.shields.io/github/issues-closed-raw/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="closed issues"><a/>
<a href="https://github.com/codeperfectplus/awesomeScripts/pulls"><img src="https://img.shields.io/github/issues-pr-raw/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="open pull request"></a>
<a href="https://github.com/codeperfectplus/awesomeScripts/pulls"><img src="https://img.shields.io/github/issues-pr-closed-raw/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="closed pull request"></a>
</p>
<p align="center">
<a href="https://discord.gg/JfbK3bS"><img src="https://img.shields.io/discord/758030555005714512.svg?label=Discord&logo=Discord&colorB=7289da&style=for-the-badge" alt="discord invite"></a>
<img src="https://img.shields.io/github/last-commit/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="last contributions">
<a href="https://api.github.com/repos/codeperfectplus/AlgorithmsAndDataStructure/contributors"><img src="https://img.shields.io/github/contributors/codeperfectplus/AlgorithmsAndDataStructure?style=for-the-badge" alt="total contributors"></a>
</p>

- [Introduction](#introduction)
- [Data Structures](#data-structures) <!-- Data Structure hyperlink in the readme doesn't link #925 issue solved. P.S. It was a typo -->
- [Algorithms](#algorithms)
- [Languages](#languages)
- [Support](#support)
- [Project Progress](#project-progress)
- [Contributing](#contributing)
- [Authors and acknowledgement](#authors-and-acknowledgement)
- [License](#license)
- [Maintainers](#maintainers)

## Introduction

Data structures & algorithms are an essential part of programming. They both fall under the fundamentals of computer science. Understanding these gives us the advantage of writing better and more efficient code in less time. They are key topics when it comes to acing software engineering interview questions, so as developers, we must have knowledge of data structures and algorithms.

:star2: Star it
:fork_and_knife:Fork it
:handshake: Contribute to it!

## Data Structures

In computer science, a data structure is a data organization, management, and storage format that enables efficient access and modification.

Data structure is a way or a format in which your data is stored in memory for efficient usage and retrieval.

## Algorithms

An algorithm is a set of instructions that are used to accomplish a task, such as finding the largest number in a list, removing all the red cards from a deck of playing cards, sorting a collection of names, or figuring out an average movie rating from just your friends' opinions.

Algorithms are not limited to computers. They are like a set of step-by-step instructions or an even a recipe, containing things you need, steps to do, the order to do them, conditions to look for, and expected results.

## Languages
- C++
- Python
- Java
- JavaScript

## Support

Check [Contribution](/CONTRIBUTING.md) Guide Before Contribution.

## Contributing

Before submitting a bug, please do the following:
Check [Contribution](/CONTRIBUTING.md) Guide Before Contribution.

- Create separate issues for Python and C++.
- You can only work on issues that you have been assigned to.
- Use Flake8 locally for linting Python Code. `pip install flake8`.
  (We have linting checks so if your code fails we will not merge the PR.)

## Authors and acknowledgement

Show your appreciation to those who have contributed to the project.

## [License](/LICENSE)

For open-source projects, Under [MIT License](/LICENSE).

## Maintainers

### 2023 Team

- [Kritika Gupta](https://github.com/Kritika30032002)
- [Arjit Goyal](https://github.com/arjit1704)

### 2022 Team

- [Deepak Raj](https://github.com/codePerfectPlus)
- [Harshit Paneri](https://github.com/harshit-paneri)
- [Romil jain](https://github.com/romiljain23)
- [Vanshika Sharma](https://github.com/Vanshika2063)

### 2020-2021 Team

  - [Ayush Modi](https://github.com/hot9cups)
  - [Deepak Raj](https://github.com/codePerfectPlus)
  - [ExpressHermes](https://github.com/ExpressHermes)
  - [Shantanu Kale](https://github.com/SSKale1)
  - [rex_divakar](https://github.com/rexdivakar)
  - [Shubham Pawar](https://github.com/shubham5351)


## Contributors

<a href="https://github.com/codePerfectPlus/AlgorithmsAndDataStructure/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=codePerfectPlus/AlgorithmsAndDataStructure" />
</a>

## Stargazers over time

[![Stargazers over time](https://starchart.cc/codePerfectPlus/AlgorithmsAndDataStructure.svg)](https://starchart.cc/codePerfectPlus/AlgorithmsAndDataStructure)

## Must Read Articles

- [How to Solve Linear Equations with Matrix Inversion](https://codeperfectplus.com/how-to-solve-linear-equations-with-matrix-inversion)
- [HackerRank Algorithms Solutions using Python and C++](https://codeperfectplus.com/hackerrank-algorithms-solutions-using-python-and-c-cpp)
- [30 Days of Code - HackerRank](https://codeperfectplus.com/category/hackerank-30daysofcode/)

<p align="center">
<a href="https://api.github.com/repos/py-contributors/AlgorithmsAndDataStructure/contributors"><img src="http://ForTheBadge.com/images/badges/built-by-developers.svg" alt="built by developers"></a>
</p>
