# Algorithm Implementation in Python

List of Algorithms in Python contained in this repository

  - [Backtracking Algorithms](#backtrackingalgorithms)
  - [Deep Learning Algorithms](#deeplearningalgorithms)
  - [Divide And Conquer](#divideandconquer)
  - [Dynamic Programing](#dynamicprograming)
  - [Graphing Algorithms](#graphingalgorithms)
  - [Greedy Algorithms](#greedyalgorithms)
  - [Machine Learning Algorithms](#machinelearningalgorithms)
  - [Path Finding Algorithms](#pathfindingalgorithms)
  - [Recursion Algorithms](#recursionalgorithms)
  - [Searching Algorithms](#searchingalgorithms)
  - [Sorting Algorithms](#sortingalgorithms)
  - [Finding all permutation](#permutationalgorithms)
  - [Spiral Matrix](#SpiralMatrix)

### Backtracking Algorithms:
Backtracking is a technique for solving problems recursively by trying to build a solution incrementally, one piece at a time, removing those solutions that fail to satisfy the constraints of the problem at any point of time.
 Example of implementation- Soduku solving.

### Deep Learning Algorithms:
Deep learning is part of machine learning, whose methods are based on artificial neural networks with representation learning. Learning can be supervised, semi-supervised or unsupervised.
Examples include- CNN, RNN, LSTM, GAN, RBM, etc.

### Divide And Conquer:
Divide and Conquer is an algorithm design paradigm based on multi-branched recursion. A divide-and-conquer algorithm works by recursively breaking down a problem into two or more sub-problems of the same or related type, until these become simple enough to be solved directly.
Example of implementation- Quick Sort, Merge Sort.

### Dynamic Programing:
Dynamic Programming is primarily an optimization over plain recursion. Wherever we see a recursive solution that has repeated calls for same inputs, we can optimize it using Dynamic Programming. The idea is to store the results of subproblems, so that we do not have to re-compute them when needed later.
Examples of implementation- Knapsack, Longest Common Subsequence.

### Graphing Algorithms:
Graphing algorithms compute a path or a value relevant to a graph data structure. Greedy algorithms like Prim's or Kruskal's algorithm are graphing algorithms because they operate on graphs
Examples of implementation - Breadth-first search, Depth-first search, Dijkstra's algorithm

### Greedy Algorithms:
A greedy algorithm is a simple, intuitive algorithm that is used in optimization problems. The algorithm makes the optimal choice at each step as it attempts to find the overall optimal way to solve the entire problem.
Examples of implementation- Kruskal's algorithm, Prim's algorithm.

### Machine Learning Algorithms:
A machine learning algorithm is a method that provides systems the ability to automatically learn and improve from experience without being explicitly programmed.
Examples include- Linear Regression, Logistic Regression, Naïve Bayes, KNN, etc

### Path Finding Algorithms:
Pathfinding or pathing is the plotting, by a computer application, of the shortest route between two points. It is a more practical variant on solving mazes.
Example of implemntation- A* search, Dijkstra's algorithm.

### Recursion Algorithms:
Recursion is a method of solving a problem where the solution depends on solutions to smaller instances of the same problem. Such problems can generally be solved by iteration, but this needs to identify and index the smaller instances at programming time.
Examples of implementation- Tower of Hanoi, Tree traversals, DFS.

### Searching Algorithms:
The searching algorithms are used to search or find one or more than one element from a dataset. These type of algorithms are used to find elements from a specific data structures, which maybe sequential or not.
Examples of implementation- Binary Search, Linear Search, Fibonacci Search.

### Sorting Algorithms:
A Sorting algorithm is an algorithm that puts elements of a list in a certain order. The most frequently used orders are numerical order and lexicographical order. Efficient sorting is important for optimizing the efficiency of other algorithms that require input data to be in sorted lists.
Examples of implementation- Quick Sort, Merge Sort.

### Finding all permutation:
In mathematics, a permutation of a set is, loosely speaking, an arrangement of its members into a sequence or linear order, or if the set is already ordered, a rearrangement of its elements. The word "permutation" also refers to the act or process of changing the linear order of an ordered set.
Examples of implementation-Input :  str = 'ABC'  Output : ABC,ACB,BAC,BCA,CAB,CBA

### Spiral Matrix:
The Spiral Matrix problem takes a 2-Dimensional array of N-rows and M-columns as an input, and prints the elements of this matrix in spiral order. The spiral begins at the top left corner of the input matrix, and prints the elements it encounters, while looping towards the center of this matrix, in a clockwise manner.
