import pytest


def pytest_addoption(parser):
    parser.addoption(
        "--runslow", action="store_true", default=False, help="run slow tests"
    )


def pytest_configure(config):
    config.addinivalue_line("markers", "slow: mark test as slow to run")


def pytest_collection_modifyitems(config, items):
    if config.getoption("--runslow"):
        return
    skip_slow = pytest.mark.skip(reason="need --runslow option to run")

    for item in items:
        if "slow" in item.keywords:
            item.add_marker(skip_slow)


@pytest.fixture()
def text_examples():
    yield {
        "lang": ["he", "ru", "da", "de"],
        "text": [
            "קפוץ לי",
            "Я вас любил: любовь еще, быть может",
            "Det blæser en halv pelican",
            "Das Blaue vom Himmel versprechen",
        ],
    }
