---
layout: ../../layouts/PostLayout.astro # Always use this layout, it's so the post gets properly styled
title: What is Astro Js.
excerpt: This post states the purpose of Astro and how to basic install it
author: rizzabh
createdAt: October 9, 2023
---

# Astro.js: The Modern Web Framework

**Astro.js** is a revolutionary modern web framework that aims to make web development faster, lighter, and more efficient. Whether you're building a simple static website or a complex web application, Astro.js empowers you to create stunning, high-performance web experiences.

## Why Choose Astro.js?

- **Blazing-Fast Loading**: Astro.js compiles your site into highly optimized static files, resulting in lightning-fast loading times for your users.

- **Framework Agnostic**: You can use your favorite JavaScript framework, such as React, Svelte, or Vue.js, seamlessly with Astro.js.

- **Optimized Bundling**: Astro.js intelligently bundles only the JavaScript, CSS, and HTML needed for a specific page, reducing unnecessary bloat.

- **Zero JavaScript by Default**: Astro.js prioritizes server-rendered content, delivering a progressively enhanced experience without relying on JavaScript.

1. **Installation**: Install Astro globally using npm or yarn.

   ```bash
   npm install -g create-astro
   ```
