---
layout: ../../layouts/PostLayout.astro # Always use this layout, it's so the post gets properly styled
title: How to Contribute to Open Source Projects – A Beginner's Guide
excerpt: As we continue to advance technologically....
author: ikshwaku03
createdAt: October 3, 2023
---

### As we continue to advance technologically, more and more products and services are being transformed into software ready services. And many of them are being made open-source.

Most developers and companies depend on open-source tools and software to make their products work. And I think you'll agree with me that the number of contributions to open-source have really grown lately – not just for solo developers but from companies also.

My first ever contributions to the open-source community was during the yearly Hacktoberfest event in _2023_. As a beginner I participated in beginner friendly projects which I will be sharing later to help you out too.

Now, if you are reading this article it's because you want to be part of the great open-source community – but maybe you don’t know where to get started? Well, you are in the right place.

In this guide we will cover:

- What exactly is open source?
- How can you get started contributing?
- What should you expect?

Well, in this article we will cover all this and more.

Let's get started!

## What is Open Source?

---

In simple words, we can describe an open source project as source code that is made available to the public to view, use, modify, and distribute under a permissive license.

As an example to explain this, let's use a classroom scenario. A teacher can share a document on a platform like Google Docs. On this platform students can edit the document and even make copies of their own. But whenever they make edits they have to be approved by the teacher before reflecting on the document again.

That's how open source code works: once it's been made public, and you need to add a feature or make changes, the owner has to approve the added changes and publish them for others to see.

Most successful open-source projects are a result of contributions from people with all skill levels – and not only coding skills, but also other skills like writing, languages, and so on.

Any time someone fixes a typo, adds an alert about a possible compiler warning, fixes a bug, or even adds detailed documentation to a project, progress is made. If we take all these small contributions from different people with different skills and put them together, great things can happen.

Just as Vincent van Gogh said:

> Great things are done by a series of small things brought together.

## Why you Should Contribute to Open-Source

---

Contributing to open source projects can be a rewarding way to learn, teach, share, and build experience.

There are plenty of reasons why you should contribute to an open source project, such as:

- To improve the software you rely on daily.
- To find a mentor if you need one.
- To learn new skills or improve on existing ones.
- To share your skills.
- To gain a much deeper knowledge about the software you're using.
- To build up your reputation and help grow your career.
- Plus, it's fun and gives you personal satisfaction and hey, you never know who is watching, maybe it's your next employer or partner 🙂.

## Step by Step Guide on How to Contribute to Open Source

When we say contributing to open-source, it does not necesarilly mean that you need to know how to code. There are different ways in which you can contribute even if you are a non-coder – but having some coding skills will help you (and the projects) out a lot.

Some common contributions can be through:

- Adding a description to a project's documentation to elaborate on a certain point, mostly referred to as a README file (_check this guide on how to write a_ [Good README file](https://www.freecodecamp.org/news/how-to-write-a-good-readme-file/)).
- Giving guidance on a specific project and how to use it.
- Adding sample output to show how the code works.
- Writing in-depth tutorials for the project.
- Adding translation for a project - A good place to start with this might be with the [freeCodeCamp's translation program](https://contribute.freecodecamp.org/#/index?id=translations).
- Answering questions about a project (like on Stack Overflow or Reddit)
- You can offer to mentor another contributor.
- You can fix typos and arrange the project's work folder correctly.

All these ways, and many more, count towards contributions. Now what exactly should you know before you start contributing to an OS project?

## What to Know Before Contributing to an OS Project

---

Just as we expect each open-source products to be different, so are the communities. Each community has it's own rules and will have different guidelines and roles, and if you are lucky some also do give rewards after you contribute.

But despite all this, there are some common features which apply across all OS projects, and that's what we are going to talk about:

### Roles in a typical OS Project

In a typical OS project we will have the following people:

- **Author** - This is the person who created the project. They have the power to assign new roles to other members to help with the project's maintenance.
- **Owner** - The owner has administrative ownership of the project (and can be the same person as the author)
- **Maintainers** - These people are responsible for driving the vision and goals of the project. They're usually people who feel responsible for the direction of the project and who are committed to improving it.
- **Contributors** - Contributors add to the project in one way or another. They follow the same code review process, are subject to the same requirements on code style, and so on.
- **Community Members/Users** - These valuable members of the community can provide feedback about features, bug reports, and more.

## Must have elements in all OS projects

When talking about an OS project, they are categorized in several ways depending on structure, type of product platform, programming language used, whether it's sponsored or fully independent, and more.

All this info should be outlined with the help of the guidelines and information:

- **License**  
  If a project does not have an open-source license, then it is not open source. The license helps protect contributors and users. Businesses and savvy developers usually won't touch a project without this protection. If you're wondering how to get one and choose the correct one for your project, check out the official OS license website: [https://choosealicense.com/](https://choosealicense.com/).
- **README file**  
  This is a manual that explains how to get started with a project. It lists the requirements for contributing to the project, the steps to take to contribute to the project etc... A good README should contain everything a potential contributor would want to know about the project. If you already have a project and you're trying to write a good README file, this guide will come in handy: [_How to write a good README file_](https://www.freecodecamp.org/news/how-to-write-a-good-readme-file/).
- **Contribution Guidelines**  
  These are guidelines that help people who contribute to the project know exactly what is expected from them. And even though it's not mandatory is always a good practice to add one. If you need help writing one or understanding what it entails, the official OS website has a template guide to help you out: [Contributor guidelines template](https://opensource.com/life/16/3/contributor-guidelines-template-and-tips)
- **Code of Conduct**  
  A code of conduct is a document that establishes your expectations for how your contributors and participants behave. Adopting and enforcing a code of conduct can help create a positive and welcoming environment for your community. The OS guide explains more on what it entails: [https://opensource.guide/code-of-conduct/](https://opensource.guide/code-of-conduct/).

As an individual or an organization running an Open-Source project, it's all about creating a community where people can grow together. This means that you will have to develop a friendly environment where people will get to share ideas, work on challenges, and even have random chats at some time.

There are some go-to options here, and you can use tools like:

- **Issue Tracker**  
  This is where you keep track of your work on GitHub, and how development happens. In case there's any problem a contributor can create an issue and link it to a pull request and fellow contributors can opt in to try and fix it. Then after it's fixed it's closed.
- **Pull Requests**  
  They let you tell others about changes you've pushed to a branch in a repository on GitHub. Once a pull request is opened, you can discuss and review the potential changes with the collaborator and add follow-up commits before the're merged into the base branch.
- **Chat Channel**  
  Although it's not mandatory, you can consider it a good practice to be part of an OS community channel. It is specifically meant for people to share their ideas and have conversations. Some of the most common media for this purpose include Slack and Discord.

So, now you have an idea of what an OS project is and what to expect when you contribute to one. Moving into the most important part, how do you know which project to contribute to?

## How to find an Open Source Project to Contribute to

Contributing works on all levels, there is no need to over think how you're gonna do it. Instead think of some of the projects you already use and how you can make a change to them or improve on them.

Research has shown that around 30% of casual contributions are documentation, typo fixes, or even translations.

At the begining I promised to share some of the projects that helped me out when I made my first contribution. Well lucky you, if you are a first-time contributor – which everybody is at some point – here are some links that will get you started in the open source world:

- [first-timers only](https://www.firsttimersonly.com/)
- [first contribution](https://github.com/firstcontributions/first-contributions)
- [contributor ninja](https://contributor.ninja/)
- [open-source friday](https://opensourcefriday.com/)
- [24 pull requests](https://24pullrequests.com/)
- [python project scripts](https://github.com/larymak/Python-project-Scripts)
- [hebatica](https://habitica.com/static/front)
- [code triage](https://www.codetriage.com/)

_**Quick hack for you** In the world of open-source software, issues get reported and fixed pretty quickly. So, a good way to kick start is to take on an issue and be sure to try to work on it promptly._

## How to choose an Open-Source Project

After you have found the project you want to contribute to, it's time to do a little vetting. Make sure it meets the following criteria so you know it'll be a good project to work on:

1.  Check out if it has a license file.
2.  Check when the last commit was made. This will help you know if the maintainers are active and also give you an estimate on how long it will take to respond to your contribution.
3.  Look for the number of contributors.
4.  Check how often people make commits.

If you see lots of recent activity that's a good sign – it means the community is active and so are the maintainers.

Now, if the first "vetting" checks out, proceed to checking the following points too:

1.  Does it have any open issues? If yes this might be a good sign, you will have a place to begin.
2.  How long does it take for maintainers to respond? This will be determined by how often issues are closed and PRs merged.
3.  Is there an active discussion on an issue?
4.  Are the issues getting closed regularly?
5.  How many open pull requests are there?
6.  How recently was the latest pull requests merged?
7.  Do the maintainers thank people for contributing?

If this final vetting process checks out, then you are good to go and start your contribution.

## What to Consider Before You Go Open Source

I know you are excited and ready to rock the OS world, but do you know what to look for in a project?

As mentioned above, there are different ways in which you can contribute. But before you make your first contribution it's good to note a few things about the project you will be choosing, like:

- **What programming language does the project use?**  
  The most fundamental technology behind any application is the programming language it uses. Some of the most popular languages on GitHub are JavaScript, Python, Java, Ruby, and PHP – but there are many more.  
  There is a multitude of projects that might suit your skills and interests. So just find one that you'd feel comfortable working on.
- **Type of project**  
  After you've chosen the language you want to work with, you will also need to choose the type of project you prefer. Just have a look around and pick a project or a topic that interests you.

Once you've found a project, you'll want to actually make contributions. And you'll do that by submitting pull requests. Let's talk about that now.

## What is a Pull Request?

Remember the example about Goggle Docs? Well, a pull request is similar only this time it's about code.

We can describe a pull request as when a contributor submits changes – wether it's code, documentation, or elsewhere – and asks a maintainer to check it out, make sure it's fine, and then merge it to the base project.

So, how do you submit one?

## How to Submit a Pull Request

If you are at this stage, it means you have found a project and you are ready to make your contribution. So let's talk about how to actually submit a pull request.

### Steps to Submit a PR

- **Fork the repository**  
  At the top right corner, you will see the term "fork". All you need to do is click it and you will have created a copy of the same project in your account.

![fork-repo ](https://www.freecodecamp.org/news/content/images/2021/11/click.png)

After this operation the URL of the project will change to:

    https://github.com/<YourUserName>/projectname

- **Clone the project into your local machine**  
  In order for you to perform this step, you must have Git installed locally in your machine. If you don't, refer to the official [Git docs](https://git-scm.com/) on how to get started.

Copy the forked project URL, and proceed to your local machine where you will open git bash, and proceed with the command below:

    git clone https://github.com/<YourUserName>/<projectname>

This will create a copy of the project on your local machine. Now that you have cloned the repo we will need to do two things:

First is to make the necessary changes/contribution and commit those changes. After making your changes and adding new files, its time to add those changes into a separate branch before pushing them to remote.

But, first let's create a branch. In your git bash, change the path to pint to your repository directory. To do that use this command:

    cd project folder name

Now, to create a branch we will use the command: `git checkout`

    git checkout -b your-new-branch-name

Here's an example:

    git checkout -b lary-mak

It's time to add the new changes into the branch we created. In order to see all the changes you made, we will use the `git status` command:

    git status

The command will list all the changes you made. To add them we will use `git add *`, which will add all the files to our branch.

    git add *

Let's add a commit message, briefly explaining what we added:

    git commit -m "<message here>"

- **Push changes to remote**  
  Now that everything is set, it's time to let our maintainer know what we have added. That is made possible by pushing the changes with this command:

  git push origin <add-your-branch-name>

replacing `<add-your-branch-name>` with the name of the branch you created earlier, in my case it will be `git push origin larykmak`.

- **Submit changes**  
  If you go to your repository on GitHub and refresh the page, you'll see a Compare and pull request button. Click on that button.

Soon the maintainer will merge all your changes into the master branch of this project (unless they need changes from you). You will get a notification email once the changes have been merged.

Creating a pull request has some advantages, like:

- It allows you to contribute to another repo without needing administrative privileges to make changes to the repo.
- It allows others to review your changes and suggest corrections, additions, edits, and so on.
- It gives repo administrators control over what gets added to their project repo.

Congratulations 🥳🎉,  
You just completed the standard fork -> clone -> edit -> pull request work-flow which sums up to your first contribution. You'll use this often as a contributor! So, what next?

## What next after your First Pull Request?

That does not mark the end! Now, just find more projects and keep contributing. Also be sure to be on the lookout for the one month dedicated to open-source contributions every year that's run by _Digital Ocean_ for a chance to win some amazing gifts.

One more thing to talk about a bit more before we end. That is, why contributing to OS is rewarding.

## Benefits of Contributing to Open Source

- People that contribute to an open-source project get to know the technology at a much deeper level than they would by simply using the technology.
- You can focus your efforts on adding and leveraging features that will benefit businesses based on experience with what works and doesn't work in the real world.
- It builds your morale and reputation. People who contribute to open source projects have access to other community members' insights and experience.
- Contributing to open source provides a clear view into the future of a project
- If you're on GitHub, a large portion of the things you do on that platform are public. Use this to your advantage by always doing your best when contributing and communicating with fellow contributors.

## Why You Should Contribute to Open Source as a Developer

- It will help sharpen your skills of coding and improvement into writing clean code.
- It helps the community and your peers get to know you. This recognition can bring you a lot of opportunities in your career.
- It helps you learn more about project management, and it could leave you inspired to start your own project.

## Wrap Up!

As I mentioned, open source is open for every one to participate. There are a lot of opportunities you can take advantage of and learn something new. All you need is to decide to begin and get started.

**OPEN-SOURCE IS WAITING FOR YOU**

If you have read this far, I really appreciate it.
