macro(_COMPILER_SWITCH_APPEND var gcc clang msvc)
    if(MSVC)
        list(APPEND ${var} ${msvc})
    elseif(CMAKE_CXX_COMPILER_ID MATCHES "^(Apple)?Clang$")
        list(APPEND ${var} ${clang})
    else()
        list(APPEND ${var} ${gcc})
    endif()
endmacro(_COMPILER_SWITCH_APPEND)

macro(_COMPILER_SWITCH_SET var gcc clang msvc)
    if(MSVC)
        set(${var} ${msvc})
    elseif(CMAKE_CXX_COMPILER_ID MATCHES "^(Apple)?Clang$")
        set(${var} ${clang})
    else()
        set(${var} ${gcc})
    endif()
endmacro(_COMPILER_SWITCH_SET)

macro(_CPU_FEATURE_SUPPORT_MESSAGE feature supports)
    if(${supports})
        message(STATUS "CPU supports '${feature}'")
    endif(${supports})
    
endmacro(_CPU_FEATURE_SUPPORT_MESSAGE prefix feature)

MACRO(_SUBDIRLIST result curdir)
    FILE(GLOB children RELATIVE ${curdir} ${curdir}/*)
    SET(dirlist "")
    FOREACH(child ${children})
        IF(IS_DIRECTORY ${curdir}/${child})
        LIST(APPEND dirlist ${child})
        ENDIF()
    ENDFOREACH()
    SET(${result} ${dirlist})
ENDMACRO()
