using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Net;
using System.IO;
namespace PlugNT.Pack.Rss
{
    /// <summary>
    /// Feed.cs
    /// </summary>
    public class Feed
    {
        private string _url;
        private System.DateTime _lastModiFied;
        private System.DateTime _lastRssDate;
        private Channel channel = new Channel();
        
        public string url
        {
            get { return _url; }
            set { _url = value; }
        }
        public System.DateTime LastModiFied
        {
            get { return _lastModiFied; }
        }
        public System.DateTime LastRssDate
        {
            set { _lastRssDate = value; }
        }
        public Channel Channel
        {
            get { return channel; }
        }
        public Feed()
        {
        }
        public Feed(string url, System.DateTime dt)
        {
            this._url = url;
            this._lastRssDate = dt;
        }
        public void Read()
        {
            XmlDocument xDoc = new XmlDocument();
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(_url);
            request.Timeout = 20000;
            request.UserAgent = @"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 2.0.40607; .NET CLR 1.1.4322)";
            Stream stream;
            HttpWebResponse response = (HttpWebResponse)request.GetResponse();
            this._lastModiFied = response.LastModified;
            stream = response.GetResponseStream();
            StreamReader sr;
            if (this.Get_CH(response.Headers["Content-Type"].ToString()) == "GBK")
            {
                sr = new StreamReader(stream, System.Text.Encoding.GetEncoding("GB2312"));
                xDoc.Load(sr);
            }
            else
            {
                xDoc.Load(stream);
            }
            if (this._lastRssDate < this._lastModiFied)
            {
                XmlNodeList xnList = xDoc.DocumentElement["channel"].SelectNodes("item");
                int a = xnList.Count;
                foreach (XmlNode xNode in xnList)
                {
                    Item rt = new Item();
                    rt.Title = xNode.SelectSingleNode("title").InnerText.Replace("'", "''");
                    rt.Link = xNode.SelectSingleNode("link").InnerText.Replace("'", "''");
                    rt.Description = xNode.SelectSingleNode("description").InnerText.Replace("'", "''");
                    try
                    {
                        rt.PubDate = xNode.SelectSingleNode("pubDate").InnerText;
                    }
                    catch
                    {
                        rt.PubDate = this._lastModiFied.ToString();
                    }
                    channel.Items.Add(rt);
                }
            }
        }
        public void WriteCss(string path)
        {
            StreamWriter rw;
            string newPath = path.EndsWith("rsstyle.css") ? path : path + @"\rsstyle.css";
            rw = new StreamWriter(newPath, false, Encoding.UTF8);
            rw.Write(Css);
            rw.Flush();
            rw.Close();
        }
        public string Css
        {
            get
            {
                return @"
                channel
                {
	                font-size: 14pt;
	                background: white;
	                margin: 10px;
	                width: 100%;
	                font-family: , , verdana, arial, helvetica, sans-serif;
                }
                managingEditor, webMaster, title, link, description, copyright, lastBuildDate, pubDate 
                { 
	                display: block; font-size: medium; 
                }
                rss, item title, item link, item description, item 
                {
	                display: block;
	                font-weight: normal;
	                font-size: 12pt;
	                background-image: none;
	                margin: 5px;
	                background-color: #ffffcc;
                }
                image, image title, image height, image width, image url, category, ttl, generator, guid, language, docs, comments,pubDate
                { 
	                display: none; 
                }
                channel
                {
	                padding-right: 10px;
	                padding-left: 10px;
	                padding-bottom: 10px;
	                margin: 0px auto;
	                width: 100%;
	                padding-top: 10px;
	                text-align: center;
                }
                item
                {
	                padding-right: 10px;
	                display: block;
	                padding-left: 10px;
	                font-size: small;
	                padding-bottom: 10px;
	                margin: 20px 0px;
	                width: 80%;
	                line-height: 150%;
	                padding-top: 10px;
	                border-bottom: red 1px solid;
	                text-align: left;
                }
                channel title
                {
	                display: block;
	                font-weight: bold;
	                font-size: large;
	                z-index: 1;
	                position: relative;
	                height: auto;
                }
                item title { font-weight: bold; font-size: 16px; display: block; height: auto; position: relative; z-index: 1}
                item link { margin-bottom: 9pt; }
                link { display: block; color: blue; text-decoration: underline; }
                info { display: block; margin: 3em 4em 3em 4em; color: Black; background: #FFFACD; border: solid #CCCC66 2px; text-align: center; padding: 1.5em; font-family: mono; font-size: small; }
                ";
            }
        }
        public void Write(string filePath)
        {
            StreamWriter rw;
            rw = new StreamWriter(filePath, false, Encoding.UTF8);
            int tCount = channel.Items.Count;
            rw.WriteLine("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            rw.WriteLine("<?xml-stylesheet type=\"text/css\" href=\"rsstyle.css\"?>");
            rw.WriteLine("<rss version=\"2.0\">");
            rw.WriteLine("<channel>");
            rw.WriteLine("<title>" + channel.Title + "</title>");
            rw.WriteLine("<link>" + channel.Link + "</link>");
            for (int i = 0; i < tCount; i++)
            {
                rw.WriteLine("<item>");
                rw.WriteLine("<title>" + channel.Items[i].Title + "</title>");
                rw.WriteLine("<link>" + channel.Items[i].Link + "</link>");
                rw.WriteLine("<description><![CDATA[" + channel.Items[i].Description + "]]></description>");
                rw.WriteLine("<pubDate>" + channel.Items[i].PubDate + "</pubDate>");
                rw.WriteLine("</item>");
            }
            rw.WriteLine("</channel>");
            rw.WriteLine("</rss>");
            rw.Flush();
            rw.Close();
        }
        private string Get_CH(string s)
        {
            int l = s.IndexOf("charset=") + 8;
            return s.Substring(l, s.Length - l);
        }
    }
}

