/**********************************************************************************
 * ˵     ͼƬˮӡ
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.IO;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
namespace PlugNT.Pack.Imager
{
    /// <summary>
    /// ˮӡ
    /// </summary>
    public class WaterMark
    {
        private string _waterimagepath;
        private string _savepath;
        private byte[] _imgbytes;
        private Stream _imgstream;
        private int _transparency;
        private int _quality;
        private int _waterstatus;
        private string _watertext;
        private string _waterfontname;
        private int _waterfontsize;
        private static PixelFormat[] indexedPixelFormats = { PixelFormat.Undefined, PixelFormat.DontCare, PixelFormat.Format16bppArgb1555, PixelFormat.Format1bppIndexed, PixelFormat.Format4bppIndexed, PixelFormat.Format8bppIndexed };
        private static bool IsPixelFormatIndexed(PixelFormat imgPixelFormat)
        {
            foreach (PixelFormat pf in indexedPixelFormats)
            {
                if (pf.Equals(imgPixelFormat)) return true;
            }
            return false;
        }
        public WaterMark()
        {
        }
        /// <summary>
        /// ˮӡͼƬ·
        /// </summary>
        public string WaterImagePath
        {
            get { return _waterimagepath; }
            set
            {
                _waterimagepath = value;
            }
        }
        /// <summary>
        /// ͼƬ·
        /// </summary>
        public string SavePath
        {
            get { return _savepath; }
            set
            {
                _savepath = value;
            }
        }
        /// <summary>
        /// ϴͼƬֽ(ΪϴͼƬ)
        /// </summary>
        public byte[] ImgBytes
        {
            get { return _imgbytes; }
            set
            {
                _imgbytes = value;
            }
        }
        /// <summary>
        /// ϴͼƬ(ΪSavePathȡ)
        /// </summary>
        public Stream ImgStream
        {
            get { return _imgstream; }
            set
            {
                _imgstream = value;
            }
        }
        /// <summary>
        /// ͼƬ͸1-1010Ϊ͸
        /// </summary>
        public int Transparency
        {
            get { return _transparency; }
            set
            {
                _transparency = value;
            }
        }
        /// <summary>
        /// ͼƬ0-100֮
        /// </summary>
        public int Quality
        {
            get { return _quality; }
            set
            {
                _quality = value;
            }
        }
        /// <summary>
        /// ˮӡͼƬλ0Ϊ1-9λ
        /// </summary>
        public int Waterstatus
        {
            get { return _waterstatus; }
            set
            {
                _waterstatus = value;
            }
        }
        /// <summary>
        /// ˮӡ
        /// </summary>
        public string WaterText
        {
            get { return _watertext; }
            set
            {
                _watertext = value;
            }
        }
        /// <summary>
        /// ˮӡ
        /// </summary>
        public string WaterFontName
        {
            get { return _waterfontname; }
            set
            {
                _waterfontname = value;
            }
        }
        /// <summary>
        /// ˮӡִС
        /// </summary>
        public int WaterFontSize
        {
            get { return _waterfontsize; }
            set
            {
                _waterfontsize = value;
            }
        }
        /// <summary>
        /// ˮӡע⣬Ĵ¼ͼƬˮӡĴ벻ܹ 
        /// </summary>
        /// <returns></returns>
        public string SaveStringWater() 
        {
            if (SavePath == null || SavePath == "")
            {
                return "ͼƬ·Ϊգ";
            }
            if (Quality == 0)
            {
                return "ҪˮӡͼƬΪգ";
            }
            if (WaterText == null)
            {
                return "ˮӡֲΪգ";
            }
            if (WaterFontName == null)
            {
                return "ˮӡΪգ";
            }
            if (WaterFontSize == 0)
            {
                return "ˮӡִСΪգ";
            }
            int quality = Quality;                     
            int watermarkStatus = Waterstatus;         
            string filename = SavePath;
            string watermarkText = WaterText;
            string fontname = WaterFontName;
            int fontsize = WaterFontSize;
            Image img = null;
            if (ImgBytes == null)
            {
                if (ImgStream == null)
                {
                    if (!File.Exists(SavePath))
                    {
                        return "ͼƬ·";
                    }
                    byte[] _ImageBytes = File.ReadAllBytes(SavePath);
                    img = Image.FromStream(new System.IO.MemoryStream(_ImageBytes));
                }
                else
                {
                    img = Image.FromStream(ImgStream);
                }
            }
            else
            {
                img = Image.FromStream(new System.IO.MemoryStream(ImgBytes));
            }
            Font drawFont = new Font(fontname, fontsize, FontStyle.Regular, GraphicsUnit.Pixel);
            float xpos = 0;
            float ypos = 0;
            SizeF crSize;
            if (IsPixelFormatIndexed(img.PixelFormat))
            {
                Bitmap bmp = new Bitmap(img.Width, img.Height, PixelFormat.Format32bppArgb);
                using (Graphics g2 = Graphics.FromImage(bmp))
                {
                    g2.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
                    g2.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                    g2.CompositingQuality = System.Drawing.Drawing2D.CompositingQuality.HighQuality;
                    g2.DrawImage(img, 0, 0);
                }
                System.Drawing.Graphics g3 = System.Drawing.Graphics.FromImage(bmp);
                crSize = g3.MeasureString(watermarkText, drawFont);
                switch (watermarkStatus)
                {
                    case 1:
                        xpos = (float)img.Width * (float).01;
                        ypos = (float)img.Height * (float).01;
                        break;
                    case 2:
                        xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
                        ypos = (float)img.Height * (float).01;
                        break;
                    case 3:
                        xpos = ((float)img.Width * (float).99) - crSize.Width;
                        ypos = (float)img.Height * (float).01;
                        break;
                    case 4:
                        xpos = (float)img.Width * (float).01;
                        ypos = ((float)img.Height * (float).50) - (crSize.Height / 2);
                        break;
                    case 5:
                        xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
                        ypos = ((float)img.Height * (float).50) - (crSize.Height / 2);
                        break;
                    case 6:
                        xpos = ((float)img.Width * (float).99) - crSize.Width;
                        ypos = ((float)img.Height * (float).50) - (crSize.Height / 2);
                        break;
                    case 7:
                        xpos = (float)img.Width * (float).01;
                        ypos = ((float)img.Height * (float).99) - crSize.Height;
                        break;
                    case 8:
                        xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
                        ypos = ((float)img.Height * (float).99) - crSize.Height;
                        break;
                    case 9:
                        xpos = ((float)img.Width * (float).99) - crSize.Width;
                        ypos = ((float)img.Height * (float).99) - crSize.Height;
                        break;
                }
                g3.DrawString(watermarkText, drawFont, new SolidBrush(Color.White), xpos + 1, ypos + 1);
                g3.DrawString(watermarkText, drawFont, new SolidBrush(Color.Black), xpos, ypos);
                bmp.Save(filename);
                g3.Dispose();
                bmp.Dispose();
                img.Dispose();
                return "";
            }
            else
            {
                Graphics g = Graphics.FromImage(img);
                crSize = g.MeasureString(watermarkText, drawFont);
                switch (watermarkStatus)
                {
                    case 1:
                        xpos = (float)img.Width * (float).01;
                        ypos = (float)img.Height * (float).01;
                        break;
                    case 2:
                        xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
                        ypos = (float)img.Height * (float).01;
                        break;
                    case 3:
                        xpos = ((float)img.Width * (float).99) - crSize.Width;
                        ypos = (float)img.Height * (float).01;
                        break;
                    case 4:
                        xpos = (float)img.Width * (float).01;
                        ypos = ((float)img.Height * (float).50) - (crSize.Height / 2);
                        break;
                    case 5:
                        xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
                        ypos = ((float)img.Height * (float).50) - (crSize.Height / 2);
                        break;
                    case 6:
                        xpos = ((float)img.Width * (float).99) - crSize.Width;
                        ypos = ((float)img.Height * (float).50) - (crSize.Height / 2);
                        break;
                    case 7:
                        xpos = (float)img.Width * (float).01;
                        ypos = ((float)img.Height * (float).99) - crSize.Height;
                        break;
                    case 8:
                        xpos = ((float)img.Width * (float).50) - (crSize.Width / 2);
                        ypos = ((float)img.Height * (float).99) - crSize.Height;
                        break;
                    case 9:
                        xpos = ((float)img.Width * (float).99) - crSize.Width;
                        ypos = ((float)img.Height * (float).99) - crSize.Height;
                        break;
                }
                g.DrawString(watermarkText, drawFont, new SolidBrush(Color.White), xpos + 1, ypos + 1);
                g.DrawString(watermarkText, drawFont, new SolidBrush(Color.Black), xpos, ypos);
                ImageCodecInfo[] codecs = ImageCodecInfo.GetImageEncoders();
                ImageCodecInfo ici = null;
                foreach (ImageCodecInfo codec in codecs)
                {
                    if (codec.MimeType.IndexOf("jpeg") > -1)
                    {
                        ici = codec;
                    }
                }
                EncoderParameters encoderParams = new EncoderParameters();
                long[] qualityParam = new long[1];
                if (quality < 0 || quality > 100)
                {
                    quality = 80;
                }
                qualityParam[0] = quality;
                EncoderParameter encoderParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, qualityParam);
                encoderParams.Param[0] = encoderParam;
                if (ici != null)
                {
                    img.Save(filename, ici, encoderParams);
                }
                else
                {
                    img.Save(filename);
                }
                g.Dispose();
                img.Dispose();
                return "";
            }
        }
        /// <summary>
        /// ͼƬˮӡ
        /// </summary>
        /// <returns></returns>
        public string SaveImageWater()
        {
            if (WaterImagePath == null || WaterImagePath=="")
            {
                return "ˮӡͼƬ·Ϊգ";
            }
            if (!File.Exists(WaterImagePath))
            {
                return "ˮӡͼƬ·";
            }
            if (SavePath == null || SavePath == "")
            {
                return "ͼƬ·Ϊգ";
            }
            if (Transparency == 0)
            {
                return "ҪˮӡͼƬ͸ȲΪգ";
            }
            if (Quality == 0)
            {
                return "ҪˮӡͼƬΪգ";
            }
            if (Waterstatus == 0)
            {
                return "ˮӡͼƬλòΪգ";
            }
            int watermarkTransparency = Transparency; 
            int quality = Quality;              
            int watermarkStatus = Waterstatus;         
            string filename = SavePath;
            string watermarkFilename = WaterImagePath;
            Image img =null;
            if (ImgBytes == null)
            {
                if (ImgStream == null)
                {
                    if (!File.Exists(SavePath))
                    {
                        return "ͼƬ·";
                    }
                    byte[] _ImageBytes = File.ReadAllBytes(SavePath);
                    img = Image.FromStream(new System.IO.MemoryStream(_ImageBytes));
                }
                else
                {
                    img = Image.FromStream(ImgStream);
                }
            }
            else
            {
                img = Image.FromStream(new System.IO.MemoryStream(ImgBytes));
            }
            Image watermark = new Bitmap(watermarkFilename);
            int xpos = 0;
            int ypos = 0;
            switch (watermarkStatus)
            {
                case 1:
                    xpos = (int)(img.Width * (float).01);
                    ypos = (int)(img.Height * (float).01);
                    break;
                case 2:
                    xpos = (int)((img.Width * (float).50) - (watermark.Width / 2));
                    ypos = (int)(img.Height * (float).01);
                    break;
                case 3:
                    xpos = (int)((img.Width * (float).99) - (watermark.Width));
                    ypos = (int)(img.Height * (float).01);
                    break;
                case 4:
                    xpos = (int)(img.Width * (float).01);
                    ypos = (int)((img.Height * (float).50) - (watermark.Height / 2));
                    break;
                case 5:
                    xpos = (int)((img.Width * (float).50) - (watermark.Width / 2));
                    ypos = (int)((img.Height * (float).50) - (watermark.Height / 2));
                    break;
                case 6:
                    xpos = (int)((img.Width * (float).99) - (watermark.Width));
                    ypos = (int)((img.Height * (float).50) - (watermark.Height / 2));
                    break;
                case 7:
                    xpos = (int)(img.Width * (float).01);
                    ypos = (int)((img.Height * (float).99) - watermark.Height);
                    break;
                case 8:
                    xpos = (int)((img.Width * (float).50) - (watermark.Width / 2));
                    ypos = (int)((img.Height * (float).99) - watermark.Height);
                    break;
                case 9:
                    xpos = (int)((img.Width * (float).99) - (watermark.Width));
                    ypos = (int)((img.Height * (float).99) - watermark.Height);
                    break;
            }
            if (IsPixelFormatIndexed(img.PixelFormat))
            {
                Bitmap bmp = new Bitmap(img.Width, img.Height, PixelFormat.Format32bppArgb);
                using (Graphics g2 = Graphics.FromImage(bmp))
                {
                    g2.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
                    g2.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                    g2.CompositingQuality = System.Drawing.Drawing2D.CompositingQuality.HighQuality;
                    g2.DrawImage(img, 0, 0);
                }
                System.Drawing.Graphics g3 = System.Drawing.Graphics.FromImage(bmp);
                g3.DrawImage(watermark, new System.Drawing.Rectangle(xpos, ypos, watermark.Width, watermark.Height), 0, 0, watermark.Width, watermark.Height, System.Drawing.GraphicsUnit.Pixel);
                bmp.Save(filename);
                g3.Dispose();
                bmp.Dispose();
                img.Dispose();
                watermark.Dispose();
                return "";
            }
            else
            {
                Graphics g = Graphics.FromImage(img);
                if (watermark.Height >= img.Height || watermark.Width >= img.Width)
                {
                    return "ˮӡͼƬȺ͸߶ȲܴϴͼƬֵ";
                }
                ImageAttributes imageAttributes = new ImageAttributes();
                ColorMap colorMap = new ColorMap();
                colorMap.OldColor = Color.FromArgb(255, 0, 255, 0);
                colorMap.NewColor = Color.FromArgb(0, 0, 0, 0);
                ColorMap[] remapTable = { colorMap };
                imageAttributes.SetRemapTable(remapTable, ColorAdjustType.Bitmap);
                float transparency = 0.5F;
                if (watermarkTransparency >= 1 && watermarkTransparency <= 10)
                {
                    transparency = (watermarkTransparency / 10.0F);
                }
                float[][] colorMatrixElements = {
												new float[] {1.0f,  0.0f,  0.0f,  0.0f, 0.0f},
												new float[] {0.0f,  1.0f,  0.0f,  0.0f, 0.0f},
												new float[] {0.0f,  0.0f,  1.0f,  0.0f, 0.0f},
												new float[] {0.0f,  0.0f,  0.0f,  transparency, 0.0f},
												new float[] {0.0f,  0.0f,  0.0f,  0.0f, 1.0f}
											};
                ColorMatrix colorMatrix = new ColorMatrix(colorMatrixElements);
                imageAttributes.SetColorMatrix(colorMatrix, ColorMatrixFlag.Default, ColorAdjustType.Bitmap);
                g.DrawImage(watermark, new Rectangle(xpos, ypos, watermark.Width, watermark.Height), 0, 0, watermark.Width, watermark.Height, GraphicsUnit.Pixel, imageAttributes);
                ImageCodecInfo[] codecs = ImageCodecInfo.GetImageEncoders();
                ImageCodecInfo ici = null;
                foreach (ImageCodecInfo codec in codecs)
                {
                    if (codec.MimeType.IndexOf("jpeg") > -1)
                    {
                        ici = codec;
                    }
                }
                EncoderParameters encoderParams = new EncoderParameters();
                long[] qualityParam = new long[1];
                if (quality < 0 || quality > 100)
                {
                    quality = 80;
                }
                qualityParam[0] = quality;
                EncoderParameter encoderParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, qualityParam);
                encoderParams.Param[0] = encoderParam;
                if (ici != null)
                {
                    img.Save(filename, ici, encoderParams);
                }
                else
                {
                    img.Save(filename);
                }
                g.Dispose();
                img.Dispose();
                watermark.Dispose();
                imageAttributes.Dispose();
                return "";
            }
        }
        public static string Help()
        {
            return @"mailto:354990393@qq.com";
        }
    }
}

