namespace PlugNT.Pack.Editer.Ubb
{
    using System;
    using System.Text.RegularExpressions;
    public class TypeConverter
    {
        public static float ObjectToFloat(object strValue)
        {
            return ObjectToFloat(strValue.ToString(), 0f);
        }
        public static float ObjectToFloat(object strValue, float defValue)
        {
            if (strValue == null)
            {
                return defValue;
            }
            return StrToFloat(strValue.ToString(), defValue);
        }
        public static int ObjectToInt(object expression)
        {
            return ObjectToInt(expression, 0);
        }
        public static int ObjectToInt(object expression, int defValue)
        {
            if (expression != null)
            {
                return StrToInt(expression.ToString(), defValue);
            }
            return defValue;
        }
        public static bool StrToBool(object expression, bool defValue)
        {
            if (expression != null)
            {
                return StrToBool(expression, defValue);
            }
            return defValue;
        }
        public static bool StrToBool(string expression, bool defValue)
        {
            if (expression != null)
            {
                if (string.Compare(expression, "true", true) == 0)
                {
                    return true;
                }
                if (string.Compare(expression, "false", true) == 0)
                {
                    return false;
                }
            }
            return defValue;
        }
        public static float StrToFloat(object strValue)
        {
            if (strValue == null)
            {
                return 0f;
            }
            return StrToFloat(strValue.ToString(), 0f);
        }
        public static float StrToFloat(object strValue, float defValue)
        {
            if (strValue == null)
            {
                return defValue;
            }
            return StrToFloat(strValue.ToString(), defValue);
        }
        public static float StrToFloat(string strValue, float defValue)
        {
            if ((strValue == null) || (strValue.Length > 10))
            {
                return defValue;
            }
            float intValue = defValue;
            if ((strValue != null) && Regex.IsMatch(strValue, @"^([-]|[0-9])[0-9]*(\.\w*)?$"))
            {
                float.TryParse(strValue, out intValue);
            }
            return intValue;
        }
        public static int StrToInt(string str)
        {
            return StrToInt(str, 0);
        }
        public static int StrToInt(string str, int defValue)
        {
            int rv;
            if (!((!string.IsNullOrEmpty(str) && (str.Trim().Length < 11)) && Regex.IsMatch(str.Trim(), @"^([-]|[0-9])[0-9]*(\.\w*)?$")))
            {
                return defValue;
            }
            if (int.TryParse(str, out rv))
            {
                return rv;
            }
            return Convert.ToInt32(StrToFloat(str, (float) defValue));
        }
    }
}

