using System;
using System.Text;
using System.Text.RegularExpressions;
namespace PlugNT.Pack.Editer.Ubb
{
    public class Editors
    {
        public static Regex[] regexCustomTag = null;
        static Editors()
        {
            InitRegexCustomTag();
        }
        public static CustomEditorButtonInfo[] GetCustomEditButtonListWithInfo()
        {
            return null;
        }
        public static void InitRegexCustomTag()
        {
            CustomEditorButtonInfo[] tagList = GetCustomEditButtonListWithInfo();
            if (tagList != null)
            {
                ResetRegexCustomTag(tagList);
            }
        }
        public static void ResetRegexCustomTag(CustomEditorButtonInfo[] tagList)
        {
            int tagCount = tagList.Length;
            if ((regexCustomTag == null) || (tagCount != regexCustomTag.Length))
            {
                regexCustomTag = new Regex[tagCount];
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < tagCount; i++)
            {
                if (builder.Length > 0)
                {
                    builder.Remove(0, builder.Length);
                }
                builder.Append(@"(\[");
                builder.Append(tagList[i].Tag);
                if (tagList[i].Params > 1)
                {
                    builder.Append("=");
                    for (int j = 2; j <= tagList[i].Params; j++)
                    {
                        builder.Append("(.*?)");
                        if (j < tagList[i].Params)
                        {
                            builder.Append(",");
                        }
                    }
                }
                builder.Append(@"\])([\s\S]+?)\[\/");
                builder.Append(tagList[i].Tag);
                builder.Append(@"\]");
                regexCustomTag[i] = new Regex(builder.ToString(), RegexOptions.IgnoreCase);
            }
        }
    }
}

