using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.ComponentModel;
using System.Text;
using System.Security.Permissions;
using System.Globalization;
using System.Resources;
using System.Collections.Specialized;
namespace PlugNT.Pack.Editer
{
    /// <summary>
    /// ༭(Msn,QQ)
    /// </summary>
    public enum EditType
    {
        Msn=0,
        Discuz = 1
    }
    [AspNetHostingPermission(SecurityAction.Demand, Level = AspNetHostingPermissionLevel.Minimal)]
    [DefaultProperty("RootPath")]
    [DefaultEvent("UploadChanged")]
    [ToolboxData("<{0}:EditerBox runat=server></{0}:EditerBox>")]
    public class EditBox : Panel, INamingContainer
    {
        public EditType EType = EditType.Msn;
        [Description("¼url"), Category("")]
        public string LoginUrl
        {
            get
            {
                object savedState = this.ViewState["LoginUrl"];
                return ((savedState == null) ? "/ubb" : ((string)savedState));
            }
            set
            {
                this.ViewState["LoginUrl"] = value;
            }
        }
        [Description("עurl"), Category("ⲿ")]
        public string RegisterUrl
        {
            get
            {
                object savedState = this.ViewState["RegisterUrl"];
                return ((savedState == null) ? "/ubb" : ((string)savedState));
            }
            set
            {
                this.ViewState["RegisterUrl"] = value;
            }
        }
        [Description("ȡ EditBox ؼǷá"), Category("")]
        public bool Enable
        {
            get
            {
                object savedState = this.ViewState["Enable"];
                return ((savedState == null) ? false : ((bool)savedState));
            }
            set
            {
                this.ViewState["Enable"] = value;
            }
        }
        [Bindable(true), Category("Appearance"), DefaultValue(""), Localizable(true)]
        public string RootPath
        {
            get
            {
                String s = (String)ViewState["AguiEditerRootPath"];
                return ((s == null) ? String.Empty : s);
            }
            set
            {
                ViewState["AguiEditerRootPath"] = value;
            }
        }
        [Bindable(true), Category("Appearance"), DefaultValue(""), Localizable(true)]
        public string ClientUploadFunction
        {
            get
            {
                String s = (String)ViewState["AguiEditerClientUploadFunction"];
                return ((s == null) ? String.Empty : s);
            }
            set
            {
                ViewState["AguiEditerClientUploadFunction"] = value;
            }
        }
        [Bindable(true), Category("Appearance"), DefaultValue(""), Localizable(true)]
        public string Text
        {
            get
            {
                String s = GetText();
                s = (s == null) ? (String)ViewState["AguiEditerText"] : s;
                return ((s == null) ? String.Empty : s);
            }
            set
            {
                ViewState["AguiEditerText"] = value;
            }
        }
        private string  GetText()
        {
            return HttpContext.Current.Request.Form["h" + this.ID];
        }
        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
        }
        protected override void OnLoad(EventArgs e)
        {
            EventArgs args = new EventArgs();
            base.OnLoad(e);
        }
        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="output"></param>
        protected override void RenderContents(HtmlTextWriter output)
        {
            StringBuilder html = new StringBuilder();
            string path = RootPath.Trim().EndsWith("/") ? RootPath.Trim() : RootPath.Trim() + "/";
            string cfun = ClientUploadFunction.Trim();
            string errStr = "";
            if (RootPath.Trim() == "")
            {
                errStr += "<br><pre> Ŀ¼δã</pre>";
            }
            if (errStr != "")
            {
                output.Write(errStr);
                return;
            }
            switch (EType)
            {
                case EditType.Msn:
                    path =path+ "msn/";
                    html.Append("<input id=\"h" + this.ID + "\" name=\"h" + this.ID + "\" type=\"hidden\" value=\"" + System.Web.HttpUtility.HtmlEncode(this.Text.Trim()) + "\" />");
                    if (this.Enable)
                    {
                    html.Append("<iframe style=\"border: none\" id=\"i" + this.ID + "\" name=\"i" + this.ID + "\" src=\"" + path + "editor.html?id=h" + this.ID + "&funstr=" + cfun + "\" width=\"" + this.Width.Value + "\" height=\"" + this.Height.Value + "\" onblur=\"document.getElementById('h" + this.ID + "').value=document.frames.i" + this.ID + ".getHTML(true);\"></iframe>");
                    }
                    else
                    {
                        html.Append(string.Concat(new object[] { "<iframe src=\"", path, "disabled_editor.html?id=", base.ID, "&TextHeight=", this.Height.Value, "&logurl=", this.LoginUrl, "&regurl=", this.RegisterUrl, "&funstr=", cfun, "\" name=\"", base.ID, "_TempFrame\" id=\"", base.ID, "_TempFrame\" style=\"height:", this.Height, ";width:", this.Width, "\" frameborder='0' marginheight='0' marginwidth='0' scrolling='no' allowtransparency='true'></iframe>" }));
                    }
                    break;
                case EditType.Discuz:
                    path = path + "discuz/";
                    html.Append("<textarea name=\"" + base.ID + "\" id=\"" + base.ID + "\" style='display:none'>" + this.Text + "</textarea>");
                    if (this.Enable)
                    {
                        html.Append(string.Concat(new object[] { "<iframe src=\"", path, "editor.html?id=", base.ID, "&TextHeight=", this.Height.Value, "\" name=\"", base.ID, "_TempFrame\" id=\"", base.ID, "_TempFrame\" style=\"height:", this.Height, ";width:", this.Width, "\" frameborder='0' marginheight='0' marginwidth='0' scrolling='no' allowtransparency='true'></iframe>" }));
                    }
                    else
                    {
                        html.Append(string.Concat(new object[] { "<iframe src=\"", path, "disabled_editor.html?id=", base.ID, "&TextHeight=", this.Height.Value, "&logurl=", this.LoginUrl, "&regurl=", this.RegisterUrl,"&funstr=", cfun , "\" name=\"", base.ID, "_TempFrame\" id=\"", base.ID, "_TempFrame\" style=\"height:", this.Height, ";width:", this.Width, "\" frameborder='0' marginheight='0' marginwidth='0' scrolling='no' allowtransparency='true'></iframe>" }));
                    }
                    break;
                default:
                    break;
            }
            output.Write(html);
        }
    }
}

