using System;
using System.ComponentModel;
using System.Text;
using System.Web.UI;
namespace PlugNT.Pack.Control
{
    /// <summary>
    /// WebControlӿ
    /// </summary>
    public interface IWebControl
    {
        /// <summary>
        /// ʾ
        /// </summary>
        string HintTitle { set; get; }
        /// <summary>
        /// ʾ
        /// </summary>
        string HintInfo { set; get; }
        /// <summary>
        /// ʾƫ
        /// </summary>
        int HintLeftOffSet { set; get; }
        /// <summary>
        /// ʾ򶥲ƫ
        /// </summary>
        int HintTopOffSet { set; get; }
        /// <summary>
        /// ʾ߶
        /// </summary>
        int HintHeight { set; get; }
    }
    /// <summary>
    /// DiscuzNT WebControl 
    /// </summary>
    public class WebControl : System.Web.UI.WebControls.WebControl, IWebControl
    {
        private string _hintTitle = "";
        private string _hintInfo = "";
        private int _hintLeftOffSet = 0;
        private int _hintTopOffSet = 0;
        private string _hintShowType = "up";//"down"
        private int _hintHeight = 50;
        /// <summary>
        /// ʾ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string HintTitle
        {
            get { return _hintTitle; }
            set { _hintTitle = value; }
        }
        /// <summary>
        /// ʾ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string HintInfo
        {
            get { return _hintInfo; }
            set { _hintInfo = value; }
        }
        /// <summary>
        /// ʾƫ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(0)]
        public int HintLeftOffSet
        {
            get { return _hintLeftOffSet; }
            set { _hintLeftOffSet = value; }
        }
        /// <summary>
        /// ʾ򶥲ƫ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(0)]
        public int HintTopOffSet
        {
            get { return _hintTopOffSet; }
            set { _hintTopOffSet = value; }
        }
        /// <summary>
        /// ʾ,up(Ϸʾ)down(·ʾ)
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("up")]
        public string HintShowType
        {
            get { return _hintShowType; }
            set { _hintShowType = value; }
        }
        /// <summary>
        /// ʾ߶
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(50)]
        public int HintHeight
        {
            get { return _hintHeight; }
            set { _hintHeight = value; }
        }
    }
}

