using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.ComponentModel;
using System.Text;
using System.Security.Permissions;
using System.Globalization;
using System.Resources;
using System.Collections.Specialized;
namespace PlugNT.Pack.Control
{
    [DefaultProperty("Text"), ToolboxData("<{0}:TextBox runat=server></{0}:TextBox>"), Designer("System.Web.UI.Design.WebControls.PreviewControlDesigner, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
    public class EditerBox : System.Web.UI.WebControls.TextBox, IWebControl
    {
        /// <summary>
        /// RequiredFieldValidatorؼ
        /// </summary>
        protected System.Web.UI.WebControls.RequiredFieldValidator CanBeNullRFV = new RequiredFieldValidator();
        /// <summary>
        /// RegularExpressionValidatorؼ
        /// </summary>
        protected System.Web.UI.WebControls.RegularExpressionValidator RequiredFieldTypeREV = new RegularExpressionValidator();
        /// <summary>
        /// RangeValidatorؼ
        /// </summary>
        protected System.Web.UI.WebControls.RangeValidator NumberRV = new System.Web.UI.WebControls.RangeValidator();
        /// <summary>
        /// 캯
        /// </summary>
        public EditerBox()
            : base()
        {
            base.Attributes.Add("onfocus", "this.className='FormFocus';");
            base.Attributes.Add("onblur", "this.className='FormBase';");
            base.CssClass = "FormBase";
        }
        /// <summary>
        /// Է
        /// </summary>
        /// <param name="key">ֵ,class</param>
        /// <param name="valuestr">Ҫ󶨵ַ</param>
        public void AddAttributes(string key, string valuestr)
        {
            this.Attributes.Add(key, valuestr);
        }
        /// <summary>
        /// ӿؼ
        /// </summary>
        protected override void CreateChildControls()
        {
            if (this.MaximumValue != null || this.MinimumValue != null)
            {
                NumberRV.ControlToValidate = this.ID;
                NumberRV.Type = ValidationDataType.Double;
                if (this.MaximumValue != null && this.MinimumValue != null)
                {
                    NumberRV.MaximumValue = this.MaximumValue;
                    NumberRV.MinimumValue = this.MinimumValue;
                    NumberRV.ErrorMessage = "ǰӦ" + this.MinimumValue + "" + this.MaximumValue + "֮!";
                }
                else
                {
                    if (this.MaximumValue != null)
                    {
                        NumberRV.MaximumValue = this.MaximumValue;
                        NumberRV.MinimumValue = Int32.MinValue.ToString();
                        NumberRV.ErrorMessage = "ǰֵΪ" + this.MaximumValue;
                    }
                    if (this.MinimumValue != null)
                    {
                        NumberRV.MinimumValue = this.MinimumValue;
                        NumberRV.MaximumValue = Int32.MaxValue.ToString();
                        NumberRV.ErrorMessage = "ǰСֵΪ" + this.MinimumValue;
                    }
                }
                NumberRV.Display = ValidatorDisplay.Static;
                this.Controls.AddAt(0, NumberRV);
            }
            if ((RequiredFieldType != null) && (RequiredFieldType != "") && (RequiredFieldType != "У"))
            {
                RequiredFieldTypeREV.Display = System.Web.UI.WebControls.ValidatorDisplay.Dynamic;
                RequiredFieldTypeREV.ControlToValidate = this.ID;
                switch (RequiredFieldType)
                {
                    case "У":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : "^[-]?\\d+[.]?\\d*$";
                            RequiredFieldTypeREV.ErrorMessage = "ֵĸʽȷ"; break;
                        }
                    case "":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : (@"^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$");
                            RequiredFieldTypeREV.ErrorMessage = "ĸʽȷ"; break;
                        }
                    case "ƶֻ":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : "\\d{11}";
                            RequiredFieldTypeREV.ErrorMessage = "ֻλӦΪ11λ!"; break;
                        }
                    case "õ绰":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : "((\\(\\d{3}\\) ?)|(\\d{3}-))?\\d{3}-\\d{4}|((\\(\\d{3}\\) ?)|(\\d{4}-))?\\d{4}-\\d{4}";
                            RequiredFieldTypeREV.ErrorMessage = " (XXX)XXX-XXXX ʽ (XXX)XXXX-XXXX 绰룡"; break;
                        }
                    case "֤":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : "^\\d{15}$|^\\d{18}$";
                            RequiredFieldTypeREV.ErrorMessage = "1518λݵ֤ţ"; break;
                        }
                    case "ҳַ":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : @"^(http|https)\://([a-zA-Z0-9\.\-]+(\:[a-zA-Z0-9\.&%\$\-]+)*@)*((25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])|localhost|([a-zA-Z0-9\-]+\.)*[a-zA-Z0-9\-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{1,10}))(\:[0-9]+)*(/($|[a-zA-Z0-9\.\,\?\'\\\+&%\$#\=~_\-]+))*$";
                            RequiredFieldTypeREV.ErrorMessage = "ȷַ"; break;
                        }
                    case "":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : @"^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-9]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-))$";
                            RequiredFieldTypeREV.ErrorMessage = "ȷ,:2006-1-1"; break;
                        }
                    case "ʱ":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : @"^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-9]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\d):[0-5]?\d:[0-5]?\d$";
                            RequiredFieldTypeREV.ErrorMessage = "ȷ,: 2006-1-1 23:59:59"; break;
                        }
                    case "":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : "^([0-9]|[0-9].[0-9]{0-2}|[1-9][0-9]*.[0-9]{0,2})$";
                            RequiredFieldTypeREV.ErrorMessage = "ȷĽ"; break;
                        }
                    case "IPַ":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : @"^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$";
                            RequiredFieldTypeREV.ErrorMessage = "ȷIPַ"; break;
                        }
                    case "IPַ˿":
                        {
                            RequiredFieldTypeREV.ValidationExpression = (this.ValidationExpression != null) ? this.ValidationExpression : @"^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9]):\d{1,5}?$";
                            RequiredFieldTypeREV.ErrorMessage = "ȷĴ˿ڵIPַ"; break;
                        }
                }
                this.Controls.AddAt(0, RequiredFieldTypeREV);
            }
            switch (CanBeNull)
            {
                case "Ϊ": { break; }
                case "":
                    {
                        CanBeNullRFV.Display = System.Web.UI.WebControls.ValidatorDisplay.Dynamic;
                        CanBeNullRFV.ControlToValidate = this.ID;
                        CanBeNullRFV.ErrorMessage = "<font color=red>!</font>";
                        this.Controls.AddAt(0, CanBeNullRFV);
                        break;
                    }
                default: { break; }
            }
        }
        /// <summary>
        /// ȡĿؼID(ύť)
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string SetFocusButtonID
        {
            get
            {
                object o = ViewState[this.ClientID + "_SetFocusButtonID"];
                return (o == null) ? "" : o.ToString();
            }
            set
            {
                ViewState[this.ClientID + "_SetFocusButtonID"] = value;
                if (value != "")
                {
                    this.Attributes.Add("onkeydown", "if(event.keyCode==13){document.getElementById('" + value + "').focus();}");
                }
            }
        }
        /// <summary>
        /// ؼ󳤶
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public override int MaxLength
        {
            get
            {
                object o = ViewState["TextBox_MaxLength"];
                if (o != null)
                {
                    int maxlength = PlugNT.Common.Utils.StrToInt(o.ToString(), 4);
                    AddAttributes("maxlength", maxlength.ToString());
                    return maxlength;
                }
                else
                {
                    return -1;
                }
            }
            set
            {
                ViewState["TextBox_MaxLength"] = value;
                AddAttributes("maxlength", value.ToString());
            }
        }
        /// <summary>
        /// ؼTextMode
        /// </summary>
        [Bindable(false), Category("Behavior"), DefaultValue(TextBoxMode.SingleLine), Description("ҪĶ")]
        public override TextBoxMode TextMode
        {
            get
            {
                return base.TextMode;
            }
            set
            {
                if (value == TextBoxMode.MultiLine)
                {
                    base.Attributes.Add("onkeyup", "return isMaxLen(this)");
                }
                base.TextMode = value;
            }
        }
        /// <summary>
        /// ҪУıʽ
        /// </summary>
        [Bindable(false), Category("Behavior"), DefaultValue(""), TypeConverter(typeof(RequiredFieldTypeControlsConverter)), Description("ҪĶ")]
        public string RequiredFieldType
        {
            get
            {
                object o = ViewState["RequiredFieldType"];
                return (o == null) ? "" : o.ToString();
            }
            set
            {
                ViewState["RequiredFieldType"] = value;
            }
        }
        /// <summary>
        /// ҪʽǷΪ
        /// </summary>
        [Bindable(false), Category("Behavior"), DefaultValue("Ϊ"), TypeConverter(typeof(CanBeNullControlsConverter)), Description("ҪĶ")]
        public string CanBeNull
        {
            get
            {
                object o = ViewState["CanBeNull"];
                return (o == null) ? "" : o.ToString();
            }
            set
            {
                ViewState["CanBeNull"] = value;
            }
        }
        /// <summary>
        /// Ƿ ' 滻
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public bool IsReplaceInvertedComma
        {
            get
            {
                object o = ViewState["IsReplaceInvertedComma"];
                if (o == null || o.ToString().Trim() == "")
                {
                    return true;
                }
                else
                {
                    return o.ToString().ToLower() == "true" ? true : false;
                }
            }
            set
            {
                ViewState["IsReplaceInvertedComma"] = value;
            }
        }
        /// <summary>
        /// ЧУʽ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string ValidationExpression
        {
            get
            {
                object o = ViewState["ValidationExpression"];
                if (o == null || o.ToString().Trim() == "")
                {
                    return null;
                }
                else
                {
                    return o.ToString().ToLower();
                }
            }
            set
            {
                ViewState["ValidationExpression"] = value;
            }
        }
        /// <summary>
        /// ı
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public override string Text
        {
            get
            {
                if (this.RequiredFieldType == "")
                {
                    try
                    {
                        return DateTime.Parse(base.Text).ToString("yyyy-MM-dd");
                    }
                    catch
                    {
                        return "1900-1-1";
                    }
                }
                if (this.RequiredFieldType == "ʱ")
                {
                    try
                    {
                        return DateTime.Parse(base.Text).ToString("yyyy-MM-dd HH:mm:ss");
                    }
                    catch
                    {
                        return "1900-1-1 00:00:00";
                    }
                }
                else
                {
                    return IsReplaceInvertedComma ? base.Text.Replace("'", "''").Trim() : base.Text;
                }
            }
            set
            {
                if (this.RequiredFieldType.IndexOf("") >= 0)
                {
                    try
                    {
                        base.Text = DateTime.Parse(value).ToString("yyyy-MM-dd");
                    }
                    catch
                    {
                        base.Text = "";
                    }
                }
                if (this.RequiredFieldType.IndexOf("ʱ") >= 0)
                {
                    try
                    {
                        base.Text = DateTime.Parse(value).ToString("yyyy-MM-dd HH:mm:ss");
                    }
                    catch
                    {
                        base.Text = "";
                    }
                }
                else
                {
                    base.Text = value;
                }
            }
        }
        /// <summary>
        /// 
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(30)]
        public int Cols
        {
            get
            {
                return base.Columns;
            }
            set
            {
                base.Columns = value;
            }
        }
        private int _size = 30;
        /// <summary>
        /// 
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(30)]
        public int Size
        {
            get
            {
                return _size;
            }
            set
            {
                _size = value;
            }
        }
        private string _maximumValue = null;
        /// <summary>
        /// Сֵ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(null)]
        public string MaximumValue
        {
            get
            {
                return _maximumValue;
            }
            set
            {
                _maximumValue = value;
            }
        }
        private string _minimumValue = null;
        /// <summary>
        /// ֵ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(null)]
        public string MinimumValue
        {
            get
            {
                return _minimumValue;
            }
            set
            {
                _minimumValue = value;
            }
        }
        private string _hintTitle = "";
        /// <summary>
        /// ʾ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string HintTitle
        {
            get { return _hintTitle; }
            set { _hintTitle = value; }
        }
        private string _hintInfo = "";
        /// <summary>
        /// ʾ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string HintInfo
        {
            get { return _hintInfo; }
            set { _hintInfo = value; }
        }
        private int _hintLeftOffSet = 0;
        /// <summary>
        /// ʾƫ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(0)]
        public int HintLeftOffSet
        {
            get { return _hintLeftOffSet; }
            set { _hintLeftOffSet = value; }
        }
        private int _hintTopOffSet = 0;
        /// <summary>
        /// ʾ򶥲ƫ
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(0)]
        public int HintTopOffSet
        {
            get { return _hintTopOffSet; }
            set { _hintTopOffSet = value; }
        }
        private string _hintShowType = "up";//"down"
        /// <summary>
        /// ʾ,up(Ϸʾ)down(·ʾ)
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("up")]
        public string HintShowType
        {
            get { return _hintShowType; }
            set { _hintShowType = value; }
        }
        private int _hintHeight = 50;
        /// <summary>
        /// ʾ߶
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue(130)]
        public int HintHeight
        {
            get { return _hintHeight; }
            set { _hintHeight = value; }
        }
        /// <summary> 
        /// html,ʾؼ
        /// </summary>
        /// <param name="output"> Ҫд HTML д </param>
        protected override void Render(HtmlTextWriter output)
        {
            if (this.TextMode == TextBoxMode.MultiLine)
            {
                output.WriteLine("<script type=\"text/javascript\">");
                output.WriteLine("function isMaxLen(o){");
                output.WriteLine("var nMaxLen=o.getAttribute? parseInt(o.getAttribute(\"maxlength\")):\"\";");
                output.WriteLine(" if(o.getAttribute && o.value.length>nMaxLen){");
                output.WriteLine(" o.value=o.value.substring(0,nMaxLen)");
                output.WriteLine("}}</script>");
                this.AddAttributes("rows", Rows.ToString());
                this.AddAttributes("cols", Cols.ToString());
                this.Attributes.Add("onfocus", "this.className='FormFocus';");
                this.Attributes.Add("onblur", "this.className='FormBase';");
                this.Attributes.Add("class", "FormBase");
            }
            else
            {
                if (this.Size > 0)
                {
                    this.AddAttributes("size", this.Size.ToString());
                }
            }
            if (this.HintInfo != "")
            {
                this.AddAttributes("onmouseover", "showhintinfo(this," + this.HintLeftOffSet + "," + this.HintTopOffSet + ",'" + this.HintTitle + "','" + this.HintInfo + "','" + this.HintHeight + "','" + this.HintShowType + "')");
                this.AddAttributes("onmouseout", "hidehintinfo()");
            }
            base.Render(output);
            RenderChildren(output);
        }
    }
    /// <summary>
    /// бѡת
    /// </summary>
    public class RequiredFieldTypeControlsConverter : StringConverter
    {
        /// <summary>
        /// 캯
        /// </summary>
        public RequiredFieldTypeControlsConverter() { }
        /// <summary>
        /// ˵Ҫб༭ 
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
        {
            return true;
        }
        /// <summary>
        /// ȡ׼ֵб
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override System.ComponentModel.TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
        {
            ArrayList controlsArray = new ArrayList();
            controlsArray.Add("У");
            controlsArray.Add("У");
            controlsArray.Add("");
            controlsArray.Add("ƶֻ");
            controlsArray.Add("õ绰");
            controlsArray.Add("֤");
            controlsArray.Add("ҳַ");
            controlsArray.Add("");
            controlsArray.Add("ʱ");
            controlsArray.Add("");
            controlsArray.Add("IPַ");
            controlsArray.Add("IPַ˿");
            return new StandardValuesCollection(controlsArray);
        }
        /// <summary>
        /// return tureĻֻѡ,return flaseѡ 
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
        {
            return false;
        }
    }
    /// <summary>
    /// бѡת
    /// </summary>
    public class CanBeNullControlsConverter : StringConverter
    {
        /// <summary>
        /// 캯
        /// </summary>
        public CanBeNullControlsConverter() { }
        /// <summary>
        /// б༭
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
        {
            return true;
        }
        /// <summary>
        /// ȡ׼ֵб
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override System.ComponentModel.TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
        {
            ArrayList controlsArray = new ArrayList();
            controlsArray.Add("Ϊ");
            controlsArray.Add("");
            return new StandardValuesCollection(controlsArray);
        }
        /// <summary>
        /// return tureĻֻѡ,return flaseѡ 
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
        {
            return false;
        }
    }
    /// <summary>
    /// бѡת
    /// </summary>
    public class FormControlsConverter : StringConverter
    {
        /// <summary>
        /// 캯
        /// </summary>
        public FormControlsConverter()
        {
        }
        /// <summary>
        /// б༭ 
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
        {
            return true;
        }
        /// <summary>
        /// ȡ׼ֵб
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override System.ComponentModel.TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
        {
            ControlCollection Controls = ((Page)context.Container.Components[0]).Controls;
            ArrayList controlsArray = new ArrayList();
            for (int i = 0; i < Controls.Count; i++)
            {
                if ((Controls[i] is HtmlTable
                    || Controls[i] is HtmlForm
                    || Controls[i] is HtmlGenericControl
                    || Controls[i] is HtmlImage
                    || Controls[i] is Label
                    || Controls[i] is DataGrid
                    || Controls[i] is DataList
                    || Controls[i] is Table
                    || Controls[i] is Repeater
                    || Controls[i] is Image
                    || Controls[i] is Panel
                    || Controls[i] is PlaceHolder
                    || Controls[i] is System.Web.UI.WebControls.Calendar
                    || Controls[i] is AdRotator
                    || Controls[i] is Xml
                    ))
                {
                    controlsArray.Add(Controls[i].ClientID);
                }
            }
            return new StandardValuesCollection(controlsArray);
        }
        /// <summary>
        /// return tureĻֻѡ,return flaseѡ 
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
        {
            return false;
        }
    }
}

