/**********************************************************************************
 * ˵     ݿ(޲)
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Safe;
using PlugNT.Database.Common;
namespace PlugNT.Database.Common.Entity
{
    /// <summary>
    /// ݿࣨҪ޸ģComplexɣ
    /// </summary>
    public class DbHelper
    {
        public DbInfo dbinfo;
        private DbConnection connection;
        private DbDataAdapter dadapter;
        public DbHelper()
        {
            dbinfo = new DbInfo(IConfig.DbType, IConfig.ConnectionString);
            Init(dbinfo);
        }
        public DbHelper(DbInfo dbInfo)
        {
            Init(dbInfo);
        }
        private void Init(DbInfo dbInfo)
        {
            dbinfo = dbInfo;
            connection = DbProvider.CreateConnection(dbinfo);
            connection.Open();
            dadapter = DbProvider.GetFactory(dbinfo).CreateDataAdapter();
        }
        ~DbHelper()
        {
            connection = null;
        }
        /// <summary>
        /// ״̬
        /// </summary>
        private void OpenConnection()
        {
            if (connection.State != ConnectionState.Open)
            {
                connection.Open();
            }
        }
        /// <summary>
        /// ر
        /// </summary>
        public void CloseConnection()
        {
            if (connection.State != ConnectionState.Closed)
            {
                connection.Close();
            }
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="fieldName"></param>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public int GetMaxField(string fieldName, string tableName)
        {
            string strsql = "select max(" + fieldName + ") from " + tableName;
            object obj = GetSingle(strsql);
            if (obj == null)
            {
                return 1;
            }
            else
            {
                return int.Parse(obj.ToString());
            }
        }
 
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="strSql"></param>
        /// <returns></returns>
        public bool Exists(string strSql)
        {
            object obj = GetSingle(strSql);
            int cmdresult;
            if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
            {
                cmdresult = 0;
            }
            else
            {
                cmdresult = int.Parse(obj.ToString());
            }
            if (cmdresult == 0)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        /// <summary>
        /// Ƿ(в)
        /// </summary>
        /// <param name="strSql"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public bool Exists(string strSql, params DbParameter[] cmdParms)
        {
            object obj = GetSingle(strSql, cmdParms);
            int cmdresult;
            if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
            {
                cmdresult = 0;
            }
            else
            {
                cmdresult = int.Parse(obj.ToString());
            }
            if (cmdresult == 0)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        /// <summary>
        /// ִһѯ䣬زѯobject
        /// </summary>
        /// <param name="SQLString">ѯ</param>
        /// <returns>ѯobject</returns>
        public object GetSingle(string SQLString)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                cmd.Connection = connection;
                cmd.CommandText = SQLString;
                object obj = cmd.ExecuteScalar();
                cmd.Dispose();
                cmd = null;
                if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                {
                    return null;
                }
                else
                {
                    return obj;
                }
            }
            catch (DbException ex)
            {
                connection.Close();
                throw ex;
            }
        }
        /// <summary>
        /// ִһѯ䣬زѯobject
        /// </summary>
        /// <param name="SQLString">ѯ</param>
        /// <returns>ѯobject</returns>
        public object GetSingle(string SQLString, params DbParameter[] cmdParms)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                object obj = cmd.ExecuteScalar();
                cmd.Parameters.Clear();
                cmd.Dispose();
                cmd = null;
                if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                {
                    return null;
                }
                else
                {
                    return obj;
                }
            }
            catch (DbException e)
            {
                throw e;
            }
        }
        /// <summary>
        /// ִSQL䣬Ӱļ¼
        /// </summary>
        /// <param name="SQLString">SQL</param>
        /// <returns>Ӱļ¼</returns>
        public int ExecuteSql(string SQLString)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                cmd.Connection = connection;
                cmd.CommandText = SQLString;
                int rows = cmd.ExecuteNonQuery();
                cmd.Dispose();
                cmd = null;
                return rows;
            }
            catch (DbException ex)
            {
                connection.Close();
                throw ex;
            }
        }
        /// <summary>
        /// ִSQL䣬Ӱļ¼(ʱ)
        /// </summary>
        /// <param name="SQLString"></param>
        /// <param name="Times"></param>
        /// <returns></returns>
        public int ExecuteSqlByTime(string SQLString, int Times)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                cmd.Connection = connection;
                cmd.CommandText = SQLString;
                cmd.CommandTimeout = Times;
                int rows = cmd.ExecuteNonQuery();
                cmd.Dispose();
                cmd = null;
                return rows;
            }
            catch (DbException ex)
            {
                connection.Close();
                throw ex;
            }
        }
        /// <summary>
        /// ִжSQL䣬ʵݿ
        /// </summary>
        /// <param name="SQLStringList">SQL</param>		
        public int ExecuteSqlTran(List<String> SQLStringList)
        {
            OpenConnection();
            DbCommand cmd = connection.CreateCommand();
            cmd.Connection = connection;
            DbTransaction tx = connection.BeginTransaction();
            cmd.Transaction = tx;
            try
            {
                int count = 0;
                for (int n = 0; n < SQLStringList.Count; n++)
                {
                    string strsql = SQLStringList[n];
                    if (strsql.Trim().Length > 1)
                    {
                        cmd.CommandText = strsql;
                        count += cmd.ExecuteNonQuery();
                    }
                }
                tx.Commit();
                cmd.Dispose();
                cmd = null;
                return count;
            }
            catch
            {
                tx.Rollback();
                return 0;
            }
        }
        /// <summary>
        /// ִвѯ䣬DbDataReader ( ע⣺ø÷һҪDbDataReaderClose )
        /// </summary>
        /// <param name="SQLString"></param>
        /// <returns></returns>
        public DbDataReader ExecuteReader(string SQLString)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                cmd.Connection = connection;
                cmd.CommandText = SQLString;
                DbDataReader myReader = cmd.ExecuteReader();
                cmd.Dispose();
                cmd = null;
                return myReader;
            }
            catch (DbException ex)
            {
                throw ex;
            }
        }
        /// <summary>
        /// ִвѯ䣬DataTable
        /// </summary>
        /// <param name="SQLString">ѯ</param>
        /// <returns>DataTable</returns>
        public DataTable GetDataTable(string SQLString)
        {
            return Query(SQLString).Tables[0];
        }
        /// <summary>
        /// ִвѯ䣬DataSet
        /// </summary>
        /// <param name="SQLString">ѯ</param>
        /// <returns>DataSet</returns>
        public DataSet Query(string SQLString)
        {
            DataSet ds = new DataSet();
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                cmd.CommandText = SQLString;
                dadapter.SelectCommand = cmd;
                cmd.Dispose();
                cmd = null;
                dadapter.Fill(ds);
            }
            catch (DbException ex)
            {
                throw new Exception(ex.Message);
            }
            return ds;
        }
        /// <summary>
        /// ִSQL䣬Ӱļ¼
        /// </summary>
        /// <param name="SQLString">SQL</param>
        /// <returns>Ӱļ¼</returns>
        public int ExecuteSql(string SQLString, params DbParameter[] cmdParms)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                int rows = cmd.ExecuteNonQuery();
                cmd.Dispose();
                cmd = null;
                return rows;
            }
            catch (DbException e)
            {
                throw e;
            }
        }
        /// <summary>
        /// ִвѯ䣬DbDataReader ( ע⣺ø÷һҪDbDataReaderClose )
        /// </summary>
        /// <param name="SQLString"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public DbDataReader ExecuteReader(string SQLString, params DbParameter[] cmdParms)
        {
            try
            {
                OpenConnection();
                DbCommand cmd = connection.CreateCommand();
                PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                DbDataReader myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Dispose();
                cmd = null;
                return myReader;
            }
            catch (DbException e)
            {
                throw e;
            }
        }
        /// <summary>
        /// ִвѯ䣬DataSet
        /// </summary>
        /// <param name="SQLString">ѯ</param>
        /// <returns>DataSet</returns>
        public DataSet Query(string SQLString, params DbParameter[] cmdParms)
        {
            OpenConnection();
            DbCommand cmd = connection.CreateCommand();
            PrepareCommand(cmd, connection, null, SQLString, cmdParms);
            dadapter.SelectCommand = cmd;
            DataSet ds = new DataSet();
            try
            {
                dadapter.Fill(ds, "ds");
                cmd.Dispose();
                cmd = null;
            }
            catch (DbException ex)
            {
                throw new Exception(ex.Message);
            }
            return ds;
        }
        /// <summary>
        /// Command
        /// </summary>
        /// <param name="cmd"></param>
        /// <param name="conn"></param>
        /// <param name="trans"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        private static void PrepareCommand(DbCommand cmd, DbConnection conn, DbTransaction trans, string cmdText, DbParameter[] cmdParms)
        {
            if (conn.State != ConnectionState.Open)
            {
                conn.Open();
            }
            cmd.Connection = conn;
            cmd.CommandText = cmdText;
            if (trans != null)
            {
                cmd.Transaction = trans;
            }
            cmd.CommandType = CommandType.Text;
            if (cmdParms != null)
            {
                foreach (DbParameter parameter in cmdParms)
                {
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) && (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    cmd.Parameters.Add(parameter);
                }
            }
        }
        /// <summary>
        /// ִд洢̣SqlDataReader ( ע⣺ø÷һҪSqlDataReaderClose )
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <returns>SqlDataReader</returns>
        public DbDataReader RunProcedure(string storedProcName, IDataParameter[] parameters)
        {
            OpenConnection();
            DbDataReader returnReader;
            DbCommand cmd = connection.CreateCommand();
            cmd.Parameters.Clear();
            BuildQueryCommand(cmd, storedProcName, parameters);
            cmd.CommandType = CommandType.StoredProcedure;
            returnReader = cmd.ExecuteReader();
            cmd.Dispose();
            cmd = null;
            return returnReader;
        }
        /// <summary>
        /// ִд洢
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <param name="tableName">DataSetеı</param>
        /// <returns>DataSet</returns>
        public DataSet RunProcedure(string storedProcName, IDataParameter[] parameters, string tableName)
        {
            OpenConnection();
            DataSet dataSet = new DataSet();
            DbCommand cmd = connection.CreateCommand();
            cmd.Parameters.Clear();
            BuildQueryCommand(cmd, storedProcName, parameters);
            dadapter.SelectCommand = cmd;
            dadapter.Fill(dataSet, tableName);
            cmd.Dispose();
            cmd = null;
            return dataSet;
        }
        /// <summary>
        /// ִд洢̣޶ʱ䣩
        /// </summary>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <param name="tableName"></param>
        /// <param name="Times"></param>
        /// <returns></returns>
        public DataSet RunProcedure(string storedProcName, IDataParameter[] parameters, string tableName, int Times)
        {
            OpenConnection();
            DataSet dataSet = new DataSet();
            DbCommand cmd = connection.CreateCommand();
            cmd.Parameters.Clear();
            BuildQueryCommand(cmd, storedProcName, parameters);
            dadapter.SelectCommand = cmd;
            dadapter.SelectCommand.CommandTimeout = Times;
            dadapter.Fill(dataSet, tableName);
            cmd.Dispose();
            cmd = null;
            return dataSet;
        }
        /// <summary>
        ///  SqlCommand (һһֵ)
        /// </summary>
        /// <param name="connection">ݿ</param>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <returns>SqlCommand</returns>
        private void BuildQueryCommand(DbCommand cmd,  string storedProcName, IDataParameter[] parameters)
        {
            cmd.CommandText = storedProcName;
            cmd.CommandType = CommandType.StoredProcedure;
            foreach (DbParameter parameter in parameters)
            {
                if (parameter != null)
                {
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) && (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    cmd.Parameters.Add(parameter);
                }
            }
        }
        /// <summary>
        /// ִд洢̣Ӱ		
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <param name="rowsAffected">Ӱ</param>
        /// <returns></returns>
        public int RunProcedure(string storedProcName, IDataParameter[] parameters, out int rowsAffected)
        {
            OpenConnection();
            int result;
            DbCommand cmd = connection.CreateCommand();
            cmd.Parameters.Clear();
            BuildIntCommand(cmd, connection, storedProcName, parameters);
            rowsAffected = cmd.ExecuteNonQuery();
            result = (int)cmd.Parameters["ReturnValue"].Value;
            cmd.Dispose();
            cmd = null;
            return result;
        }
        /// <summary>
        ///  SqlCommand ʵ(һֵ)	
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <returns>SqlCommand ʵ</returns>
        private void BuildIntCommand(DbCommand cmd, DbConnection connection, string storedProcName, IDataParameter[] parameters)
        {
            BuildQueryCommand(cmd, storedProcName, parameters);
            DbParameter dbpar = DbProvider.MakeIntParam(dbinfo, "ReturnValue");
            dbpar.Direction = ParameterDirection.ReturnValue;
            cmd.Parameters.Add(dbpar);
        }
        public static string Help()
        {
            return @"mailto:354990393@qq.com";
        }
    }
}

