/**********************************************************************************
 * ˵     ݿṩ
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
namespace PlugNT.Database.Common
{
    /// <summary>
    /// ݿṩ
    /// </summary>
    public abstract class DbProvider
    {
        /// <summary>
        /// oleԴṩ
        /// </summary>
        private static DbProviderFactory oleFactory;
        /// <summary>
        /// sqlԴṩ
        /// </summary>
        private static DbProviderFactory sqlFactory;
        /// <summary>
        /// oracleԴṩ
        /// </summary>
        private static DbProviderFactory oracleFactory;
        /// <summary>
        /// mysqlԴṩ
        /// </summary>
        private static DbProviderFactory mysqlFactory;
        /// <summary>
        /// õԴṩ(޸Ĵ˴Ҫ޸Sql.csеGetReSetColumnStr)
        /// </summary>
        /// <param name="dbinfo">ݿϢ</param>
        /// <returns>DbProviderFactory</returns>
        public static DbProviderFactory GetFactory(DbInfo dbinfo)
        {
 
            switch (dbinfo.DbType)
            {
                case "System.Data.SqlClient":
                    if (sqlFactory == null)
                    {
                        sqlFactory = DbProviderFactories.GetFactory(dbinfo.DbType);
                    }
                    return sqlFactory;
                case "System.Data.OleDb":
                    if (oleFactory == null)
                    {
                        oleFactory = DbProviderFactories.GetFactory(dbinfo.DbType);
                    }
                    return oleFactory;
                case "System.Data.OracleClient":
                    if (oracleFactory == null)
                    {
                        oracleFactory = DbProviderFactories.GetFactory(dbinfo.DbType);
                    }
                    return oracleFactory;
                case "MySql.Data.MySqlClient":
                    if (mysqlFactory == null)
                    {
                        mysqlFactory = new MySql.Data.MySqlClient.MySqlClientFactory();
                    }
                    return mysqlFactory;
                default:
                    return null;
            }
        }
        /// <summary>
        /// õǷ洢̵Ĵ
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <returns></returns>
        public static string GetRunProcedureError(DbInfo dbinfo)
        {
            switch (dbinfo.DbType)
            {
                case "System.Data.OleDb":
                    return "Accessݿⲻִд洢̡";
                case "System.Data.SqlClient":
                    return "";
                case "MySql.Data.MySqlClient":
                    return "";
                case "System.Data.OracleClient":
                    return "";
                default:
                    return "";
            }
        }
        /// <summary>
        /// Ӷ
        /// </summary>
        /// <param name="dbinfo">ݿϢ</param>
        /// <returns>DbConnection</returns>
        public static DbConnection CreateConnection(DbInfo dbinfo)
        {
            DbConnection connection = GetFactory(dbinfo).CreateConnection();
            connection.ConnectionString = dbinfo.ConnectionString;   
            return connection;
        }
        /// <summary>
        /// Cmd
        /// </summary>
        /// <param name="dbinfo">ݿϢ</param>
        /// <param name="paraName">("@argname")</param>
        /// <param name="objValue">ֵ</param>
        /// <returns></returns>
        public static DbParameter MakeParam(DbInfo dbinfo, string paraName, object objValue)
        {
            DbParameter dbParam = null;
            switch (dbinfo.DbType)
            {
                case "System.Data.SqlClient":
                    dbParam = new System.Data.SqlClient.SqlParameter(paraName, objValue);
                    break;
                case "System.Data.OleDb":
                    dbParam = new System.Data.OleDb.OleDbParameter(paraName, objValue);
                    break;
                case "MySql.Data.MySqlClient":
                    dbParam = new MySql.Data.MySqlClient.MySqlParameter(paraName, objValue);
                    break;
                default:
                    break;
            }
            return dbParam;
        }
        /// <summary>
        /// Cmd
        /// </summary>
        /// <param name="dbinfo">ݿϢ</param>
        /// <param name="paraName">("@argname")</param>
        /// <param name="dType"></param>
        /// <param name="dSize"></param>
        /// <returns>DbParameter</returns>
        public static DbParameter MakeParam(DbInfo dbinfo, string paraName, DbType dType, int dSize)
        {
            DbParameter dbParam = null;
            switch (dbinfo.DbType)
            {
                case "System.Data.SqlClient":
                    dbParam = new System.Data.SqlClient.SqlParameter(paraName, (SqlDbType)dType, dSize);
                    break;
                case "System.Data.OleDb":
                    dbParam = new System.Data.OleDb.OleDbParameter(paraName, (System.Data.OleDb.OleDbType)dType, dSize);
                    break;
                case "MySql.Data.MySqlClient":
                    dbParam = new MySql.Data.MySqlClient.MySqlParameter(paraName, (MySql.Data.MySqlClient.MySqlDbType)dType, dSize);
                    break;
                default:
                    break;
            }
            return dbParam;
        }
        
        /// <summary>
        /// Int͵Cmd
        /// </summary>
        /// <param name="dbinfo">ݿϢ</param>
        /// <param name="paraName">("@argname")</param>
        /// <returns>DbParameter</returns>
        internal static DbParameter MakeIntParam(DbInfo dbinfo, string paraName)
        {
            DbParameter dbParam = null;
            switch (dbinfo.DbType)
            {
                case "System.Data.SqlClient":
                    dbParam = new System.Data.SqlClient.SqlParameter(paraName, SqlDbType.Int);
                    break;
                case "System.Data.OleDb":
                    dbParam = new System.Data.OleDb.OleDbParameter(paraName, System.Data.OleDb.OleDbType.Integer);
                    break;
                case "MySql.Data.MySqlClient":
                    dbParam = new MySql.Data.MySqlClient.MySqlParameter(paraName, MySql.Data.MySqlClient.MySqlDbType.Int32);
                    break;
                default:
                    break;
            }
            return dbParam;
        }
  
     
    }
}

