/**********************************************************************************
 * ˵     ݿ(.в)
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
namespace PlugNT.Database.Common.Complex
{
    /// <summary>
    /// ݿ
    /// </summary>
    public abstract class DbHelper
    {
        /// <summary>
        /// ر
        /// </summary>
        /// <param name="connection"></param>
        private static void CloseConnection(DbConnection connection)
        {
            if (connection.State == ConnectionState.Open)
            {
                connection.Close();
            }
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="fieldName"></param>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public static int GetMaxField(DbInfo dbinfo, string fieldName, string tableName)
        {
            string strsql = "select max(" + fieldName + ") from " + tableName;
            object obj = GetSingle(dbinfo,strsql);
            if (obj == null)
            {
                return 1;
            }
            else
            {
                return int.Parse(obj.ToString());
            }
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="strSql"></param>
        /// <returns></returns>
        public static bool Exists(DbInfo dbinfo,string strSql)
        {
            object obj = GetSingle(dbinfo, strSql);
            return (obj == null) ? false : obj.ToString() != "";
        }
        /// <summary>
        /// Ƿ(в)
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="strSql"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public static bool Exists(DbInfo dbinfo,string strSql, params DbParameter[] cmdParms)
        {
            object obj = GetSingle(dbinfo,strSql, cmdParms);
            return (obj == null) ? false : obj.ToString() != "";
        }
        /// <summary>
        /// ִһѯ䣬زѯobject
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <returns></returns>
        public static object GetSingle(DbInfo dbinfo,string SQLString)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                using (DbCommand cmd = connection.CreateCommand())
                {
                    try
                    {
                        cmd.Connection = connection;
                        cmd.CommandText = SQLString;
                        connection.Open();
                        object obj = cmd.ExecuteScalar();
                        cmd.Dispose();
                        CloseConnection(connection);
                        if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                        {
                            return null;
                        }
                        else
                        {
                            return obj;
                        }
                    }
                    catch (DbException ex)
                    {
                        connection.Close();
                        throw ex;
                    }
                }
                
            }
        }
        /// <summary>
        /// ִһѯ䣬زѯobject
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public static object GetSingle(DbInfo dbinfo,string SQLString, params DbParameter[] cmdParms)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                using (DbCommand cmd = connection.CreateCommand())
                {
                    try
                    {
                        PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                        object obj = cmd.ExecuteScalar();
                        cmd.Parameters.Clear();
                        cmd.Dispose();
                        CloseConnection(connection);
                        if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                        {
                            return null;
                        }
                        else
                        {
                            return obj;
                        }
                    }
                    catch (DbException e)
                    {
                        throw e;
                    }
                }
            }
        }
        /// <summary>
        /// ִSQL䣬Ӱļ¼
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <returns></returns>
        public static int ExecuteSql(DbInfo dbinfo,string SQLString)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                using (DbCommand cmd = connection.CreateCommand())
                {
                    try
                    {
                        cmd.Connection = connection;
                        cmd.CommandText = SQLString;
                        connection.Open();
                        int rows = cmd.ExecuteNonQuery();
                        cmd.Dispose();
                        CloseConnection(connection);
                        return rows;
                    }
                    catch (DbException ex)
                    {
                        connection.Close();
                        throw ex;
                    }
                }
            }
        }
        /// <summary>
        /// ִSQL䣬Ӱļ¼(ʱ)
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <param name="Times"></param>
        /// <returns></returns>
        public static int ExecuteSqlByTime(DbInfo dbinfo,string SQLString, int Times)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                using (DbCommand cmd = connection.CreateCommand())
                {
                    try
                    {
                        cmd.Connection = connection;
                        cmd.CommandText = SQLString;
                        connection.Open();
                        cmd.CommandTimeout = Times;
                        int rows = cmd.ExecuteNonQuery();
                        cmd.Dispose();
                        CloseConnection(connection);
                        return rows;
                    }
                    catch (DbException ex)
                    {
                        connection.Close();
                        throw ex;
                    }
                }
            }
        }
        /// <summary>
        /// ִжSQL䣬ʵݿ
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLStringList"></param>
        /// <param name="error"></param>
        /// <returns></returns>
        public static int ExecuteSqlTran(DbInfo dbinfo,List<String> SQLStringList,out string error)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                DbCommand cmd = connection.CreateCommand();
                cmd.Connection = connection;
                connection.Open();
                DbTransaction tx = connection.BeginTransaction();
                cmd.Transaction = tx;
                try
                {
                    int count = 0;
                    for (int n = 0; n < SQLStringList.Count; n++)
                    {
                        string strsql = SQLStringList[n];
                        if (strsql.Trim().Length > 1)
                        {
                            cmd.CommandText = strsql;
                            count += cmd.ExecuteNonQuery();
                        }
                    }
                    tx.Commit();
                    cmd.Dispose();
                    CloseConnection(connection);
                    error = "";
                    return count;
                }
                catch(Exception ex)
                {
                    tx.Rollback();
                    connection.Close();
                    error = ex.Message + "\n" + ex.StackTrace;
                    return 0;
                }
            }
        }
        
        /// <summary>
        /// ִвѯ䣬DbDataReader ( ע⣺ø÷һҪDbDataReaderClose )
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <returns></returns>
        public static DbDataReader GetReader(DbInfo dbinfo, string SQLString)
        {
            DbConnection connection = DbProvider.CreateConnection(dbinfo);
            DbCommand cmd = connection.CreateCommand(); 
            try
            {
                cmd.Connection = connection;
                cmd.CommandText = SQLString;
                connection.Open();
                DbDataReader myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection); 
                return myReader;
            }
            catch (DbException ex)
            {
                CloseConnection(connection);
                throw ex;
            }
        }
        /// <summary>
        /// ִвѯ䣬DataTable
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <returns></returns>
        public static DataTable GetDataTable(DbInfo dbinfo, string SQLString)
        {
            return GetDataSet(dbinfo, SQLString).Tables[0];
        }
        /// <summary>
        /// ִвѯ䣬DataSet
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <returns></returns>
        public static DataSet GetDataSet(DbInfo dbinfo, string SQLString)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                DataSet ds = new DataSet();
                try
                {
                    connection.Open();
                    DbDataAdapter da = DbProvider.GetFactory(dbinfo).CreateDataAdapter();
                    DbCommand cmd = connection.CreateCommand();
                    cmd.CommandText = SQLString;
                    da.SelectCommand = cmd;
                    da.Fill(ds);
                    cmd.Dispose();
                    CloseConnection(connection);
                }
                catch (DbException ex)
                {
                    connection.Close();
                    throw new Exception(ex.Message);
                }
                return ds;
            }
        }
       
        /// <summary>
        /// ִSQL䣬Ӱļ¼
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public static int ExecuteSql(DbInfo dbinfo,string SQLString, params DbParameter[] cmdParms)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                using (DbCommand cmd = connection.CreateCommand())
                {
                    try
                    {
                        PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                        int rows = cmd.ExecuteNonQuery();
                        cmd.Parameters.Clear();
                        cmd.Dispose();
                        CloseConnection(connection);
                        return rows;
                    }
                    catch (DbException e)
                    {
                        CloseConnection(connection);
                        throw e;
                    }
                }
            }
        }
        /// <summary>
        /// ִвѯ䣬DbDataReader ( ע⣺ø÷һҪDbDataReaderClose )
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public static DbDataReader ExecuteReader(DbInfo dbinfo,string SQLString, params DbParameter[] cmdParms)
        {
            DbConnection connection = DbProvider.CreateConnection(dbinfo);
            DbCommand cmd = connection.CreateCommand();
            try
            {
                PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                DbDataReader myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);  
                cmd.Parameters.Clear();
                return myReader;
            }
            catch (DbException e)
            {
                CloseConnection(connection);
                throw e;
            }
        }
        /// <summary>
        /// ִвѯ䣬DataSet
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="SQLString"></param>
        /// <param name="cmdParms"></param>
        /// <returns></returns>
        public static DataSet GetDataSet(DbInfo dbinfo,string SQLString, params DbParameter[] cmdParms)
        {
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                DbCommand cmd = connection.CreateCommand();
                PrepareCommand(cmd, connection, null, SQLString, cmdParms);
                using (DbDataAdapter da = DbProvider.GetFactory(dbinfo).CreateDataAdapter())
                {
                    da.SelectCommand = cmd;
                    DataSet ds = new DataSet();
                    try
                    {
                        da.Fill(ds, "ds");
                        cmd.Parameters.Clear();
                        CloseConnection(connection);
                    }
                    catch (DbException ex)
                    {
                        CloseConnection(connection);
                        throw new Exception(ex.Message);
                    }
                    return ds;
                }
            }
        }
        /// <summary>
        /// Command
        /// </summary>
        /// <param name="cmd"></param>
        /// <param name="conn"></param>
        /// <param name="trans"></param>
        /// <param name="cmdText"></param>
        /// <param name="cmdParms"></param>
        private static void PrepareCommand(DbCommand cmd, DbConnection conn, DbTransaction trans, string cmdText, DbParameter[] cmdParms)
        {
            if (conn.State != ConnectionState.Open)
            {
                conn.Open();
            }
            cmd.Connection = conn;
            cmd.CommandText = cmdText;
            if (trans != null)
            {
                cmd.Transaction = trans;
            }
            cmd.CommandType = CommandType.Text;
            if (cmdParms != null)
            {
                foreach (DbParameter parameter in cmdParms)
                {
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) &&  (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    cmd.Parameters.Add(parameter);
                }
            }
        }
        /// <summary>
        /// ִд洢̣DbDataReader ( ע⣺ø÷һҪDbDataReaderClose )
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <returns></returns>
        public static DbDataReader RunProcedure(DbInfo dbinfo,string storedProcName, IDataParameter[] parameters)
        {
            string error = DbProvider.GetRunProcedureError(dbinfo);
            if (error != "")
            {
                throw new Exception(error);
            }
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                DbDataReader returnReader;
                connection.Open();
                DbCommand cmd = BuildQueryCommand(connection, storedProcName, parameters);
                cmd.CommandType = CommandType.StoredProcedure;
                returnReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                return returnReader;
            }
        }
        /// <summary>
        /// ִд洢
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public static DataSet RunProcedure(DbInfo dbinfo,string storedProcName, IDataParameter[] parameters, string tableName)
        {
            string error = DbProvider.GetRunProcedureError(dbinfo);
            if (error != "")
            {
                throw new Exception(error);
            }
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                DataSet dataSet = new DataSet();
                connection.Open();
                DbDataAdapter sqlDA = DbProvider.GetFactory(dbinfo).CreateDataAdapter(); 
                sqlDA.SelectCommand = BuildQueryCommand(connection, storedProcName, parameters);
                sqlDA.Fill(dataSet, tableName);
                CloseConnection(connection);
                return dataSet;
            }
        }
        /// <summary>
        /// ִд洢̣޶ʱ䣩
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <param name="tableName"></param>
        /// <param name="Times"></param>
        /// <returns></returns>
        public static DataSet RunProcedure(DbInfo dbinfo,string storedProcName, IDataParameter[] parameters, string tableName, int Times)
        {
            string error = DbProvider.GetRunProcedureError(dbinfo);
            if (error != "")
            {
                throw new Exception(error);
            }
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                DataSet dataSet = new DataSet();
                connection.Open();
                DbDataAdapter sqlDA = DbProvider.GetFactory(dbinfo).CreateDataAdapter();
                sqlDA.SelectCommand = BuildQueryCommand(connection, storedProcName, parameters);
                sqlDA.SelectCommand.CommandTimeout = Times;
                sqlDA.Fill(dataSet, tableName);
                CloseConnection(connection);
                return dataSet;
            }
        }
        /// <summary>
        ///  SqlCommand (һһֵ)
        /// </summary>
        /// <param name="connection"></param>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <returns></returns>
        private static DbCommand BuildQueryCommand(DbConnection connection, string storedProcName, IDataParameter[] parameters)
        {
            DbCommand cmd = connection.CreateCommand();  
            cmd.CommandText = storedProcName;
            cmd.CommandType = CommandType.StoredProcedure;
            foreach (DbParameter parameter in parameters)
            {
                if (parameter != null)
                {
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) && (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    cmd.Parameters.Add(parameter);
                }
            }
            return cmd;
        }
        /// <summary>
        /// ִд洢̣Ӱ		
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <param name="rowsAffected"></param>
        /// <returns></returns>
        public static int RunProcedure(DbInfo dbinfo,string storedProcName, IDataParameter[] parameters, out int rowsAffected)
        {
            string error = DbProvider.GetRunProcedureError(dbinfo);
            if (error != "")
            {
                throw new Exception(error);
            }
            using (DbConnection connection = DbProvider.CreateConnection(dbinfo))
            {
                int result;
                connection.Open();
                DbCommand cmd = BuildIntCommand(dbinfo,connection, storedProcName, parameters);
                rowsAffected = cmd.ExecuteNonQuery();
                result = (int)cmd.Parameters["ReturnValue"].Value;
                CloseConnection(connection);
                return result;
            }
        }
        /// <summary>
        ///  SqlCommand ʵ(һֵ)
        /// </summary>
        /// <param name="dbinfo"></param>
        /// <param name="connection"></param>
        /// <param name="storedProcName"></param>
        /// <param name="parameters"></param>
        /// <returns></returns>
        private static DbCommand BuildIntCommand(DbInfo dbinfo,DbConnection connection, string storedProcName, IDataParameter[] parameters)
        {
            DbCommand cmd = BuildQueryCommand(connection, storedProcName, parameters);
            DbParameter dbpar = DbProvider.MakeIntParam(dbinfo, "ReturnValue");
            dbpar.Direction = ParameterDirection.ReturnValue;
            cmd.Parameters.Add(dbpar);
            return cmd;
        }
    }
}

