﻿/**********************************************************************************
 * 程序说明：     正则匹配html类
 * 创建日期：     2009.10.20
 * 程序制作：     agui
 * 联系方式：     mailto:354990393@qq.com  
 * ********************************************************************************/
using System;
using System.Collections.Generic; 
using System.Text; 
using System.Web; 
using System.Text.RegularExpressions;

namespace PlugNT.Common.Templet
{
    /// <summary>
    /// 正则匹配html类
    /// </summary>
    public class RegTemplet
    {

        //(RegexOptions.Compiled | RegexOptions.IgnoreCase) 重复使用影响性能

        /// <summary>
        /// 替换字符(如果有特征字符则应不考虑用)
        /// </summary>
        /// <param name="template">要替换的文本</param>
        /// <param name="tag">标签</param>
        /// <param name="value">内容</param>
        /// <returns></returns>
        public static string Replace(string template, string tag, string value)
        {
            
            if (string.IsNullOrEmpty(value))
                template = Regex.Replace(template, tag, "", RegexOptions.None);
            else
                template = Regex.Replace(template, tag, value, RegexOptions.None);                
            return template;
        }

        /// <summary>
        /// 返回一组标签中指定属性的值小写格式
        /// 属性值必须被双引号括起来。
        /// </summary>
        /// <param name="tag">一组标签</param>
        /// <param name="attributename">属性名称</param>
        /// <returns>属性的小写值</returns>
        public static string GetAttribute(string tag, string attributename)
        {
            Regex rt = new Regex(@"(?<Key>\w+)\s*=\s*(?<Value>" + "\"[^\"]*\")", RegexOptions.None);
            foreach (Match mt in rt.Matches(tag))
            {
                if (mt.Groups["Key"].ToString().Trim() == attributename)
                {
                    return mt.Groups["Value"].ToString().Trim().Replace("\"", "");
                }
            }
            return "";
        }

        /// <summary>
        /// 返回一组标签中指定属性的值小写格式
        /// 属性值必须被特征字符串括起来。
        /// </summary>
        /// <param name="tag">一组标签</param>
        /// <param name="prostr">特征字符串如括号等</param>
        /// <param name="attributename">属性名称</param>
        /// <returns>属性的小写值</returns>
        public static string GetAttribute(string tag, string prostr, string attributename)
        {
            Regex rt = new Regex(@"(?<Key>\w+)\s*=\s*(?<Value>" + prostr + "[^" + prostr + "]*" + prostr + ")", RegexOptions.None);
            foreach (Match mt in rt.Matches(tag))
            {
                if (mt.Groups["Key"].ToString().Trim() == attributename)
                {
                    return mt.Groups["Value"].ToString().Trim().Replace(prostr, "");
                }
            }
            return "";
        }


        /// <summary>
        /// 标签的匹配替换(匹配内容中不能有+、\、(、)、?、[、]等特征字符)
        /// </summary>
        /// <param name="template">模板内容</param>
        /// <param name="tagName">标签名</param>
        /// <returns>RegTags</returns>
        public static List<RegTag> GetRegTags(string template, string tagName)
        {
            string regstr = @"(\{tagname\s+(?<attributes>[^\]]*?)\})".Replace("tagname", tagName);
            bool flag = false;
            if (template.Contains("{/" + tagName + "}"))
            {
                regstr = @"(\{tagname\s+(?<attributes>[^\]]*?)\}(?<text>[\s\S]*?)\{/tagname\})".Replace("tagname", tagName);
                flag = true;
            }
            Regex r = new Regex(regstr, RegexOptions.None);
            List<RegTag> list = new List<RegTag>();
            foreach (Match m in r.Matches(template))
            {
                RegTag tag = new RegTag();
                tag.Attributes = m.Groups["attributes"].ToString();                //循环属性集
                tag.InnerText = flag ? m.Groups["text"].ToString() : "";           //循环内的内容
                tag.OuterText = m.Groups[0].Value.ToString();                      //整个匹配的内容
                list.Add(tag);
            }
            return list;
        }


        /// <summary>
        /// 标签的匹配替换去掉重复项(匹配内容中不能有+、\、(、)、?、[、]等特征字符)
        /// </summary>
        /// <param name="template">模板内容</param>
        /// <param name="tagName">标签名</param>
        /// <returns>RegTags</returns>
        public static List<RegTag> GetRegTagsDistinct(string template, string tagName)
        {
            string regstr = @"(\{tagname+(?<attributes>[^\]]*?)\})".Replace("tagname", tagName);
            bool flag = false;
            if (template.Contains("{/" + tagName + "}"))
            {
                regstr = @"(\{tagname+(?<attributes>[^\]]*?)\}(?<text>[\s\S]*?)\{/tagname\})".Replace("tagname", tagName);
                flag = true;
            }
            Regex r = new Regex(regstr, RegexOptions.None);
            List<RegTag> list = new List<RegTag>();
            List<string> chencklist = new List<string>();
            foreach (Match m in r.Matches(template))
            {
                RegTag tag = new RegTag();
                tag.Attributes = m.Groups["attributes"].ToString();                 //循环属性集
                tag.InnerText = flag ? m.Groups["text"].ToString() : "";            //循环内的内容
                tag.OuterText = m.Groups[0].Value.ToString();                       //整个匹配的内容
                if (!chencklist.Contains(tag.OuterText))
                {
                    list.Add(tag);
                    chencklist.Add(tag.OuterText);
                }
            }
            return list;
        }


        /// <summary>
        /// 标签的匹配替换去掉重复项(匹配内容中不能有+、\、(、)、?、[、]等特征字符)
        /// </summary>
        /// <param name="template">模板内容</param>
        /// <param name="tagName">标签名</param>
        /// <returns>RegTags</returns>
        public static List<RegTag> GetPublicRegTagsDistinct(string template, string tagName)
        {
            string regstr = @"(\[tagname+(?<attributes>[^\]]*?)\])".Replace("tagname", tagName);
            Regex r = new Regex(regstr, RegexOptions.None);
            List<RegTag> list = new List<RegTag>();
            List<string> chencklist = new List<string>();
            foreach (Match m in r.Matches(template))
            {
                RegTag tag = new RegTag();
                tag.Attributes = m.Groups["attributes"].ToString();                 //循环属性集
                tag.InnerText = "";                                                 //循环内的内容
                tag.OuterText = m.Groups[0].Value.ToString();                       //整个匹配的内容
                if (!chencklist.Contains(tag.OuterText))
                {
                    list.Add(tag);
                    chencklist.Add(tag.OuterText);
                }
            }
            return list;
        }


        #region contact me
        public static string Help()
        {
            return @"mailto:354990393@qq.com";
        }
        #endregion


    }
}



