/**********************************************************************************
 * ˵     ƥhtml
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System; 
using System.Collections.Generic; 
using System.Text; 
using System.Web; 
using System.Text.RegularExpressions;
namespace PlugNT.Common
{
    /// <summary>
    /// ƥhtml
    /// </summary>
    public class RegHtml
    {
        /// <summary>
        /// ⲿбǩеַ
        /// </summary>
        /// <param name="str"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public static string[] MatcheSinglelines(string str, string flag)
        {
            if (str==null || str.Trim() == "")
            {
                return new string[] { "(1)ַΪգûҵƥַ" };
            }
            Regex re = new Regex("<" + flag + @"[\s\S]*?>", (RegexOptions.Multiline | RegexOptions.IgnoreCase));  
            MatchCollection mc = re.Matches(str);
            string[] tStr = new string[mc.Count];
            int i = 0;
            foreach (Match ma in mc)
            {
                tStr[i] = ma.Groups[0].Value;
                i++;
            }
            return tStr;
        }
        /// <summary>
        /// ⲿеݹǩеַ
        /// </summary>
        /// <param name="str"></param>
        /// <param name="flag"></param>
        /// <param name="specialCode"></param>
        /// <returns></returns>
        public static string[] MatcheComplexs(string str, string flag, string specialCode)
        {
            if (str == null || str.Trim() == "")
            {
                return new string[] { "(2)ַΪգûҵƥַ" };
            }
            string pattern = @"(?isx)
                      <({0})\b\s*{1}\s*[^>]*>         #ʼǡ<tag...>
                          (?>                         #鹹죬޶ʡ*ηΧ 
                              <\1[^>]*>  (?<Open>)    #飬ʼǣջOpen1
                          |                           #֧ṹ
                              </\1>  (?<-Open>)       #ƽ飬ǣջOpen1
                          |                           #֧ṹ
                              (?:(?!</?\1\b).)*       #Ҳ಻Ϊʼǵַ
                          )*                          #Ӵ0λ
                          (?(Open)(?!))               #жǷ'OPEN'˵ԣʲôƥ
                      </\1>                           #ǡ</tag>
                     ";
            Regex re = new Regex(string.Format(pattern, Regex.Escape(flag), Regex.Escape(specialCode)), (RegexOptions.Multiline | RegexOptions.IgnoreCase));
            MatchCollection mc = re.Matches(str);
            string[] tStr = new string[mc.Count];
            int i = 0;
            foreach (Match ma in mc)
            {
                tStr[i] = ma.Groups[0].Value;
                i++;
            }
            return tStr;
        }
        /// <summary>
        /// رǩе
        /// </summary>
        /// <param name="str"></param>
        /// <param name="property"></param>
        /// <returns></returns>
        public static string MatcheValues(string str, string property)
        {
            if (str == null || str.Trim() == "")
            {
                return "(3)ַΪգûҵƥַ" ;
            }
            int flg=str.IndexOf(">");
            if (flg > 0)
            {
                string tStr = str.Substring(0, flg + 1);
                string m = Regex.Match(tStr, property + "\\s*\\=\\s*['|\"].+?['|\"]", RegexOptions.IgnoreCase).ToString();
                int dflg = m.IndexOf("'");
                int sflg = m.IndexOf("\"");
                if (m != "")
                {
                    if (dflg > 0)
                    {
                        m = m.Substring(dflg);
                        m = m.TrimStart('\'').TrimEnd('\'');
                    }
                    else
                    {
                        m = m.Substring(sflg);
                        m = m.TrimStart('\"').TrimEnd('\"');
                    }
                }
                else
                {
                    m = Regex.Match(str, property + "\\s*\\=\\s*.+?[\\s+|>]", RegexOptions.IgnoreCase).ToString();
                    if (m != "")
                    {
                        m = m.TrimStart(property.ToCharArray()).Trim().TrimStart('=').Trim().TrimEnd('>');
                    }
                }
                return m;
            }
            else
            {
                return "";
            }
        }
        /// <summary>
        /// ضеݹǩеڲǩ
        /// </summary>
        /// <param name="str"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public static string MatcheInners(string str, string flag)
        {
            if (str == null || str.Trim() == "")
            {
                return "(4)ַΪգûҵƥַ" ;
            }
            string start = Regex.Match(str, "<" + flag + @"[\s\S]*?>",  RegexOptions.IgnoreCase).ToString();
            string end = "</" + flag + ">";
            string reStr = str.Substring(start.Length);
            return (reStr.Length > end.Length) ? reStr.Substring(0, reStr.Length - end.Length) : reStr;
        }
        public static string Help()
        {
            return @"mailto:354990393@qq.com";
        }
    }
}

