/**********************************************************************************
 * ˵     Httpĵ
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Web;
using System.Text;
using System.Data;
namespace PlugNT.Common
{
    /// <summary>
    /// ExcelXmlĵ
    /// </summary>
    public class HttpDocument
    {
        /// <summary>
        /// Excelĵ
        /// </summary>
        /// <param name="dataTable"></param>
        /// <param name="fileName">*.xls*.xml</param>
        public static void ExcelExport(DataTable dataTable, string fileName)
        {
            HttpResponse resp;
            resp = HttpContext.Current.Response;
            resp.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            resp.AppendHeader("Content-Disposition", "attachment;filename=" + fileName);
            StringBuilder colHeaders = new StringBuilder();
            int i = 0;
            DataRow[] myRow = dataTable.Select("");
            for (i = 0; i < dataTable.Columns.Count; i++)
            {
                if (i == dataTable.Columns.Count - 1)
                {
                    colHeaders.Append(dataTable.Columns[i].Caption.ToString() + "\n");
                }
                else
                {
                    colHeaders.Append(dataTable.Columns[i].Caption.ToString() + "\t");
                }
            }
            resp.Write(colHeaders.ToString());
            foreach (DataRow row in myRow)
            {
                StringBuilder lsItem = new StringBuilder();
                for (i = 0; i < dataTable.Columns.Count; i++)
                {
                    if (i == dataTable.Columns.Count - 1)
                    {
                        lsItem.Append(row[i].ToString() + "\n");
                    }
                    else
                    {
                        lsItem.Append(row[i].ToString() + "\t");
                    }
                }
                resp.Write(lsItem.ToString());
            }
            resp.End();
        }
        /// <summary>
        /// Xmlĵ
        /// </summary>
        /// <param name="dataTable"></param>
        /// <param name="fileName">*.xls*.xml</param>
        public static void XmlExport(DataTable dataTable, string fileName)
        {
            HttpResponse resp;
            resp = HttpContext.Current.Response;
            resp.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            resp.AppendHeader("Content-Disposition", "attachment;filename=" + fileName);
            resp.Write(dataTable.DataSet.GetXml());
            resp.End();
        }
    }
}

