/**********************************************************************************
 * ˵     ϣ
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
namespace PlugNT.Common.Hash
{
    public class Hashtable
    {
        private struct bucket
        {
            public Object key; 
            public Object val; 
            public int hash_coll; 
        }
        private bucket[] buckets; 
        private int count; 
        private int loadsize; 
        private float loadFactor; 
        public Hashtable() : this(0, 1.0f) { }
        public Hashtable(int capacity, float loadFactor)
        {
            if (!(loadFactor >= 0.1f && loadFactor <= 1.0f))
                throw new ArgumentOutOfRangeException(
                    "ӱ0.11֮");
            this.loadFactor = loadFactor > 0.72f ? 0.72f : loadFactor;
            double rawsize = capacity / this.loadFactor;
            int hashsize = (rawsize > 11) ? 
                HashHelpers.GetPrime((int)rawsize) : 11;
            buckets = new bucket[hashsize]; 
            loadsize = (int)(this.loadFactor * hashsize);
        }
        public virtual void Add(Object key, Object value) 
        {
            Insert(key, value, true);
        }
        private uint InitHash(Object key, int hashsize,
            out uint seed, out uint incr)
        {
            uint hashcode = (uint)GetHash(key) & 0x7FFFFFFF; 
            seed = (uint)hashcode; 
            incr = (uint)(1 + (((seed >> 5) + 1) % ((uint)hashsize - 1)));
            return hashcode; 
        }
        public virtual Object this[Object key] 
        {
            get
            {
                uint seed; 
                uint incr; 
                uint hashcode = InitHash(key, buckets.Length,
                    out seed, out incr);
                int ntry = 0; 
                bucket b;
                int bn = (int)(seed % (uint)buckets.Length); 
                do
                {
                    b = buckets[bn];
                    if (b.key == null) 
                    { 
                        return null;
                    }
                    if (((b.hash_coll & 0x7FFFFFFF) == hashcode) &&
                        KeyEquals(b.key, key))
                    { 
                        return b.val;
                    }
                    bn = (int)(((long)bn + incr) %
                        (uint)buckets.Length); 
                } while (b.hash_coll < 0 && ++ntry < buckets.Length);
                return null;
            }
            set
            {
                Insert(key, value, false);
            }
        }
        private void expand() 
        { 
            int rawsize = HashHelpers.GetPrime(buckets.Length * 2);
            rehash(rawsize);
        }
        private void rehash(int newsize) 
        {
            bucket[] newBuckets = new bucket[newsize];
            for (int nb = 0; nb < buckets.Length; nb++)
            {
                bucket oldb = buckets[nb];
                if ((oldb.key != null) && (oldb.key != buckets))
                {
                    putEntry(newBuckets, oldb.key, oldb.val,
                        oldb.hash_coll & 0x7FFFFFFF);
                }
            }
            buckets = newBuckets;
            loadsize = (int)(loadFactor * newsize);
            return;
        }
        private void putEntry(bucket[] newBuckets, Object key,
            Object nvalue, int hashcode)
        {
            uint seed = (uint)hashcode; 
            uint incr = (uint)(1 + (((seed >> 5) + 1) %
                ((uint)newBuckets.Length - 1))); 
            int bn = (int)(seed % (uint)newBuckets.Length);
            do
            { 
                if ((newBuckets[bn].key == null) ||
                    (newBuckets[bn].key == buckets))
                { 
                    newBuckets[bn].val = nvalue;
                    newBuckets[bn].key = key;
                    newBuckets[bn].hash_coll |= hashcode;
                    return;
                }
                if (newBuckets[bn].hash_coll >= 0)
                { 
                    newBuckets[bn].hash_coll |=
                        unchecked((int)0x80000000);
                }
                bn = (int)(((long)bn + incr) % (uint)newBuckets.Length);
            } while (true);
        }
        protected virtual int GetHash(Object key)
        { 
            return key.GetHashCode();
        }
        protected virtual bool KeyEquals(Object item, Object key)
        { 
            return item == null ? false : item.Equals(key);
        }
        private void Insert(Object key, Object nvalue, bool add)
        { 
            if (count >= loadsize)
            {
                expand();
            }
            uint seed; 
            uint incr; 
            uint hashcode = InitHash(key, buckets.Length, out seed, out incr);
            int ntry = 0; 
            int emptySlotNumber = -1; 
            int bn = (int)(seed % (uint)buckets.Length); 
            do
            { 
                if (emptySlotNumber == -1 && (buckets[bn].key == buckets) &&
                    (buckets[bn].hash_coll < 0))
                {
                    emptySlotNumber = bn;
                }
                if (buckets[bn].key == null) 
                {
                    if (emptySlotNumber != -1) 
                        bn = emptySlotNumber;
                    buckets[bn].val = nvalue;
                    buckets[bn].key = key;
                    buckets[bn].hash_coll |= (int)hashcode;
                    count++;
                    return;
                }
                if (((buckets[bn].hash_coll & 0x7FFFFFFF) == hashcode) &&
                    KeyEquals(buckets[bn].key, key))
                { 
                    if (add)
                    {
                        throw new ArgumentException("ظļֵ");
                    }
                    buckets[bn].val = nvalue; 
                    return;
                }
                if (emptySlotNumber == -1)
                {
                    if (buckets[bn].hash_coll >= 0)
                    {
                        buckets[bn].hash_coll |= unchecked((int)0x80000000);
                    }
                }
                bn = (int)(((long)bn + incr) % (uint)buckets.Length);
            } while (++ntry < buckets.Length);
            throw new InvalidOperationException("ʧܣ");
        }
        public virtual void Remove(Object key) 
        {
            uint seed; 
            uint incr; 
            uint hashcode = InitHash(key, buckets.Length, out seed, out incr);
            int ntry = 0; 
            bucket b;
            int bn = (int)(seed % (uint)buckets.Length); 
            do
            {
                b = buckets[bn];
                if (((b.hash_coll & 0x7FFFFFFF) == hashcode) &&
                    KeyEquals(b.key, key)) 
                { 
                    buckets[bn].hash_coll &= unchecked((int)0x80000000);
                    if (buckets[bn].hash_coll != 0) 
                    { 
                        buckets[bn].key = buckets;
                    }
                    else 
                    { 
                        buckets[bn].key = null;
                    }
                    buckets[bn].val = null; 
                    count--;
                    return;
                } 
                bn = (int)(((long)bn + incr) % (uint)buckets.Length);
            } while (b.hash_coll < 0 && ++ntry < buckets.Length);
        }
        public override string ToString()
        {
            string s = string.Empty;
            for (int i = 0; i < buckets.Length; i++)
            {
                if (buckets[i].key != null && buckets[i].key != buckets)
                { 
                    s += string.Format("{0,-5}{1,-8}{2,-8}{3,-8}rn",
                        i.ToString(), buckets[i].key.ToString(),
                        buckets[i].val.ToString(),
                        buckets[i].hash_coll.ToString());
                }
                else
                { 
                    s += string.Format("{0,-21}{1,-8}rn", i.ToString(),
                        buckets[i].hash_coll.ToString());
                }
            }
            return s;
        }
        public virtual int Count 
        { 
            get { return count; }
        }
    }
}

