/**********************************************************************************
 * ˵     ļ
 * ڣ     2009.9.20
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.Checksums; 
namespace PlugNT.Common
{
    /// <summary>
    /// ļ
    /// </summary>
    public class FileHelper
    {
        /// <summary>  
        /// ѹָļZIPļ  
        /// </summary>  
        /// <param name="topDirName">ļ \Storage Card\PDADataExchange\send\xml\</param>  
        /// <param name="fileNamesToZip">ѹļб  file ddd.txt</param>  
        /// <param name="ZipedFileName">ZIPļ  \Storage Card\PDADataExchange\send\zip\version.zip</param>  
        /// <param name="CompressionLevel">ѹ  7</param>  
        /// <param name="password"> ""</param>  
        /// <param name="comment">ѹļע  ""</param>  
        public static void ZipFile(string topDirName, string[] fileNamesToZip, string ZipedFileName, int CompressionLevel, string password, string comment)
        {
            using (ZipOutputStream s = new ZipOutputStream(System.IO.File.Open(ZipedFileName, FileMode.Create)))
            {
                if (password != null && password.Length > 0)
                    s.Password = password;
                if (comment != null && comment.Length > 0)
                    s.SetComment(comment);
                s.SetLevel(CompressionLevel); 
                foreach (string file in fileNamesToZip)
                {
                    using (FileStream fs = File.OpenRead(Path.Combine(topDirName, file)))   
                    {
                        byte[] buffer = new byte[fs.Length];
                        fs.Read(buffer, 0, buffer.Length);      
                        ZipEntry entry = new ZipEntry(file);    
                        entry.DateTime = DateTime.Now;
                        entry.Size = fs.Length;
                        fs.Close();
                        s.PutNextEntry(entry);
                        s.Write(buffer, 0, buffer.Length);
                    }
                }
                s.Finish();
                s.Close();
            }
        }
        /// <summary>  
        /// ѹZIPļָļ  
        /// </summary>  
        /// <param name="zipfileName">ZIPļ</param>  
        /// <param name="UnZipDir">ѹļ</param>  
        /// <param name="password">ѹļ</param>  
        public static void UnZipFile(string zipfileName, string UnZipDir, string password)
        {
            ZipInputStream s = new ZipInputStream(File.OpenRead(zipfileName));
            if (password != null && password.Length > 0)
                s.Password = password;
            try
            {
                ZipEntry theEntry;
                while ((theEntry = s.GetNextEntry()) != null)
                {
                    string directoryName = Path.GetDirectoryName(UnZipDir);
                    string pathname = Path.GetDirectoryName(theEntry.Name);
                    string fileName = Path.GetFileName(theEntry.Name);
                    pathname = pathname.Replace(":", "$");//ѹʱ̷  
                    directoryName = directoryName + "\\" + pathname;
                    Directory.CreateDirectory(directoryName);
                    if (fileName != String.Empty)
                    {
                        FileStream streamWriter = File.Create(directoryName + "\\" + fileName);
                        int size = 2048;
                        byte[] data = new byte[2048];
                        while (true)
                        {
                            size = s.Read(data, 0, data.Length);
                            if (size > 0)
                            {
                                streamWriter.Write(data, 0, size);
                            }
                            else
                            {
                                break;
                            }
                        }
                        streamWriter.Close();
                    }
                }
                s.Close();
            }
            catch (Exception eu)
            {
                throw eu;
            }
            finally
            {
                s.Close();
            }
        }
        ///using System.IO.Packaging;
        /// <summary>
        /// .Net3.0 Office 2007
        /// </summary>
        /// <param name="fileName"></param>
        /// <summary>
        /// Ƿȫļ
        /// </summary>
        /// <param name="filepath"></param>
        /// <returns></returns>
        public static bool IsSafeFile(string filepath)
        {
            System.IO.FileStream fs = new System.IO.FileStream(filepath, System.IO.FileMode.Open, System.IO.FileAccess.Read);
            System.IO.BinaryReader br = new System.IO.BinaryReader(fs);
            string fileclass = "";
            try
            {
                byte buffer = br.ReadByte();
                fileclass = buffer.ToString();
                buffer = br.ReadByte();
                fileclass += buffer.ToString();
            }
            catch
            {
                return false;
            }
            finally
            {
                br.Close();
                fs.Close();
            }
            bool ret = false;
            String[] fileType = { "255216", "6677", "7173", "13780", "8297", "208207", "3780", "8075" };
            int lenFile = fileType.Length;
            for (int i = 0; i < lenFile; i++)
            {
                if (fileclass == fileType[i])
                {
                    ret = true;
                    break;
                }
            }
            return ret;
        }
        /// <summary>
        /// Ƿȫļ
        /// </summary>
        /// <param name="fs"></param>
        /// <param name="isImage"></param>
        /// <returns></returns>
        public static bool IsSafeFile(System.IO.Stream fs, bool isImage)
        {
            System.IO.BinaryReader br = new System.IO.BinaryReader(fs);
            string fileclass = "";
            try
            {
                byte buffer = br.ReadByte();
                fileclass = buffer.ToString();
                buffer = br.ReadByte();
                fileclass += buffer.ToString();
            }
            catch
            {
                return false;
            }
            finally
            {
                br.Close();
                fs.Close();
            }
            bool ret = false;
            String[] fileType = { "255216", "6677", "7173", "13780", "8297", "208207", "8075", "3780" };
            int lenFile = isImage ? 4 : fileType.Length;
            for (int i = 0; i < lenFile; i++)
            {
                if (fileclass == fileType[i])
                {
                    ret = true;
                    break;
                }
            }
            return ret;
            /*ļչ˵ 
            jpg255216 
            bmp6677 
            gif7173 
            png: 13780
            rar8297 
            xls,doc,ppt208207 
            zip8075 
            pdf3780 
            txt98109 
            exe: 7790
            */
        }
        /// <summary>
        /// ļ
        /// </summary>
        /// <param name="hifile"></param>
        /// <returns></returns>
        public static MemoryStream CopyStream(System.Web.HttpPostedFile hifile)
        {
            int fileLen = hifile.ContentLength;
            byte[] imgArray = new byte[fileLen];
            hifile.InputStream.Read(imgArray, 0, fileLen);
            System.IO.MemoryStream fs = new System.IO.MemoryStream(imgArray);
            return fs;
        }
    }
}

