using System;
using System.Collections;
using System.IO;
using System.Net;
using System.Data;
using System.Web;
using System.Web.SessionState;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Page;
namespace PlugNT.Cms.Web.Tools
{
    /// <summary>
    /// 
    /// </summary>
    public class Attach : IHttpHandler, IRequiresSessionState
    {
        public void ProcessRequest(HttpContext context)
        {
            int sid;
            if (!int.TryParse(context.Request.Params["id"] as string, out sid))
            {
                context.Response.Redirect("/error.html");
                return;
            }
            Attachment bllAttachment = new Attachment();
            AttachmentInfo aInfo = bllAttachment.GetAttachmentInfo(sid);
            if (aInfo==null)
            {
                context.Response.Redirect("/error.html?rnd=1");
                return;
            }
            
            string fullFileName = PlugNT.Common.Utils.GetMapPath(aInfo.file_path);
            
            if (!File.Exists(fullFileName))
            {
                context.Response.Redirect("/error.html?rnd=2");
                return;
            }
            bllAttachment.OperationDownCount(sid, "+", 1);
            FileInfo file = new FileInfo(fullFileName);
            context.Response.ContentEncoding = System.Text.Encoding.GetEncoding("UTF-8"); //
            context.Response.AddHeader("Content-Disposition", "attachment; filename=" + HttpUtility.UrlEncode(file.Name)); //ļ    
            context.Response.AddHeader("Content-length", file.Length.ToString());
            switch (aInfo.file_type)
            {
                case ".txt":
                    context.Response.ContentType = "text/plain";
                    break;
                case ".css":
                    context.Response.ContentType = "text/css";
                    break;
                case ".gif":
                    context.Response.ContentType = "image/gif";
                    break;
                case ".png":
                    context.Response.ContentType = "image/png";
                    break;
                case ".jpg":
                    context.Response.ContentType = "image/jpeg";
                    break;
                case ".avi":
                    context.Response.ContentType = "video/x-msvideo";
                    break;
                case ".ra":
                    context.Response.ContentType = "audio/x-realaudio";
                    break;
                case ".wav":
                    context.Response.ContentType = "audio/x-wav";
                    break;
                case ".pdf":
                    context.Response.ContentType = "application/pdf";
                    break;
                case ".xls":
                    context.Response.ContentType = "application/vnd.ms-excel";
                    break;
                case ".doc":
                    context.Response.ContentType = "application/msword";
                    break;
                case ".ppt":
                    context.Response.ContentType = "application/powerpoint";
                    break;
                default:
                    context.Response.ContentType = "application/x-msdownload";
                    break;
            }
            context.Response.WriteFile(file.FullName);
            context.Response.End();
        }
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}

