﻿<%@ Application Language="C#" %>

<script runat="server">

    void Application_Start(object sender, EventArgs e) 
    {
        //在应用程序启动时运行的代码
        //初始化WebConfig
        PlugNT.Cms.Custom.SiteConfig.Init();
        //自动更新页面
        PlugNT.Cms.Page.AutoUpdater.Start();
    }
    
    void Application_End(object sender, EventArgs e) 
    {
        //在应用程序关闭时运行的代码
        PlugNT.Cms.BLL.IUser.ReSetOnline();
    }
        
    void Application_Error(object sender, EventArgs e) 
    { 
        //在出现未处理的错误时运行的代码

    }

    void Session_Start(object sender, EventArgs e) 
    {
        //在新会话启动时运行的代码
        //添加访问人数
        PlugNT.Cms.BLL.IUser.AddOnline();
    }

    void Session_End(object sender, EventArgs e) 
    {
        //在会话结束时运行的代码。 
        // 注意: 只有在 Web.config 文件中的 sessionstate 模式设置为
        // InProc 时，才会引发 Session_End 事件。如果会话模式 
        //设置为 StateServer 或 SQLServer，则不会引发该事件。

        //删除当前在线用户,只能用当前Session，否则出错(Object reference not set to an instance of an object.)。
        string sessionname = PlugNT.Cms.Custom.Key_Flags.SessionUser;
        if (Session[sessionname] != null)
        {
            PlugNT.Cms.BLL.IUser.DelOnlineUser(Session[sessionname].ToString(), Session.SessionID);
        }
        //删除访问人数
        PlugNT.Cms.BLL.IUser.DelOnline();
    }


</script>
