/**********************************************************************************
 * ˵     ̨ҳ(ֲ)
 * ڣ     2009.6.13
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Text;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Page;
namespace PlugNT.Cms.Web.Admin.Pre_App
{
    public partial class List : AdminPager
    {
        private string uName;
        protected void Page_Load(object sender, EventArgs e)
        {
            this.CheckPower();
            if (!IsPostBack)
            {
                string type = (Request.QueryString["t"] == null) ? "" : Request.QueryString["t"].Trim();
                uName = (Request.QueryString["name"] == null) ? "" : Request.QueryString["name"].Trim();
                switch (type)
                {
                    case "enable":
                        EnableApp();
                        break;
                    case "disable":
                        DisableApp();
                        break;
                    default:
                        break;
                }
                rptAdmin_bind();
                
            }
        }
        private void rptAdmin_bind()
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("name");
            dt.Columns.Add("title");
            dt.Columns.Add("version");
            dt.Columns.Add("setuped");
            dt.Columns.Add("article");
            dt.Columns.Add("text");
            XmlDataDocument xmlDoc = new XmlDataDocument();
            xmlDoc.Load(SiteConfig.ConfigPath + "plugin.config");
            XmlNodeList xmlNodes = xmlDoc.SelectNodes("/configs/plugitem");
        
            foreach (XmlNode n in xmlNodes)
            {
                DataRow dr = dt.NewRow();
                string dllPath = SiteConfig.RootPath + "bin\\" + n.SelectSingleNode("plug").Attributes["filename"].Value;
                dr["name"] = n.Attributes["name"].Value;
                dr["title"] = n.SelectSingleNode("plug").InnerText;
                dr["version"] = System.IO.File.Exists(dllPath) ? PlugNT.Common.Utils.GetAssemblyVersion(SiteConfig.RootPath + "bin\\" + n.SelectSingleNode("plug").Attributes["filename"].Value) : "unknown";
                dr["setuped"] = n.SelectSingleNode("plug").Attributes["setuped"].Value;
                dr["article"] = (n.SelectSingleNode("assembly/article") == null) ? "false" : "true";
                dr["text"] = n.SelectSingleNode("text").InnerText;
                dt.Rows.Add(dr);
            }
            xmlDoc = null;
            rptAdmin.DataSource = dt.DefaultView;
            rptAdmin.DataBind();
            
        }
        private void EnableApp()
        {
            this.CheckReadOnly();
            if (!SiteConfig.IsAccess)
            {
                XmlDataDocument xmlDoc = new XmlDataDocument();
                xmlDoc.Load(SiteConfig.ConfigPath + "plugin.config");
                XmlNodeList xmlNodes = xmlDoc.SelectNodes("/configs/plugitem");
                foreach (XmlNode n in xmlNodes)
                {
                    if (n.Attributes["name"].Value == uName)
                    {
                        if (n.SelectSingleNode("plug").Attributes["setuped"].Value != "true")
                        {
                            n.SelectSingleNode("plug").Attributes["setuped"].Value = "true";
                            XmlNodeList sqls = n.SelectNodes("insql/sql");
                            if (sqls != null && sqls.Count > 0)
                            {
                                List<string> lsql = new List<string>();
                                foreach (XmlNode sql in sqls)
                                {
                                    string sqlStr = sql.InnerText.Trim();
                                    if (sqlStr != "")
                                    {
                                        lsql.Add(sqlStr);
                                    }
                                }
                                if (lsql.Count > 0)
                                {
                                    ITable.SqlClient_ExecuteSqlList(lsql);
                                }
                            }
                        }
                        break;
                    }
                }
                xmlDoc.Save(SiteConfig.ConfigPath + "plugin.config");
                xmlDoc = null;
                Response.Redirect("./List.aspx" + GetBaseParams("?"));
            }
            else
            {
                ShowMessager("òʧܣAccessݿ޴", Type_Message.Error);
            }
        }
        private void DisableApp()
        {
            this.CheckReadOnly();
            if (!SiteConfig.IsAccess)
            {
                XmlDataDocument xmlDoc = new XmlDataDocument();
                xmlDoc.Load(SiteConfig.ConfigPath + "plugin.config");
                XmlNodeList xmlNodes = xmlDoc.SelectNodes("/configs/plugitem");
                foreach (XmlNode n in xmlNodes)
                {
                    if (n.Attributes["name"].Value == uName)
                    {
                        if (n.SelectSingleNode("plug").Attributes["setuped"].Value == "true")
                        {
                            n.SelectSingleNode("plug").Attributes["setuped"].Value = "false";
                            XmlNodeList sqls = n.SelectNodes("unsql/sql");
                            if (sqls != null && sqls.Count > 0)
                            {
                                List<string> lsql = new List<string>();
                                foreach (XmlNode sql in sqls)
                                {
                                    string sqlStr = sql.InnerText.Trim();
                                    if (sqlStr != "")
                                    {
                                        lsql.Add(sqlStr);
                                    }
                                }
                                if (lsql.Count > 0)
                                {
                                    ITable.SqlClient_ExecuteSqlList(lsql);
                                }
                            }
                        }
                        break;
                    }
                }
                xmlDoc.Save(SiteConfig.ConfigPath + "plugin.config");
                xmlDoc = null;
                Response.Redirect("./List.aspx" + GetBaseParams("?"));
            }
            else
            {
                ShowMessager("òʧܣAccessݿ޴", Type_Message.Error);
            }
        }
    }
}

