/**********************************************************************************
 * ˵     ̨ҳ(ֲ)
 * ڣ     2009.6.13
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Data;
using System.Web.UI.WebControls;
using PlugNT.Cms.Custom;
using PlugNT.Common;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Model;
using PlugNT.Cms.Page;
namespace PlugNT.Cms.Web.Admin.Pre_Adminer
{
    public partial class List : AdminPager
    {
        private Adminer bllAdminer = new Adminer();
        private GroupAdmin bllGroupAdmin = new GroupAdmin();
        private string power = "";
        private int pageSize = 15;
        protected void Page_Load(object sender, EventArgs e)
        {
            this.CheckPower();
            power = Request.QueryString["power"] == null ? "" : Request.QueryString["power"].Trim();
            if (!IsPostBack)
            {
                string type = (Request.QueryString["t"] == null) ? "" : Request.QueryString["t"].Trim();
                string sid = (Request.QueryString["id"] == null) ? "" : Request.QueryString["id"].Trim();
                if (type == "delete" &&  Utils.IsNumeric(sid))
                {
                    bllAdminer.Delete(int.Parse(sid));
                }
                BindData();
                rptAdmin_bind();
            }
        }
       
        private void BindData()
        {
            DataTable dt = bllGroupAdmin.GetPowerList();
            this.ddlMenu.Items.Clear();
            this.ddlMenu.Items.Add(new ListItem("з", ""));
            int tCount = 1;
            foreach (DataRow dr in dt.Rows)
            {
                string tpower = dr["power"].ToString();
                string tname = dr["name"].ToString();
                ListItem li = new ListItem(tname, tpower);
                ddlMenu.Items.Add(li);
                if (power == tpower)
                {
                    ddlMenu.SelectedIndex = tCount;
                }
                tCount++;
            }
        }
        
        private void rptAdmin_bind()
        {
            string currPageCount = (Request.QueryString["page"] == null) ? "0" : Request.QueryString["page"].Trim();
            int tCurrPageCount = int.Parse(currPageCount);
            int recordCount = 0;
            DataTable dt = bllAdminer.GetList(pageSize, tCurrPageCount, power, "id", out recordCount);
            litPager.Text = Pager.Pagination(recordCount, pageSize, tCurrPageCount, "?power=" + power + "&page={0}" + GetBaseParams("&"), "", true, true);
            rptAdmin.DataSource = dt;
            rptAdmin.DataBind();
        }
        protected void rptAdmin_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.AlternatingItem || e.Item.ItemType == ListItemType.Item)
            {
                Literal litPower = (Literal)e.Item.FindControl("litPower");
                DataRowView drv = (DataRowView)e.Item.DataItem;
                string tpower = drv["power"].ToString();
                if (tpower == "0")
                {
                    litPower.Text = "Ա";
                }
                else
                {
                    litPower.Text = GroupAdmin.GetName(tpower);
                }
            }
        }
        protected void ImageButton_all_del_Click(object sender, System.Web.UI.ImageClickEventArgs e)
        {
            this.CheckReadOnly();
            int nub = 0;
            for (int i = 0; i < rptAdmin.Items.Count; i++)
            {
                int id = Convert.ToInt32(((HiddenField)rptAdmin.Items[i].FindControl("hidid")).Value.Trim());
                CheckBox CK = (CheckBox)rptAdmin.Items[i].FindControl("ID_list");
                if (CK.Checked)
                {
                    bllAdminer.Delete(id);
                    nub += 1;
                }
            }
            if (nub == 0)
            {
                ShowMessager("ɾϢʧܣ", Type_Message.Error);
            }
            else
            {
                ShowMessager("ɾ<b>" + nub + "</b>Ϣɹ", Type_Message.Ok);
            }
        }
    }
}

