/**********************************************************************************
 * ˵     ɾ̬ҳ(ҵĲ)
 * ڣ     2009.6.13
 * ޸ڣ     2013.10.06
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Reflection;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Data;
using System.ComponentModel;
using System.Collections;
using PlugNT.Common.Templet;
using PlugNT.Cms.Custom;
using PlugNT.Cms.BLL;
namespace PlugNT.Cms.Utility
{
    /// <summary>
    /// ɾ̬ҳ(ɱʵ)
    /// ıַȫ滻 RegTemplet.Replace  templet.Replace  ֱ滻
    /// </summary>
    public class FileBuilder
    {
        private const string trait_str = "{0}";
        private string[] traitArr = null;
        private string _filePath = "";
        /// <summary>
        /// ɾ̬ļ
        /// </summary>
        public string FileCreatePath = "";
        /// <summary>
        /// ̬ļģ·
        /// </summary>
        public string FilePath
        {
            get { return _filePath; }
            set { _filePath = value.Replace(TplLabel.pubStartFlg + TplLabel.templetdirFlg + TplLabel.pubEndFlg, SiteConfig.TempletDir); }
        }
        /// <summary>
        /// ɾ̬ļ
        /// </summary>
        public string FileName = "";
        /// <summary>
        /// ̬ļչ
        /// </summary>
        public string FileExtName = "";
        /// <summary>
        /// ֵ(ҳ)
        /// </summary>
        public int IdValue = -1;
        /// <summary>
        /// (бҳ)
        /// </summary>
        public int ChannelId = 0;
        /// <summary>
        /// Ƿѹ
        /// </summary>
        public bool IsZipFile = false;
        
        /// <summary>
        /// 캯
        /// </summary>
        public FileBuilder()
        {
            traitArr = SiteConfig.TraitStr.Split(',');
        }
        /// <summary>
        /// ɵҳľۺҳҳ(ΪΪҳ)
        /// </summary>
        /// <param name="pageName">ļ</param>
        /// <returns></returns>
        public void CreateSingle()
        {
            if (this.FilePath.Trim() == "")
            {
                throw new TplException("FilePath·Ϊɾۺҳʧ");
            }
            string path = GetPath(this.FilePath);
            if (!File.Exists(path))
            {
                throw new TplException("FilePath·ɾۺҳʧ");
            }
            bool zipFile = IsZipFile;
            zipFile = (FileExtName == ".js" || FileExtName == ".css" || FileExtName == ".config") ? false : zipFile;
            string templet = GetHtml(path, zipFile);
            if (HasFieldTag(templet))
            {
                throw new TplException("бҳвоۺҳҳıǩ");
            }
            if (HasPageListTag(templet) || HasPaginationTag(templet))
            {
                throw new TplException("ɵҳľۺҳбҳıǩ");
            }
            this.FileName = this.FileName.Trim();
            if (this.FileName == "")
            {
                throw new TplException("ɾۺҳƲΪ");
            }
            templet = ReplaceBaseTemplett(templet);
            templet = ReplacePublicTemplet(templet);
            templet = ReplaceCurrentTemplet(templet);
            CreateFile(templet);
        }
        /// <summary>
        /// ɵҳҳ
        /// </summary>
        public void CreateShow()
        {
            if (this.FilePath.Trim() == "")
            {
                throw new TplException("FilePath·Ϊҳʧ");
            }
            string path = GetPath(this.FilePath);
            if (!File.Exists(path))
            {
                throw new TplException("FilePath·ҳʧ");
            }
            bool zipFile = IsZipFile;
            zipFile = (FileExtName == ".js" || FileExtName == ".css" || FileExtName == ".config") ? false : zipFile;
            string templet = GetHtml(path, zipFile);
            if (HasPageListTag(templet) || HasPaginationTag(templet))
            {
                throw new TplException("ɵҳҳбҳıǩ");
            }
            this.FileName = this.FileName.Trim();
            if (this.FileName == "")   //ΪյĻֻһ
            {
                throw new TplException("ҳƲΪ");
            }
            templet = ReplaceBaseTemplett(templet);
            templet = ReplaceShowTemplet(templet);
            templet = ReplacePublicTemplet(templet);
            templet = ReplaceCurrentTemplet(templet);
            
            CreateFile(templet);
        }
        /// <summary>
        /// list htmlļ
        /// </summary>
        public void CreateList()
        {
            if (this.FilePath.Trim() == "")
            {
                throw new TplException("FilePath·Ϊбҳʧ");
            }
            string path = GetPath(this.FilePath);
            if (!File.Exists(path))
            {
                throw new TplException("FilePath·бҳʧ");
            }
            bool zipFile = IsZipFile;
            zipFile = (FileExtName == ".js" || FileExtName == ".css" || FileExtName == ".config") ? false : zipFile;
            string templet = GetHtml(path, zipFile);
            if (HasFieldTag(templet))
            {
                throw new TplException("бҳвоۺҳҳıǩ");
            }
            if (!HasPageListTag(templet))
            {
                throw new TplException("ǰбҳûбҳıǩ");
            }
            templet = ReplaceBaseTemplett(templet);
            templet = ReplacePublicTemplet(templet);
            templet = ReplaceCurrentTemplet(templet);
            if (this.FileName == "")
            {
                throw new TplException("бҳƲΪ");
            }
            string cmsPreList = this.FileName;
            List<string> templets = GetReplaceListTemplets(templet);
            int tCount = templets.Count;
            for (int i = 0; i < tCount; i++)
            {
                this.FileName = (i == 0) ? cmsPreList : cmsPreList + "-" + (i + 1).ToString();
                CreateFile(templets[i]);
            }
        }
 
        /// <summary>
        /// д뵥ļĺ
        /// </summary>
        /// <param name="pageContent">дļ</param>
        private void CreateFile(string pageContent)
        {
            int tLength = traitArr.Length;
            for (int i = 0; i < tLength; i++)
            {
                pageContent = pageContent.Replace(string.Format(trait_str, i), traitArr[i]);
            }
            Encoding code = Encoding.Default;
            StreamWriter sw = null;
            string htmlfilename = this.FileName + this.FileExtName;                            
            try
            {
                string dir = GetPath(this.FileCreatePath);
                if (Directory.Exists(dir) != true)
                {
                    Directory.CreateDirectory(dir);
                }
                string path = (dir.EndsWith("/")) ? dir + htmlfilename : dir + "/" + htmlfilename;
                sw = new StreamWriter(path, false, code);
                sw.Write(pageContent);
                sw.Flush();
                sw.Close();
                
            }
            catch (Exception ex)
            {
                sw = null;
                throw new TplException(ex.Message);    
            }
            finally
            {
                sw = null;
            }
        }
        /// <summary>
        /// õ·
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private static string GetPath(string url)
        {
            return HttpContext.Current.Server.MapPath(url);
        }
        /// <summary>
        /// ݾ·õѹļ
        /// </summary>
        /// <param name="path">·</param>
        /// <returns></returns>
        private static string GetHtml(string path, bool zipFile)
        {
            string fileContent = PlugNT.Common.Utils.ReadFile(path);
            if (zipFile)
            {
                return PlugNT.Common.Utils.ZipHtml(fileContent);
            }
            else
            {
                return fileContent;
            }
        }
        /// <summary>
        /// жϵǰҳǷpagelistǩ
        /// </summary>
        /// <param name="templet"></param>
        /// <returns></returns>
        private static bool HasPageListTag(string templet)
        {
            bool flag = false;
            if (templet.Contains(TplLabel.startFlg + TplLabel.pagelistFlg))
            {
                flag = true;
            }
            return flag;
        }
        /// <summary>
        /// жϵǰҳǷpaginationǩ
        /// </summary>
        /// <param name="templet"></param>
        /// <returns></returns>
        private static bool HasPaginationTag(string templet)
        {
            bool flag = false;
            if (templet.Contains(TplLabel.startFlg + TplLabel.paginationFlg))
            {
                flag = true;
            }
            return flag;
        }
        /// <summary>
        /// жϵǰҳǷfieldǩ
        /// </summary>
        /// <param name="templet"></param>
        /// <returns></returns>
        private static bool HasFieldTag(string templet)
        {
            bool flag = false;
            if (templet.Contains(TplLabel.pubStartFlg + TplLabel.fieldFlg))
            {
                flag = true;
            }
            return flag;
        }
        private string ReplaceBaseTemplett(string template)
        {
            int tLength = traitArr.Length;
            for (int i = 0; i < tLength; i++)
            {
                template = template.Replace(traitArr[i], string.Format(trait_str, i));
            }
            List<RegTag> tags = null;
            if (template.Contains(TplLabel.startFlg + TplLabel.fileFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.fileFlg);
                foreach (RegTag tag in tags)
                {
                    string src = RegTemplet.GetAttribute(tag.Attributes, TplLabel.includeProperty);
                    if (src == "")
                    {
                        throw new TplException("δҵģģ壬ģ·Ϊա");
                    }
                    else
                    {
                        src = GetPath(src);
                        if (!File.Exists(src))
                        {
                            throw new TplException("δҵ" + src + "ģ塣");
                        }
                        bool zipFile = IsZipFile;
                        zipFile = (FileExtName == ".js" || FileExtName == ".css" || FileExtName == ".config") ? false : zipFile;
                        template = template.Replace(tag.OuterText, GetHtml(src, zipFile));
                    }
                }
            }
            if (template.Contains(TplLabel.pubStartFlg + TplLabel.templetdirFlg))
            {
                tags = RegTemplet.GetPublicRegTagsDistinct(template, TplLabel.templetdirFlg);
                foreach (RegTag tag in tags)
                {
                    template = template.Replace(tag.OuterText, SiteConfig.TempletDir);
                }
            }
            if (template.Contains(TplLabel.pubStartFlg + TplLabel.currentFlg))
            {
                tags = RegTemplet.GetPublicRegTagsDistinct(template, TplLabel.currentFlg);
                foreach (RegTag tag in tags)
                {
                    string strname = RegTemplet.GetAttribute(tag.Attributes, TplLabel.nameProperty).ToLower();
                    switch (strname)
                    {
                        case "channel_id":
                            template = template.Replace(tag.OuterText, this.ChannelId.ToString());
                            break;
                        default :
                            template = template.Replace(tag.OuterText, "");
                            break;
                    }
                }
            }
            if (template.Contains(TplLabel.pubStartFlg + TplLabel.siteconfigFlg))
            {
                tags = RegTemplet.GetPublicRegTagsDistinct(template, TplLabel.siteconfigFlg);
                foreach (RegTag tag in tags)
                {
                    string strname = RegTemplet.GetAttribute(tag.Attributes, TplLabel.nameProperty);
                    if (strname == "")
                    {
                        throw new TplException("վδnameԡ");
                    }
                    template = template.Replace(tag.OuterText, SiteConfig.GetPropertyValue(strname));
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.labelFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.labelFlg);
                foreach (RegTag tag in tags)
                {
                    string strkey = RegTemplet.GetAttribute(tag.Attributes, TplLabel.strkeyProperty);
                    if (strkey == "")
                    {
                        throw new TplException("ǩؼδá");
                    }
                    template = template.Replace(tag.OuterText, DataHelper.GetDadaLabelStr(strkey));
                }
            }
            if (template.Contains(TplLabel.pubStartFlg + TplLabel.copyrightFlg))
            {
                tags = RegTemplet.GetPublicRegTagsDistinct(template, TplLabel.copyrightFlg);
                foreach (RegTag tag in tags)
                {
                    template = template.Replace(tag.OuterText, PlugNT.Cms.Utility.DataHelper.CreateCopyright("CMS", SiteConfig.Version));
                }
            }
            return template;
        }
        /// <summary>
        /// ǩ滻
        /// </summary>
        /// <param name="template">ԭģ</param>
        /// <returns></returns>
        private string ReplacePublicTemplet(string template)
        {
            List<RegTag> tags = null;
            if (template.Contains(TplLabel.pubStartFlg + TplLabel.channelfieldFlg))
            {
                DataRow dr = this.ChannelId > 0 ? DataHelper.GetChannelRow(this.ChannelId) : null;
                tags = RegTemplet.GetPublicRegTagsDistinct(template, TplLabel.channelfieldFlg);
                if (dr != null)
                {
                    foreach (RegTag tag in tags)
                    {
                        string name = RegTemplet.GetAttribute(tag.Attributes, TplLabel.nameProperty);
                        if (name == "")
                        {
                            throw new TplException("δֶ");
                        }
                        if (!dr.Table.Columns.Contains(name))
                        {
                            throw new TplException("ݿв" + name + "ֶΡ");
                        }
                        string expression = RegTemplet.GetAttribute(tag.Attributes, TplLabel.expressionProperty);
                        if (expression == "")
                        {
                            template = template.Replace(tag.OuterText, dr[name].ToString());
                        }
                        else
                        {
                            string svalue = GetConditionValue(expression, dr[name].ToString());
                            template = template.Replace(tag.OuterText, svalue);
                        }
                    }
                }
                else
                {
                    foreach (RegTag tag in tags)
                    {
                        template = template.Replace(tag.OuterText, "");
                    }
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.baseifFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.baseifFlg);
                foreach (RegTag tag in tags)
                {
                    string strTest = RegTemplet.GetAttribute(tag.Attributes, TplLabel.testProperty);
                    string strOperate = RegTemplet.GetAttribute(tag.Attributes, TplLabel.operateProperty);
                    string strValue = RegTemplet.GetAttribute(tag.Attributes, TplLabel.valueProperty);
                    if (strOperate=="")
                    {
                        throw new TplException("δã");
                    }
                    string val = GetConditionValue(strTest, strOperate, strValue);
                    if (val != "true" && val != "false")
                    {
                        throw new TplException(val);
                    }
                    if (tag.InnerText.Contains(TplLabel.startFlg + TplLabel.baseelseFlg + TplLabel.endFlg))
                    {
                        string[] arr = PlugNT.Common.Utils.SplitString(tag.InnerText, TplLabel.startFlg + TplLabel.baseelseFlg + TplLabel.endFlg);
                        val = (val == "true") ? arr[0] : arr[1];
                    }
                    else
                    {
                        val = (val == "true") ? tag.InnerText : "";
                    }
                    template = template.Replace(tag.OuterText, val);
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.navigationFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.navigationFlg);
                foreach (RegTag tag in tags)
                {
                    string channelid = RegTemplet.GetAttribute(tag.Attributes, TplLabel.channelidProperty);
                    if (!PlugNT.Common.Utils.IsNumeric(channelid))
                    {
                        throw new TplException("Ŀδá");
                    }
                    string lencount = RegTemplet.GetAttribute(tag.Attributes, TplLabel.lencountProperty);
                    if (lencount == "")
                    {
                        template = template.Replace(tag.OuterText, DataHelper.GetChannelTitle(int.Parse(channelid)));
                    }
                    else
                    {
                        if (!PlugNT.Common.Utils.IsNumeric(lencount))
                        {
                            throw new TplException("Ŀδá");
                        }
                        string target = RegTemplet.GetAttribute(tag.Attributes, TplLabel.targetProperty);
                        string spliter = RegTemplet.GetAttribute(tag.Attributes, TplLabel.spliterProperty);
                        spliter = (spliter == "") ? "   " : spliter;
                        template = template.Replace(tag.OuterText, DataHelper.CreateNavigation(int.Parse(channelid), int.Parse(lencount), target, spliter));
                    }
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.friendlinkFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.friendlinkFlg);
                foreach (RegTag tag in tags)
                {
                    string classid = RegTemplet.GetAttribute(tag.Attributes, TplLabel.classidProperty);
                    if (!PlugNT.Common.Utils.IsNumeric(classid))
                    {
                        throw new TplException("δá");
                    }
                    string spliter = RegTemplet.GetAttribute(tag.Attributes, TplLabel.spliterProperty);
                    spliter = (spliter == "") ? "   " : spliter;
                    template = template.Replace(tag.OuterText, DataHelper.CreateFriendLink(int.Parse(classid), spliter));
                }
            }
            return template;
        }
        /// <summary>
        /// 滻ǰҳģַ
        /// </summary>
        /// <param name="template">ԭģ</param>
        /// <returns>string</returns>
        private string ReplaceCurrentTemplet(string template)
        {
            List<RegTag> tags = null;
            if (template.Contains(TplLabel.startFlg + TplLabel.execFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.execFlg);
                foreach (RegTag tag in tags)
                {
                    string src = RegTemplet.GetAttribute(tag.Attributes, TplLabel.dynamicProperty);
                    if (src == "")
                    {
                        src = RegTemplet.GetAttribute(tag.Attributes, TplLabel.controlProperty);
                        if (src == "")
                        {
                            throw new TplException("δҵģģ壬ģ·Ϊա");
                        }
                        else
                        {
                            if (!File.Exists(GetPath(src.Split('?')[0])))
                            {
                                throw new TplException("δҵ" + src + "ģ塣");
                            }
                            template = template.Replace(tag.OuterText, DataHelper.GetControlFile(src));
                        }
                    }
                    else
                    {
                        if (!File.Exists(GetPath(src.Split('?')[0])))
                        {
                            throw new TplException("δҵ" + src + "ģ塣");
                        }
                        template = template.Replace(tag.OuterText, DataHelper.GetDynamicFile(src));
                    }
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.channelFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.channelFlg);
                foreach (RegTag tag in tags)
                {
                    string channelid = RegTemplet.GetAttribute(tag.Attributes, TplLabel.channelidProperty);
                    string selectid = RegTemplet.GetAttribute(tag.Attributes, TplLabel.selectidProperty);
                    if (!PlugNT.Common.Utils.IsNumeric(channelid))
                    {
                        channelid = "0";
                    }
                    if (!PlugNT.Common.Utils.IsNumeric(selectid))
                    {
                        selectid = "0";
                    }
                    DataTable listdt = DataHelper.GetChannelList(int.Parse(channelid));
                    int dtCount = listdt.Rows.Count;
                    if (dtCount > 0)
                    {
                        StringBuilder sb = new StringBuilder();
                        List<RegTag> itags = RegTemplet.GetPublicRegTagsDistinct(tag.InnerText, TplLabel.itemFlg);
                        List<RegTag> rctags = RegTemplet.GetPublicRegTagsDistinct(tag.InnerText, TplLabel.rowcountFlg);
                        List<RegTag> setags = RegTemplet.GetRegTagsDistinct(tag.InnerText, TplLabel.selectedFlg);
                        int rctagFlag = 1;
                        foreach (DataRow dr in listdt.Rows)
                        {
                            string tagInnerText = tag.InnerText;
                            foreach (RegTag rctag in rctags)
                            {
                                tagInnerText = tagInnerText.Replace(rctag.OuterText, rctagFlag.ToString());
                            }
                            foreach (RegTag setag in setags)
                            {
                                if (dr["id"].ToString() == selectid)
                                {
                                    string cssClass = RegTemplet.GetAttribute(setag.Attributes, TplLabel.classProperty);
                                    tagInnerText = tagInnerText.Replace(setag.OuterText, " class=\""+cssClass+"\" ");
                                }
                                else
                                {
                                    tagInnerText = tagInnerText.Replace(setag.OuterText, "");
                                }
                            }
                            foreach (RegTag itag in itags)
                            {
                                string name = RegTemplet.GetAttribute(itag.Attributes, TplLabel.nameProperty);
                                if (name == "")
                                {
                                    throw new TplException("бδֶ");
                                }
                                string expression = RegTemplet.GetAttribute(itag.Attributes, TplLabel.expressionProperty);
                                if (expression != "")
                                {
                                    tagInnerText = tagInnerText.Replace(itag.OuterText, GetConditionValue(expression, dr[name].ToString()));
                                }
                                else
                                {
                                    tagInnerText = tagInnerText.Replace(itag.OuterText, dr[name].ToString());
                                }
                            }
                            List<RegTag> iftags = RegTemplet.GetRegTagsDistinct(tagInnerText, TplLabel.itemifFlg);
                            foreach (RegTag iftag in iftags)
                            {
                                string strTest = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.testProperty);
                                string strOperate = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.operateProperty);
                                string strValue = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.valueProperty);
                                if (strOperate == "")
                                {
                                    throw new TplException("δã");
                                }
                                string val = GetConditionValue(strTest, strOperate, strValue);
                                if (val != "true" && val != "false")
                                {
                                    throw new TplException(val);
                                }
                                if (iftag.InnerText.Contains(TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg))
                                {
                                    string[] arr = PlugNT.Common.Utils.SplitString(iftag.InnerText, TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg);
                                    val = (val == "true") ? arr[0] : arr[1];
                                }
                                else
                                {
                                    val = (val == "true") ? iftag.InnerText : "";
                                }
                                if (val != "")
                                {
                                    StringBuilder isb = new StringBuilder();
                                    List<RegTag> chtags = RegTemplet.GetRegTagsDistinct(val, TplLabel.childFlg);
                                    foreach (RegTag chtag in chtags)
                                    {
                                        List<RegTag> ichtags = RegTemplet.GetPublicRegTagsDistinct(chtag.InnerText, TplLabel.childitemFlg);
                                        string ichannelid = RegTemplet.GetAttribute(chtag.Attributes, TplLabel.channelidProperty);
                                        if (!PlugNT.Common.Utils.IsNumeric(ichannelid))
                                        {
                                            throw new TplException("Ŀڲǩchannelidδã");
                                        }
                                        DataTable ilistdt = DataHelper.GetChannelList(int.Parse(ichannelid));
                                        if (ilistdt.Rows.Count > 0)
                                        {
                                            foreach (DataRow idr in ilistdt.Rows)
                                            {
                                                string itagInnerText = chtag.InnerText;
                                                foreach (RegTag ichtag in ichtags)
                                                {
                                                    string iname = RegTemplet.GetAttribute(ichtag.Attributes, TplLabel.nameProperty);
                                                    if (iname == "")
                                                    {
                                                        throw new TplException("бδֶ");
                                                    }
                                                    string expression = RegTemplet.GetAttribute(ichtag.Attributes, TplLabel.expressionProperty);
                                                    if (expression != "")
                                                    {
                                                        itagInnerText = itagInnerText.Replace(ichtag.OuterText, GetConditionValue(expression, idr[iname].ToString()));
                                                    }
                                                    else
                                                    {
                                                        itagInnerText = itagInnerText.Replace(ichtag.OuterText, idr[iname].ToString());
                                                    }
                                                }
                                                isb.Append(itagInnerText);
                                            }
                                        }
                                        val = isb.ToString() != "" ? val.Replace(chtag.OuterText, isb.ToString()) : val;
                                    }
                                }
                                tagInnerText = tagInnerText.Replace(iftag.OuterText, val);
                            }
                            sb.Append(tagInnerText);
                            rctagFlag++;
                        }
                        template = template.Replace(tag.OuterText, sb.ToString());
                    }
                    else
                    {
                        template = template.Replace(tag.OuterText, "");
                    }
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.looplistFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.looplistFlg);
                foreach (RegTag tag in tags)
                {
                    string channelid = RegTemplet.GetAttribute(tag.Attributes, TplLabel.channelidProperty);
                    string count = RegTemplet.GetAttribute(tag.Attributes, TplLabel.countProperty);
                    string exact = RegTemplet.GetAttribute(tag.Attributes, TplLabel.exactProperty);
                    string selected = RegTemplet.GetAttribute(tag.Attributes, TplLabel.selectedProperty);
                    string orders = RegTemplet.GetAttribute(tag.Attributes, TplLabel.ordersProperty);
                    string sort = RegTemplet.GetAttribute(tag.Attributes, TplLabel.sortProperty);
                    sort = GetSortString(sort);
                    channelid = (channelid == "") ? this.ChannelId.ToString() : channelid;
                    count = (count == "") ? "0" : count;
                    if (!PlugNT.Common.Utils.IsNumeric(channelid))
                    {
                        throw new TplException("looplistǩchannelidֻ֣");
                    }
                    if (!PlugNT.Common.Utils.IsNumeric(count))
                    {
                        throw new TplException("looplistǩcountֻ֣0");
                    }
                    int tmpChannelId = int.Parse(channelid);
                    int tmpOrders=(orders=="")?-1:int.Parse(orders);
                    bool isexact = (exact.ToLower() == "true") ? true : false;
                    DataTable listdt = DataHelper.GetArticleList(Channel.GetSysModelId(tmpChannelId), tmpChannelId, int.Parse(count),tmpOrders, selected, sort, isexact);
                    
                    int dtCount = listdt.Rows.Count;
                    if (dtCount > 0)
                    {
                        StringBuilder sb = new StringBuilder();
                        List<RegTag> itags = RegTemplet.GetPublicRegTagsDistinct(tag.InnerText, TplLabel.itemFlg);
                        List<RegTag> rctags = RegTemplet.GetPublicRegTagsDistinct(tag.InnerText, TplLabel.rowcountFlg);
                        int rctagFlag = 1;
                        foreach (DataRow dr in listdt.Rows)
                        {
                            string tagInnerText = tag.InnerText;
                            foreach (RegTag rctag in rctags)
                            {
                                tagInnerText = tagInnerText.Replace( rctag.OuterText, rctagFlag.ToString());
                            }
                            foreach (RegTag itag in itags)
                            {
                                string name = RegTemplet.GetAttribute(itag.Attributes, TplLabel.nameProperty);
                                if (name == "")
                                {
                                    throw new TplException("бδֶ");
                                }
                                string expression = RegTemplet.GetAttribute(itag.Attributes, TplLabel.expressionProperty);
                                if (expression != "")
                                {
                                    tagInnerText = tagInnerText.Replace(itag.OuterText, GetConditionValue(expression, dr[name].ToString()));
                                }
                                else
                                {
                                    tagInnerText = tagInnerText.Replace(itag.OuterText, dr[name].ToString());
                                }
                            }
                            List<RegTag> iftags = RegTemplet.GetRegTagsDistinct(tagInnerText, TplLabel.itemifFlg);
                            foreach (RegTag iftag in iftags)
                            {
                                string strTest = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.testProperty);
                                string strOperate = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.operateProperty);
                                string strValue = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.valueProperty);
                                if (strOperate == "")
                                {
                                    throw new TplException("δã");
                                }
                                string val = GetConditionValue(strTest, strOperate, strValue);
                                if (val != "true" && val != "false")
                                {
                                    throw new TplException(val);
                                }
                                if (iftag.InnerText.Contains(TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg))
                                {
                                    string[] arr = PlugNT.Common.Utils.SplitString(iftag.InnerText, TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg);
                                    val = (val == "true") ? arr[0] : arr[1];
                                }
                                else
                                {
                                    val = (val == "true") ? iftag.InnerText : "";
                                }
                                tagInnerText = tagInnerText.Replace(iftag.OuterText, val);
                            }
                            
                            sb.Append(tagInnerText);
                            rctagFlag++;
                        }
                        template = template.Replace( tag.OuterText, sb.ToString());
                    }
                    else
                    {
                        template = template.Replace( tag.OuterText, "");
                    }
                }
            }
            if (template.Contains(TplLabel.startFlg + TplLabel.datalistFlg))
            {
                tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.datalistFlg);
                foreach (RegTag tag in tags)
                {
                    DataTable listdt = null;
                    string sqlkey = RegTemplet.GetAttribute(tag.Attributes, TplLabel.sqlkeyProperty);
                    if (sqlkey == "")
                    {
                        throw new TplException("datalistǩsqlkeyδã");
                    }
                    string args = RegTemplet.GetAttribute(tag.Attributes, TplLabel.argsProperty);
                    if (args != "")
                    {
                        string[] tmpArgs = args.Split(',');
                        listdt = DataHelper.GetDadaList(sqlkey, tmpArgs);
                    }
                    else
                    {
                        listdt = DataHelper.GetDadaList(sqlkey);
                    }
                    int dtCount = listdt.Rows.Count;
                    if (dtCount > 0)
                    {
                        StringBuilder sb = new StringBuilder();
                        List<RegTag> itags = RegTemplet.GetPublicRegTagsDistinct(tag.InnerText, TplLabel.itemFlg);
                        List<RegTag> rctags = RegTemplet.GetPublicRegTagsDistinct(tag.InnerText, TplLabel.rowcountFlg);
                        
                        int rctagFlag = 1;
                        foreach (DataRow dr in listdt.Rows)
                        {
                            string tagInnerText = tag.InnerText;
                            foreach (RegTag rctag in rctags)
                            {
                                tagInnerText = tagInnerText.Replace(rctag.OuterText, rctagFlag.ToString());
                            }
                            foreach (RegTag itag in itags)
                            {
                                string name = RegTemplet.GetAttribute(itag.Attributes, TplLabel.nameProperty);
                                if (name == "")
                                {
                                    throw new TplException("бδֶ");
                                }
                                string expression = RegTemplet.GetAttribute(itag.Attributes, TplLabel.expressionProperty);
                                if (expression != "")
                                {
                                    tagInnerText = tagInnerText.Replace(itag.OuterText, GetConditionValue(expression, dr[name].ToString()));
                                }
                                else
                                {
                                    tagInnerText = tagInnerText.Replace(itag.OuterText, dr[name].ToString());
                                }
                            }
                            List<RegTag> iftags = RegTemplet.GetRegTagsDistinct(tagInnerText, TplLabel.itemifFlg);
                            foreach (RegTag iftag in iftags)
                            {
                                string strTest = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.testProperty);
                                string strOperate = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.operateProperty);
                                string strValue = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.valueProperty);
                                if (strOperate == "")
                                {
                                    throw new TplException("δã");
                                }
                                string val = GetConditionValue(strTest, strOperate, strValue);
                                if (val != "true" && val != "false")
                                {
                                    throw new TplException(val);
                                }
                                if (iftag.InnerText.Contains(TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg))
                                {
                                    string[] arr = PlugNT.Common.Utils.SplitString(iftag.InnerText, TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg);
                                    val = (val == "true") ? arr[0] : arr[1];
                                }
                                else
                                {
                                    val = (val == "true") ? iftag.InnerText : "";
                                }
                                tagInnerText = tagInnerText.Replace(iftag.OuterText, val);
                            }
                            sb.Append(tagInnerText);
                            rctagFlag++;
                        }
                        template = template.Replace(tag.OuterText, sb.ToString());
                    }
                    else
                    {
                        template = template.Replace(tag.OuterText, "");
                    }
                }
            }
            ////滻
                
            return template;
        }
        /// <summary>
        /// 滻ҳģַ
        /// </summary>
        /// <param name="template"></param>
        /// <returns></returns>
        private string ReplaceShowTemplet(string template)
        {
            List<RegTag> tags = null;
            if (template.Contains(TplLabel.pubStartFlg + TplLabel.fieldFlg))
            {
                
                DataRow dr = IdValue > 0 ? DataHelper.GetArticleRow(Channel.GetSysModelId(this.ChannelId), IdValue) : null;
                tags = RegTemplet.GetPublicRegTagsDistinct(template, TplLabel.fieldFlg);
                if (dr != null)
                {
                    foreach (RegTag tag in tags)
                    {
                        string name = RegTemplet.GetAttribute(tag.Attributes, TplLabel.nameProperty);
                        if (name == "")
                        {
                            throw new TplException("δֶ");
                        }
                        if (!dr.Table.Columns.Contains(name))
                        {
                            throw new TplException("ݿв" + name + "ֶΡ");
                        }
                        string expression = RegTemplet.GetAttribute(tag.Attributes, TplLabel.expressionProperty);
                        if (expression == "")
                        {
                            template = template.Replace(tag.OuterText, dr[name].ToString());
                        }
                        else
                        {
                            string svalue = GetConditionValue(expression, dr[name].ToString());
                            template = template.Replace( tag.OuterText, svalue);
                        }
                    }
                }
                else
                {
                    foreach (RegTag tag in tags)
                    {
                        template = template.Replace( tag.OuterText, "");
                    }
                }
            }
            return template;
        }
        /// <summary>
        /// õ滻бҳģб
        /// </summary>
        /// <param name="template">ԭģ</param>
        /// <returns>List->string</returns>
        private List<string> GetReplaceListTemplets(string template)
        {
            List<string> templetes = new List<string>();
            if (template.Contains(TplLabel.startFlg + TplLabel.pagelistFlg))
            {
                List<RegTag> tags = RegTemplet.GetRegTagsDistinct(template, TplLabel.pagelistFlg);
                int tCount = tags.Count;
                if (tCount != 1)
                {
                    throw new TplException("ģδҵ" + TplLabel.pagelistFlg + "ıǩǩ1");
                }
                RegTag pagelistTag = tags[0];
                string pagesize = RegTemplet.GetAttribute(pagelistTag.Attributes, TplLabel.pagesizeProperty);
                string exact = RegTemplet.GetAttribute(pagelistTag.Attributes, TplLabel.exactProperty);
                string count = RegTemplet.GetAttribute(pagelistTag.Attributes, TplLabel.countProperty);
                string selected = RegTemplet.GetAttribute(pagelistTag.Attributes, TplLabel.selectedProperty);
                string orders = RegTemplet.GetAttribute(pagelistTag.Attributes, TplLabel.ordersProperty);
                string sort = RegTemplet.GetAttribute(pagelistTag.Attributes, TplLabel.sortProperty);
                sort = GetSortString(sort);
                
                pagesize = (pagesize == "") ? "0" : pagesize;
                count = (count == "") ? "0" : count;
                if (!PlugNT.Common.Utils.IsNumeric(pagesize))
                {
                    throw new TplException("pagelistǩpagesizeֻ֣");
                }
                if (!PlugNT.Common.Utils.IsNumeric(count))
                {
                    throw new TplException("pagelistǩcountֻ֣");
                }
                int tpagesize = int.Parse(pagesize); 
                int tcount = int.Parse(count);
                int tmpOrders = (orders == "") ? -1 : int.Parse(orders);
                bool isexact = (exact.ToLower() == "true") ? true : false;
                DataTable dt = DataHelper.GetArticleList(Channel.GetSysModelId(this.ChannelId), this.ChannelId, tcount, tmpOrders,selected, sort, isexact);
                int recordCount = dt.Rows.Count;          
                 
                int pageCount = 1;
                List<RegTag> itags = RegTemplet.GetPublicRegTagsDistinct(pagelistTag.InnerText, TplLabel.itemFlg);
                List<RegTag> rctags = RegTemplet.GetRegTagsDistinct(pagelistTag.InnerText, TplLabel.rowcountFlg);
                List<RegTag> ptags = RegTemplet.GetRegTagsDistinct(template, TplLabel.paginationFlg);
                if (recordCount == 0)
                {
                    template = template.Replace( pagelistTag.OuterText, "");
                    foreach (RegTag tag in ptags)
                    {
                        template = template.Replace( tag.OuterText, "");
                    }
                    templetes.Add(template);
                    return templetes;
                }
                StringBuilder sb = new StringBuilder();     
                for (int i = 0; i < recordCount; i++)
                {
                    DataRow dr = dt.Rows[i];
                    string tagInnerText = pagelistTag.InnerText;
                    foreach (RegTag rctag in rctags)
                    {
                        tagInnerText = tagInnerText.Replace(rctag.OuterText, (i + 1).ToString());
                    }
                    foreach (RegTag itag in itags)
                    {
                        string name = RegTemplet.GetAttribute(itag.Attributes, TplLabel.nameProperty);
                        if (name == "")
                        {
                            throw new TplException("бδֶ");
                        }
                        string expression = RegTemplet.GetAttribute(itag.Attributes, TplLabel.expressionProperty);
                        if (expression != "")
                        {
                            tagInnerText = tagInnerText.Replace(itag.OuterText, GetConditionValue(expression, dr[name].ToString()));
                        }
                        else
                        {
                            tagInnerText = tagInnerText.Replace(itag.OuterText, dr[name].ToString());
                        }
                    }
                    List<RegTag> iftags = RegTemplet.GetRegTagsDistinct(tagInnerText, TplLabel.itemifFlg);
                    foreach (RegTag iftag in iftags)
                    {
                        string strTest = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.testProperty);
                        string strOperate = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.operateProperty);
                        string strValue = RegTemplet.GetAttribute(iftag.Attributes, TplLabel.valueProperty);
                        if (strOperate == "")
                        {
                            throw new TplException("δã");
                        }
                        string val = GetConditionValue(strTest, strOperate, strValue);
                        if (val != "true" && val != "false")
                        {
                            throw new TplException(val);
                        }
                        if (iftag.InnerText.Contains(TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg))
                        {
                            string[] arr = PlugNT.Common.Utils.SplitString(iftag.InnerText, TplLabel.startFlg + TplLabel.itemelseFlg + TplLabel.endFlg);
                            val = (val == "true") ? arr[0] : arr[1];
                        }
                        else
                        {
                            val = (val == "true") ? iftag.InnerText : "";
                        }
                        tagInnerText = tagInnerText.Replace(iftag.OuterText, val);
                    }
                    sb.Append(tagInnerText);
                    if ((i + 1) % tpagesize == 0)
                    {
                        string currTemplet = template;
                        string pag = "";
                        foreach (RegTag tag in ptags)
                        {
                            string pagTypeName = RegTemplet.GetAttribute(tag.Attributes, TplLabel.typeProperty);
                            if (pagTypeName != "")
                            {
                                switch (pagTypeName)
                                {
                                    case TplLabel.paginationSimpleType:
                                        pag = Pagination(recordCount, tpagesize, pageCount, this.FileName, false);
                                        break;
                                    case TplLabel.paginationComplexType:
                                        pag = Pagination(recordCount, tpagesize, pageCount, this.FileName, true);
                                        break;
                                    default:
                                        pag = Pagination(recordCount, tpagesize, pageCount, this.FileName, true);
                                        break;
                                }
                            }
                            else
                            {
                                pag = Pagination(recordCount, tpagesize, pageCount, this.FileName, true);
                            }
                            currTemplet = currTemplet.Replace( tag.OuterText, pag);
                        }
                        templetes.Add(currTemplet.Replace(pagelistTag.OuterText, sb.ToString()));
                        sb.Remove(0, sb.Length);
                        pageCount++;
                    }
                    else
                    {
                        if (i == recordCount - 1)
                        {
                            string currTemplet = template;
                            string pag = Pagination(recordCount, tpagesize, pageCount, this.FileName, true);
                            foreach (RegTag tag in ptags)
                            {
                                currTemplet = currTemplet.Replace( tag.OuterText, pag);
                            }
                            templetes.Add(currTemplet.Replace( pagelistTag.OuterText, sb.ToString()));
                        }
                    }
                }
            }
            return templetes;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="expression"></param>
        /// <param name="tmpValue"></param>
        /// <returns></returns>
        private string GetConditionValue(string expression, string tmpValue)
        {
            string[] conparr = expression.Split(',');
            string reValue = tmpValue;
            int sflag =0;
            int eflag=0; 
            switch (conparr[0])
            {
                case "cut":
                    sflag = int.Parse(conparr[1]);
                    eflag = int.Parse(conparr[2]);
                    if (tmpValue.Length > eflag)
                    {
                        reValue = tmpValue.Substring(sflag, eflag) + conparr[3];
                    }
                    break;
                case "len":
                    sflag = int.Parse(conparr[1]);
                    int len = PlugNT.Common.Utils.GetStringLength(tmpValue);
                    if (len > sflag)
                    {
                        reValue = PlugNT.Common.Utils.CutLenString(tmpValue, sflag) + conparr[2];
                    }
                    break;
                case "replace":
                    reValue = tmpValue.Replace(conparr[1], conparr[2]);
                    break;
                case "format":
                    reValue = DateTime.Parse(tmpValue).ToString(conparr[1]);
                    break;
                case "thumbnail":
                    if (tmpValue == "")
                    {
                        reValue = conparr[1];
                    }
                    else
                    {
                        sflag = tmpValue.LastIndexOf('.');
                        if (sflag <= 0)
                        {
                            reValue = conparr[1];
                        }
                        else
                        {
                            reValue = tmpValue.Insert(sflag, "_small");
                        }
                    }
                    break;
                case "empty":
                    reValue = (tmpValue == "" ? conparr[1] : tmpValue);
                    break;
            }
            return reValue.Replace("this", tmpValue);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="strTest"></param>
        /// <param name="strOperate"></param>
        /// <param name="strValue"></param>
        /// <returns></returns>
        private string GetConditionValue(string strTest, string strOperate, string strValue)
        {
            string strTmpValue = "false";
            switch (strOperate.ToLower())
            {
                case "equals": 
                    if (strTest == strValue)
                    {
                        strTmpValue = "true";
                    }
                    break;
                case "notequals":
                    if (strTest != strValue)
                    {
                        strTmpValue = "true";
                    }
                    break;
                case "in":
                    strValue = "," + strValue + ",";
                    if (strValue.Contains("," + strTest + ","))
                    {
                        strTmpValue = "true";
                    }
                    break;
                case "notin":
                    strValue = "," + strValue + ",";
                    if (!strValue.Contains("," + strTest + ","))
                    {
                        strTmpValue = "true";
                    }
                    break;
                case "greatthan": 
                    if (PlugNT.Common.Utils.IsNumeric(strTest) == false || PlugNT.Common.Utils.IsNumeric(strValue) == false)
                    {
                        strTmpValue = "ֵͻֵ!";
                    }
                    else
                    {
                        if (int.Parse(strTest) > int.Parse(strValue))
                        {
                            strTmpValue = "true";
                        }
                    }
                    break;
                case "lessthan": 
                    if (PlugNT.Common.Utils.IsNumeric(strTest) == false || PlugNT.Common.Utils.IsNumeric(strValue) == false)
                    {
                        strTmpValue = "ֵͻֵ!";
                    }
                    else
                    {
                        if (int.Parse(strTest) < int.Parse(strValue))
                        {
                            strTmpValue = "true";
                        }
                    }
                    break;
                default:
                    strTmpValue = "δ֪";
                    break;
            }
            return strTmpValue;
        }
        /// <summary>
        /// õַδȥΣַ-ɲοFieldеExists
        /// </summary>
        /// <param name="sortString"></param>
        /// <returns></returns>
        private static string GetSortString(string sortString)
        {
            if (sortString != "")
            {
                string[] strArr = sortString.Split(',');
                StringBuilder sortsb = new StringBuilder();
                foreach (string s in strArr)
                {
                    string innerstr = s.Trim();
                    if (innerstr != "")
                    {
                        string[] istrArr = innerstr.Split(' ');
                        int istrArrLength = istrArr.Length;
                        if (istrArrLength == 1)
                        {
                            sortsb.Append(istrArr[0] + " asc,");
                        }
                        else
                        {
                            if (istrArr[istrArrLength - 1] == "asc")
                            {
                                sortsb.Append(istrArr[0] + " asc,");
                            }
                            else if (istrArr[istrArrLength - 1] == "desc")
                            {
                                sortsb.Append(istrArr[0] + " desc,");
                            }
                            else
                            {
                                throw new TplException("ؼִSQLʹ" + istrArr[istrArrLength - 1] + "Ĺؼ֡");
                            }
                        }
                    }
                }
                return sortsb.ToString().Trim(',');
            }
            else
            {
                return sortString;
            }
        }
        /// <summary>
        /// ҳ
        /// </summary>
        /// <param name="recordcount">ܼ¼</param>
        /// <param name="pagesize">ÿҳ¼</param>
        /// <param name="currentpage">ǰҳ</param>
        /// <param name="prefix">ǰ׺</param>
        /// <param name="showcount">Ƿʾ</param>
        /// <returns></returns>
        private static string Pagination(int recordcount, int pagesize, int currentpage, string prefix, bool showcount)
        {
            int allcurrentpage = 0;
            int next = 0;
            int pre = 0;
            int startcount = 0;
            int endcount = 0;
            StringBuilder currentpagestr = new StringBuilder();
            if (currentpage < 1) { currentpage = 1; }
            if (pagesize != 0)
            {
                allcurrentpage = (recordcount / pagesize);
                allcurrentpage = ((recordcount % pagesize) != 0 ? allcurrentpage + 1 : allcurrentpage);
                allcurrentpage = (allcurrentpage == 0 ? 1 : allcurrentpage);
            }
            next = currentpage + 1;
            pre = currentpage - 1;
            startcount = (currentpage + 5) > allcurrentpage ? allcurrentpage - 9 : currentpage - 4;
            endcount = currentpage < 5 ? 10 : currentpage + 5;
            if (startcount < 1) { startcount = 1; } 
            if (allcurrentpage < endcount) { endcount = allcurrentpage; }
            if (showcount)
            {
                currentpagestr.Append("<span class='pcount'>" + allcurrentpage + "ҳ&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>");
            }
            if (currentpage > 1)
            {
                string prefixpre = (pre == 1) ? prefix : prefix + "-" + pre;
                currentpagestr.Append("<a href=\"" + prefix + ".html\">ҳ</a>&nbsp;&nbsp;<a href=\"" +
                    prefixpre + ".html\">һҳ</a>");
            }
            else
            {
                currentpagestr.Append("ҳһҳ");
            }
            for (int i = startcount; i <= endcount; i++)
            {
                if (currentpage == i)
                {
                    currentpagestr.Append("&nbsp;&nbsp;<font color=\"#ff0000\">" + i + "</font>");
                }
                else
                {
                    string prefixpre = (i == 1) ? prefix : prefix + "-" + i;
                    currentpagestr.Append("&nbsp;&nbsp;<a href=\"" + prefixpre + ".html\">" + i + "</a>");
                }
            }
            if (currentpage != allcurrentpage)
            {
                currentpagestr.Append("&nbsp;&nbsp;<a href=\"" +
                    prefix + "-" + next.ToString() + ".html\">һҳ</a>&nbsp;&nbsp;<a href=\"" +
                    prefix + "-" + allcurrentpage + ".html\">ĩҳ</a>");
            }
            else
            {
                currentpagestr.Append("һҳĩҳ");
            }
            return currentpagestr.ToString();
        }
    }
    /// <summary>
    /// htmlģǩ
    /// </summary>
    public class TplLabel
    {
        public const string startFlg = "{";
        public const string endFlg = "}";
        public const string pubStartFlg = "[";
        public const string pubEndFlg = "]";
        public const string looplistFlg = "tmp:looplist";
        public const string datalistFlg = "tmp:datalist";
        public const string pagelistFlg = "tmp:pagelist";
        public const string paginationFlg = "tmp:pagination";
        public const string itemFlg = "tmp:item";
        public const string currentFlg = "tmp:current";
        public const string fieldFlg = "tmp:field";
        public const string channelfieldFlg = "tmp:channelfield";
        public const string fileFlg = "tmp:file";
        public const string execFlg = "tmp:exec";
        public const string navigationFlg = "tmp:navigation";
        public const string friendlinkFlg = "tmp:friendlink";
        public const string copyrightFlg = "tmp:copyright";
        public const string siteconfigFlg = "tmp:siteconfig";
        public const string rowcountFlg = "tmp:rowcount";
        public const string templetdirFlg = "tmp:templetdir";
        public const string labelFlg = "tmp:label";
        public const string channelFlg = "tmp:channel";
        public const string selectedFlg = "tmp:selected";
        public const string childFlg = "tmp:child";
        public const string childitemFlg = "tmp:childitem";
        public const string baseifFlg = "tmp:baseif";
        public const string baseelseFlg = "tmp:baseelse";
        public const string itemifFlg = "tmp:itemif";
        public const string itemelseFlg = "tmp:itemelse";
        public const string pagesizeProperty = "pagesize";
        public const string countProperty = "count";
        public const string argsProperty = "args";
        public const string nameProperty = "name";
        public const string exactProperty = "exact";
        public const string includeProperty = "include";
        public const string dynamicProperty = "dynamic";
        public const string controlProperty = "control";
        public const string typeProperty = "type";
        public const string channelidProperty = "channelid";
        public const string selectidProperty = "selectid";
        public const string classProperty = "class";
        public const string selectedProperty = "selected";
        public const string ordersProperty = "orders";
        public const string lencountProperty = "lencount";
        public const string targetProperty = "target";
        public const string sortProperty = "sort";
        public const string sqlkeyProperty = "sqlkey";
        public const string strkeyProperty = "strkey";
        public const string classidProperty = "classid";
        public const string spliterProperty = "spliter";
        public const string expressionProperty = "expression";
        public const string testProperty = "test";
        public const string operateProperty = "operate";
        public const string valueProperty = "value";
        public const string paginationSimpleType = "simple";
        public const string paginationComplexType = "complex";
        public const string powerCode = "$powercode$";
    }
    /// <summary>
    /// 쳣
    /// </summary>
    public class TplException : Exception
    {
        private const string msg = "ɴ";
        public TplException(string str) : base(msg + str.Replace("\\", "/")) { }
    }
}

