/**********************************************************************************
 * ˵     ݷ(ҵĲ)
 * ڣ     2009.6.13
 * ޸ڣ     2011.08.09
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.IO;
using System.Web;
using PlugNT.Safe;
using PlugNT.Common;
using PlugNT.Cms.Custom;
using PlugNT.Cms.BLL;
namespace PlugNT.Cms.Utility
{
    public class DataHelper
    {
        /// <summary>
        /// õļ
        /// </summary>
        /// <param name="filepath">ļ·</param>
        /// <returns></returns>
        public static string GetFile(string filepath)
        {
            string tmpFilePath = System.Web.HttpContext.Current.Server.MapPath(filepath);
            if (File.Exists(tmpFilePath))
            {
                string tmpContent = Utils.ReadFile(tmpFilePath);
                return tmpContent;
            }
            else
            {
                return filepath + "ļڣ";
            }
        }
        /// <summary>
        /// õļ(ʽܼ򵥴)
        /// </summary>
        /// <param name="filepath">ļ·</param>
        /// <param name="argValues">滻</param>
        /// <returns></returns>
        public static string GetCacheFile(string filepath, params string[] argValues)
        {
            object obj = DataCache.GetCache(filepath);
            if (obj == null)
            {
                string tmpFilePath = System.Web.HttpContext.Current.Server.MapPath(filepath);
                if (!File.Exists(tmpFilePath))
                {
                    return filepath + "ļڣ";
                }
                obj = Utils.ReadFile(tmpFilePath);
                DataCache.SetCache(filepath, obj);
            }
            if (argValues.Length == 0)
            {
                return obj.ToString();
            }
            else
            {
                return string.Format(obj.ToString(), argValues);
            }
        }
        /// <summary>
        /// ض̬ҳ(·)
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static string GetDynamicFile(string path)
        {
            System.IO.StringWriter tw = new System.IO.StringWriter();
            System.Web.HttpContext.Current.Server.Execute(path, tw);
            return tw.ToString();
        }
        /// <summary>
        /// ض̬ؼ(·)
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public static string GetControlFile(string path)
        {
            System.Web.UI.UserControl _ucl = new System.Web.UI.UserControl();
            System.IO.TextWriter writer = new System.IO.StringWriter();
            _ucl.RenderControl(new System.Web.UI.HtmlTextWriter(writer));
            return writer.ToString(); 
        }
        /// <summary>
        /// ûǷ½
        /// </summary>
        /// <returns></returns>
        public static bool IsUserLogined()
        {
            string username = Key_Flags.SessionUser;
            return System.Web.HttpContext.Current.Session[username] != null;
        }
        /// <summary>
        /// õû
        /// </summary>
        /// <returns></returns>
        public static string GetOnlineUserName()
        {
            string username = Key_Flags.SessionUser;
            object obj = System.Web.HttpContext.Current.Session[username];
            return obj != null ? obj.ToString() : "";
        }
        /// <summary>
        /// ȡRequest
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetRequest(string key)
        {
            if (HttpContext.Current.Request[key] == null)
                return "";
            return HttpContext.Current.Request[key];
        }
        /// <summary>
        /// ָUrlֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <returns>Urlֵ</returns>
        public static string GetQueryString(string strName)
        {
            return GetQueryString(strName, false);
        }
        /// <summary>
        /// ָUrlֵ
        /// </summary> 
        /// <param name="strName">Url</param>
        /// <param name="sqlSafeCheck">ǷSQLȫ</param>
        /// <returns>Urlֵ</returns>
        public static string GetQueryString(string strName, bool sqlSafeCheck)
        {
            if (HttpContext.Current.Request.QueryString[strName] == null)
                return "";
            if (sqlSafeCheck && !Utils.IsSafeSqlString(HttpContext.Current.Request.QueryString[strName]))
                return "unsafe string";
            return HttpContext.Current.Request.QueryString[strName];
        }
        /// <summary>
        /// ֵָ
        /// </summary>
        /// <param name="strName"></param>
        /// <returns>ֵ</returns>
        public static string GetFormString(string strName)
        {
            return GetFormString(strName, false);
        }
        /// <summary>
        /// ֵָ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="sqlSafeCheck">ǷSQLȫ</param>
        /// <returns>ֵ</returns>
        public static string GetFormString(string strName, bool sqlSafeCheck)
        {
            if (HttpContext.Current.Request.Form[strName] == null)
                return "";
            if (sqlSafeCheck && !Utils.IsSafeSqlString(HttpContext.Current.Request.Form[strName]))
                return "unsafe string";
            return HttpContext.Current.Request.Form[strName];
        }
        /// <summary>
        /// ָUrlintֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <returns>Urlintֵ</returns>
        public static int GetQueryInt(string strName)
        {
            return Utils.StrToInt(HttpContext.Current.Request.QueryString[strName], 0);
        }
        /// <summary>
        /// ָUrlintֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>Urlintֵ</returns>
        public static int GetQueryInt(string strName, int defValue)
        {
            return Utils.StrToInt(HttpContext.Current.Request.QueryString[strName], defValue);
        }
        /// <summary>
        /// ָintֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <returns>intֵ</returns>
        public static int GetFormInt(string strName)
        {
            return GetFormInt(strName, 0);
        }
        /// <summary>
        /// ָintֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>intֵ</returns>
        public static int GetFormInt(string strName, int defValue)
        {
            return Utils.StrToInt(HttpContext.Current.Request.Form[strName], defValue);
        }
        /// <summary>
        /// ָUrldecimalֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>Urldecimalֵ</returns>
        public static decimal GetQueryDecimal(string strName, decimal defValue)
        {
            return Utils.StrToDecimal(HttpContext.Current.Request.QueryString[strName], defValue);
        }
        /// <summary>
        /// ָdecimalֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>decimalֵ</returns>
        public static decimal GetFormDecimal(string strName, decimal defValue)
        {
            return Utils.StrToDecimal(HttpContext.Current.Request.Form[strName], defValue);
        }
        /// <summary>
        /// ָUrlfloatֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>Urlintֵ</returns>
        public static float GetQueryFloat(string strName, float defValue)
        {
            return Utils.StrToFloat(HttpContext.Current.Request.QueryString[strName], defValue);
        }
        /// <summary>
        /// ָfloatֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>floatֵ</returns>
        public static float GetFormFloat(string strName, float defValue)
        {
            return Utils.StrToFloat(HttpContext.Current.Request.Form[strName], defValue);
        }
        /// <summary>
        /// ȡͼ(·ΪջͼƬ򷵻ؿ)
        /// </summary>
        /// <param name="imgPath"></param>
        /// <returns></returns>
        public static string GetThumbnail(string imgPath)
        {
            if (string.IsNullOrEmpty(imgPath))
            {
                return "";
            }
            int sflag = imgPath.LastIndexOf('.');
            if (sflag <= 0)
            {
                return "";
            }
            return imgPath.Insert(sflag, "_small");
        }
        /// <summary>
        /// õȨ
        /// </summary>
        /// <param name="sysName"></param>
        /// <param name="assVersion"></param>
        /// <returns></returns>
        public static string CreateCopyright(string sysName, string assVersion)
        {
            string copyrightString = "<span class=\"copyright\">Powered by <strong><a href=\"http://www.plugnet.cn\" target=\"_blank\">PlugNT {0} {1}</a></strong></span>";
            return string.Format(copyrightString, sysName, assVersion);
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="classId">ҳ()</param>
        /// <param name="splitString">ַָ</param>
        /// <returns></returns>
        public static string CreateFriendLink(int classId, string splitString)
        {
            return new FriendLink().CreateLinks(classId, splitString);
        }
        /// <summary>
        /// õĿ
        /// </summary>
        /// <param name="channelId"></param>
        /// <param name="lenCount"></param>
        /// <param name="target"></param>
        /// <param name="splitString"></param>
        /// <returns></returns>
        public static string CreateNavigation(int channelId, int lenCount,string target, string splitString)
        {
            return new Channel().GetNavigation(channelId, lenCount, target, splitString);
        }
        /// <summary>
        /// ȡStrǩֵ
        /// </summary>
        /// <param name="strkey"></param>
        /// <returns></returns>
        public static string GetDadaLabelStr(string strkey)
        {
            return DataLabel.GetKeyValue(strkey);
        }
        /// <summary>
        /// ȡSqlǩֵ
        /// </summary>
        /// <param name="strkey"></param>
        /// <returns></returns>
        public static string GetDadaLabelSql(string strkey)
        {
            return DataLabel.GetSqlValue(strkey);
        }
        /// <summary>
        /// idõݱһ
        /// </summary>
        /// <param name="sysModelId">ģid</param>
        /// <param name="idvalue">id</param>
        /// <returns></returns>
        public static DataRow GetArticleRow(int sysModelId, int idvalue)
        {
            return (idvalue > 0) ? new Article().GetDataRow(sysModelId ,idvalue) : null;
        }
        /// <summary>
        /// ȡĿ
        /// </summary>
        /// <param name="channelId"></param>
        /// <returns></returns>
        public static string GetChannelTitle(int channelId)
        {
            return Channel.GetTitle(channelId);
        }
        /// <summary>
        /// ȡĿؼб
        /// </summary>
        /// <param name="channelId"></param>
        /// <returns></returns>
        public static string GetChannelKeyList(int channelId)
        {
            return Channel.GetKeyList(channelId);
        }
        /// <summary>
        /// жϹؼǷ
        /// </summary>
        /// <param name="keyList"></param>
        /// <param name="key"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool ChannelContainsKeyValue(string keyList, string key, string value)
        {
            return Channel.ContainsKeyValue(keyList, key, value);
        }
        /// <summary>
        /// ȡĿ
        /// </summary>
        /// <param name="channelId"></param>
        /// <returns></returns>
        public static DataRow GetChannelRow(int channelId)
        {
            Channel bllChannel = new Channel();
            return bllChannel.GetChannelRow(channelId);
        }
        /// <summary>
        /// ȡĿб(channelIdΪ0ʱʾȫ)
        /// </summary>
        /// <param name="channelId"></param>
        /// <returns></returns>
        public static DataTable GetChannelList(int channelId)
        {
            Channel bllChannel= new Channel();
            return bllChannel.GetSubList(channelId, false);
        }
        /// <summary>
        /// ȡĿб(lenIndexΪ-1ʱʾȫ)
        /// </summary>
        /// <param name="noList"></param>
        /// <param name="lenIndex"></param>
        /// <returns></returns>
        public static DataTable GetChannelList(string noList, int lenIndex)
        {
            Channel bllChannel = new Channel();
            return bllChannel.GetOrderList(noList, lenIndex);
        }
        /// <summary>
        /// ²б(topCountС0ʱΪȫ)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="topCount"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public static DataTable GetArticleList(int sysModelId, int topCount, string andWhere)
        {
            return new Article().GetList(sysModelId, topCount, andWhere);
        }
        /// <summary>
        /// ²б3
        /// </summary>
        /// <param name="sysModelId">ģid</param>
        /// <param name="topCount"></param>
        /// <param name="channelId"></param>
        /// <param name="orders">Ȩ</param>
        /// <param name="selected">(Ƽȵ㣬)</param>
        /// <param name="sort"></param>
        /// <param name="isexact">Ƿȷѯ</param>
        /// <returns></returns>
        public static DataTable GetArticleList(int sysModelId, int channelId, int topCount,int orders, string selected, string sort, bool isexact)
        {
            
            return new Article().GetList(sysModelId, channelId, topCount,orders, selected, sort, isexact);
        }
        /// <summary>
        /// sqlб(в)
        /// </summary>
        /// <param name="sqlkey"></param>
        /// <param name="args"></param>
        /// <returns></returns>
        public static DataTable GetDadaList(string sqlkey, params string[] args)
        {
            string sql = DataLabel.GetSqlValue(sqlkey);
            if (string.IsNullOrEmpty(sql)==false)
            {
                if (args.Length == 0)
                {
                    return ITable.GetDataTable(sql);
                }
                else
                {
                    return ITable.GetDataTable(string.Format(sql, args));
                }
            }
            else
            {
                return new DataTable();
            }
        }
        /// <summary>
        /// ݵǰб(topCountС0ʾȫ)
        /// </summary>
        /// <param name="tableName"></param> 
        /// <param name="topCount"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public static DataTable GetRecordList(string tableName, int topCount, string andWhereOrderBy)
        {
            return ITable.GetList(tableName, "*", topCount, andWhereOrderBy);
        }
        /// <summary>
        /// ݵǰб
        /// </summary>
        /// <param name="tableName"></param> 
        /// <param name="topCount"></param> 
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public static DataTable GetRecordList(string tableName, int topCount, string colNames, string andWhereOrderBy)
        {
            return ITable.GetList(tableName, colNames, topCount, andWhereOrderBy);
        }
        /// <summary>
        /// ݵǰб
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public static DataTable GetRecordList(string tableName, int pageSize, int currPageCount, string colNames, string andWhere, string orderBy, out int recordCount)
        {
            return ITable.GetList(tableName, pageSize, currPageCount,colNames,  andWhere, orderBy, out recordCount);
        }
        /// <summary>
        /// ݵǰб
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="joinAsTableName"></param>
        /// <param name="joinColNames"></param>
        /// <param name="joinOn"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public static DataTable GetRecordList(string tableName, int pageSize, int currPageCount, string colNames, string andWhere, string orderBy, string joinAsTableName, string joinColNames, string joinOn, out int recordCount)
        {
            return ITable.GetList(tableName, pageSize, currPageCount, colNames, andWhere, orderBy, joinAsTableName, joinColNames, joinOn, out recordCount);
        }
        /// <summary>
        /// SQLб
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="strSql"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public static DataTable GetRecordList(int pageSize, int currPageCount, string strSql, string orderBy, out int recordCount)
        {
            return ITable.GetList(pageSize, currPageCount, strSql, orderBy, out recordCount);
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        private static IDataReader GetRecordReader(string tableName, int topCount, string colNames, string andWhereOrderBy)
        {
            return ITable.GetReader(tableName, topCount, colNames, andWhereOrderBy);
        }
        /// <summary>
        /// õ¼
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static string[] GetRecordArray(string tableName, string colNames, string andWhereOrderBy)
        {
            return ITable.GetArray(tableName, colNames, andWhereOrderBy);
        }
        /// <summary>
        /// õеַ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="colName"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static string GetRecordString(string tableName, string colName, string andWhereOrderBy)
        {
            return ITable.GetObjectString(tableName, colName, andWhereOrderBy);
        }
        /// <summary>
        /// ݵǰ
        /// </summary>
        /// <param name="tableName"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public static int GetRecordCount(string tableName, string andWhereOrderBy)
        {
            return ITable.GetCount(tableName, andWhereOrderBy);
        }
        /// <summary>
        /// ݵǰ()
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="andWhereArr"></param>
        /// <returns></returns>
        public static int[] GetRecordCount(string tableName, string[] andWhereArr)
        {
            return ITable.GetCount(tableName, andWhereArr);
        }
    }
}

