/**********************************************************************************
 * ˵     ̨ҳ(ֲ)
 * ڣ     2010.03.13
 * ޸ڣ     2012.01.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;
using System.Data;
using System.IO;
using System.Web;
using PlugNT.Common;
using PlugNT.Cms.Custom;
using PlugNT.Cms.BLL;
using PlugNT.Cms.Model;
using PlugNT.Cms.Utility;
namespace PlugNT.Cms.Page
{
    /// <summary>
    /// ҳļ
    /// </summary>
    public class PageHelper
    {  
        /// <summary>
        /// ִ(̬ҳ)
        /// </summary>
        /// <param name="tmpDynamicPath">ģ嶯̬ҳ·</param>
        /// <param name="lastCreatePath">ϴ·(·һ򸲸Ƿɾϴ·)</param>
        /// <param name="createPath">·(Ϊ)</param>
        /// <returns></returns>
        public static bool CreateFile(string tmpDynamicPath, string lastCreatePath, string createPath)
        {
            try
            {
                createPath = System.Web.HttpContext.Current.Server.MapPath(createPath.Trim());
                if (createPath != "")
                {
                    Encoding ResEncoding = System.Web.HttpContext.Current.Response.ContentEncoding;
                    StringWriter sw = new StringWriter();
                    System.Web.HttpContext.Current.Server.Execute(tmpDynamicPath, sw);
                    string content = sw.ToString();
                    int createFlag = createPath.LastIndexOf(@"\");
                    if (createFlag > 0)
                    {
                        string dir = createPath.Substring(0, createFlag);
                        if (!Directory.Exists(dir))
                        {
                            Directory.CreateDirectory(dir);
                        }
                    }
                    using (FileStream fs = new FileStream(createPath, FileMode.Create, FileAccess.Write, FileShare.Write))
                    {
                        using (StreamWriter strWriter = new StreamWriter(fs, ResEncoding))
                        {
                            strWriter.Write(content);
                        }
                    }
                }
                lastCreatePath = lastCreatePath.Trim();
                if (lastCreatePath != "" && File.Exists(lastCreatePath))
                {
                    File.Delete(lastCreatePath);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ļ(̬ļ)
        /// </summary>
        /// <param name="html"></param>
        /// <param name="create_path"></param>
        /// <param name="file_path"></param>
        /// <returns></returns>
        public static string CreateFile(FileBuilder fbFile, int pageType)
        {
            try
            {
                if (fbFile.FilePath.Trim() == "")
                {
                    return "ļ:" + fbFile.FileCreatePath + fbFile.FileName + fbFile.FileExtName + "<br>ģ·δ󶨣";
                }
                switch (pageType)
                {
                    case Type_Page.Aspx:
                    case Type_Page.Index:
                        fbFile.CreateSingle();
                        return "";
                    case Type_Page.List:
                        fbFile.CreateList();
                        return "";
                    case Type_Page.Show:
                        fbFile.CreateShow();
                        return "";
                    default:
                        return "ļ:" + fbFile.FileCreatePath + fbFile.FileName + fbFile.FileExtName + "<br>ļʹ";
                }
            }
            catch (TplException ex)
            {
                return "ļ:" + fbFile.FileCreatePath + fbFile.FileName + fbFile.FileExtName + "<br>" + ex.Message;
            }
        }
        /// <summary>
        /// ¾̬ļ
        /// </summary>
        public static void UpdatePages()
        {
 
            Sys.Info.updated_count++;
            Sys.Info.updated_time = DateTime.Now;   
            Sys.UpdateCountAndTime();
            DataTable tplList = new Templet().GetList(-1, -1, 1);
            DataTable clList = new Channel().GetOrderList("");
            foreach (DataRow dr in tplList.Rows)
            {
                string pageType = dr["type"].ToString();
                string create_path = dr["create_path"].ToString();
                string file_path = dr["file_path"].ToString();
                string channel_id = dr["channel_id"].ToString();
                DataRow[] cdrList = clList.Select("id=" + channel_id);
                if (cdrList.Length == 0)
                {
                    continue;
                }
                DataRow cdr = cdrList[0];
                if (cdr["is_create_static"].ToString() == "1")
                {
                    if (pageType == "1")
                    {
                        FileBuilder html = new FileBuilder();
                        html.ChannelId = int.Parse(cdr["id"].ToString());
                        html.FileCreatePath = create_path;
                        html.FilePath = file_path;
                        html.IsZipFile = cdr["is_ziphtml"].ToString() == "1";
                        CreateFile(html, Type_Page.Index);
                    }
                    if (pageType == "2")
                    {
                        FileBuilder html = new FileBuilder();
                        html.ChannelId = int.Parse(cdr["id"].ToString());
                        html.FileCreatePath = create_path;
                        html.FilePath = file_path;
                        html.IsZipFile = cdr["is_ziphtml"].ToString() == "1";
                        CreateFile(html, Type_Page.List);
                    }
                }
                if (pageType == "0")
                {
                    FileBuilder html = new FileBuilder();
                    html.ChannelId = int.Parse(cdr["id"].ToString());
                    html.FileCreatePath = create_path;
                    html.FilePath = file_path;
                    html.IsZipFile = cdr["is_ziphtml"].ToString() == "1";
                    CreateFile(html, Type_Page.Aspx);
                }
            }
        }
        /// <summary>
        /// ΣHTML
        /// </summary>
        /// <param name="contents"></param>
        /// <returns></returns>
        public static string FilterHtml(string contents)
        {
            contents = System.Text.RegularExpressions.Regex.Replace(contents, @"<script[\s\S]+</script*>", "", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
            contents = System.Text.RegularExpressions.Regex.Replace(contents, @" href*=*[\s\S]*script*:", "", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
            contents = System.Text.RegularExpressions.Regex.Replace(contents, @" on[\s\S]*=", "", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
            contents = System.Text.RegularExpressions.Regex.Replace(contents, @"<iframe[\s\S]+</iframe*>", "", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
            contents = System.Text.RegularExpressions.Regex.Replace(contents, @"<frameset[\s\S]+</frameset*>", "", System.Text.RegularExpressions.RegexOptions.IgnoreCase);
            return contents;
        }
        /// <summary>
        /// ʾ
        /// </summary>
        /// <param name="context"></param>
        public static void ShowError(HttpContext context)
        {
            context.Response.Redirect("/tools/error.html");
        }
        /// <summary>
        /// ʾ
        /// </summary>
        /// <param name="context"></param>
        /// <param name="title"></param>
        public static void ShowError(HttpContext context,string title)
        {
            string tar="www.plugnet.cn";
            if (PlugNT.Cms.Custom.Http.Authorize.IsAuthorize())
            {
                tar = SiteConfig.SiteUrl;
            }
            context.Response.Redirect("/tools/error.html?msg=" + PlugNT.Common.Utils.Escape(title) + "&tar=" + tar);
        }
        /// <summary>
        /// ʾ(3󷵻url)
        /// </summary>
        /// <param name="context"></param>
        /// <param name="title"></param>
        /// <param name="backurl"></param>
        public static void ShowError(HttpContext context, string title, string backurl)
        {
            string tar = "www.plugnet.cn";
            if (PlugNT.Cms.Custom.Http.Authorize.IsAuthorize())
            {
                tar = SiteConfig.SiteUrl;
            }
            context.Response.Redirect("/tools/error.html?msg=" + PlugNT.Common.Utils.Escape(title) + "&tar=" + tar + "&url=" + PlugNT.Common.Utils.Escape(backurl));
        }
        /// <summary>
        /// ʾ(3󷵻url)
        /// </summary>
        /// <param name="context"></param>
        /// <param name="title"></param>
        /// <param name="content"></param>
        /// <param name="backurl"></param>
        public static void ShowError(HttpContext context, string title, string content, string backurl)
        {
            string tar = "www.plugnet.cn";
            if (PlugNT.Cms.Custom.Http.Authorize.IsAuthorize())
            {
                tar = SiteConfig.SiteUrl;
            }
            context.Response.Redirect("/tools/error.html?msg=" + PlugNT.Common.Utils.Escape(title) + "&tar=" + tar + "&str=" + PlugNT.Common.Utils.Escape(content) + "&url=" + PlugNT.Common.Utils.Escape(backurl));
        }
    }
}

