/**********************************************************************************
 * ˵     ģ(ݷʲ)
 * ڣ     2009.6.13
 * ޸ڣ     2011.08.09
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    public class Templet
    {
        internal static string currTableName = SiteConfig.TablePrefix + "templet";
  
        /// <summary>
        /// idȡģ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TempletInfo GetTempletInfo(int id)
        {
            TempletInfo model = new TempletInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [no], channel_id, [type], [enable], [description], file_path, file_create_path, file_name, file_ext_name, has_site_map, [order]", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    if (dr["channel_id"].ToString() != "")
                    {
                        model.channel_id = int.Parse(dr["channel_id"].ToString());
                    }
                    if (dr["type"].ToString() != "")
                    {
                        model.type = int.Parse(dr["type"].ToString());
                    }
                    if (dr["enable"].ToString() != "")
                    {
                        model.enable = dr["enable"].ToString()=="1";
                    }
                    model.description = dr["description"].ToString();
                    model.file_path = dr["file_path"].ToString();
                    model.file_create_path = dr["file_create_path"].ToString();
                    model.file_name = dr["file_name"].ToString();
                    model.file_ext_name = dr["file_ext_name"].ToString();
                    if (dr["has_site_map"].ToString() != "")
                    {
                        model.has_site_map = dr["has_site_map"].ToString()=="1";
                    }
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        public TempletInfo GetTempletInfo(string no)
        {
            TempletInfo model = new TempletInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [no], channel_id, [type], [enable], [description], file_path, file_create_path, file_name, file_ext_name, has_site_map, [order]", " and [no]=" + SqlHelper.FieldFilter(no));
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    if (dr["channel_id"].ToString() != "")
                    {
                        model.channel_id = int.Parse(dr["channel_id"].ToString());
                    }
                    if (dr["type"].ToString() != "")
                    {
                        model.type = int.Parse(dr["type"].ToString());
                    }
                    if (dr["enable"].ToString() != "")
                    {
                        model.enable = dr["enable"].ToString() == "1";
                    }
                    model.description = dr["description"].ToString();
                    model.file_path = dr["file_path"].ToString();
                    model.file_create_path = dr["file_create_path"].ToString();
                    model.file_name = dr["file_name"].ToString();
                    model.file_ext_name = dr["file_ext_name"].ToString();
                    if (dr["has_site_map"].ToString() != "")
                    {
                        model.has_site_map = dr["has_site_map"].ToString() == "1";
                    }
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(TempletInfo model)
        {
            string noString =SysManager.GetNoString(); 
            if (model.type == 3)
            {
                noString = model.type + "-" + model.channel_id;
                if (DbHelper.Exists("select top 1 [id] from " + currTableName + " where [no]='" + noString + "'"))
                {
                    return false;
                }
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([no],channel_id,[type],[enable],[description],file_path,file_create_path,file_name,file_ext_name,has_site_map,[order])");
            strSql.Append(" values (");
            strSql.Append("@no,@channel_id,@type,@enable,@description,@file_path,@file_create_path,@file_name,@file_ext_name,@has_site_map,@order)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@no",noString),
                 ParamHelper.MakeParam("@channel_id",model.channel_id),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@enable",model.enable?1:0),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@file_path",model.file_path),
                 ParamHelper.MakeParam("@file_create_path",model.file_create_path),
                 ParamHelper.MakeParam("@file_name",model.file_name),
                 ParamHelper.MakeParam("@file_ext_name",model.file_ext_name),
                 ParamHelper.MakeParam("@has_site_map",model.has_site_map?1:0),
                 ParamHelper.MakeParam("@order",model.order)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(TempletInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("channel_id=@channel_id,");
            strSql.Append("[type]=@type,");
            strSql.Append("[enable]=@enable,");
            strSql.Append("[description]=@description,");
            strSql.Append("file_path=@file_path,");
            strSql.Append("file_create_path=@file_create_path,");
            strSql.Append("file_name=@file_name,");
            strSql.Append("file_ext_name=@file_ext_name,");
            strSql.Append("has_site_map=@has_site_map,");
            strSql.Append("[order]=@order");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@channel_id",model.channel_id),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@enable",model.enable?1:0),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@file_path",model.file_path),
                 ParamHelper.MakeParam("@file_create_path",model.file_create_path),
                 ParamHelper.MakeParam("@file_name",model.file_name),
                 ParamHelper.MakeParam("@file_ext_name",model.file_ext_name),
                 ParamHelper.MakeParam("@has_site_map",model.has_site_map?1:0),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            TempletInfo tinfo = GetTempletInfo(id);
            if (tinfo != null)
            {
                StringBuilder strSql = new StringBuilder();
                strSql.Append("delete from ");
                strSql.Append(currTableName);
                strSql.Append(" where [id]=@id");
                DbParameter[] parameters = {
			        ParamHelper.MakeParam("@id",id)
		        };
                return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
            }
            else
            {
                return false;
            }
        }
        
        /// <summary>
        /// 滻ģ
        /// </summary>
        /// <param name="channelId"></param>
        /// <param name="oldString"></param>
        /// <param name="newString"></param>
        /// <returns></returns>
        public int Replace(int channelId, string oldString, string newString)
        {
            int tCount = 0;
            DataTable dt = GetList(channelId, "");
            foreach (DataRow dr in dt.Rows)
            {
                StringBuilder strSql = new StringBuilder();
                strSql.Append("update ");
                strSql.Append(currTableName);
                strSql.Append(" set ");
                strSql.Append("file_path=@file_path");
                strSql.Append(" where [id]=@id ");
                DbParameter[] parameters = {
                     ParamHelper.MakeParam("@id",int.Parse(dr["id"].ToString())),
                     ParamHelper.MakeParam("@file_path",dr["file_path"].ToString().Replace(oldString, newString))
                };
                if (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0)
                {
                    tCount++;
                }
            }
            return tCount;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount">-1ʾȫ</param>
        /// <param name="colNames"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        private static IDataReader GetReader(int topCount, string colNames, string andWhere)
        {
            string sql = "select " + (topCount == -1 ? "" : "top " + topCount) + " " + colNames + " from " + currTableName + " where 1=1 " + andWhere;
            return DbHelper.ExecuteReader(sql);
        }
        /// <summary>
        /// ȡб
        /// </summary>
        /// <param name="channelId"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public DataTable GetList(int channelId, string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,channel_id,type,enable,description,file_path,file_name,file_ext_name,file_create_path,has_site_map,[order] from  [" + currTableName + "] ");
            strSql.Append(" where " + (channelId > 0 ? " channel_id=" + channelId + " " : " 1=1 ") + andWhere);
            strSql.Append(SiteConfig.IsAccess ? " Order By [order],id Asc" : " Order By [order] Asc");
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ȡģļ(channel_id,[0,1,2,3])
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <returns></returns>
        public Dictionary<string, string> GetHasTempletDictionary()
        {
            Dictionary<string, string> dic = new Dictionary<string, string>();
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select distinct channel_id,[type] from [" + currTableName + "]");
            strSql.Append(" Order By [channel_id] Asc");
            IDataReader dr = DbHelper.ExecuteReader(strSql.ToString());
            if (dr != null)
            {
                StringBuilder sb = new StringBuilder();
                string channelId = "";
                bool flag=false;
                while (dr.Read())
                {
                    string tChannelId = dr["channel_id"].ToString();
                    if (tChannelId != channelId)
                    {
                        if (flag)
                        {
                            dic.Add(channelId, sb.ToString());
                            sb.Remove(0, sb.Length);
                        }
                        sb.Append(",");
                        channelId = tChannelId;
                        flag = true;
                    }
                    sb.Append(dr["type"].ToString() + ",");
                }
                dr.Close();
                if (channelId != "")
                {
                    dic.Add(channelId, sb.ToString());
                }
            }
            return dic;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        
    }
}

