/**********************************************************************************
 * ˵     ģ(ݷʲ)
 * ڣ     2012.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Security.Cryptography;
using PlugNT.Common;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    public class SysModel
    {
        
        internal static string currTableName = SiteConfig.TablePrefix + "sys_model";
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Add(SysModelInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([id],[name],[enable],article_search_fields,article_search_html,article_isedithtml,article_headcode,article_ext_nav)");
            strSql.Append(" values (");
            strSql.Append("@id,@name,@enable,@article_search_fields,@article_search_html,@article_isedithtml,@article_headcode,@article_ext_nav)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@id",model.id),
                 ParamHelper.MakeParam("@name",model.name),
                 ParamHelper.MakeParam("@enable",model.enable),
                 ParamHelper.MakeParam("@article_search_fields",model.article_search_fields),
                 ParamHelper.MakeParam("@article_search_html",model.article_search_html),
                 ParamHelper.MakeParam("@article_isedithtml",model.article_isedithtml),
                 ParamHelper.MakeParam("@article_headcode",model.article_headcode),
                 ParamHelper.MakeParam("@article_ext_nav",model.article_ext_nav)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Update(SysModelInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("[name]=@name,");
            strSql.Append("[enable]=@enable,");
            strSql.Append("article_search_fields=@article_search_fields,");
            strSql.Append("article_search_html=@article_search_html,");
            strSql.Append("article_isedithtml=@article_isedithtml,");
            strSql.Append("article_headcode=@article_headcode,");
            strSql.Append("article_ext_nav=@article_ext_nav");
            strSql.Append(" where [id]=@ ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@name",model.name),
                 ParamHelper.MakeParam("@enable",model.enable),
                 ParamHelper.MakeParam("@article_search_fields",model.article_search_fields),
                 ParamHelper.MakeParam("@article_search_html",model.article_search_html),
                 ParamHelper.MakeParam("@article_isedithtml",model.article_isedithtml),
                 ParamHelper.MakeParam("@article_headcode",model.article_headcode),
                 ParamHelper.MakeParam("@article_ext_nav",model.article_ext_nav),
                 ParamHelper.MakeParam("@id",model.id)
            };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="fields"></param> 
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Update(List<Model_Field> fields, string andWhere)
        {
            if (fields.Count <= 0)
            {
                return false;
            }
            StringBuilder sbField = new StringBuilder();
            foreach (Model_Field field in fields)
            {
                if (field.fieldType == Type_Field.integerType)
                {
                    sbField.Append("," + field.fieldName + "=" + (string.IsNullOrEmpty(field.fieldValue) ? "0" : field.fieldValue));
                }
                else
                {
                    sbField.Append("," + field.fieldName + "='" + field.fieldValue.Replace("'", "''") + "'");
                }
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append(sbField.ToString().TrimStart(','));
            strSql.Append(" where 1=1 " + andWhere);
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// ɾһ
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			ParamHelper.MakeParam("@id",id)
		};
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// õһʵ
        /// </summary>
        /// <param name="dr"></param> 
        /// <returns></returns>
        public SysModelInfo GetSysModelInfo(int id)
        {
            SysModelInfo model = new SysModelInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [name], [enable], article_search_fields, article_search_html, article_isedithtml, article_headcode, article_ext_nav", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.name = dr["name"].ToString();
                    if (dr["enable"].ToString() != "")
                    {
                        model.enable = int.Parse(dr["enable"].ToString());
                    }
                    model.article_search_fields = dr["article_search_fields"].ToString();
                    model.article_search_html = dr["article_search_html"].ToString();
                    if (dr["article_isedithtml"].ToString() != "")
                    {
                        model.article_isedithtml = int.Parse(dr["article_isedithtml"].ToString());
                    }
                    model.article_headcode = dr["article_headcode"].ToString();
                    model.article_ext_nav = dr["article_ext_nav"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// Requestȡģ(Request.FormҲRequest.QueryStringһ)
        /// </summary>
        /// <param name="requests"></param> 
        /// <returns></returns>
        public SysModelInfo GetSysModelInfo(System.Collections.Specialized.NameValueCollection requests)
        {
            SysModelInfo model = null;
            if (requests != null)
            {
                model = new SysModelInfo();
                if (requests["id"] != null)
                {
                    model.id = int.Parse(requests["id"]);
                }
                model.name = requests["name"];
                if (requests["enable"] != null)
                {
                    model.enable = int.Parse(requests["enable"]);
                }
                model.article_search_fields = requests["article_search_fields"];
                model.article_search_html = requests["article_search_html"];
                if (requests["article_isedithtml"] != null)
                {
                    model.article_isedithtml = int.Parse(requests["article_isedithtml"]);
                }
                model.article_headcode = requests["article_headcode"];
                model.article_ext_nav = requests["article_ext_nav"];
            }
            return model;
        }
        /// <summary>
        /// õһ
        /// </summary>
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public string[] GetArray(string colNames, string andWhereOrderBy)
        {
            string[] tmpColNames = colNames.Replace("[", "").Replace("]", "").Split(',');
            int colLength = tmpColNames.Length;
            if (colLength == 0)
            {
                return null;
            }
            bool isRead = false;
            string[] strArr = new string[colLength];
            IDataReader dr = GetReader(1, colNames, andWhereOrderBy);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    for (int i = 0; i < colLength; i++)
                    {
                        strArr[i] = dr[tmpColNames[i]].ToString();
                    }
                }
                dr.Close();
            }
            return isRead ? strArr : null;
        }
        /// <summary>
        /// õһеĶ
        /// </summary>
        /// <param name="colName"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public object GetSingle(string colName, string andWhereOrderBy)
        {
            return DbHelper.GetSingle("select top 1 [" + colName + "] from " + currTableName + " where 1=1 " + andWhereOrderBy);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Exists(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
		    ParamHelper.MakeParam("@id",id)
		};
            return DbHelper.Exists(strSql.ToString(), parameters);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Exists(string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where 1=1 " + andWhere);
            return DbHelper.Exists(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select  [id], [name], [enable], article_search_fields, article_search_html, article_isedithtml, article_headcode, article_ext_nav");
            strSql.Append(" from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " [id], [name], [enable], article_search_fields, article_search_html, article_isedithtml, article_headcode, article_ext_nav");
            strSql.Append(" from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// ҳű
        /// </summary>
        /// <param name="id"></param>
        /// <param name="headCode"></param>
        /// <returns></returns>
        public bool UpdateArticleHeadcode(int id, string headCode)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("article_headcode=@article_headcode");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@article_headcode",headCode),
                 ParamHelper.MakeParam("@id",id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
    }
}

