/**********************************************************************************
 * ˵     ϵͳ(ݷʲ)
 * ڣ     2012.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Security.Cryptography;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// ϵͳ(ƵHtml뱣浽ݿ)
    /// </summary>
    public class Sys
    {
        private static string currTableName = SiteConfig.TablePrefix + "sys";
        /// <summary>
        /// ȡģ
        /// </summary>
        /// <returns></returns>
        public SysInfo GetSysInfo()
        {
            SysInfo model = new SysInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], str_filter, updated_count, updated_time, new_users, max_online_count, max_online_time", "");
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.str_filter = dr["str_filter"].ToString();
                    model.updated_count = int.Parse(dr["updated_count"].ToString());
                    if (dr["updated_time"].ToString() != "")
                    {
                        model.updated_time = DateTime.Parse(dr["updated_time"].ToString());
                    }
                    model.new_users = dr["new_users"].ToString();
                    if (dr["max_online_count"].ToString() != "")
                    {
                        model.max_online_count = int.Parse(dr["max_online_count"].ToString());
                    }
                    if (dr["max_online_time"].ToString() != "")
                    {
                        model.max_online_time = DateTime.Parse(dr["max_online_time"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(SysInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("str_filter=@str_filter,");
            strSql.Append("updated_count=@updated_count,");
            strSql.Append("updated_time=@updated_time,");
            strSql.Append("new_users=@new_users,");
            strSql.Append("max_online_count=@max_online_count,");
            strSql.Append("max_online_time=@max_online_time");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@str_filter",model.str_filter),
                 ParamHelper.MakeParam("@updated_count",model.updated_count),
                 ParamHelper.MakeParam("@updated_time",model.updated_time),
                 ParamHelper.MakeParam("@new_users",model.new_users),
                 ParamHelper.MakeParam("@max_online_count",model.max_online_count),
                 ParamHelper.MakeParam("@max_online_time",model.max_online_time.ToString()),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ۹
        /// </summary>
        /// <param name="id"></param>
        /// <param name="strFilter"></param>
        /// <returns></returns>
        public bool UpdateStrfilter(int id, string strFilter)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("str_filter=@str_filter");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@str_filter",strFilter),
                 ParamHelper.MakeParam("@id",id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// û
        /// </summary>
        /// <param name="id"></param>
        /// <param name="newUsers"></param>
        /// <returns></returns>
        public bool UpdateNewusers(int id, string newUsers)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("new_users=@new_users");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@new_users",newUsers),
                 ParamHelper.MakeParam("@id",id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// Զɸ
        /// </summary>
        /// <param name="id"></param>
        /// <param name="updatedCount"></param>
        /// <param name="time"></param>
        /// <returns></returns>
        public bool UpdateCountAndTime(int id,int updatedCount, DateTime time)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("updated_count=@updated_count");
            strSql.Append("updated_time=@updated_time");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@updated_count",updatedCount),
                 ParamHelper.MakeParam("@updated_time",time.ToString()),
                 ParamHelper.MakeParam("@id",id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ߲
        /// </summary>
        /// <param name="id"></param>
        /// <param name="maxCount"></param>
        /// <param name="time"></param>
        /// <returns></returns>
        public bool UpdateMaxOnline(int id, int maxCount, DateTime time)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("max_online_count=@max_online_count");
            strSql.Append("max_online_time=@max_online_time");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@max_online_count",maxCount),
                 ParamHelper.MakeParam("@max_online_time",time.ToString()),
                 ParamHelper.MakeParam("@id",id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
    }
}

