/**********************************************************************************
 * ˵     ݱӿ(ݷʲ)
 * ڣ     2010.03.13
 * ޸ڣ     2012.01.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Data;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// 1.C:\Program Files\Common Files\System\ado\msadox.dll,DLLADOXռ; 
    /// 2.C:\Program Files\Common Files\System\ado\msado15.dll,DLLADODBռ; 
    /// 3.C:\Program Files\Common Files\System\ado\msjro.dll,DLLJROռ 
    /// SxSʾ:磬dllɹֶcomΪ .netvs.netߵ 
    /// ʾַͱADOX.DataTypeEnum.adVarWCharADOX.DataTypeEnum.adVarChar
    /// </summary>
    public class ITable
    {
        /// <summary>
        /// ݱ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="idName"></param>
        /// <returns></returns>
        public static bool ReSetTable(string tableName, string idName)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            if (PlugNT.Database.Common.Simple.DbHelper.ExecuteSql("delete from " + tableName) > 0)
            {
                if (SiteConfig.IsAccess)
                {
                    return PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(string.Format("alter table [{0}] alter column {1} counter(1,1)",
                        tableName, SqlHelper.StrFilter(idName))) > 0;
                }
                else
                {
                    return PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(string.Format("dbcc checkident({0},reseed,1)", tableName)) > 0;
                }
            }
            return false;
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public static bool ExistsTable(string tableName)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            if (SiteConfig.IsAccess)
            {
                return PlugNT.Database.Common.Simple.DbHelper.Exists("SELECT Count(1) AS Qty FROM MSysObjects WHERE name=" + tableName);
            }
            else
            {
                return PlugNT.Database.Common.Simple.DbHelper.Exists("select count(1) from sysobjects where id = object_id(N" + tableName + ") and OBJECTPROPERTY(id, N'IsUserTable') = 1");
            }
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="colNameList"></param>
        /// <returns></returns>
        public static bool ExistsColumn(string tableName, string colNameList)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            if (colNameList == "")
            {
                return false;
            }
            if (SiteConfig.IsAccess)
            {
                StringBuilder strSql = new StringBuilder();
                strSql.Append("select top 1 * from  [" + tableName + "] where 1=0");
                DataTable dt = PlugNT.Database.Common.Simple.DbHelper.GetDataTable(strSql.ToString());
                if (dt == null)
                {
                    return false;
                }
                string[] colArr = colNameList.Split(',');
                foreach (string col in colArr)
                {
                    if (!dt.Columns.Contains(col))
                    {
                        return false;
                    }
                }
                return true;
            }
            else
            {
                return PlugNT.Database.Common.Simple.DbHelper.Exists("select count(1) from syscolumns where [id]=object_id(" + tableName
                    + ") and [name] in ('" + SqlHelper.FieldFilter(colNameList.Replace(",", "','")) + "')");
            }
        }
        /// <summary>   
        /// Mdbݿбֶ
        /// </summary>   
        public static Dictionary<string, string[]> GetShemaTables()
        {
            Dictionary<string, string[]> tables = new Dictionary<string, string[]>();
            System.Data.DataTable shemaTable = null;
            int m = 0, n = 0;
            switch (SiteConfig.DbType)
            {
                case "System.Data.OleDb":
                    System.Data.OleDb.OleDbConnection conn = new System.Data.OleDb.OleDbConnection();
                    conn.ConnectionString = SiteConfig.ConnectionString;
                    conn.Open();
                    shemaTable = conn.GetOleDbSchemaTable(System.Data.OleDb.OleDbSchemaGuid.Tables, new object[] { null, null, null, "TABLE" });
                    m = shemaTable.Columns.IndexOf("TABLE_NAME");
                    n = shemaTable.Rows.Count;
                    for (int i = 0; i < n; i++)
                    {
                        System.Data.DataRow m_DataRow = shemaTable.Rows[i];
                        string strTable = m_DataRow.ItemArray.GetValue(m).ToString();
                        System.Data.DataTable dt = conn.GetOleDbSchemaTable(System.Data.OleDb.OleDbSchemaGuid.Columns, new object[] { null, null, strTable, null });
                        int tmp_n = dt.Rows.Count;
                        string[] strColumns = new string[tmp_n];
                        int tmp_m = dt.Columns.IndexOf("COLUMN_NAME");
                        for (int tmp_i = 0; tmp_i < tmp_n; tmp_i++)
                        {
                            System.Data.DataRow tmp_m_DataRow = dt.Rows[tmp_i];
                            strColumns[tmp_i] = tmp_m_DataRow.ItemArray.GetValue(tmp_m).ToString();
                        }
                        tables.Add(strTable, strColumns);
                    }
                    conn.Close();
                    conn.Dispose();
                    conn = null;
                    break;
                case "System.Data.SqlClient":
                    System.Data.SqlClient.SqlConnection conn2 = new System.Data.SqlClient.SqlConnection();
                    conn2.ConnectionString = SiteConfig.ConnectionString;
                    conn2.Open();
                    shemaTable = conn2.GetSchema("Tables");
                    System.Data.DataTable dtColumns = conn2.GetSchema("Columns");
                    int colIndex = dtColumns.Columns.IndexOf("COLUMN_NAME");
                    m = shemaTable.Columns.IndexOf("TABLE_NAME");
                    n = shemaTable.Rows.Count;
                    for (int i = 0; i < n; i++)
                    {
                        System.Data.DataRow m_DataRow = shemaTable.Rows[i];
                        string strTable = m_DataRow.ItemArray.GetValue(m).ToString();
                        System.Data.DataRow[] drs = dtColumns.Select("TABLE_NAME='" + strTable + "'");
                        int tmp_n = drs.Length;
                        string[] strColumns = new string[tmp_n];
                        for (int tmp_i = 0; tmp_i < tmp_n; tmp_i++)
                        {
                            System.Data.DataRow tmp_m_DataRow = drs[tmp_i];
                            strColumns[tmp_i] = tmp_m_DataRow.ItemArray.GetValue(colIndex).ToString();
                        }
                        tables.Add(strTable, strColumns);
                    }
                    conn2.Close();
                    conn2.Dispose();
                    conn2 = null;
                    break;
                default:
                    string sel_all_table_sql = "SELECT Name FROM " + SiteConfig.DbName + "..SysObjects Where XType='U' ORDER BY Name ";
                    shemaTable = PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sel_all_table_sql);
                    n = shemaTable.Rows.Count;
                    for (int i = 0; i < n; i++)
                    {
                        string strTable = shemaTable.Rows[i]["Name"].ToString();
                        string sel_col_sql = "SELECT Name FROM SysColumns WHERE id=Object_Id('" + strTable + "')";
                        System.Data.DataTable dt = PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sel_col_sql);
                        int tmp_n = dt.Rows.Count;
                        string[] strColumns = new string[tmp_n];
                        for (int tmp_i = 0; tmp_i < tmp_n; tmp_i++)
                        {
                            strColumns[tmp_i] = dt.Rows[tmp_i]["Name"].ToString();
                        }
                        tables.Add(strTable, strColumns);
                    }
                    break;
            }
            return tables;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="args"></param>
        /// <returns></returns>
        public static bool SqlClient_CreateArticleTable(int sysModelId)
        {
            List<string> sqlList = new List<string>();
            sqlList.Add(SqlClient_GetCreateArticleTableSql(sysModelId));
            string error = "";
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSqlTran(sqlList, out error) > 0 && error == "");
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        public static bool SqlClient_DropTable(string tableName)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            List<string> sqlList = new List<string>();
            sqlList.Add(SqlClient_GetDropTableSql(tableName));
            string error = "";
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSqlTran(sqlList, out error) > 0 && error == "");
        }
        /// <summary>
        /// ޸ı
        /// </summary>
        /// <param name="ftype"></param>
        /// <param name="field"></param>
        /// <returns></returns>
        public static bool SqlClient_ModifyTable(Type_FieldAction ftype, FieldInfo field)
        {
            bool tmpFlag = false;
            string execSql = "ALTER TABLE [" + Article.currTableName +field.sys_model_id + "] {0} " + field.column + " {1} ";
            string fieldTypeStr = "";
            switch (field.column_type)
            {
                case Type_Field.stringType:
                    if (field.length == 0)
                    {
                        fieldTypeStr = "[ntext] COLLATE Chinese_PRC_CI_AS NULL";
                    }
                    else
                    {
                        fieldTypeStr = "[nvarchar] (" + field.length.ToString() + ") COLLATE Chinese_PRC_CI_AS NULL";
                    }
                    break;
                case Type_Field.integerType:
                    if (field.length == 0)
                    {
                        fieldTypeStr = "[bit] NULL";
                    }
                    else if (field.length == 1)
                    {
                        fieldTypeStr = "[tinyint] NULL";
                    }
                    else if (field.length == 2)
                    {
                        fieldTypeStr = "[smallint] NULL";
                    }
                    else if (field.length == 3)
                    {
                        fieldTypeStr = "[decimal] NULL";
                    }
                    else
                    {
                        fieldTypeStr = "[int] NULL";
                    }
                    break;
                case Type_Field.datetimeType:
                    if (field.length == 0)
                    {
                        fieldTypeStr = "[datetime] NULL";
                    }
                    else
                    {
                        fieldTypeStr = "[smalldatetime] NULL";
                    }
                    break;
                default:
                    break;
            }
            switch (ftype)
            {
                case Type_FieldAction.add:
                    execSql = string.Format(execSql, "ADD", fieldTypeStr);
                    break;
                case Type_FieldAction.update:
                    execSql = string.Format(execSql, "ALTER COLUMN", fieldTypeStr);
                    break;
                case Type_FieldAction.delete:
                    execSql = string.Format(execSql, "DROP COLUMN", "");
                    break;
                default:
                    execSql = "";
                    break;
            }
            if (execSql != "")
            {
                PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(execSql);
                tmpFlag = true;
            }
            return tmpFlag;
        }
        /// <summary>
        /// ִSQLб
        /// </summary>
        /// <param name="sqlList"></param>
        /// <returns></returns>
        public static bool SqlClient_ExecuteSqlList(List<string> sqlList)
        {
            string error = "";
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSqlTran(sqlList, out error) > 0 && error == "");
        }
        /// <summary>
        /// õҪSql
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <returns></returns>
        private static string SqlClient_GetCreateArticleTableSql(int sysModelId)
        {
            return @"CREATE TABLE [dbo].[" + SiteConfig.TablePrefix + @"article_" + sysModelId + @"] (
	                    [id] [int] IDENTITY (1, 1) NOT NULL ,
	                    [no] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NOT NULL ,
	                    [title] [nvarchar] (150) COLLATE Chinese_PRC_CI_AS NULL ,
                        [channel_id] [int] NOT NULL ,
	                    [contents] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	                    [templetfile] [nvarchar] (150) COLLATE Chinese_PRC_CI_AS NULL ,
	                    [commend] [bit] NOT NULL ,
	                    [stick] [bit] NOT NULL ,
	                    [publish] [bit] NOT NULL ,
	                    [addtime] [smalldatetime] NULL 
                    ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
                    ALTER TABLE [dbo].[" + SiteConfig.TablePrefix + @"article_" + sysModelId + @"] WITH NOCHECK ADD 
	                    CONSTRAINT [PK_" + SiteConfig.TablePrefix + @"article_" + sysModelId + @"] PRIMARY KEY  CLUSTERED 
	                    (
		                    [id]
	                    )  ON [PRIMARY] 
                     CREATE  UNIQUE  INDEX [" + SiteConfig.TablePrefix + @"weiyi] ON [dbo].[" + SiteConfig.TablePrefix + @"article_" + sysModelId + @"]([no]) ON [PRIMARY]
                     CREATE  INDEX [" + SiteConfig.TablePrefix + @"suoyin] ON [dbo].[" + SiteConfig.TablePrefix + @"article_" + sysModelId + @"]([title], [no], [channel_id]) ON [PRIMARY]";
        }
        /// <summary>
        /// õҪɾSql
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        private static string SqlClient_GetDropTableSql(string tableName)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            return @"if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[" + tableName + @"]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
                    drop table [dbo].[" + tableName + @"]";
        }
        /// <summary>
        /// õɾSQL
        /// </summary>
        /// <param name="tableName"></param>
        /// <returns></returns>
        private static string SqlClient_GetDeleteTableSql(string tableName)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            return @"if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[" + tableName + @"]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
                    delete from [dbo].[" + tableName + @"]";
        }
        /// <summary>
        /// ִSQL(ɵⲿ)
        /// </summary>
        /// <param name="dbType"></param>
        /// <param name="dbConstring"></param>
        /// <param name="sqlString"></param>
        public static int ExecuteSql(string dbType, string dbConstring, string sqlString)
        {
            PlugNT.Database.DbInfo dbinfo = new PlugNT.Database.DbInfo(dbType, dbConstring);
            return PlugNT.Database.Common.Complex.DbHelper.ExecuteSql(dbinfo, sqlString);
        }
        /// <summary>
        /// ȡб(ɵⲿ)
        /// </summary>
        /// <param name="dbType"></param>
        /// <param name="dbConstring"></param>
        /// <param name="sqlString"></param>
        public static DataTable GetDataTable(string dbType, string dbConstring, string sqlString)
        {
            PlugNT.Database.DbInfo dbinfo = new PlugNT.Database.DbInfo(dbType, dbConstring);
            return PlugNT.Database.Common.Complex.DbHelper.GetDataTable(dbinfo, sqlString);
        }
        /// <summary>
        /// ȡReader(ɵⲿ)
        /// </summary>
        /// <param name="dbType"></param>
        /// <param name="dbConstring"></param>
        /// <param name="sqlString"></param>
        public static IDataReader GetReader(string dbType, string dbConstring, string sqlString)
        {
            PlugNT.Database.DbInfo dbinfo = new PlugNT.Database.DbInfo(dbType, dbConstring);
            return PlugNT.Database.Common.Complex.DbHelper.GetReader(dbinfo, sqlString);
        }
        /// <summary>
        /// ȡ(ɵⲿ)
        /// </summary>
        /// <param name="dbType"></param>
        /// <param name="dbConstring"></param>
        /// <param name="sqlString"></param>
        public static object GetSingle(string dbType, string dbConstring, string sqlString)
        {
            PlugNT.Database.DbInfo dbinfo = new PlugNT.Database.DbInfo(dbType, dbConstring);
            return PlugNT.Database.Common.Complex.DbHelper.GetSingle(dbinfo, sqlString);
        }
        /// <summary>
        /// StringתObject
        /// </summary>
        /// <param name="type"></param>
        /// <param name="str"></param>
        /// <returns></returns>
        public static object ConvertToObject(Type type, string str)
        {
            switch (type.ToString())
            {
                case "System.Boolean":
                    return Convert.ToBoolean(str);
                case "System.Decimal":
                    return Convert.ToDecimal(str);
                case "System.Double":
                    return Convert.ToDouble(str);
                case "System.Single":
                    return Convert.ToSingle(str);
                case "System.Byte":
                    return Convert.ToByte(str);
                case "System.SByte":
                    return Convert.ToSByte(str);
                case "System.Int16":
                    return Convert.ToInt16(str);
                case "System.Int32":
                    return Convert.ToInt32(str);
                case "System.Int64":
                    return Convert.ToInt64(str);
                case "System.DateTime":
                    return Convert.ToDateTime(str);
                case "System.Char":
                    return Convert.ToChar(str);
                default:
                    return str;
            }
        }
        /// <summary>
        /// ObjectתString
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        private static string ConvertToString(object obj)
        {
            switch (obj.GetType().ToString())
            {
                case "System.Boolean":
                case "System.Decimal":
                case "System.Double":
                case "System.Single":
                case "System.Byte":
                case "System.SByte":
                case "System.Int16":
                case "System.Int32":
                case "System.Int64":
                    return obj.ToString();
                case "System.DateTime":
                    return "'" + obj.ToString() + "'";
                case "System.Char":
                case "System.String":
                    return SqlHelper.FieldFilter(obj.ToString());
                default:
                    return SqlHelper.FieldFilter(obj.ToString());
            }
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="dictions">ֵֶκֵ</param>
        /// <returns></returns>
        public static bool Add(string tableName, Dictionary<string, object> dictions)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            bool startflag = true;
            StringBuilder strSql = new StringBuilder();
            StringBuilder strSqlValues = new StringBuilder();
            strSql.Append("insert into " + tableName + " (");
            foreach (KeyValuePair<string, object> item in dictions)
            {
                if (startflag)
                {
                    strSql.Append("[" + item.Key + "]");
                    strSqlValues.Append(ConvertToString(item.Value));
                    startflag = false;
                }
                else
                {
                    strSql.Append(",[" + item.Key + "]");
                    strSqlValues.Append("," + ConvertToString(item.Value));
                }
            }
            strSql.Append(")");
            strSql.Append(" values (");
            strSql.Append(strSqlValues.ToString());
            strSql.Append(")");
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// һ()
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="hashtab">ϣֶκֵ</param>
        /// <returns></returns>
        public static bool Add(string tableName, Hashtable hashtab)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            bool startflag = true;
            StringBuilder strSql = new StringBuilder();
            StringBuilder strSqlValues = new StringBuilder();
            strSql.Append("insert into " + tableName + " (");
            foreach (DictionaryEntry item in hashtab)
            {
                if (startflag)
                {
                    strSql.Append("[" + item.Key.ToString() + "]");
                    strSqlValues.Append(ConvertToString(item.Value));
                    startflag = false;
                }
                else
                {
                    strSql.Append(",[" + item.Key.ToString() + "]");
                    strSqlValues.Append("," + ConvertToString(item.Value));
                }
            }
            strSql.Append(")");
            strSql.Append(" values (");
            strSql.Append(strSqlValues.ToString());
            strSql.Append(")");
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="dictions">ֵֶκֵ</param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public static bool Update(string tableName, Dictionary<string, object> dictions, string andWhere)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            bool startflag = true;
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + tableName + " set ");
            foreach (KeyValuePair<string, object> item in dictions)
            {
                if (startflag)
                {
                    strSql.Append("[" + item.Key + "]=");
                    startflag = false;
                }
                else
                {
                    strSql.Append(",[" + item.Key + "]=");
                }
                strSql.Append(ConvertToString(item.Value));
            }
            strSql.Append(" where 1=1 " + andWhere);
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// һ()
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="hashtab">ϣֶκֵ</param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public static bool Update(string tableName, Hashtable hashtab, string andWhere)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            bool startflag = true;
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + tableName + " set ");
            foreach (DictionaryEntry item in hashtab)
            {
                if (startflag)
                {
                    strSql.Append("[" + item.Key.ToString() + "]=");
                    startflag = false;
                }
                else
                {
                    strSql.Append(",[" + item.Key.ToString() + "]=");
                }
                strSql.Append(ConvertToString(item.Value));
            }
            strSql.Append(" where 1=1 " + andWhere);
            return (PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// ɾһ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public static int Delete(string tableName, string andWhere)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from [" + tableName + "] ");
            strSql.Append(" where 1=1 " + andWhere);
            return PlugNT.Database.Common.Simple.DbHelper.ExecuteSql(strSql.ToString());
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static IDataReader GetReader(string tableName, int topCount, string colNames, string andWhereOrderBy)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + tableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// ѯеĵ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="colName"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static string GetObjectString(string tableName, string colName, string andWhereOrderBy)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            string sql = string.Format("select top 1 [{0}] from [" + tableName + "] where 1=1 {1}", colName, andWhereOrderBy);
            Object obj = PlugNT.Database.Common.Simple.DbHelper.GetSingle(sql);
            return obj == null ? "" : obj.ToString();
        }
        /// <summary>
        /// õһ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public static string[] GetArray(string tableName, string colNames, string andWhereOrderBy)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            string[] tmpColNames = colNames.Replace("[", "").Replace("]", "").Split(',');
            int colLength = tmpColNames.Length;
            if (colLength == 0)
            {
                return null;
            }
            bool isRead = false;
            string[] strArr = new string[colLength];
            IDataReader dr = GetReader(tableName, 1, colNames, andWhereOrderBy);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    for (int i = 0; i < colLength; i++)
                    {
                        strArr[i] = dr[tmpColNames[i]].ToString();
                    }
                }
                dr.Close();
            }
            return isRead ? strArr : null;
        }
        /// <summary>
        /// õб
        /// </summary>
        /// <param name="sqlString"></param>
        /// <returns></returns>
        public static DataTable GetDataTable(string sqlString)
        {
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable( sqlString);
        }
        /// <summary>
        /// õб
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="colNames"></param>
        /// <param name="topCount">ǰn</param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static DataTable GetList(string tableName, string colNames, int topCount, string andWhereOrderBy)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            string strTopCount = (topCount > 0) ? " top " + topCount.ToString() : "";
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(string.Format("select {0} {1} from [" + tableName + "] where 1=1 {2}", strTopCount, colNames, andWhereOrderBy));
        }
        /// <summary>
        /// õб(ҳ)
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="pageSize">nҳ</param>
        /// <param name="currPage">ǰҳ</param>
        /// <param name="colNames"></param>
        /// <param name="andWhere">SQLǰand</param>
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param>
        /// <param name="recordCount">¼</param>
        /// <returns></returns>
        public static DataTable GetList(string tableName, int pageSize, int currPage, string colNames, string andWhere, string orderBy, out int recordCount)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from [" + tableName + "] where 1=1 " + andWhere);
            recordCount = GetCount(tableName, andWhere);
            string sql = SqlHelper.GetPagingString(pageSize, currPage, recordCount, strSql.ToString(), orderBy);
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
        /// <summary>
        /// õб(ҳ)
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="pageSize">nҳ</param>
        /// <param name="currPage">ǰҳ</param>
        /// <param name="colNames"></param>
        /// <param name="andWhere">SQLǰand</param>
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param>
        /// <param name="joinAsTableName"></param>
        /// <param name="joinColNames"></param>
        /// <param name="joinOn"></param>
        /// <param name="recordCount">¼</param>
        /// <returns></returns>
        public static DataTable GetList(string tableName, int pageSize, int currPage, string colNames, string andWhere, string orderBy, string joinAsTableName, string joinColNames, string joinOn, out int recordCount)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from [" + tableName + "] where 1=1 " + andWhere);
            recordCount = GetCount(tableName, andWhere);
            string sql = SqlHelper.GetPagingString(pageSize, currPage, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, joinAsTableName, joinColNames, joinOn + SqlHelper.GetJoinOrderBy(orderBy, joinAsTableName));
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
        /// <summary>
        /// õб(ҳ)
        /// </summary>
        /// <param name="pageSize">nҳ</param>
        /// <param name="currPage">ǰҳ</param>
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public static DataTable GetList(int pageSize, int currPage, string strSql, string orderBy, out int recordCount)
        {
            object objCount = PlugNT.Database.Common.Simple.DbHelper.GetSingle(SqlHelper.GetCountString(strSql));
            recordCount = objCount != null ? int.Parse(objCount.ToString()) : 0;
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPage, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// ҵ(ҳ)
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static int GetCount(string tableName, string andWhereOrderBy)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            string sql = "select count(1) as tcount from [" + tableName + "] where 1=1 " + andWhereOrderBy;
            return (int)PlugNT.Database.Common.Simple.DbHelper.GetSingle(sql);
        }
        /// <summary>
        /// Ҷ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="andWhereArr"></param>
        /// <returns></returns>
        public static int[] GetCount(string tableName, string[] andWhereArr)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(tableName))
            {
                throw new Exception(":" + tableName + "Σַ");
            }
            int[] ctArr = null;
            StringBuilder strSql = new StringBuilder();
            if (andWhereArr != null)
            {
                int colLength = andWhereArr.Length;
                ctArr = new int[colLength];
                for (int i = 0; i < colLength; i++)
                {
                    strSql.Append("(select count(1) from [" + tableName + "] where 1=1 " + andWhereArr[i] + ") as count" + i + ",");
                }
                string sql = "select top 1 " + strSql.ToString().Trim(',') + " from [" + tableName + "]";
                IDataReader dr = PlugNT.Database.Common.Simple.DbHelper.ExecuteReader(sql);
                if (dr != null)
                {
                    if (dr.Read())
                    {
                        for (int i = 0; i < colLength; i++)
                        {
                            int tCount = 0;
                            int.TryParse(dr[i].ToString(), out tCount);
                            ctArr[i] = tCount;
                        }
                    }
                    dr.Close();
                }
            }
            return ctArr;
        }
    }
}

