/**********************************************************************************
 * ˵     Ȩ޷ҳ(ݷʲ)
 * ڣ     2012.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    public class GroupPages
    {
        private static string currTableName = SiteConfig.TablePrefix + "group_pages";
        /// <summary>
        /// õģ
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public GroupPagesInfo GetGroupPagesInfo(string codeNo)
        {
            GroupPagesInfo model = new GroupPagesInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], code_no, page_name, page_path, group_name", " and code_no=" + SqlHelper.FieldFilter(codeNo));
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.code_no = dr["code_no"].ToString();
                    model.page_name = dr["page_name"].ToString();
                    model.page_path = dr["page_path"].ToString();
                    model.group_name = dr["group_name"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="codeNo"></param>
        /// <returns></returns>
        public bool Exist(string codeNo)
        {
            string sql = "Select top 1 [id] From " + currTableName + " where [code_no]=" + SqlHelper.FieldFilter(codeNo);
            return  DbHelper.Exists(sql);
        }
        /// <summary>
        /// õҳ
        /// </summary>
        /// <param name="codeNo"></param>
        /// <returns></returns>
        public string GetPageName(string codeNo)
        {
            string sql = "Select top 1 page_name From " + currTableName + " where [code_no]=" + SqlHelper.FieldFilter(codeNo) ;
            object obj = DbHelper.GetSingle(sql);
            return (obj == null) ? "" : obj.ToString();
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(GroupPagesInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("(code_no,page_name,page_path,group_name)");
            strSql.Append(" values (");
            strSql.Append("@code_no,@page_name,@page_path,@group_name)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@code_no",model.code_no),
                 ParamHelper.MakeParam("@page_name",model.page_name),
                 ParamHelper.MakeParam("@page_path",model.page_path),
                 ParamHelper.MakeParam("@group_name",model.group_name)
            };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(GroupPagesInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("code_no=@code_no,");
            strSql.Append("page_name=@page_name,");
            strSql.Append("page_path=@page_path,");
            strSql.Append("group_name=@group_name");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@code_no",model.code_no),
                 ParamHelper.MakeParam("@page_name",model.page_name),
                 ParamHelper.MakeParam("@page_path",model.page_path),
                 ParamHelper.MakeParam("@group_name",model.group_name),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="codeNo"></param>
        /// <returns></returns>
        public bool Delete(string codeNo)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [code_no]=@code_no");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@code_no",codeNo)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// ȡб
        /// </summary>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            string sql = "select * from " + currTableName + " where 1=1 " + andWhereOrderBy + " order by group_name" + (SiteConfig.IsAccess ? ",id" : "");
            return DbHelper.GetDataTable(sql);
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
    }
}

