/**********************************************************************************
 * ˵     (ݷʲ)
 * ڣ     2012.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    public class FriendLink
    {
        public static string currTableName = SiteConfig.TablePrefix + "friendlink";
        private const string linkTemplet = "<a href='{0}' target='_blank' title='{1}'>{2}</a>";
        private int GetClassId(int id)
        {
            string sql = "Select top 1 [class_id] From " + currTableName + " where [id]=" + id.ToString();
            object obj = DbHelper.GetSingle(sql);
            return (obj == null) ? 0 : int.Parse(obj.ToString());
        }
        /// <summary>
        /// һҳ(ɶӶ)
        /// </summary>
        /// <param name="classId"></param>
        /// <param name="splitString"></param>
        /// <returns></returns>
        public string CreateLinks(int classId, string splitString)
        {
            StringBuilder sb = new StringBuilder();
            FriendLinkClassInfo clsInfo = new FriendLinkClass().GetFriendLinkClassInfo(classId);
            if (clsInfo != null)
            {
                IDataReader dr = GetReader(-1, "*", " and class_id=" + classId);
                if (dr != null)
                {
                    bool first = true;
                    while (dr.Read())
                    {
                        if (first)
                        {
                            first = false;
                        }
                        else
                        {
                            sb.Append("{0}");
                        }
                        sb.Append(string.Format(linkTemplet, dr["target_url"].ToString(), dr["description"].ToString(), dr["text"].ToString()));
                    }
                    dr.Close();
                }
            }
            string reString = sb.ToString();
            return reString != "" ? string.Format(reString, splitString) : "";
        }
        /// <summary>
        /// õģ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public FriendLinkInfo GetFriendLinkInfo(int id)
        {
            FriendLinkInfo model = new FriendLinkInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], class_id, target_url, [description], [text], [order]", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    if (dr["class_id"].ToString() != "")
                    {
                        model.class_id = int.Parse(dr["class_id"].ToString());
                    }
                    model.target_url = dr["target_url"].ToString();
                    model.description = dr["description"].ToString();
                    model.text = dr["text"].ToString();
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(FriendLinkInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("(class_id,target_url,[description],[text],[order])");
            strSql.Append(" values (");
            strSql.Append("@class_id,@target_url,@description,@text,@order)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@class_id",model.class_id),
                 ParamHelper.MakeParam("@target_url",model.target_url),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@text",model.text),
                 ParamHelper.MakeParam("@order",model.order)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(FriendLinkInfo model)
        {
   
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("class_id=@class_id,");
            strSql.Append("target_url=@target_url,");
            strSql.Append("[description]=@description,");
            strSql.Append("[text]=@text,");
            strSql.Append("[order]=@order");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@class_id",model.class_id),
                 ParamHelper.MakeParam("@target_url",model.target_url),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@text",model.text),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="classId"></param>
        /// <returns></returns>
        public bool DeleteByClassId(int classId)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [class_id]=@class_id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@class_id",classId)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount">-1ʾȫ</param>
        /// <param name="colNames"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        private IDataReader GetReader(int topCount, string colNames, string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount >0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + " where 1=1 " + andWhere);
            strSql.Append(SiteConfig.IsAccess ? " order by [order],id desc" : " order by [order] desc");
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// õб
        /// </summary>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public DataTable GetList(string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + " where 1=1 " +  andWhere);
            strSql.Append(SiteConfig.IsAccess ? " order by [order],id desc" : " order by [order] desc");
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetCDataList(int pageSize, int currPageCount, string andWhere, string orderBy, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(andWhere.ToString());
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, "as a", "a.*,b.name", "left join " + FriendLinkClass.currTableName +
                " as b on a.class_id=b.id " + SqlHelper.GetJoinOrderBy(orderBy, "a"));
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
    }
}

