/**********************************************************************************
 * ˵     ֶβѯ(ݷʲ)
 * ڣ     2012.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Security.Cryptography;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    public class FieldSearch
    {
        private static string currTableName = SiteConfig.TablePrefix + "field_search";
        /// <summary>
        /// idȡģ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public FieldSearchInfo GetFieldSearchInfo(int id)
        {
            FieldSearchInfo model = new FieldSearchInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], sys_model_id, column_index, [title], [column], [type], symbol, type_text, symbol_text, default_value, category_no_list, is_sub_category", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    if (dr["sys_model_id"].ToString() != "")
                    {
                        model.sys_model_id = int.Parse(dr["sys_model_id"].ToString());
                    }
                    model.column_index = dr["column_index"].ToString();
                    model.title = dr["title"].ToString();
                    model.column = dr["column"].ToString();
                    model.type = dr["type"].ToString();
                    model.symbol = dr["symbol"].ToString();
                    model.type_text = dr["type_text"].ToString();
                    model.symbol_text = dr["symbol_text"].ToString();
                    model.default_value = dr["default_value"].ToString();
                    model.category_no_list = dr["category_no_list"].ToString();
                    if (dr["is_sub_category"].ToString() != "")
                    {
                        model.is_sub_category = dr["is_sub_category"].ToString()=="1";
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(FieldSearchInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("(sys_model_id,column_index,[title],[column],[type],[symbol],type_text,symbol_text,default_value,category_no_list,is_sub_category)");
            strSql.Append(" values (");
            strSql.Append("@sys_model_id,@column_index,@title,@column,@type,@symbol,@type_text,@symbol_text,@default_value,@category_no_list,@is_sub_category)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@sys_model_id",model.sys_model_id),
                 ParamHelper.MakeParam("@column_index",model.column_index),
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@column",model.column),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@symbol",model.symbol),
                 ParamHelper.MakeParam("@type_text",model.type_text),
                 ParamHelper.MakeParam("@symbol_text",model.symbol_text),
                 ParamHelper.MakeParam("@default_value",model.default_value),
                 ParamHelper.MakeParam("@category_no_list",model.category_no_list),
                 ParamHelper.MakeParam("@is_sub_category",model.is_sub_category?1:0)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(FieldSearchInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("column_index=@column_index,");
            strSql.Append("[title]=@title,");
            strSql.Append("[column]=@column,");
            strSql.Append("[type]=@type,");
            strSql.Append("[symbol]=@symbol,");
            strSql.Append("type_text=@type_text,");
            strSql.Append("symbol_text=@symbol_text,");
            strSql.Append("default_value=@default_value,");
            strSql.Append("category_no_list=@category_no_list,");
            strSql.Append("is_sub_category=@is_sub_category");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@column_index",model.column_index),
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@column",model.column),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@symbol",model.symbol),
                 ParamHelper.MakeParam("@type_text",model.type_text),
                 ParamHelper.MakeParam("@symbol_text",model.symbol_text),
                 ParamHelper.MakeParam("@default_value",model.default_value),
                 ParamHelper.MakeParam("@category_no_list",model.category_no_list),
                 ParamHelper.MakeParam("@is_sub_category",model.is_sub_category?1:0),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// һݱֶ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colName"></param>
        /// <param name="categoryNoList"></param>
        /// <param name="isSubCategory"></param>
        /// <returns></returns>
        internal static bool Update(int sysModelId, string colName, string categoryNoList, bool isSubCategory)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("category_no_list=@category_no_list,");
            strSql.Append("is_sub_category=@is_sub_category,");
            strSql.Append(" where sys_model_id=@sys_model_id and [column]=@column");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@sys_model_id",sysModelId),
                 ParamHelper.MakeParam("@category_no_list",categoryNoList),
                 ParamHelper.MakeParam("@is_sub_category",isSubCategory?1:0),
                 ParamHelper.MakeParam("@column",colName)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// ȡб
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public DataTable GetList(int sysModelId, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from  [" + currTableName + "] where 1=1 ");
            strSql.Append(sysModelId > 0 ? "and sys_model_id= " + sysModelId : "");
            strSql.Append(andWhereOrderBy);
            return DbHelper.GetDataTable(strSql.ToString());
        }
 
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(int sysModelId, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) from [" + currTableName + "] where ");
            strSql.Append(sysModelId > 0 ? "sys_model_id= " + sysModelId : "");
            strSql.Append(andWhereOrderBy);
            object objCount = DbHelper.GetSingle(strSql.ToString());
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// Ƿĳ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colName"></param>
        /// <returns></returns>
        public bool Exists(int sysModelId, string colName)
        {
            if (colName != "")
            {
                return ITable.ExistsColumn(Article.currTableName + sysModelId, SqlHelper.StrFilter(colName));
            }
            else
            {
                return false;
            }
        }
    }
}

