/**********************************************************************************
 * ˵     Զֶ(ݷʲ)
 * ڣ     2012.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Security.Cryptography;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    public class Field
    {
        private static string currTableName = SiteConfig.TablePrefix + "field";
        /// <summary>
        /// idȡģ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public FieldInfo GetFieldInfo(int id)
        {
            FieldInfo model = new FieldInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], sys_model_id, column_index, [title], message, html_type, html_depth, default_value, category_no_list, is_sub_category, [column], column_type, [order], length, list_value", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    if (dr["sys_model_id"].ToString() != "")
                    {
                        model.sys_model_id = int.Parse(dr["sys_model_id"].ToString());
                    }
                    model.column_index = dr["column_index"].ToString();
                    model.title = dr["title"].ToString();
                    model.message = dr["message"].ToString();
                    model.html_type = dr["html_type"].ToString();
                    model.html_depth = dr["html_depth"].ToString();
                    model.default_value = dr["default_value"].ToString();
                    model.category_no_list = dr["category_no_list"].ToString();
                    if (dr["is_sub_category"].ToString() != "")
                    {
                        model.is_sub_category = dr["is_sub_category"].ToString()=="1";
                    }
                    model.column = dr["column"].ToString();
                    model.column_type = dr["column_type"].ToString();
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    if (dr["length"].ToString() != "")
                    {
                        model.length = int.Parse(dr["length"].ToString());
                    }
                    model.list_value = dr["list_value"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// õֶ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colName"></param>
        /// <returns></returns>
        public string[] GetFieldArr(int sysModelId,string colName)
        {
            string[] arr = null;
            IDataReader dr = GetReader(1, "*", " and sys_model_id=" + sysModelId + " and [column]=" + SqlHelper.FieldFilter(colName));
            if (dr != null)
            {
                if (dr.Read())
                {
                    arr = new string[2];
                    arr[0] = dr["category_no_list"].ToString();
                    arr[1] = dr["is_sub_category"].ToString();
                }
                dr.Close();
            }
            return arr;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(FieldInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("(sys_model_id,column_index,[title],[message],html_type,html_depth,default_value,category_no_list,is_sub_category,[column],column_type,[order],[length],list_value)");
            strSql.Append(" values (");
            strSql.Append("@sys_model_id,@column_index,@title,@message,@html_type,@html_depth,@default_value,@category_no_list,@is_sub_category,@column,@column_type,@order,@length,@list_value)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@sys_model_id",model.sys_model_id),
                 ParamHelper.MakeParam("@column_index",model.column_index),
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@message",model.message),
                 ParamHelper.MakeParam("@html_type",model.html_type),
                 ParamHelper.MakeParam("@html_depth",model.html_depth),
                 ParamHelper.MakeParam("@default_value",model.default_value),
                 ParamHelper.MakeParam("@category_no_list",model.category_no_list),
                 ParamHelper.MakeParam("@is_sub_category",model.is_sub_category?1:0),
                 ParamHelper.MakeParam("@column",model.column),
                 ParamHelper.MakeParam("@column_type",model.column_type),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@length",model.length),
                 ParamHelper.MakeParam("@list_value",model.list_value)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(FieldInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("column_index=@column_index,");
            strSql.Append("[title]=@title,");
            strSql.Append("[message]=@message,");
            strSql.Append("html_type=@html_type,");
            strSql.Append("html_depth=@html_depth,");
            strSql.Append("default_value=@default_value,");
            strSql.Append("category_no_list=@category_no_list,");
            strSql.Append("is_sub_category=@is_sub_category,");
            strSql.Append("[column]=@column,");
            strSql.Append("column_type=@column_type,");
            strSql.Append("[order]=@order,");
            strSql.Append("[length]=@length,");
            strSql.Append("[list_value]=@list_value");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@column_index",model.column_index),
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@message",model.message),
                 ParamHelper.MakeParam("@html_type",model.html_type),
                 ParamHelper.MakeParam("@html_depth",model.html_depth),
                 ParamHelper.MakeParam("@default_value",model.default_value),
                 ParamHelper.MakeParam("@category_no_list",model.category_no_list),
                 ParamHelper.MakeParam("@is_sub_category",model.is_sub_category?1:0),
                 ParamHelper.MakeParam("@column",model.column),
                 ParamHelper.MakeParam("@column_type",model.column_type),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@length",model.length),
                 ParamHelper.MakeParam("@list_value",model.list_value),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// ȡб
        /// </summary>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public static DataTable GetList(int sysModelId, string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from  [" + currTableName + "] where sys_model_id= " + sysModelId + andWhere);
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By [order],id Asc");
            }
            else
            {
                strSql.Append(" Order By [order] Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ݱ׺ȡб
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <returns></returns>
        public DataTable GetBindList(int sysModelId)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select a.*,b.name from  [" + currTableName +
                "] as a left join " +SysModel.currTableName +
                " as b on a.sys_model_id=b.id where a.sys_model_id=" + sysModelId );
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By a.[order],a.id Asc");
            }
            else
            {
                strSql.Append(" Order By a.[order] Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public int GetCount(int sysModelId, string andWhere)
        {
            string sql = "select count(1) from [" + currTableName + "] where  and sys_model_id= " + sysModelId + andWhere;
            return (int)DbHelper.GetSingle(sql);
        }
        /// <summary>
        /// Ƿĳ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colName"></param>
        /// <returns></returns>
        public bool Exists(int sysModelId, string colName)
        {
            if (colName != "")
            {
                return DbHelper.Exists("select top 1 id from  [" + currTableName + "] where sys_model_id= " + sysModelId +" and [column]='" + colName + "'");
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// Ƿֶ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colName"></param>
        /// <returns></returns>
        public bool ExistsField(int sysModelId, string colName)
        {
            if (colName != "")
            {
                return ITable.ExistsColumn(Article.currTableName + sysModelId, SqlHelper.StrFilter(colName));
            }
            else
            {
                return false;
            }
        }
    }
}

