/**********************************************************************************
 * ˵     ǩ(ݷʲ)
 * ڣ     2013.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Common;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// ҳ
    /// </summary>
    public class DataLabel
    {
        public static readonly string currTableName = SiteConfig.TablePrefix + "data_label";
        private static object lockHelper = new object();
        private static volatile Dictionary<string, string> sqlList = null;
        static DataLabel()
        {
            sqlList = new Dictionary<string, string>();
            DataTable dtList = GetSqlList();
            foreach (DataRow dr in dtList.Rows)
            {
                sqlList.Add(dr["key"].ToString(), dr["value"].ToString());
            }
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// õһʵ
        /// </summary>
        /// <param name="dr"></param> 
        /// <returns></returns>
        public DataLabelInfo GetDataLabelInfo(int id)
        {
            DataLabelInfo model = new DataLabelInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [title], [type], depth, [key], [value]", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.title = dr["title"].ToString();
                    if (dr["type"].ToString() != "")
                    {
                        model.type = int.Parse(dr["type"].ToString());
                    }
                    model.depth = dr["depth"].ToString();
                    model.key = dr["key"].ToString();
                    model.value = dr["value"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// Requestȡģ(Request.FormҲRequest.QueryStringһ)
        /// </summary>
        /// <param name="requests"></param> 
        /// <returns></returns>
        public DataLabelInfo GetDataLabelInfo(System.Collections.Specialized.NameValueCollection requests)
        {
            DataLabelInfo model = null;
            if (requests != null)
            {
                model = new DataLabelInfo();
                if (requests["id"] != null)
                {
                    model.id = int.Parse(requests["id"]);
                }
                model.title = requests["title"];
                if (requests["type"] != null)
                {
                    model.type = int.Parse(requests["type"]);
                }
                model.depth = requests["depth"];
                model.key = requests["key"];
                model.value = requests["value"];
            }
            return model;
        }
        /// <summary>
        /// õһ
        /// </summary>
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public string[] GetArray(string colNames, string andWhereOrderBy)
        {
            string[] tmpColNames = colNames.Replace("[", "").Replace("]", "").Split(',');
            int colLength = tmpColNames.Length;
            if (colLength == 0)
            {
                return null;
            }
            bool isRead = false;
            string[] strArr = new string[colLength];
            IDataReader dr = GetReader(1, colNames, andWhereOrderBy);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    for (int i = 0; i < colLength; i++)
                    {
                        strArr[i] = dr[tmpColNames[i]].ToString();
                    }
                }
                dr.Close();
            }
            return isRead ? strArr : null;
        }
        /// <summary>
        /// õһеĶ
        /// </summary>
        /// <param name="colName"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public object GetSingle(string colName, string andWhereOrderBy)
        {
            return DbHelper.GetSingle("select top 1 [" + colName + "] from " + currTableName + " where 1=1 " + andWhereOrderBy);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Exists(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
		    ParamHelper.MakeParam("@id",id)
		};
            return DbHelper.Exists(strSql.ToString(), parameters);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public bool Exists(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where 1=1 " + andWhereOrderBy);
            return DbHelper.Exists(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="strSql">SQLѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string strSql, string orderBy)
        {
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Add(DataLabelInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([title],[type],depth,[key],[value])");
            strSql.Append(" values (");
            strSql.Append("@title,@type,@depth,@key,@value)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@depth",model.depth),
                 ParamHelper.MakeParam("@key",model.key),
                 ParamHelper.MakeParam("@value",model.value)
             };
            if (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0)
            {
                if (model.type != 0)
                {
                    DataCache.SetCache(model.key, model.value);
                }
                else
                {
                    if (sqlList.ContainsKey(model.key))
                    {
                        lock (lockHelper)
                        {
                            if (sqlList.ContainsKey(model.key))
                            {
                                sqlList.Add(model.key, model.value);
                            }
                        }
                    }
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Update(DataLabelInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("[title]=@title,");
            strSql.Append("[type]=@type,");
            strSql.Append("depth=@depth,");
            strSql.Append("[key]=@key,");
            strSql.Append("[value]=@value");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@depth",model.depth),
                 ParamHelper.MakeParam("@key",model.key),
                 ParamHelper.MakeParam("@value",model.value),
                 ParamHelper.MakeParam("@id",model.id)
             };
            if (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0)
            {
                if (model.type != 0)
                {
                    DataCache.SetCache(model.key, model.value);
                }
                else
                {
                    if (sqlList.ContainsKey(model.key))
                    {
                        lock (lockHelper)
                        {
                            if (sqlList.ContainsKey(model.key))
                            {
                                sqlList[model.key] = model.value;
                            }
                        }
                    }
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// ɾһ
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            DataLabelInfo model = GetDataLabelInfo(id);
            if (model != null)
            {
                if (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0)
                {
                    if (model.type != 0)
                    {
                        DataCache.Remove(model.key);
                    }
                    else
                    {
                        if (sqlList.ContainsKey(model.key))
                        {
                            lock (lockHelper)
                            {
                                if (sqlList.ContainsKey(model.key))
                                {
                                    sqlList.Remove(model.key);
                                }
                            }
                        }
                    }
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// б
        /// </summary>
        /// <returns></returns>
        private static DataTable GetSqlList()
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select  [type], [key], [value]");
            strSql.Append(" from " + currTableName);
            strSql.Append(" where [type]=0 ");
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ȡSQL
        /// </summary>
        /// <param name="sqlkey"></param>
        /// <returns></returns>
        public static string GetSqlValue(string sqlkey)
        {
            string sValue = "";
            sqlList.TryGetValue(sqlkey, out sValue);
            return sValue;
        }
        /// <summary>
        /// ȡֵ
        /// </summary>
        /// <param name="strkey"></param>
        /// <returns></returns>
        public static string GetKeyValue(string strkey)
        {
            object obj = DataCache.GetCache(strkey);
            if (obj == null)
            {
                obj = DbHelper.GetSingle("select top 1 [value] from " + currTableName + " where [type]<>0 and [key]=" + SqlHelper.FieldFilter(strkey));
                if (obj == null)
                {
                    obj = strkey + " is null";
                }
                DataCache.SetCache(strkey, obj);
            }
            return obj.ToString();
        }
    }
}

