/**********************************************************************************
 * ˵     (ݷʲ)
 * ڣ     2013.07.15
 * ޸ڣ     2013.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Common;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// ҳ
    /// </summary>
    public class DataForm
    {
        public static readonly string currTableName = SiteConfig.TablePrefix + "data_form";
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Add(DataFormInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([title],table_name,table_id_name,search_fields,operate_fields,search_html,back_html,[state],is_captcha,is_logined,ext_nav,add_url,upt_url,del_url,headcode)");
            strSql.Append(" values (");
            strSql.Append("@title,@table_name,@table_id_name,@search_fields,@operate_fields,@search_html,@back_html,@state,@is_captcha,@is_logined,@ext_nav,@add_url,@upt_url,@del_url,@headcode)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@table_name",model.table_name),
                 ParamHelper.MakeParam("@table_id_name",model.table_id_name),
                 ParamHelper.MakeParam("@search_fields",model.search_fields),
                 ParamHelper.MakeParam("@operate_fields",model.operate_fields),
                 ParamHelper.MakeParam("@search_html",model.search_html),
                 ParamHelper.MakeParam("@back_html",model.back_html),
                 ParamHelper.MakeParam("@state",model.state),
                 ParamHelper.MakeParam("@is_captcha",model.is_captcha),
                 ParamHelper.MakeParam("@is_logined",model.is_logined),
                 ParamHelper.MakeParam("@ext_nav",model.ext_nav),
                 ParamHelper.MakeParam("@add_url",model.add_url),
                 ParamHelper.MakeParam("@upt_url",model.upt_url),
                 ParamHelper.MakeParam("@del_url",model.del_url),
                 ParamHelper.MakeParam("@headcode",model.headcode)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// һ
        /// </summary>
        /// <param name="model"></param> 
        /// <returns></returns>
        public bool Update(DataFormInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("[title]=@title,");
            strSql.Append("table_name=@table_name,");
            strSql.Append("table_id_name=@table_id_name,");
            strSql.Append("search_fields=@search_fields,");
            strSql.Append("operate_fields=@operate_fields,");
            strSql.Append("search_html=@search_html,");
            strSql.Append("back_html=@back_html,");
            strSql.Append("[state]=@state,");
            strSql.Append("is_captcha=@is_captcha,");
            strSql.Append("is_logined=@is_logined,");
            strSql.Append("ext_nav=@ext_nav,");
            strSql.Append("add_url=@add_url,");
            strSql.Append("upt_url=@upt_url,");
            strSql.Append("del_url=@del_url,");
            strSql.Append("headcode=@headcode");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@table_name",model.table_name),
                 ParamHelper.MakeParam("@table_id_name",model.table_id_name),
                 ParamHelper.MakeParam("@search_fields",model.search_fields),
                 ParamHelper.MakeParam("@operate_fields",model.operate_fields),
                 ParamHelper.MakeParam("@search_html",model.search_html),
                 ParamHelper.MakeParam("@back_html",model.back_html),
                 ParamHelper.MakeParam("@state",model.state),
                 ParamHelper.MakeParam("@is_captcha",model.is_captcha),
                 ParamHelper.MakeParam("@is_logined",model.is_logined),
                 ParamHelper.MakeParam("@ext_nav",model.ext_nav),
                 ParamHelper.MakeParam("@add_url",model.add_url),
                 ParamHelper.MakeParam("@upt_url",model.upt_url),
                 ParamHelper.MakeParam("@del_url",model.del_url),
                 ParamHelper.MakeParam("@headcode",model.headcode),
                 ParamHelper.MakeParam("@id",model.id)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="fields"></param> 
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Update(List<Model_Field> fields, string andWhere)
        {
            if (fields.Count <= 0)
            {
                return false;
            }
            StringBuilder sbField = new StringBuilder();
            foreach (Model_Field field in fields)
            {
                if (field.fieldType == Type_Field.integerType)
                {
                    sbField.Append("," + field.fieldName + "=" + (string.IsNullOrEmpty(field.fieldValue) ? "0" : field.fieldValue));
                }
                else
                {
                    sbField.Append("," + field.fieldName + "='" + field.fieldValue.Replace("'", "''") + "'");
                }
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append(sbField.ToString().TrimStart(','));
            strSql.Append(" where 1=1 " + andWhere);
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// ɾһ
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			ParamHelper.MakeParam("@id",id)
		};
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// õһʵ
        /// </summary>
        /// <param name="dr"></param> 
        /// <returns></returns>
        public DataFormInfo GetDataFormInfo(int id)
        {
            DataFormInfo model = new DataFormInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [title], table_name, table_id_name, search_fields, operate_fields, search_html, back_html, [state], is_captcha, is_logined, ext_nav, add_url, upt_url, del_url, headcode", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.title = dr["title"].ToString();
                    model.table_name = dr["table_name"].ToString();
                    model.table_id_name = dr["table_id_name"].ToString();
                    model.search_fields = dr["search_fields"].ToString();
                    model.operate_fields = dr["operate_fields"].ToString();
                    model.search_html = dr["search_html"].ToString();
                    model.back_html = dr["back_html"].ToString();
                    if (dr["state"].ToString() != "")
                    {
                        model.state = int.Parse(dr["state"].ToString());
                    }
                    if (dr["is_captcha"].ToString() != "")
                    {
                        model.is_captcha = int.Parse(dr["is_captcha"].ToString());
                    }
                    if (dr["is_logined"].ToString() != "")
                    {
                        model.is_logined = int.Parse(dr["is_logined"].ToString());
                    }
                    model.ext_nav = dr["ext_nav"].ToString();
                    model.add_url = dr["add_url"].ToString();
                    model.upt_url = dr["upt_url"].ToString();
                    model.del_url = dr["del_url"].ToString();
                    model.headcode = dr["headcode"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// Requestȡģ(Request.FormҲRequest.QueryStringһ)
        /// </summary>
        /// <param name="requests"></param> 
        /// <returns></returns>
        public DataFormInfo GetDataFormInfo(System.Collections.Specialized.NameValueCollection requests)
        {
            DataFormInfo model = null;
            if (requests != null)
            {
                model = new DataFormInfo();
                if (requests["id"] != null)
                {
                    model.id = int.Parse(requests["id"]);
                }
                model.title = requests["title"];
                model.table_name = requests["table_name"];
                model.table_id_name = requests["table_id_name"];
                model.search_fields = requests["search_fields"];
                model.operate_fields = requests["operate_fields"];
                model.search_html = requests["search_html"];
                model.back_html = requests["back_html"];
                if (requests["state"] != null)
                {
                    model.state = int.Parse(requests["state"]);
                }
                if (requests["is_captcha"] != null)
                {
                    model.is_captcha = int.Parse(requests["is_captcha"]);
                }
                if (requests["is_logined"] != null)
                {
                    model.is_logined = int.Parse(requests["is_logined"]);
                }
                model.ext_nav = requests["ext_nav"];
                model.add_url = requests["add_url"];
                model.upt_url = requests["upt_url"];
                model.del_url = requests["del_url"];
                model.headcode = requests["headcode"];
            }
            return model;
        }
        /// <summary>
        /// õһ
        /// </summary>
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public string[] GetArray(string colNames, string andWhereOrderBy)
        {
            string[] tmpColNames = colNames.Replace("[", "").Replace("]", "").Split(',');
            int colLength = tmpColNames.Length;
            if (colLength == 0)
            {
                return null;
            }
            bool isRead = false;
            string[] strArr = new string[colLength];
            IDataReader dr = GetReader(1, colNames, andWhereOrderBy);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    for (int i = 0; i < colLength; i++)
                    {
                        strArr[i] = dr[tmpColNames[i]].ToString();
                    }
                }
                dr.Close();
            }
            return isRead ? strArr : null;
        }
        /// <summary>
        /// õһеĶ
        /// </summary>
        /// <param name="colName"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public object GetSingle(string colName, string andWhereOrderBy)
        {
            return DbHelper.GetSingle("select top 1 [" + colName + "] from " + currTableName + " where 1=1 " + andWhereOrderBy);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public bool Exists(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
		    ParamHelper.MakeParam("@id",id)
		};
            return DbHelper.Exists(strSql.ToString(), parameters);
        }
        /// <summary>
        /// Ƿڸü¼
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public bool Exists(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from ");
            strSql.Append(currTableName);
            strSql.Append(" where 1=1 " + andWhereOrderBy);
            return DbHelper.Exists(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="strSql">SQLѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string strSql, string orderBy)
        {
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql, orderBy));
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// ӱ
        /// </summary>
        public bool AddRecord(DataFormInfo model)
        {
            
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into [" + model.table_name + "]");
            string[] arrFields = model.operate_fields.Split(',');
            StringBuilder sbField = new StringBuilder();
            StringBuilder sbValue = new StringBuilder();
            foreach (string field in arrFields)
            {
                string[] arrField = Utils.SplitString(field, ":");
                if (arrField.Length != 2)
                {
                    return false;
                }
                string strField = arrField[0].Trim();
                string strType = arrField[1].Trim();
                sbField.Append("["+strField + "],");
                string fValue = model.GetField(strField);
                if (strType == Type_Field.integerType)
                {
                    sbValue.Append((Utils.IsNumeric(fValue) ? fValue : "0") + ",");
                }
                else
                {
                    sbValue.Append(SqlHelper.FieldFilter(fValue) + ",");
                }
            }
            strSql.Append(" (" + sbField.ToString().TrimEnd(',') + ") values (");
            strSql.Append(sbValue.ToString().TrimEnd(','));
            strSql.Append(")");
            SysManager.LogDebugWriteln(this.GetType(), strSql.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// ±
        /// </summary>
        /// <param name="model"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public bool UpdateRecord(DataFormInfo model,string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update [" + model.table_name + "] set ");
            string[] arrFields = model.operate_fields.Split(',');
            StringBuilder sbFildValue = new StringBuilder();
            foreach (string field in arrFields)
            {
                string[] arrField = Utils.SplitString(field, ":");
                if (arrField.Length != 2)
                {
                    return false;
                }
                string strField = arrField[0].Trim();
                string strType = arrField[1].Trim();
                string fValue = "";
                if (model.TryGetField(strField, out fValue))
                {
                    if (strType == Type_Field.integerType)
                    {
                        sbFildValue.Append("[" + strField + "]=" + (Utils.IsNumeric(fValue) ? fValue : "0") + ",");
                    }
                    else
                    {
                        sbFildValue.Append("[" + strField + "]=" + SqlHelper.FieldFilter(fValue) + ",");
                    }
                }
            }
            strSql.Append(sbFildValue.ToString().TrimEnd(',') + " where 1=1 " + andWhere);
            SysManager.LogDebugWriteln(this.GetType(), strSql.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="model"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public bool DeleteRecord(DataFormInfo model, string andWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from [" + model.table_name+"]");
            strSql.Append(" where 1=1 " + andWhere);
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// õб
        /// </summary>
        /// <param name="model"></param>
        /// <param name="topCount"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public DataTable GetRecordList(DataFormInfo model, int topCount, string andWhere)
        {
            string sql = "select top " + topCount + " * from [" +model.table_name + "] where 1=1 " + andWhere;
            return DbHelper.GetDataTable(sql);
        }
  
        /// <summary>
        /// õб
        /// </summary>
        /// <param name="model">ģ</param> 
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetRecordList(DataFormInfo model, int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + model.table_name);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// õб()
        /// </summary>
        /// <param name="model">ģ</param> 
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <param name="joinAsTableName">ӱ</param>
        /// <param name="joinColNames"></param>
        /// <param name="joinOn"></param>
        /// <returns></returns>
        public DataTable GetRecordList(DataFormInfo model, int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy, string joinAsTableName, string joinColNames, string joinOn)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + model.table_name);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            return DbHelper.GetDataTable(SqlHelper.Join(sql, joinAsTableName, joinColNames, joinOn));
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="model"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public int GetRecordCount(DataFormInfo model, string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + model.table_name + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
    
    }
}

