/**********************************************************************************
 * ˵     ޼Ŀ(ݷʲ)
 * ڣ     2009.6.13
 * ޸ڣ     2012.02.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Database;
using PlugNT.Database.Common;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Common;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// ޼Ŀ
    /// </summary>
    public class Channel
    {
        public static string currTableName = SiteConfig.TablePrefix + "channel";
        private static object lockHelper = new object();
        private static volatile Dictionary<int, int> sysModelIdList = null;
        static Channel()
        {
            sysModelIdList = new Dictionary<int, int>();
            DataTable dt = DbHelper.GetDataTable("select [id],sys_model_id from " + currTableName);
            foreach (DataRow dr in dt.Rows)
            {
                sysModelIdList.Add(int.Parse(dr["id"].ToString()), int.Parse(dr["sys_model_id"].ToString()));
            }
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static string GetTitle(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [title] from " + currTableName);
            strSql.Append(" where id=" + id);
            return Convert.ToString(DbHelper.GetSingle(strSql.ToString()));
        }
        /// <summary>
        /// õģID(ڴ)
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static int GetSysModelId(int id)
        {
            int sysModelId = 0;
            sysModelIdList.TryGetValue(id, out sysModelId);
            return sysModelId;
        }
        /// <summary>
        /// ȡؼб
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static string GetKeyList(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [keylist] from " + currTableName);
            strSql.Append(" where id=" + id);
            return Convert.ToString(DbHelper.GetSingle(strSql.ToString()));
        }
        /// <summary>
        /// жϹؼбǷжӦֵ
        /// </summary>
        /// <param name="keylist"></param>
        /// <param name="key"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool ContainsKeyValue(string keylist, string key,string value)
        {
            return ("," + keylist + ",").Contains("," + key + ":" + value + ",");
        }
        /// <summary>
        /// ǷID(ڴ)
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static bool Exists(int id)
        {
            return sysModelIdList.ContainsKey(id);
        }
        /// <summary>
        /// õж
        /// </summary>
        /// <param name="colName"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public string GetObjectString(string colName, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [" + colName + "] from " + currTableName);
            strSql.Append(" where 1=1 " + andWhereOrderBy);
            return Convert.ToString(DbHelper.GetSingle(strSql.ToString()));
        }
        /// <summary>
        /// ȡno_list
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetNoList(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 no_list from " + currTableName);
            strSql.Append(" where id=" + id);
            return Convert.ToString(DbHelper.GetSingle(strSql.ToString()));
        }
        /// <summary>
        /// õID
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public int GetParentId(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 parent_id from " + currTableName);
            strSql.Append(" where [id]=" + id);
            object obj = DbHelper.GetSingle(strSql.ToString());
            return obj == null ? 0 : int.Parse(obj.ToString());
        }
        /// <summary>
        /// õID
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public int GetId(string no)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from " + currTableName);
            strSql.Append(" where [no]=" + SqlHelper.FieldFilter(no));
            object obj = DbHelper.GetSingle(strSql.ToString());
            return obj == null ? 0 : int.Parse(obj.ToString());
        }
        /// <summary>
        /// õ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetUrl(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [url] from " + currTableName);
            strSql.Append(" where [id]=" +id);
            object obj = DbHelper.GetSingle(strSql.ToString());
            return obj == null ? "" : obj.ToString();
        }
        /// <summary>
        /// õģ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public ChannelInfo GetChannelInfo(int id)
        {
            ChannelInfo model = new ChannelInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [no], sys_model_id, [title], tag, no_list, parent_id, no_list_len, [order], has_sub, url, keywords, [description], [content], addtime, is_create_static, is_ziphtml, is_single, is_front_show, keylist, keyhtml, article_path", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.no = dr["no"].ToString();
                    if (dr["sys_model_id"].ToString() != "")
                    {
                        model.sys_model_id = int.Parse(dr["sys_model_id"].ToString());
                    }
                    model.title = dr["title"].ToString();
                    model.tag = dr["tag"].ToString();
                    model.no_list = dr["no_list"].ToString();
                    if (dr["parent_id"].ToString() != "")
                    {
                        model.parent_id = int.Parse(dr["parent_id"].ToString());
                    }
                    if (dr["no_list_len"].ToString() != "")
                    {
                        model.no_list_len = int.Parse(dr["no_list_len"].ToString());
                    }
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    if (dr["has_sub"].ToString() != "")
                    {
                        model.has_sub = dr["has_sub"].ToString()=="1";
                    }
                    model.url = dr["url"].ToString();
                    model.keywords = dr["keywords"].ToString();
                    model.description = dr["description"].ToString();
                    model.content = dr["content"].ToString();
                    if (dr["addtime"].ToString() != "")
                    {
                        model.addtime = DateTime.Parse(dr["addtime"].ToString());
                    }
                    if (dr["is_create_static"].ToString() != "")
                    {
                        model.is_create_static = dr["is_create_static"].ToString()=="1";
                    }
                    if (dr["is_ziphtml"].ToString() != "")
                    {
                        model.is_ziphtml = dr["is_ziphtml"].ToString() == "1";
                    }
                    if (dr["is_single"].ToString() != "")
                    {
                        model.is_single = dr["is_single"].ToString()=="1";
                    }
                    if (dr["is_front_show"].ToString() != "")
                    {
                        model.is_front_show = dr["is_front_show"].ToString() == "1";
                    }
                    model.keylist = dr["keylist"].ToString();
                    model.keyhtml = dr["keyhtml"].ToString();
                    model.article_path = dr["article_path"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// õģ
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public ChannelInfo GetChannelInfo(string no)
        {
            ChannelInfo model = new ChannelInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [no], sys_model_id, [title], tag, no_list, parent_id, no_list_len, [order], has_sub, url, keywords, [description], [content], addtime, is_create_static, is_ziphtml, is_single, is_front_show, keylist, keyhtml, article_path", " and [no]=" + SqlHelper.FieldFilter(no));
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.no = dr["no"].ToString();
                    if (dr["sys_model_id"].ToString() != "")
                    {
                        model.sys_model_id = int.Parse(dr["sys_model_id"].ToString());
                    }
                    model.title = dr["title"].ToString();
                    model.tag = dr["tag"].ToString();
                    model.no_list = dr["no_list"].ToString();
                    if (dr["parent_id"].ToString() != "")
                    {
                        model.parent_id = int.Parse(dr["parent_id"].ToString());
                    }
                    if (dr["no_list_len"].ToString() != "")
                    {
                        model.no_list_len = int.Parse(dr["no_list_len"].ToString());
                    }
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    if (dr["has_sub"].ToString() != "")
                    {
                        model.has_sub = dr["has_sub"].ToString() == "1";
                    }
                    model.url = dr["url"].ToString();
                    model.keywords = dr["keywords"].ToString();
                    model.description = dr["description"].ToString();
                    model.content = dr["content"].ToString();
                    if (dr["addtime"].ToString() != "")
                    {
                        model.addtime = DateTime.Parse(dr["addtime"].ToString());
                    }
                    if (dr["is_create_static"].ToString() != "")
                    {
                        model.is_create_static = dr["is_create_static"].ToString() == "1";
                    }
                    if (dr["is_ziphtml"].ToString() != "")
                    {
                        model.is_ziphtml = dr["is_ziphtml"].ToString() == "1";
                    }
                    if (dr["is_single"].ToString() != "")
                    {
                        model.is_single = dr["is_single"].ToString() == "1";
                    }
                    if (dr["is_front_show"].ToString() != "")
                    {
                        model.is_front_show = dr["is_front_show"].ToString() == "1";
                    }
                    model.keylist = dr["keylist"].ToString();
                    model.keyhtml = dr["keyhtml"].ToString();
                    model.article_path = dr["article_path"].ToString();
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
            
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataRow GetChannelRow(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 * from " + currTableName);
            strSql.Append(" where id=" + id.ToString());
            DataTable dt = DbHelper.GetDataTable(strSql.ToString());
            if (dt.Rows.Count > 0)
            {
                return dt.Rows[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// õһ
        /// </summary>
        /// <param name="colNames"></param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public string[] GetArray(string colNames, string andWhereOrderBy)
        {
            string[] tmpColNames = colNames.Replace("[", "").Replace("]", "").Split(',');
            int colLength = tmpColNames.Length;
            if (colLength == 0)
            {
                return null;
            }
            bool isRead = false;
            string[] strArr = new string[colLength];
            IDataReader dr = GetReader(1, colNames, andWhereOrderBy);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    for (int i = 0; i < colLength; i++)
                    {
                        strArr[i] = dr[tmpColNames[i]].ToString();
                    }
                }
                dr.Close();
            }
            return isRead ? strArr : null;
        }
        /// <summary>
        /// һĿ
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(ChannelInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([no],sys_model_id,[title],[tag],no_list,parent_id,no_list_len,[order],has_sub,[url],[keywords],[description],[content],[addtime],is_create_static,is_ziphtml,is_single,is_front_show,keylist,keyhtml,article_path)");
            strSql.Append(" values (");
            strSql.Append("@no,@sys_model_id,@title,@tag,@no_list,@parent_id,@no_list_len,@order,@has_sub,@url,@keywords,@description,@content,@addtime,@is_create_static,@is_ziphtml,@is_single,@is_front_show,@keylist,@keyhtml,@article_path)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@no",model.no),
                 ParamHelper.MakeParam("@sys_model_id",model.sys_model_id),
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@tag",model.tag),
                 ParamHelper.MakeParam("@no_list",model.no_list),
                 ParamHelper.MakeParam("@parent_id",model.parent_id),
                 ParamHelper.MakeParam("@no_list_len",model.no_list_len),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@has_sub",model.has_sub?1:0),
                 ParamHelper.MakeParam("@url",model.url),
                 ParamHelper.MakeParam("@keywords",model.keywords),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@content",model.content),
                 ParamHelper.MakeParam("@addtime",model.addtime.ToString()),
                 ParamHelper.MakeParam("@is_create_static",model.is_create_static?1:0),
                 ParamHelper.MakeParam("@is_ziphtml",model.is_ziphtml?1:0),
                 ParamHelper.MakeParam("@is_single",model.is_single?1:0),
                 ParamHelper.MakeParam("@is_front_show",model.is_front_show?1:0),
                 ParamHelper.MakeParam("@keylist",model.keylist),
                 ParamHelper.MakeParam("@keyhtml",model.keyhtml),
                 ParamHelper.MakeParam("@article_path",model.article_path)
             };
            if (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0)
            {
                UpdateHasSub(model.parent_id);
                int channelId=GetId(model.no);
                if (channelId > 0)
                {
                    if (!sysModelIdList.ContainsKey(channelId))
                    {
                        lock (lockHelper)
                        {
                            if (!sysModelIdList.ContainsKey(channelId))
                            {
                                sysModelIdList.Add(channelId, model.sys_model_id);
                            }
                        }
                    }
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        private bool UpdateHasSub(int id)
        {
            if (ExistsParent(id))
            {
                return DbHelper.ExecuteSql("update " + currTableName + " set has_sub=1  where id=" + id) > 0;
            }
            else
            {
                return DbHelper.ExecuteSql("update " + currTableName + " set has_sub=0  where id=" + id) > 0;
            }
        }
        /// <summary>
        /// ༭һĿ
        /// </summary>
        /// <param name="model"></param>
        /// <param name="isSubModel">Ƿ¼</param>
        /// <returns></returns>
        public bool Update(ChannelInfo model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("[no]=@no,");
            strSql.Append("sys_model_id=@sys_model_id,");
            strSql.Append("[title]=@title,");
            strSql.Append("[tag]=@tag,");
            strSql.Append("no_list=@no_list,");
            strSql.Append("parent_id=@parent_id,");
            strSql.Append("no_list_len=@no_list_len,");
            strSql.Append("[order]=@order,");
            strSql.Append("has_sub=@has_sub,");
            strSql.Append("[url]=@url,");
            strSql.Append("keywords=@keywords,");
            strSql.Append("[description]=@description,");
            strSql.Append("[content]=@content,");
            strSql.Append("[addtime]=@addtime,");
            strSql.Append("is_create_static=@is_create_static,");
            strSql.Append("is_ziphtml=@is_ziphtml,");
            strSql.Append("is_single=@is_single,");
            strSql.Append("is_front_show=@is_front_show,");
            strSql.Append("keylist=@keylist,");
            strSql.Append("keyhtml=@keyhtml,");
            strSql.Append("article_path=@article_path");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@no",model.no),
                 ParamHelper.MakeParam("@sys_model_id",model.sys_model_id),
                 ParamHelper.MakeParam("@title",model.title),
                 ParamHelper.MakeParam("@tag",model.tag),
                 ParamHelper.MakeParam("@no_list",model.no_list),
                 ParamHelper.MakeParam("@parent_id",model.parent_id),
                 ParamHelper.MakeParam("@no_list_len",model.no_list_len),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@has_sub",model.has_sub?1:0),
                 ParamHelper.MakeParam("@url",model.url),
                 ParamHelper.MakeParam("@keywords",model.keywords),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@content",model.content),
                 ParamHelper.MakeParam("@addtime",model.addtime.ToString()),
                 ParamHelper.MakeParam("@is_create_static",model.is_create_static?1:0),
                 ParamHelper.MakeParam("@is_ziphtml",model.is_ziphtml?1:0),
                 ParamHelper.MakeParam("@is_single",model.is_single?1:0),
                 ParamHelper.MakeParam("@is_front_show",model.is_front_show?1:0),
                 ParamHelper.MakeParam("@keylist",model.keylist),
                 ParamHelper.MakeParam("@keyhtml",model.keyhtml),
                 ParamHelper.MakeParam("@article_path",model.article_path),
                 ParamHelper.MakeParam("@id",model.id)
             };
            if (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0)
            {
                UpdateHasSub(model.parent_id);
                int sysModelId = GetSysModelId(model.id);
                if (sysModelId!=model.sys_model_id)
                {
                    if (sysModelIdList.ContainsKey(model.id))
                    {
                        lock (lockHelper)
                        {
                            if (sysModelIdList.ContainsKey(model.id))
                            {
                                sysModelIdList[model.id] = model.sys_model_id;
                            }
                        }
                    }
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="fields"></param> 
        /// <param name="andWhere"></param> 
        /// <returns></returns>
        public bool Update(List<Model_Field> fields, string andWhere)
        {
            if (fields.Count <= 0)
            {
                return false;
            }
            StringBuilder sbField = new StringBuilder();
            foreach (Model_Field field in fields)
            {
                if (field.fieldType == Type_Field.integerType)
                {
                    sbField.Append("," + field.fieldName + "=" + (string.IsNullOrEmpty(field.fieldValue) ? "0" : field.fieldValue));
                }
                else
                {
                    sbField.Append("," + field.fieldName + "='" + field.fieldValue.Replace("'", "''") + "'");
                }
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append(sbField.ToString().TrimStart(','));
            strSql.Append(" where 1=1 " + andWhere);
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <param name="tarId"></param>
        /// <returns></returns>
        public bool SwapOrder(int id, int tarId)
        {
            string error="";
            List<string> sqlList = new List<string>();
            string idOrder = GetObjectString("order", "and id=" + id);
            string tarIdOrder = GetObjectString("order", "and id=" + tarId);
            if (idOrder != "")
            {
                sqlList.Add("update " + currTableName + " set [order]=" + idOrder + " where id=" + tarId);
            }
            if (tarIdOrder != "")
            {
                sqlList.Add("update " + currTableName + " set [order]=" + tarIdOrder + " where id=" + id);
            }
            if (sqlList.Count != 2)
            {
                return false;
            }
            return DbHelper.ExecuteSqlTran(sqlList, out error) > 0;
        }
        /// <summary>
        /// ɾĿ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            StringBuilder strSql = new StringBuilder();
            string[] arr = GetArray("parent_id,no_list", "and [id]=" + id);
            if (arr != null)
            {
                DataTable dt = DbHelper.GetDataTable("select [id] from " + currTableName + " where no_list like '" + arr[1] + "%'");
                strSql.Append("Delete From " + currTableName);
                strSql.Append(" where no_list like '" + arr[1] + "%'");
                
                if (DbHelper.ExecuteSql(strSql.ToString()) > 0)
                {
                    UpdateHasSub(int.Parse(arr[0]));
                    lock (lockHelper)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            int channelId = int.Parse(dr["id"].ToString());
                            if (sysModelIdList.ContainsKey(channelId))
                            {
                                sysModelIdList.Remove(channelId);
                            }
                        }
                    }
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
   
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// жһǷ
        /// </summary>
        public bool ExistsParent(int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 [id] from " + currTableName);
            strSql.Append(" where parent_id=" + id);
            return DbHelper.Exists(strSql.ToString());
        }
        /// <summary>
        ///  õĿ˵(ģ)
        /// </summary>
        /// <param name="noList"></param>
        /// <returns></returns>
        public DataTable GetMenuList(string noList)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select a.id,a.no,a.sys_model_id,a.title,a.tag,a.no_list,a.parent_id,a.no_list_len,a.[order],a.has_sub,a.url,a.is_create_static,a.is_single,a.is_ziphtml,b.has_show_templet from ");
            strSql.Append(Channel.currTableName + " as a left join (select distinct channel_id,");
            if (SiteConfig.IsAccess)
            {
                strSql.Append("IIf([type]=3,1,0) as has_show_templet");
            }
            else
            {
                strSql.Append("(case [type] when 3 then 1 else 0 end) as has_show_templet");
            }
            strSql.Append(" from " + Templet.currTableName + " where [type]=3) as b on a.id=b.channel_id");
            if (noList != "")
            {
                strSql.Append(" where a.no_list like " + SqlHelper.FieldFilter(noList + "%")+" ");
            }
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By a.[order],a.id Asc");
            }
            else
            {
                strSql.Append(" Order By a.[order] Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        ///// <summary>
        ///// õ(ļ)б
        ///// </summary>
        ///// <param name="sysModelId"></param>
        ///// <param name="noList"></param>
        ///// <returns></returns>
        /// <summary>
        /// ȡĿб
        /// </summary>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public DataTable GetList(string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,[no],sys_model_id,title,tag,no_list,parent_id,no_list_len,[order],has_sub,url,is_create_static,is_single,is_ziphtml from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ȡĿб1(order)
        /// </summary>
        /// <param name="noList"></param>
        /// <returns></returns>
        public DataTable GetOrderList(string noList)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,[no],sys_model_id,title,tag,no_list,parent_id,no_list_len,[order],has_sub,url,is_create_static,is_single,is_ziphtml from " + currTableName);
            if (noList != "")
            {
                strSql.Append(" where no_list like " + SqlHelper.FieldFilter(noList + "%") + " ");
            }
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By [order],id Asc");
            }
            else
            {
                strSql.Append(" Order By [order] Asc"); 
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ȡĿб2(order)
        /// </summary>
        /// <param name="noList"></param>
        /// <param name="lenIndex"></param>
        /// <returns></returns>
        public DataTable GetOrderList(string noList, int lenIndex)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,[no],sys_model_id,title,tag,no_list,parent_id,no_list_len,[order],has_sub,url,is_create_static,is_single,is_ziphtml from " + currTableName + " where 1=1 ");
            if (noList != "")
            {
                strSql.Append(" and no_list like " + SqlHelper.FieldFilter(noList + "%") + " ");
            }
            if (lenIndex > 0)
            {
                strSql.Append(" and no_list_len <= " + lenIndex);
            }
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By [order],id Asc");
            }
            else
            {
                strSql.Append(" Order By [order] Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ȡĿб(no_list)
        /// </summary>
        /// <returns></returns>
        public DataTable GetNolistList(string noList)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,[no],sys_model_id,title,tag,no_list,parent_id,no_list_len,[order],has_sub,url,is_create_static,is_single,is_ziphtml from " + currTableName);
            if (noList != "")
            {
                strSql.Append(" where no_list like " + SqlHelper.FieldFilter(noList + "%") + " ");
            }
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By no_list,id Asc");
            }
            else
            {
                strSql.Append(" Order By no_list Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// ȡĿĿ(IDΪ0ʱĿ)
        /// </summary>
        /// <param name="id"></param>
        /// <param name="incCurrent"></param>
        /// <returns></returns>
        public DataTable GetSubList(int id, bool incCurrent)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,[no],sys_model_id,title,tag,no_list,parent_id,no_list_len,[order],has_sub,url,is_create_static,is_single,is_ziphtml from " + currTableName);
            if (id > 0)
            {
                strSql.Append(" where" + (incCurrent ? " [id]=" + id + " or" : "") + " parent_id=" + id);
            }
            else
            {
                strSql.Append(" where parent_id=0");
            }
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By [order],id Asc");
            }
            else
            {
                strSql.Append(" Order By [order] Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
            
        }
        /// <summary>
        /// ȡĿĿ
        /// </summary>
        /// <param name="noList"></param>
        /// <param name="incCurrent"></param>
        /// <returns></returns>
        public DataTable GetSubList(string noList,bool incCurrent)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select id,[no],sys_model_id,title,tag,no_list,parent_id,no_list_len,[order],has_sub,url,is_create_static,is_single,is_ziphtml from " + currTableName);
            strSql.Append(" where " + (incCurrent ? " no_list='" + noList + "' or" : "") + " parent_id=(select top 1 id from " + currTableName + " where no_list='" + noList + "')");
            if (SiteConfig.IsAccess)
            {
                strSql.Append(" Order By [order],id Asc");
            }
            else
            {
                strSql.Append(" Order By [order] Asc");
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
    }
}

