/**********************************************************************************
 * ˵     Ϣ(ݷʲ)
 * ڣ     2009.6.13
 * ޸ڣ     2012.07.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Reflection;
using System.Collections.Specialized;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Common;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// Ϣ
    /// </summary>
    public class Article
    {
        public static readonly string currTableName = SiteConfig.TablePrefix + "article_";
  
        /// <summary>
        /// õһеĶ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colName"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static object GetSingle(int sysModelId, string colName, string andWhereOrderBy)
        {
            if (!PlugNT.Common.Utils.IsSafeSqlString(colName))
            {
                throw new Exception(":" + colName + "Σַ");
            }
            return DbHelper.GetSingle("select top 1 [" + colName + "] from " + currTableName + sysModelId + " where 1=1 " + andWhereOrderBy);
        }
        /// <summary>
        /// õеĶ(ַ)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public static string[] GetArray(int sysModelId, string colNames, string andWhereOrderBy)
        {
            string []reValue = null;
            string columns = colNames.Trim();
            if (columns != "")
            {
                string[] arr = columns.Replace("[", "").Replace("]", "").Split(',');
                IDataReader dr = GetReader(sysModelId, 1, columns, andWhereOrderBy);
                if (dr != null)
                {
                    bool dRead = false;
                    if (dr.Read())
                    {
                        int alen = arr.Length;
                        for (int i = 0; i < alen; i++)
                        {
                            arr[i] = dr[arr[i]].ToString();
                        }
                        dRead = true;
                    }
                    dr.Close();
                    if (dRead)
                    {
                        reValue = arr;
                    }
                }
            }
            return reValue;
        }
        /// <summary>
        /// õеĶ(ַ)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhere"></param>
        /// <returns></returns>
        public StringDictionary GetDictionary(int sysModelId, string colNames, string andWhere)
        {
            StringDictionary reValue = null;
            string columns = colNames.Trim();
            if (columns != "")
            {
                string[] arr = columns.Replace("[", "").Replace("]", "").Split(',');
                IDataReader dr = GetReader(sysModelId, 1, columns, andWhere);
                if (dr != null)
                {
                    if (dr.Read())
                    {
                        reValue = new StringDictionary();
                        int alen = arr.Length;
                        for (int i = 0; i < alen; i++)
                        {
                            reValue.Add(dr.GetName(i), dr[i].ToString());
                        }
                    }
                    dr.Close();
                }
            }
            return reValue;
        }
        /// <summary>
        /// ȡһʵ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public ArticleInfo GetArticleInfo(int sysModelId, int id)
        {
            bool isRead = false;
            string[] strArr = new string[9];
            IDataReader dr = GetReader(sysModelId, 1, "*", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    isRead = true;
                    strArr[0] = dr["id"].ToString();
                    strArr[1] = dr["no"].ToString();
                    strArr[2] = dr["title"].ToString();
                    strArr[3] = dr["channel_id"].ToString();
                    strArr[4] = dr["contents"].ToString();
                    strArr[5] = dr["commend"].ToString();
                    strArr[6] = dr["stick"].ToString();
                    strArr[7] = dr["publish"].ToString();
                    strArr[8] = dr["addtime"].ToString();
                }
                dr.Close();
            }
            if (isRead)
            {
                ArticleInfo model = new ArticleInfo();
                if (strArr[0] != "")
                {
                    model.id = int.Parse(strArr[0]);
                }
                model.no = strArr[1];
                model.title = strArr[2];
                if (strArr[3] != "")
                {
                    model.channel_id = int.Parse(strArr[3]);
                }
                model.contents = strArr[4];
                model.commend = strArr[5] == "1";
                model.stick = strArr[6] == "1";
                model.publish = strArr[7] == "1";
                if (strArr[8] != "")
                {
                    model.addtime = DateTime.Parse(strArr[8]);
                }
                return model;
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataRow GetDataRow(int sysModelId, int id)
        {
            
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 * from " + currTableName + sysModelId);
            strSql.Append(" where id=" + id.ToString());
            DataTable dt = DbHelper.GetDataTable(strSql.ToString());
            if (dt.Rows.Count > 0)
            {
                return dt.Rows[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// ȡ(user)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataRow GetUDataRow(int sysModelId, int id)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(UserConfig.GetFieldName("username") + ",");
            sb.Append(UserConfig.GetFieldName("grade") + ",");
            sb.Append(UserConfig.GetFieldName("pic") + ",");
            sb.Append(UserConfig.GetFieldName("integral") + ",");
            sb.Append(UserConfig.GetFieldName("medal") + ",");
            sb.Append(UserConfig.GetFieldName("mark") + ",");
            sb.Append(UserConfig.GetFieldName("topic_count") + ",");
            sb.Append(UserConfig.GetFieldName("reply_count") + ",");
            sb.Append(UserConfig.GetFieldName("create_time") + ",");
            sb.Append(UserConfig.GetFieldName("login_time"));
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select top 1 a.*,b." + sb.ToString().Replace(",", ",b.") + " from ");
            strSql.Append("(" + currTableName + sysModelId + " as a left join " + UserConfig.UsersTableName + " as b ");
            strSql.Append(" on a.author=b." + UserConfig.GetFieldName("username") + ")");
            strSql.Append(" where a.id=" + id.ToString());
            
            DataTable dt = DbHelper.GetDataTable(strSql.ToString());
            if (dt.Rows.Count > 0)
            {
                return dt.Rows[0];
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// ȡһ(ֵ)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="channelId"></param>
        /// <param name="id"></param>
        /// <param name="colNames"></param>
        /// <param name="format"></param>
        /// <returns></returns>
        public string GetPrevFormat(int sysModelId, int channelId, int id, string colNames,string format)
        {
            string reValue = "";
            string columns = colNames.Trim();
            if (columns != "")
            {
                string[] arr = columns.Split(',');
                IDataReader dr = GetReader(sysModelId, 1, columns, " and id<" + id + " and [channel_id]=" + channelId + " order by id desc");
                if (dr != null)
                {
                    bool dRead = false;
                    if (dr.Read())
                    {
                        int alen = arr.Length;
                        for (int i = 0; i < alen; i++)
                        {
                            arr[i] = dr[arr[i]].ToString();
                        }
                        dRead = true;
                    }
                    dr.Close();
                    if (dRead)
                    {
                        reValue = string.Format(format, arr);
                    }
                }
            }
            return reValue;
        }
        /// <summary>
        /// ȡһ(ֵ)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="channelId"></param>
        /// <param name="id"></param>
        /// <param name="colNames"></param>
        /// <param name="format"></param>
        /// <returns></returns>
        public string GetNextFormat(int sysModelId, int channelId, int id, string colNames, string format)
        {
            string reValue = "";
            string columns = colNames.Trim();
            if (columns != "")
            {
                string[] arr = columns.Split(',');
                IDataReader dr = GetReader(sysModelId, 1, columns, " and id>" + id + " and [channel_id]=" + channelId + " order by id asc");
                if (dr != null)
                {
                    bool dRead = false;
                    if (dr.Read())
                    {
                        int alen = arr.Length;
                        for (int i = 0; i < alen; i++)
                        {
                            arr[i] = dr[arr[i]].ToString();
                        }
                        dRead = true;
                    }
                    dr.Close();
                    if (dRead)
                    {
                        reValue = string.Format(format, arr);
                    }
                }
            }
            return reValue;
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="colNameList"></param>
        /// <returns></returns>
        public bool ExistsColumn(int sysModelId, string colNameList)
        {
            if (colNameList == "")
            {
                return false;
            }
            if (SiteConfig.IsAccess)
            {
                StringBuilder strSql = new StringBuilder();
                strSql.Append("select top 1 * from  [" + currTableName + sysModelId + "] where 1=0");
                DataTable dt = DbHelper.GetDataTable(strSql.ToString());
                if (dt == null)
                {
                    return false;
                }
                string[] colArr = colNameList.Split(',');
                foreach (string col in colArr)
                {
                    if (!dt.Columns.Contains(col))
                    {
                        return false;
                    }
                }
                return true;
            }
            else
            {
                return DbHelper.Exists("select count(1) from syscolumns where [id]=object_id(" + currTableName + sysModelId
                    + ") and [name] in ('" + SqlHelper.FieldFilter(colNameList.Replace(",", "','")) + "')");
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(int sysModelId, ArticleInfo model)
        {
            
            string[] strInsertArr = model.GetExtFieldInsertSqlString();
            string noString = model.no;
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into " + currTableName + sysModelId);
            strSql.Append(" ([no],title,channel_id,contents,templetfile,commend,stick,publish,orders,addtime");
            strSql.Append(strInsertArr[0]);
            strSql.Append(")");
            strSql.Append(" values (");
            strSql.Append(SqlHelper.FieldFilter(noString) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.title) + ",");
            strSql.Append(model.channel_id + ",");
            strSql.Append(SqlHelper.FieldFilter(model.contents) + ",");
            strSql.Append(SqlHelper.FieldFilter(model.templetfile) + ",");
            strSql.Append((model.commend ? "1" : "0") + ",");
            strSql.Append((model.stick ? "1" : "0") + ",");
            strSql.Append((model.publish ? "1" : "0") + ",");
            strSql.Append(model.orders.ToString() + ",");
            strSql.Append(SiteConfig.IsAccess ? "Now()" : "getdate()");
            strSql.Append(strInsertArr[1]);
            strSql.Append(")");
            SysManager.LogDebugWriteln(this.GetType(), strSql.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(int sysModelId, ArticleInfo model)
        {
            
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + currTableName + sysModelId);
            strSql.Append(" set ");
            strSql.Append("title=" + SqlHelper.FieldFilter(model.title) + ",");
            strSql.Append("channel_id=" + model.channel_id + ",");
            strSql.Append("contents=" + SqlHelper.FieldFilter(model.contents) + ",");
            strSql.Append("templetfile=" + SqlHelper.FieldFilter(model.templetfile) + ",");
            strSql.Append("commend=" + (model.commend ? "1" : "0") + ",");
            strSql.Append("stick=" + (model.stick ? "1" : "0") + ",");
            strSql.Append("publish=" + (model.publish ? "1" : "0") + "," );
            strSql.Append("orders=" + model.orders.ToString() + ",");
            strSql.Append("addtime='" + model.addtime.ToString() + "'");
            string strUpdateArr = model.GetExtFieldUpdateSqlString();
            strSql.Append(strUpdateArr);
            strSql.Append(" where id=" + model.id.ToString());
            SysManager.LogDebugWriteln(this.GetType(), strSql.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0);
        }
        /// <summary>
        /// ҳ¼¼(isPrevpageΪtrueҳҳ)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <param name="pagestring"></param>
        /// <param name="isPrevpage"></param>
        /// <returns></returns>
        public bool UpdatePage(int sysModelId, int id, string pagestring,bool isPrevpage)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + currTableName + sysModelId);
            if (isPrevpage)
            {
                strSql.Append(" set prevpage=" + SqlHelper.FieldFilter(pagestring));
            }
            else
            {
                strSql.Append(" set nextpage='" + SqlHelper.FieldFilter(pagestring));
            }
            strSql.Append(" where id=" + id.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// չ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdateData(int sysModelId, ArticleInfo model)
        {
            string sql = model.GetExtFieldUpdateSqlString().Trim(',');
            if (sql != "")
            {
                StringBuilder strSql = new StringBuilder();
                strSql.Append("update " + currTableName + sysModelId);
                strSql.Append(" set " + sql + " where id=" + model.id.ToString());
                if (DbHelper.ExecuteSql(strSql.ToString()) > 0)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="channelId"></param>
        /// <param name="id"></param>
        /// <param name="isToday"></param>
        /// <returns></returns>
        public bool Delete(int sysModelId,int channelId, int id ,bool isToday)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(sysModelId);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0);
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool DeleteData(int sysModelId, int id)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(sysModelId);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
			    ParamHelper.MakeParam("@id",id)
		    };
            return DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0;
        }
        /// <summary>
        /// Ƽ
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <param name="isCommend"></param>
        /// <returns></returns>
        public bool Commend(int sysModelId ,int id, bool isCommend)
        {
            
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + currTableName + sysModelId);
            strSql.Append(" set commend=" + (isCommend ? "1" : "0") + " where id=" + id.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// ö
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <param name="isStick"></param>
        /// <returns></returns>
        public bool Stick(int sysModelId, int id, bool isStick)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + currTableName + sysModelId);
            strSql.Append(" set stick=" + (isStick ? "1" : "0") + " where id=" + id.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// (html)
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="id"></param>
        /// <param name="isRecycle"></param>
        /// <returns></returns>
        public bool Publish(int sysModelId ,int id, bool isRecycle)
        {
            
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update " + currTableName + sysModelId);
            strSql.Append(" set publish=" + (isRecycle ? "1" : "0") + " where id=" + id.ToString());
            return (DbHelper.ExecuteSql(strSql.ToString()) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="sysModelId">ģid</param>
        /// <param name="topCount">-1ʾȫ</param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        private static IDataReader GetReader(int sysModelId, int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + sysModelId + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="sysModelId">ģid</param> 
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int sysModelId, int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName + sysModelId);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="sysModelId">ģid</param> 
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int sysModelId, int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName + sysModelId);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sysModelId">ģid</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(int sysModelId,string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + sysModelId + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// õб
        /// </summary>
        /// <param name="sysModelId"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public DataTable GetCreateList(int sysModelId, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select [id],[no],channel_id,templetfile,[create_path],[pagename],[extname] from [" + currTableName + sysModelId + "] where publish=1 ");
            strSql.Append(andWhereOrderBy);
            return DbHelper.GetDataTable(strSql.ToString());
        }
        public DataTable GetUDataList(int sysModelId, int pageSize, int currPageCount, string andWhere, string orderBy, string authorColName, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + sysModelId + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(sysModelId ,andWhere.ToString());
            StringBuilder strColNames = new StringBuilder();
            strColNames.Append("a.*,");
            strColNames.Append("b." + UserConfig.GetFieldName("username") + ",");
            strColNames.Append("b." + UserConfig.GetFieldName("nickname") + ",");
            strColNames.Append("b." + UserConfig.GetFieldName("grade") + ",");
            strColNames.Append("b." + UserConfig.GetFieldName("pic"));
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, "as a", strColNames.ToString(), "left join " + UserConfig.UsersTableName +
                " as b on a." + authorColName + "=b." + UserConfig.GetFieldName("username") + SqlHelper.GetJoinOrderBy(orderBy, "a"));
            return DbHelper.GetDataTable(sql);
        }
        public DataTable GetCDataList(int sysModelId, int pageSize, int currPageCount, string andWhere, string orderBy, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + sysModelId + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(sysModelId, andWhere.ToString());
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, "as a", "a.*,b.article_path", "left join " + Channel.currTableName +
                " as b on a.channel_id=b.id " + SqlHelper.GetJoinOrderBy(orderBy, "a"));
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
    }
}

