/**********************************************************************************
 * ˵     ҳ(ݷʲ)
 * ڣ     2009.6.13
 * ޸ڣ     2012.02.15
 *      agui
 * ϵʽ     mailto:354990393@qq.com  
 * Ȩ     http:
 * ********************************************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using PlugNT.Database;
using PlugNT.Database.Common.Simple;
using PlugNT.Cms.Custom;
using PlugNT.Cms.Model;
namespace PlugNT.Cms.DAL
{
    /// <summary>
    /// ҳ
    /// </summary>
    public class Ad
    {
        public static string currTableName = SiteConfig.TablePrefix + "ad";
        private static Dictionary<string, string> adlinks;
        static Ad()
        {
            adlinks = new Dictionary<string, string>();
        }
        public static string GetTableName()
        {
            return currTableName;
        }
        private int GetClassId(int id)
        {
            string sql = "select top 1 [class_id] From " + currTableName + " where [id]=" + id.ToString();
            object obj = DbHelper.GetSingle(sql);
            return (obj == null) ? 0 : int.Parse(obj.ToString());
        }
        /// <summary>
        /// õһ
        /// </summary>
        private string GetAdLinks(int classId)
        {
            StringBuilder sb = new StringBuilder();
            AdClassInfo clsInfo = new AdClass().GetAdClassInfo(classId);
            if (clsInfo != null)
            {
                string orderBy= SiteConfig.IsAccess ? " order by [order],id desc" : " order by [order] desc";
                IDataReader dr = GetReader(-1, "[code]", " and [disabled]=0 and class_id=" + classId + orderBy);
                if (dr != null)
                {
                    while (dr.Read())
                    {
                        sb.AppendLine();
                        sb.AppendLine(dr["code"].ToString());
                    }
                    dr.Close();
                }
            }
            return sb.ToString();
        }
        /// <summary>
        /// һҳĹ(ɶ)
        /// </summary>
        /// <param name="no"></param>
        /// <param name="splitstr"></param> 
        /// <returns></returns>
        public string CreateAdLinks(int classId)
        {
            string reString = "";
            string key =  classId.ToString();
            if (!adlinks.TryGetValue(key, out reString))
            {
                reString = GetAdLinks(classId);
                adlinks.Add(key, reString);
            }
            return reString;
        }
        /// <summary>
        /// ɾеĹ
        /// </summary>
        public void RemoveAdLinks()
        {
            adlinks.Clear();
        }
        /// <summary>
        /// ɾһҳĹ
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public static bool RemoveAdLinks(int classId)
        {
            bool flag = false;
            string key = classId.ToString();
            if (adlinks.ContainsKey(key))
            {
                flag = adlinks.Remove(key);
            }
            return flag;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Add(AdInfo model)
        {
            RemoveAdLinks(model.class_id);
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into ");
            strSql.Append(currTableName);
            strSql.Append("([no],class_id,target_url,[description],start_time,end_time,[code],file_path,target_html_id,[type],[width],[height],[disabled],[order])");
            strSql.Append(" values (");
            strSql.Append("@no,@class_id,@target_url,@description,@start_time,@end_time,@code,@file_path,@target_html_id,@type,@width,@height,@disabled,@order)");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@no",model.no),
                 ParamHelper.MakeParam("@class_id",model.class_id),
                 ParamHelper.MakeParam("@target_url",model.target_url),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@start_time",model.start_time.ToString()),
                 ParamHelper.MakeParam("@end_time",model.end_time.ToString()),
                 ParamHelper.MakeParam("@code",model.code),
                 ParamHelper.MakeParam("@file_path",model.file_path),
                 ParamHelper.MakeParam("@target_html_id",model.target_html_id),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@width",model.width),
                 ParamHelper.MakeParam("@height",model.height),
                 ParamHelper.MakeParam("@disabled",model.disabled?1:0),
                 ParamHelper.MakeParam("@order",model.order)
             };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ༭
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Update(AdInfo model)
        {
            int cid1 = model.class_id;
            int cid2 = GetClassId(model.id);
            if (cid1 != cid2)
            {
                RemoveAdLinks(cid1);
                RemoveAdLinks(cid2);
            }
            else
            {
                RemoveAdLinks(cid1);
            }
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update ");
            strSql.Append(currTableName);
            strSql.Append(" set ");
            strSql.Append("class_id=@class_id,");
            strSql.Append("target_url=@target_url,");
            strSql.Append("[description]=@description,");
            strSql.Append("start_time=@start_time,");
            strSql.Append("end_time=@end_time,");
            strSql.Append("[code]=@code,");
            strSql.Append("file_path=@file_path,");
            strSql.Append("target_html_id=@target_html_id,");
            strSql.Append("[type]=@type,");
            strSql.Append("[width]=@width,");
            strSql.Append("[height]=@height,");
            strSql.Append("[disabled]=@disabled,");
            strSql.Append("[order]=@order");
            strSql.Append(" where [id]=@id ");
            DbParameter[] parameters = {
                 ParamHelper.MakeParam("@class_id",model.class_id),
                 ParamHelper.MakeParam("@target_url",model.target_url),
                 ParamHelper.MakeParam("@description",model.description),
                 ParamHelper.MakeParam("@start_time",model.start_time),
                 ParamHelper.MakeParam("@end_time",model.end_time),
                 ParamHelper.MakeParam("@code",model.code),
                 ParamHelper.MakeParam("@file_path",model.file_path),
                 ParamHelper.MakeParam("@target_html_id",model.target_html_id),
                 ParamHelper.MakeParam("@type",model.type),
                 ParamHelper.MakeParam("@width",model.width),
                 ParamHelper.MakeParam("@height",model.height),
                 ParamHelper.MakeParam("@disabled",model.disabled?1:0),
                 ParamHelper.MakeParam("@order",model.order),
                 ParamHelper.MakeParam("@id",model.id)
            };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public bool Delete(int id)
        {
            RemoveAdLinks(GetClassId(id));
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where [id]=@id");
            DbParameter[] parameters = {
		        ParamHelper.MakeParam("@id",id)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="no"></param>
        /// <returns></returns>
        public bool DeleteByClassId(int classId)
        {
            RemoveAdLinks(classId);
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete from ");
            strSql.Append(currTableName);
            strSql.Append(" where class_id=@class_id");
            DbParameter[] parameters = {
		        ParamHelper.MakeParam("@class_id",classId)
		    };
            return (DbHelper.ExecuteSql(strSql.ToString(), parameters) > 0) ? true : false;
        }
        /// <summary>
        /// õIDataReader
        /// </summary>
        /// <param name="topCount"></param>
        /// <param name="colNames"></param>
        /// <param name="andWhereOrderBy"></param>
        /// <returns></returns>
        public IDataReader GetReader(int topCount, string colNames, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " " + colNames + " from " + currTableName + "  where 1=1 " + andWhereOrderBy);
            return DbHelper.ExecuteReader(strSql.ToString());
        }
        /// <summary>
        /// õһʵ
        /// </summary>
        /// <param name="id"></param> 
        /// <returns></returns>
        public AdInfo GetAdInfo(int id)
        {
            AdInfo model = new AdInfo();
            bool isRead = false;
            IDataReader dr = GetReader(1, "[id], [no], class_id, target_url, [description], start_time, end_time, [code], file_path, target_html_id, [type], [width], [height], [disabled], [order]", " and id=" + id);
            if (dr != null)
            {
                if (dr.Read())
                {
                    if (dr["id"].ToString() != "")
                    {
                        model.id = int.Parse(dr["id"].ToString());
                    }
                    model.no = dr["no"].ToString();
                    if (dr["class_id"].ToString() != "")
                    {
                        model.class_id = int.Parse(dr["class_id"].ToString());
                    }
                    model.target_url = dr["target_url"].ToString();
                    model.description = dr["description"].ToString();
                    if (dr["start_time"].ToString() != "")
                    {
                        model.start_time = DateTime.Parse(dr["start_time"].ToString());
                    }
                    if (dr["end_time"].ToString() != "")
                    {
                        model.end_time = DateTime.Parse(dr["end_time"].ToString());
                    }
                    model.code = dr["code"].ToString();
                    model.file_path = dr["file_path"].ToString();
                    model.target_html_id = dr["target_html_id"].ToString();
                    if (dr["type"].ToString() != "")
                    {
                        model.type = int.Parse(dr["type"].ToString());
                    }
                    if (dr["width"].ToString() != "")
                    {
                        model.width = int.Parse(dr["width"].ToString());
                    }
                    if (dr["height"].ToString() != "")
                    {
                        model.height = int.Parse(dr["height"].ToString());
                    }
                    if (dr["disabled"].ToString() != "")
                    {
                        model.disabled = dr["disabled"].ToString()=="1";
                    }
                    if (dr["order"].ToString() != "")
                    {
                        model.order = int.Parse(dr["order"].ToString());
                    }
                    isRead = true;
                }
                dr.Close();
            }
            return isRead ? model : null;
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="topCount">ָĿ</param> 
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public DataTable GetList(int topCount, string andWhereOrderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + (topCount > 0 ? "top " + topCount : "") + " * from " + currTableName);
            if (andWhereOrderBy != "")
            {
                strSql.Append(" where 1=1 " + andWhereOrderBy);
            }
            return DbHelper.GetDataTable(strSql.ToString());
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize">ҳ</param> 
        /// <param name="currPageCount">ǰҳ</param> 
        /// <param name="recordCount">¼</param> 
        /// <param name="colNames">ȫ*ʾ</param> 
        /// <param name="andWhere">andѯ</param> 
        /// <param name="orderBy">ֶΣá,id asc,addtime desc</param> 
        /// <returns></returns>
        public DataTable GetList(int pageSize, int currPageCount, int recordCount, string colNames, string andWhere, string orderBy)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select " + colNames + " from " + currTableName);
            if (andWhere != "")
            {
                strSql.Append(" where 1=1 " + andWhere);
            }
            return DbHelper.GetDataTable(SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="andWhereOrderBy"></param> 
        /// <returns></returns>
        public int GetCount(string andWhereOrderBy)
        {
            string sql = "select count(1) from [" + currTableName + "] where 1=1 " + andWhereOrderBy;
            object objCount = DbHelper.GetSingle(sql);
            return objCount != null ? int.Parse(objCount.ToString()) : 0;
        }
        /// <summary>
        /// б
        /// </summary>
        /// <param name="pageSize"></param>
        /// <param name="currPageCount"></param>
        /// <param name="andWhere"></param>
        /// <param name="orderBy"></param>
        /// <param name="recordCount"></param>
        /// <returns></returns>
        public DataTable GetCDataList(int pageSize, int currPageCount, string andWhere, string orderBy, out int recordCount)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from " + currTableName + " where 1=1 ");
            if (andWhere != "")
            {
                strSql.Append(andWhere); ;
            }
            recordCount = GetCount(andWhere.ToString());
            string sql = SqlHelper.GetPagingString(pageSize, currPageCount, recordCount, strSql.ToString(), orderBy);
            sql = SqlHelper.Join(sql, "as a", "a.*,b.name", "left join " + AdClass.currTableName +
                " as b on a.class_id=b.id " + SqlHelper.GetJoinOrderBy(orderBy, "a"));
            return PlugNT.Database.Common.Simple.DbHelper.GetDataTable(sql);
        }
    }
}

